/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.user.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.internal.AbstractPrincipal;
import com.crystaldecisions.celib.conversion.LocaleConversion;
import com.crystaldecisions.celib.conversion.TimeZoneConversion;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.internal.UserGroupAssociates;
import com.crystaldecisions.sdk.plugin.desktop.user.IUser;
import com.crystaldecisions.sdk.plugin.desktop.user.IUserAliases;
import com.crystaldecisions.sdk.plugin.desktop.user.internal.UserAliases;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropContainerHelper;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

class User
extends AbstractPrincipal
implements IUser {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.user.internal.User");
    private Set m_groups;
    private IUserAliases m_userAliases;
    public static final Integer SEC_ID_USER_FOLDER = new Integer(19);
    private static final String SECOND_CRED_PREFIX = "__CE2CRED_";
    private PropContainerHelper.Map m_addCreds = null;
    private PropContainerHelper.Set m_removeCreds = null;
    boolean m_isPreferenceChanged = false;
    private static final Integer SI_UserPreferenceChanged = PropertyIDs.define("SI_UserPreferenceChanged");

    User() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, SEC_ID_USER_FOLDER);
        this.setPasswordExpiryAllowed(true);
        this.setPasswordToChangeAtNextLogon(true);
        this.setPasswordChangeAllowed(true);
        this.m_isPreferenceChanged = false;
    }

    public void prepareCommit() throws SDKException {
        IProperty propChangePwdAtNextLogon = this.getProperty(PropertyIDs.SI_FORCE_PASSWORD_CHANGE);
        IProperty propAllowPwdChange = this.getProperty(PropertyIDs.SI_CHANGEPASSWORD);
        if (propChangePwdAtNextLogon != null && propAllowPwdChange != null) {
            boolean changePwdAtNextLogon = (Boolean)propChangePwdAtNextLogon.getValue();
            boolean allowPwdChange = (Boolean)propAllowPwdChange.getValue();
            if (changePwdAtNextLogon && !allowPwdChange) {
                throw new SDKRuntimeException.ContradictingValues(PropertyIDs.SI_FORCE_PASSWORD_CHANGE, "true", PropertyIDs.SI_CHANGEPASSWORD, "false");
            }
        }
        if (this.isNew()) {
            this.getGroups();
            IProperties props = this.properties();
            IProperty currPass = props.getProperty(PropertyIDs.SI_PASSWORD);
            IProperty newPass = props.getProperty(PropertyIDs.ADM_NEW_PASSWORD);
            if (currPass == null && newPass == null) {
                this.setNewPassword("");
            }
        }
    }

    public String getFullName() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_USERFULLNAME);
        if (prop != null) {
            return (String)prop.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_USERFULLNAME);
    }

    public void setFullName(String newFullName) {
        this.setProperty((Object)PropertyIDs.SI_USERFULLNAME, newFullName);
    }

    public boolean isPasswordExpiryAllowed() {
        Boolean passwordNoExpire = (Boolean)this.getProperty(PropertyIDs.SI_PASSWORDEXPIRE).getValue();
        return passwordNoExpire;
    }

    public void setPasswordExpiryAllowed(boolean newPasswordExpires) {
        Boolean passwordExpires = newPasswordExpires ? Boolean.TRUE : Boolean.FALSE;
        this.setProperty((Object)PropertyIDs.SI_PASSWORDEXPIRE, passwordExpires);
    }

    public boolean isPasswordToChangeAtNextLogon() {
        return (Boolean)this.getProperty(PropertyIDs.SI_FORCE_PASSWORD_CHANGE).getValue();
    }

    public void setPasswordToChangeAtNextLogon(boolean newChangePasswordAtNextLogon) {
        this.setProperty((Object)PropertyIDs.SI_FORCE_PASSWORD_CHANGE, newChangePasswordAtNextLogon ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isPasswordChangeAllowed() {
        return (Boolean)this.getProperty(PropertyIDs.SI_CHANGEPASSWORD).getValue();
    }

    public void setPasswordChangeAllowed(boolean newAllowChangePassword) {
        this.setProperty((Object)PropertyIDs.SI_CHANGEPASSWORD, newAllowChangePassword ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getConnection() {
        Boolean namedUser = (Boolean)this.getProperty(PropertyIDs.SI_NAMEDUSER).getValue();
        if (namedUser != null && namedUser.booleanValue()) {
            return 0;
        }
        return 1;
    }

    public void setConnection(int newConnection) {
        if (newConnection == 0) {
            this.setProperty((Object)PropertyIDs.SI_NAMEDUSER, Boolean.TRUE);
        } else if (newConnection == 1) {
            this.setProperty((Object)PropertyIDs.SI_NAMEDUSER, Boolean.FALSE);
        } else {
            LOG.assertTrue(false);
        }
    }

    public void changePassword(String oldPassword, String newPassword) {
        this.setProperty((Object)PropertyIDs.ADM_OLD_PASSWORD, oldPassword);
        this.setProperty((Object)PropertyIDs.ADM_NEW_PASSWORD, newPassword);
    }

    public void setNewPassword(String newPassword) {
        this.setProperty((Object)PropertyIDs.ADM_OLD_PASSWORD, null);
        this.setProperty((Object)PropertyIDs.ADM_NEW_PASSWORD, newPassword);
    }

    public synchronized Set getGroups() {
        if (this.m_groups == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_USERGROUPS) == null) {
                    this.properties().add(PropertyIDs.SI_USERGROUPS, null, 0x8000000);
                }
                this.m_groups = new UserGroupAssociates(PropertyIDs.SI_USERGROUPS, PropertyIDs.SI_ADM_ADD_USERGROUPS_TO_USER, PropertyIDs.SI_ADM_DEL_USERGROUPS, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_groups;
    }

    public String getProfileString(String name) throws SDKException {
        IProperty data = this.getProperty(PropertyIDs.SI_DATA);
        if (data != null) {
            IProperty value = ((IProperties)data.getValue()).getProperty(name);
            if (value != null) {
                return (String)value.getValue();
            }
            throw new SDKException.PropertyNotFound(name);
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_DATA);
    }

    public void setProfileString(String name, String newProfileString) {
        IProperty data = this.getProperty(PropertyIDs.SI_DATA);
        if (data == null) {
            data = this.properties().add(PropertyIDs.SI_DATA, null, 0x8000000);
        }
        ((IProperties)data.getValue()).add(name, newProfileString, 0);
        if (name.equalsIgnoreCase("SI_LOCALE") || name.equalsIgnoreCase("DOCUMENT_WIUserContentLocale") || name.equalsIgnoreCase("SI_TIMEZONE")) {
            this.m_isPreferenceChanged = true;
        }
    }

    public void removeProfileString(String name) throws SDKException {
        IProperty data = this.getProperty(PropertyIDs.SI_DATA);
        if (data != null) {
            PropertyBag props = (PropertyBag)data.getValue();
            props.remove((Object)name);
            if (name.equalsIgnoreCase("SI_LOCALE") || name.equalsIgnoreCase("DOCUMENT_WIUserContentLocale") || name.equalsIgnoreCase("SI_TIMEZONE")) {
                this.m_isPreferenceChanged = true;
            }
        }
    }

    public synchronized IUserAliases getAliases() {
        if (this.m_userAliases == null) {
            PropertyBag propertyBag = (PropertyBag)this.properties();
            PropertyBag aliasesBag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_ALIASES);
            if (aliasesBag == null) {
                Property prop = propertyBag.addArray((Object)PropertyIDs.SI_ALIASES);
                aliasesBag = prop.getPropertyBag();
            }
            this.m_userAliases = new UserAliases(aliasesBag, this.getSession());
        }
        return this.m_userAliases;
    }

    public String getEmailAddress() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_EMAIL_ADDRESS);
        if (prop != null) {
            return (String)prop.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_EMAIL_ADDRESS);
    }

    public void setEmailAddress(String address) {
        this.setProperty((Object)PropertyIDs.SI_EMAIL_ADDRESS, address);
    }

    protected void updateSessionInfo(ISecuritySession sess, IProperty dataprop) throws SDKException {
        TimeZone tz;
        int timeZoneInt;
        String stz;
        if (dataprop == null) {
            return;
        }
        PropertyBag props = (PropertyBag)dataprop.getValue();
        String newlocale = props.getString((Object)PropertyIDs.SI_LOCALE);
        String newpvl = props.getString((Object)PropertyIDs.DOCUMENT_WIUserContentLocale);
        String newtz = props.getString((Object)PropertyIDs.SI_TIMEZONE);
        IUserInfo uinfo = sess.getUserInfo();
        if (newtz != null && !newtz.equals(stz = new Integer(timeZoneInt = TimeZoneConversion.convertToID((TimeZone)(tz = uinfo.getTimeZone()))).toString())) {
            tz = TimeZoneConversion.convertToTimeZone((int)Integer.parseInt(newtz));
            uinfo.setTimeZone(tz);
        }
        if (newlocale != null) {
            int newlocaleInt = Integer.parseInt(newlocale);
            if (newlocaleInt == LocaleConversion.ceLocaleUserDefault) {
                if (!uinfo.isUserDefaultLocale()) {
                    uinfo.setUserDefaultLocale();
                }
            } else {
                Locale l = LocaleConversion.convertToLocale((int)newlocaleInt);
                uinfo.setLocale(l);
            }
        }
        Locale pvl = null;
        try {
            pvl = uinfo.getPreferredViewingLocale();
        }
        catch (SDKException.PropertyNotFound e) {
            // empty catch block
        }
        if (newpvl == null || newpvl.length() == 0) {
            if (pvl != null) {
                uinfo.removePreferredViewingLocale();
            }
        } else {
            String spvl = "";
            if (pvl != null) {
                spvl = pvl.toString();
            }
            if (!newpvl.equals(spvl)) {
                Locale l = LocaleConversion.convertStringToLocale((String)newpvl);
                uinfo.setPreferredViewingLocale(l);
            }
        }
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    User.this.prepareCommit();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 5) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    ISecuritySession ssess = event.getSecuritySession();
                    if (User.this.m_isPreferenceChanged && ssess != null) {
                        IUserInfo uinfo = ssess.getUserInfo();
                        User.this.updateSessionInfo(ssess, User.this.getProperty(PropertyIDs.SI_DATA));
                        User.this.m_isPreferenceChanged = false;
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public boolean hasSecondaryCredential(String secondCred) throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_2ND_CREDS);
        if (prop == null) {
            throw new SDKException.PropertyNotFound("SI_2ND_CREDS");
        }
        PropertyBag propBag = (PropertyBag)prop.getValue();
        Object obj = propBag.get((Object)(SECOND_CRED_PREFIX + secondCred));
        return obj != null;
    }

    public void addSecondaryCredential(String secondCred, String password) throws SDKException {
        if (this.m_addCreds == null) {
            Property prop = (Property)this.getProperty(PropertyIDs.SI_ADM_ADD_2ND_CREDES);
            if (prop == null) {
                prop = (Property)this.addProperty(PropertyIDs.SI_ADM_ADD_2ND_CREDES, null, 0x8000000);
            }
            this.m_addCreds = new PropContainerHelper.Map(prop.getPropertyBag(), PropertyIDs.SI_NAME, PropertyIDs.SI_VALUE);
        }
        this.m_addCreds.put(SECOND_CRED_PREFIX + secondCred, password);
        if (this.m_removeCreds != null) {
            this.m_removeCreds.remove(SECOND_CRED_PREFIX + secondCred);
        }
    }

    public void removeSecondaryCredential(String secondCred) throws SDKException {
        if (this.m_removeCreds == null) {
            Property prop = (Property)this.getProperty(PropertyIDs.SI_ADM_REMOVE_2ND_CREDS);
            if (prop == null) {
                prop = (Property)this.addProperty(PropertyIDs.SI_ADM_REMOVE_2ND_CREDS, null, 0x8000000);
            }
            this.m_removeCreds = new PropContainerHelper.Set(prop.getPropertyBag(), PropertyIDs.SI_NAME);
        }
        this.m_removeCreds.add(SECOND_CRED_PREFIX + secondCred);
        if (this.m_addCreds != null) {
            this.m_addCreds.remove(SECOND_CRED_PREFIX + secondCred);
        }
    }

    public boolean isAttributeBindingEnabled() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_ENABLE_ATTR_BINDING);
        if (prop != null) {
            return (Boolean)prop.getValue();
        }
        return true;
    }

    public void setAttributeBindingEnabled(boolean isEnabled) {
        this.setProperty((Object)PropertyIDs.SI_ENABLE_ATTR_BINDING, isEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getDelta(int deltaFlags) throws SDKException {
        this.properties().add(SI_UserPreferenceChanged, this.m_isPreferenceChanged, 0x2000000);
        return super.getDelta(deltaFlags);
    }

    public boolean applyDelta(String delta, int deltaFlags) throws SDKException {
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(delta);
        SDKPropertyBag allroot = new SDKPropertyBag();
        allroot.merge(unpacker);
        String result1 = allroot.getString(PropertyIDs.SI_DELTA);
        WireOb3Unpacker unpacker1 = new WireOb3Unpacker();
        unpacker1.initialize(result1);
        SDKPropertyBag deltaBag = new SDKPropertyBag();
        deltaBag.merge(unpacker1);
        this.m_isPreferenceChanged = deltaBag.getBoolean("SI_UserPreferenceChanged");
        return super.applyDelta(delta, deltaFlags);
    }

    public int getFavoritesFolderID() throws SDKException {
        PropertyBag bag;
        PropertyArrayHelper bagArr;
        Property prop = (Property)this.properties().get(PropertyIDs.SI_FAVORITES_FOLDER);
        if (prop != null && (bagArr = new PropertyArrayHelper(bag = prop.getPropertyBag(), PropertyIDs.SI_TOTAL, new Integer(0))).size() == 1) {
            return (Integer)bagArr.get(0);
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_FAVORITES_FOLDER);
    }

    public int getInboxID() throws SDKException {
        PropertyBag bag;
        PropertyArrayHelper bagArr;
        Property prop = (Property)this.properties().get(PropertyIDs.SI_INBOX);
        if (prop != null && (bagArr = new PropertyArrayHelper(bag = prop.getPropertyBag(), PropertyIDs.SI_TOTAL, new Integer(0))).size() == 1) {
            return (Integer)bagArr.get(0);
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_INBOX);
    }

    public int getPersonalCategoryID() throws SDKException {
        PropertyBag bag;
        PropertyArrayHelper bagArr;
        Property prop = (Property)this.properties().get(PropertyIDs.SI_PERSONALCATEGORY);
        if (prop != null && (bagArr = new PropertyArrayHelper(bag = prop.getPropertyBag(), PropertyIDs.SI_TOTAL, new Integer(0))).size() == 1) {
            return (Integer)bagArr.get(0);
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_PERSONALCATEGORY);
    }
}

