/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.destination.diskunmanaged.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.destination.common.internal.FRSFileList;
import com.crystaldecisions.sdk.plugin.destination.diskunmanaged.IDiskUnmanagedOptions;
import com.crystaldecisions.sdk.plugin.destination.internal.DestinationFiles;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.List;

public class DiskUnmanagedOptions
implements IDiskUnmanagedOptions {
    private PropertyBag m_props;

    public void initialize(PropertyBag props) {
        this.m_props = props;
    }

    public String getUserName() {
        return this.m_props.getString((Object)PropertyIDs.SI_USERNAME);
    }

    public void setUserName(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_USERNAME, (Object)sVal);
    }

    public void setPassword(String sVal) {
        this.m_props.addItem((Object)PropertyIDs.SI_CRED_KEY, (Object)sVal, 0x1800000);
        this.m_props.addItem((Object)PropertyIDs.SI_PASSWORD, (Object)("".equals(sVal) ? "" : "********"), 0);
    }

    public boolean isPasswordNotEmpty() throws SDKException {
        Property prop = this.m_props.getItem((Object)PropertyIDs.SI_CRED_KEY);
        return prop != null && !"".equals(this.m_props.getStringHandler().unpack((String)prop.getValue()));
    }

    public boolean isPasswordSet() throws SDKException {
        return this.m_props.getItem((Object)PropertyIDs.SI_CRED_KEY) != null;
    }

    public List getDestinationFiles() {
        PropertyBag aliasesBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_OUTPUT_FILES);
        if (aliasesBag == null) {
            Property prop = this.m_props.addArray((Object)PropertyIDs.SI_OUTPUT_FILES);
            aliasesBag = prop.getPropertyBag();
        }
        return new DestinationFiles(aliasesBag);
    }

    public List getInputFiles() {
        PropertyBag pathsBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_INPUT_FILES);
        if (pathsBag == null) {
            Property prop = this.m_props.addArray((Object)PropertyIDs.SI_INPUT_FILES);
            pathsBag = prop.getPropertyBag();
        }
        return new FRSFileList(pathsBag);
    }
}

