/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.destination.managed.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.plugin.destination.common.internal.FRSFileList;
import com.crystaldecisions.sdk.plugin.destination.managed.IManagedOptions;
import com.crystaldecisions.sdk.plugin.destination.managed.internal.ManagedObjectSet;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.List;
import java.util.Set;

public class ManagedOptions
implements IManagedOptions {
    private PropertyBag m_props;
    private Set m_sources;
    private List m_frsPaths;
    private Set m_destinations;
    private int m_destOption;
    private int m_sendOption;
    private boolean m_includeInstance;
    private boolean m_instanceAsParent;
    private boolean m_createNewObject;
    private boolean m_useSavedData;
    public static final int s_sendOptionMask = 15;
    public static final int s_destOptionMask = 240;
    public static final int s_excludeInstance = 256;
    public static final int s_createNewObject = 512;
    public static final int s_instanceAsParent = 1024;
    public static final int s_useSavedData = 4096;

    public ManagedOptions(PropertyBag props) {
        this.m_props = props;
        this.initOptions();
    }

    public int getSendOption() {
        return this.m_sendOption;
    }

    public void setSendOption(int option) {
        this.m_sendOption = option;
        this.updateOptions();
    }

    public int getDestinationOption() {
        return this.m_destOption;
    }

    public void setDestinationOption(int option) {
        this.m_destOption = option;
        this.updateOptions();
    }

    private void initOptions() {
        int option = this.m_props.getInt((Object)PropertyIDs.SI_OPTIONS);
        this.m_sendOption = option & 0xF;
        this.m_destOption = option & 0xF0;
        this.m_includeInstance = (option & 0x100) == 0;
        this.m_instanceAsParent = (option & 0x400) != 0;
        this.m_createNewObject = (option & 0x200) != 0;
        this.m_useSavedData = (option & 0x1000) != 0;
    }

    private void updateOptions() {
        int option = this.m_sendOption | this.m_destOption;
        if (!this.m_includeInstance) {
            option |= 0x100;
        }
        if (this.m_instanceAsParent) {
            option |= 0x400;
        }
        if (this.m_createNewObject) {
            option |= 0x200;
        }
        if (this.m_useSavedData) {
            option |= 0x1000;
        }
        this.m_props.setProperty((Object)PropertyIDs.SI_OPTIONS, option);
    }

    public Set getDestinations() {
        if (this.m_destinations == null) {
            PropertyBag fileBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_OUTPUT_FILES);
            if (fileBag == null) {
                Property prop = this.m_props.addArray((Object)PropertyIDs.SI_OUTPUT_FILES);
                fileBag = prop.getPropertyBag();
            }
            this.m_destinations = new ManagedObjectSet(fileBag);
        }
        return this.m_destinations;
    }

    public Set getSourceObjects() {
        if (this.m_sources == null) {
            PropertyBag fileBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_INPUT_FILES);
            if (fileBag == null) {
                Property prop = this.m_props.addArray((Object)PropertyIDs.SI_INPUT_FILES);
                fileBag = prop.getPropertyBag();
            }
            this.m_sources = new ManagedObjectSet(fileBag);
        }
        return this.m_sources;
    }

    public List getInputFiles() {
        if (this.m_frsPaths == null) {
            PropertyBag fileBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_INPUT_FILES);
            if (fileBag == null) {
                Property prop = this.m_props.addArray((Object)PropertyIDs.SI_INPUT_FILES);
                fileBag = prop.getPropertyBag();
            }
            this.m_frsPaths = new FRSFileList(fileBag);
        }
        return this.m_frsPaths;
    }

    public String getTargetObjectName() {
        return this.m_props.getString((Object)PropertyIDs.SI_NAME);
    }

    public void setTargetObjectName(String name) {
        this.m_props.setProperty((Object)PropertyIDs.SI_NAME, (Object)name);
    }

    public boolean isIncludeInstance() {
        return this.m_includeInstance;
    }

    public void setIncludeInstance(boolean include) {
        this.m_includeInstance = include;
        this.updateOptions();
    }

    public boolean isInstanceAsParent() {
        return this.m_instanceAsParent;
    }

    public void setInstanceAsParent(boolean parent) {
        this.m_instanceAsParent = parent;
        this.updateOptions();
    }

    public boolean isCreateNewObject() {
        return this.m_createNewObject;
    }

    public void setCreateNewObject(boolean createNewObj) {
        this.m_createNewObject = createNewObj;
        this.updateOptions();
    }

    public boolean isKeepSavedData() {
        return this.m_useSavedData;
    }

    public void setKeepSavedData(boolean bKeepSavedData) {
        this.m_useSavedData = bKeepSavedData;
        this.updateOptions();
    }
}

