/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.pojomgr.axis2.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.pojomgr.axis2.internal.IAxis2ServiceFactory;
import com.crystaldecisions.sdk.pojomgr.axis2.internal.POJOConfigurator;
import com.crystaldecisions.sdk.pojomgr.axis2.internal.TransportSenderFactory;
import com.crystaldecisions.sdk.pojomgr.internal.IPOJOMgr;
import com.crystaldecisions.sdk.pojomgr.internal.IPOJOServiceFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportSender;

public class Axis2ServiceMgr
implements IPOJOMgr {
    private static final ILogger LOG;
    private Map m_cache;
    private AxisConfiguration m_noServiceConfiguration;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Axis2ServiceMgr() {
        this.m_noServiceConfiguration = new AxisConfiguration();
        Axis2ServiceMgr.setupAxisConfiguration(this.m_noServiceConfiguration);
        this.m_cache = new HashMap();
    }

    public Axis2ServiceMgr(String cluserName, AxisConfiguration axisConfiguration, AxisConfiguration emptyAxisConfiguration) {
        this.m_cache = new HashMap();
        this.m_cache.put(cluserName, axisConfiguration);
        this.m_noServiceConfiguration = emptyAxisConfiguration;
    }

    public Object makePOJO(String serviceName, IPOJOMgr.InvocationPolicy policy, String svr, ISecuritySession session, IPOJOServiceFactory pojoServiceFactory) throws SDKException {
        if (!$assertionsDisabled && !(pojoServiceFactory instanceof IAxis2ServiceFactory)) {
            throw new AssertionError();
        }
        IAxis2ServiceFactory axis2ServiceFactory = (IAxis2ServiceFactory)pojoServiceFactory;
        String clusterName = session.getClusterName();
        String apsName = session.getAPSName();
        String key = clusterName;
        AxisService axis2Service = this.findService(key, svr, serviceName, apsName, clusterName);
        AxisConfiguration configurationForStub = new AxisConfiguration();
        AxisConfiguration configurationForServiceClient = new AxisConfiguration();
        Axis2ServiceMgr.setupAxisConfiguration(configurationForStub);
        Axis2ServiceMgr.setupAxisConfiguration(configurationForServiceClient);
        try {
            Axis2ServiceMgr.copyTransportInsOuts(this.m_noServiceConfiguration, configurationForServiceClient);
        }
        catch (AxisFault axisFault) {
            throw new SDKException.FailedToBuildAxisService(serviceName, (Exception)((Object)axisFault));
        }
        try {
            Axis2ServiceMgr.copyTransportInsOuts(this.m_noServiceConfiguration, configurationForStub);
        }
        catch (AxisFault axisFault) {
            throw new SDKException.FailedToBuildAxisService(serviceName, (Exception)((Object)axisFault));
        }
        ConfigurationContext confContextForServiceClient = null;
        ConfigurationContext confContextForStub = null;
        confContextForStub = new ConfigurationContext(configurationForStub);
        confContextForServiceClient = new ConfigurationContext(configurationForServiceClient);
        confContextForServiceClient.setProperty("SECURITY_CONTEXT", (Object)session);
        confContextForStub.setProperty("SECURITY_CONTEXT", (Object)session);
        try {
            ServiceClient svcClient = new ServiceClient(confContextForServiceClient, axis2Service);
            String address = axis2ServiceFactory.getServiceAddress(svr, policy, serviceName, session);
            Options options = svcClient.getOptions();
            options.setTo(new EndpointReference(address));
            confContextForServiceClient.setProperty("InvocationPolicy", (Object)policy);
            confContextForStub.setProperty("InvocationPolicy", (Object)policy);
            return axis2ServiceFactory.makePOJO(serviceName, address, confContextForStub, svr, session, svcClient);
        }
        catch (AxisFault axisFault) {
            throw new SDKException.FailedToBuildAxisService(serviceName, (Exception)((Object)axisFault));
        }
    }

    private static void copyTransportInsOuts(AxisConfiguration source, AxisConfiguration destioation) throws AxisFault {
        HashMap transportIns = source.getTransportsIn();
        Set transportInNames = transportIns.keySet();
        Iterator iter = transportInNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            TransportInDescription inDesc = (TransportInDescription)transportIns.get(name);
            destioation.addTransportIn(inDesc);
        }
        HashMap transportOuts = source.getTransportsOut();
        Set tranposrtOutNames = transportOuts.keySet();
        Iterator iter2 = tranposrtOutNames.iterator();
        while (iter2.hasNext()) {
            String name = (String)iter2.next();
            TransportOutDescription outDesc = (TransportOutDescription)transportOuts.get(name);
            destioation.addTransportOut(outDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AxisService findService(String key, String svr, String serviceName, String apsName, String clusterName) throws SDKException {
        AxisService axis2Service;
        Object configurator;
        AxisConfiguration configuration;
        Axis2ServiceMgr axis2ServiceMgr = this;
        synchronized (axis2ServiceMgr) {
            configuration = (AxisConfiguration)this.m_cache.get(key);
        }
        if (configuration == null) {
            configuration = new AxisConfiguration();
            Axis2ServiceMgr.setupAxisConfiguration(configuration);
            configurator = new POJOConfigurator(configuration, svr, serviceName, apsName, clusterName);
            configurator.loadServices();
        }
        configurator = this;
        synchronized (configurator) {
            if (this.m_cache.get(key) == null) {
                this.m_cache.put(key, configuration);
            } else {
                configuration = (AxisConfiguration)this.m_cache.get(key);
            }
        }
        configurator = configuration;
        synchronized (configurator) {
            axis2Service = configuration.getServiceForActivation(serviceName);
        }
        if (axis2Service == null) {
            configurator = new POJOConfigurator(configuration, svr, serviceName, apsName, clusterName);
            configurator.loadServices();
            AxisConfiguration axisConfiguration = configuration;
            synchronized (axisConfiguration) {
                axis2Service = configuration.getAxisConfiguration().getServiceForActivation(serviceName);
            }
            if (axis2Service == null) {
                throw new SDKException.ServiceNotFound(serviceName, null);
            }
        }
        if (!axis2Service.isActive()) {
            throw new SDKException.FailedToBuildAxisService(serviceName, null);
        }
        AxisService copy = new AxisService();
        Axis2ServiceMgr.copyService(axis2Service, copy);
        return copy;
    }

    private static void copyService(AxisService src, AxisService dest) {
        String name = src.getName();
        dest.setName(name);
        Iterator axisOperations = src.getOperations();
        while (axisOperations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)axisOperations.next();
            String mep = axisOperation.getMessageExchangePattern();
            try {
                AxisOperation op = AxisOperationFactory.getOperationDescription((String)mep);
                op.setName(axisOperation.getName());
                dest.addOperation(op);
            }
            catch (AxisFault axisFault) {
                LOG.warn((Object)"(copyService:221): ", (Throwable)axisFault);
            }
        }
    }

    private static void setupAxisConfiguration(AxisConfiguration axisConfiguration) {
        try {
            TransportOutDescription outDesc = new TransportOutDescription("bip");
            TransportSender sender = TransportSenderFactory.getFactory().createSender();
            outDesc.setSender(sender);
            axisConfiguration.addTransportOut(outDesc);
        }
        catch (AxisFault axisFault) {
            LOG.error((Object)"(setupAxisConfiguration:83): ", (Throwable)axisFault);
        }
    }

    static {
        $assertionsDisabled = !Axis2ServiceMgr.class.desiredAssertionStatus();
        LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.pojomgr.axis2.internal.Axis2ServiceMgr");
    }
}

