/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.pojomgr.axis2.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.service.internal.IInternalService;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import com.crystaldecisions.sdk.plugin.desktop.server.IServiceDeploymentConfig;
import com.crystaldecisions.sdk.pojomgr.axis2.deployment.internal.ClientDeploymentDescriptor;
import com.crystaldecisions.sdk.pojomgr.axis2.deployment.internal.IClientDeploymentDescriptor;
import com.crystaldecisions.sdk.pojomgr.axis2.deployment.internal.IOperation;
import com.crystaldecisions.sdk.pojomgr.axis2.internal.AxisOperationHelper;
import com.crystaldecisions.sdk.properties.IProperties;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;

public class InfoStoreAxisConfigurator
implements AxisConfigurator {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.pojomgr.axis2.internal.InfoStoreAxisConfigurator");
    private final AxisConfiguration m_configuration;
    private String m_aps;
    private String m_cluster;
    private String m_svr;

    public InfoStoreAxisConfigurator(AxisConfiguration configuration, String svr, String serviceName, String aps, String cluster) {
        this.m_configuration = configuration;
        this.m_aps = aps;
        this.m_cluster = cluster;
        this.m_svr = svr;
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        return this.m_configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadServices() {
        try {
            ISecuritySession session = SecurityFactory.getFactory().makeServerSession(this.m_aps, this.m_cluster);
            IInternalInfoStore store = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", session);
            IInfoObjects serviceObjects = store.query("select SI_NAME, SI_DEPLOYMENT_DESCRIPTOR from ci_systemobjects where si_kind='service' and si_service_type='pojo'");
            AxisConfiguration axisConfiguration = this.m_configuration;
            synchronized (axisConfiguration) {
                for (int i = 0; i < serviceObjects.size(); ++i) {
                    IInternalService service = (IInternalService)serviceObjects.get(i);
                    String serviceName = service.getTitle();
                    if (this.m_configuration.getServiceForActivation(serviceName) != null) continue;
                    IServiceDeploymentConfig svcDeploymentConfig = service.getDeploymentConfig();
                    IProperties deploymentDescriptor = svcDeploymentConfig.getDeploymentDescriptor();
                    ClientDeploymentDescriptor dd = new ClientDeploymentDescriptor(deploymentDescriptor);
                    try {
                        this.addService(serviceName, dd);
                        continue;
                    }
                    catch (SDKException e) {
                        LOG.error((Object)"(loadServices:100): failed to load services", (Throwable)((Object)e));
                    }
                }
            }
        }
        catch (SDKException e) {
            LOG.error((Object)"(loadServices:100): failed to load services", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addService(String serviceName, IClientDeploymentDescriptor dd) throws SDKException {
        AxisConfiguration axisConfiguration = this.m_configuration;
        synchronized (axisConfiguration) {
            if (this.m_configuration.getServiceForActivation(serviceName) == null) {
                List operations = dd.getOperations();
                AxisService axisService = new AxisService(serviceName);
                for (int j = 0; j < operations.size(); ++j) {
                    IOperation operation = (IOperation)operations.get(j);
                    int mep = operation.getMep();
                    int mirroredMEP = AxisOperationHelper.mirror(mep);
                    String operationName = operation.getName();
                    QName opName = new QName(operationName);
                    try {
                        AxisOperation mirrorOp = AxisOperationFactory.getAxisOperation((int)mirroredMEP);
                        mirrorOp.setName(opName);
                        axisService.addOperation(mirrorOp);
                        continue;
                    }
                    catch (AxisFault axisFault) {
                        throw new SDKException.FailedToBuildAxisService(serviceName, (Exception)((Object)axisFault));
                    }
                }
                try {
                    this.m_configuration.addService(axisService);
                    this.m_configuration.startService(serviceName);
                }
                catch (AxisFault axisFault) {
                    throw new SDKException.FailedToBuildAxisService(serviceName, (Exception)((Object)axisFault));
                }
            }
        }
    }

    public void engageGlobalModules() throws AxisFault {
    }

    public void cleanup() {
    }
}

