/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.properties.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.ISDKList;
import com.crystaldecisions.sdk.properties.internal.ISDKElement;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBagHelper;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSDKList
extends AbstractList
implements ISDKList {
    private boolean m_readonly;
    private List m_elements;
    private SDKPropertyBagHelper m_bagHelper;
    protected PropertyArrayHelper m_bag;

    protected AbstractSDKList(PropertyBag bag, Integer countID, Integer keyID, boolean useKeyID, Integer baseID, boolean readonly) {
        this.m_bag = new PropertyArrayHelper(bag, countID, baseID);
        this.m_elements = new ArrayList(this.m_bag.size());
        this.buildArray();
        if (useKeyID) {
            this.m_bagHelper = new SDKPropertyBagHelper(this.m_bag, keyID);
        }
        this.m_readonly = readonly;
    }

    protected AbstractSDKList(PropertyBag bag, Integer countID, Integer keyID, boolean useKeyID, boolean readonly) {
        this.m_bag = new PropertyArrayHelper(bag, countID);
        this.m_elements = new ArrayList(this.m_bag.size());
        this.buildArray();
        if (useKeyID) {
            this.m_bagHelper = new SDKPropertyBagHelper(this.m_bag, keyID);
        }
        this.m_readonly = readonly;
    }

    protected AbstractSDKList(PropertyBag bag, boolean readOnly) {
        this.m_bag = new PropertyArrayHelper(bag);
        this.m_elements = new ArrayList(this.m_bag.size());
        this.m_readonly = readOnly;
        this.buildArray();
    }

    public synchronized Object get(int index) {
        Object item = this.m_elements.get(index);
        if (item == null) {
            Object obj = this.createCollectionObject(index);
            this.m_elements.set(index, obj);
            return obj;
        }
        return item;
    }

    public synchronized Object get(Object key) {
        if (this.m_bagHelper == null) {
            throw new UnsupportedOperationException();
        }
        int index = this.m_bagHelper.getIndex(key);
        if (index != -1) {
            return this.get(index);
        }
        return null;
    }

    public synchronized Object remove(int index) {
        if (this.m_readonly) {
            throw new UnsupportedOperationException();
        }
        Object o = this.m_elements.remove(index);
        if (this.m_bagHelper != null) {
            this.m_bagHelper.remove(index);
        } else {
            this.m_bag.remove(index);
        }
        return o;
    }

    public synchronized boolean remove(Object o) {
        if (this.m_readonly) {
            throw new UnsupportedOperationException();
        }
        int index = this.findObject(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public int size() {
        return this.m_elements.size();
    }

    protected Object addNewObjectToCollection() {
        int size = this.m_elements.size();
        this.m_elements.add(null);
        if (this.m_bagHelper != null) {
            this.m_bagHelper.add();
        }
        Object newObj = this.createCollectionObject(size);
        this.m_elements.set(size, newObj);
        return this.m_elements.get(size);
    }

    protected void addNewObjectToCollection(ISDKElement newObject) {
        IProperties newBag = (IProperties)this.m_bag.add(null, 0x8000000).getValue();
        newObject.assumeProperties(newBag);
        this.m_elements.add(newObject);
        if (this.m_bagHelper != null) {
            this.m_bagHelper.add();
        }
    }

    protected abstract Object createCollectionObject(int var1);

    private void buildArray() {
        for (int i = 0; i < this.m_bag.size(); ++i) {
            this.m_elements.add(i, null);
        }
    }

    private int findObject(Object o) {
        int index;
        if (this.m_bagHelper != null && (index = this.m_bagHelper.find(o)) != -1) {
            return index;
        }
        index = 0;
        Iterator e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() == null) {
                    return index;
                }
                ++index;
            }
        } else {
            while (e.hasNext()) {
                if (o.equals(e.next())) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    protected boolean getReadOnly() {
        return this.m_readonly;
    }

    protected void setReadOnly(boolean value) {
        this.m_readonly = value;
    }
}

