/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.properties.internal;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBagHelper;
import java.util.ArrayList;
import java.util.Iterator;

public class PropContainerHelper {

    public static class Map {
        private Integer m_keyID;
        private Integer m_valueID;
        private SDKPropertyBagHelper m_bagHelper;

        public Map(PropertyBag propBag, Integer keyID, Integer valueID) {
            this.m_bagHelper = new SDKPropertyBagHelper(propBag, keyID);
            this.m_keyID = keyID;
            this.m_valueID = valueID;
        }

        public Object get(Object key) {
            PropertyBag bag = (PropertyBag)this.m_bagHelper.get(key);
            if (bag != null) {
                return bag.getItem((Object)this.m_valueID).getValue();
            }
            return null;
        }

        public Object put(Object key, Object value) {
            PropertyBag bag = (PropertyBag)this.m_bagHelper.get(key);
            if (bag != null) {
                Object oldValue = bag.getItem((Object)this.m_valueID).getValue();
                bag.setProperty((Object)this.m_valueID, value);
                return oldValue;
            }
            PropertyBag newBag = this.m_bagHelper.add(key);
            newBag.addItem((Object)this.m_valueID, value, 0);
            return null;
        }

        public boolean containsKey(Object key) {
            return this.m_bagHelper.getIndex(key) != -1;
        }

        public Object remove(Object key) {
            PropertyBag bag = (PropertyBag)this.m_bagHelper.get(key);
            if (bag != null) {
                Object deleteValue = bag.getItem((Object)this.m_valueID).getValue();
                this.m_bagHelper.remove(key);
                return deleteValue;
            }
            return null;
        }

        public int size() {
            return this.m_bagHelper.size();
        }

        public Object[] keyArray(Object[] arr) {
            ArrayList<Object> keys = new ArrayList<Object>(this.size());
            Iterator itr = this.m_bagHelper.iterator();
            while (itr.hasNext()) {
                PropertyBag bag = (PropertyBag)itr.next();
                keys.add(bag.getItem((Object)this.m_keyID).getValue());
            }
            return keys.toArray(arr);
        }
    }

    public static class Set {
        private Integer m_keyID;
        private SDKPropertyBagHelper m_bagHelper;

        public Set(PropertyBag propBag, Integer keyID) {
            this.m_keyID = keyID;
            this.m_bagHelper = new SDKPropertyBagHelper(propBag, keyID);
        }

        public boolean contains(Object item) {
            return this.m_bagHelper.getIndex(item) != -1;
        }

        public boolean add(Object item) {
            if (this.contains(item)) {
                return false;
            }
            return this.m_bagHelper.add(item) != null;
        }

        public boolean remove(Object item) {
            int index = this.m_bagHelper.getIndex(item);
            if (index == -1) {
                return false;
            }
            this.m_bagHelper.remove(index);
            return true;
        }

        public int size() {
            return this.m_bagHelper.size();
        }

        public Object[] toArray(Object[] arr) {
            ArrayList<Object> result = new ArrayList<Object>(this.size());
            Iterator itr = this.m_bagHelper.iterator();
            while (itr.hasNext()) {
                PropertyBag bag = (PropertyBag)itr.next();
                result.add(bag.getItem((Object)this.m_keyID).getValue());
            }
            return result.toArray(arr);
        }
    }
}

