/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigurationHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)ConfigurationHelper.class.getName());
    private String m_configurationPath = "";
    private Properties m_properties = null;
    private static HashMap propertyFileMap = new HashMap();

    private ConfigurationHelper(String configFilePath) {
        try {
            this.m_configurationPath = configFilePath;
            this.m_properties = new Properties();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream stream = cl.getResourceAsStream(configFilePath);
            if (stream == null) {
                cl = this.getClass().getClassLoader();
                stream = cl.getResourceAsStream(configFilePath);
            }
            if (stream == null) {
                LOG.warn((Object)("Unable to retrieve input stream from config file: " + configFilePath + ".  Using defaults."));
            } else {
                this.m_properties.load(stream);
            }
            this.m_properties.putAll((Map<?, ?>)System.getProperties());
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to retrieve input stream from config file: " + configFilePath + ".  Using defaults. The error was: " + ioe.getMessage()));
        }
        catch (Throwable t) {
            LOG.warn((Object)("Unable to load properties from config file: " + configFilePath + ".  Using defaults.  The error was: " + t.getMessage()));
        }
    }

    public static synchronized ConfigurationHelper getInstance(String configFilePath) {
        if (propertyFileMap.containsKey(configFilePath)) {
            return (ConfigurationHelper)propertyFileMap.get(configFilePath);
        }
        ConfigurationHelper newHelper = new ConfigurationHelper(configFilePath);
        propertyFileMap.put(configFilePath, newHelper);
        return newHelper;
    }

    public static String getProperty(Properties props, String propName, String defaultValue) {
        String retVal = defaultValue;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getProperty " + propName));
        }
        if (props != null) {
            retVal = props.getProperty(propName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found property " + propName + " = " + retVal));
            }
            if (retVal == null || retVal.equals("")) {
                retVal = defaultValue;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning property " + propName + " = " + retVal));
        }
        return retVal;
    }

    public static boolean getPropertyAsBoolean(Properties props, String propName, boolean defaultValue) {
        String sVal;
        boolean retVal = defaultValue;
        if (props != null && (sVal = props.getProperty(propName)) != null && !sVal.equals("")) {
            sVal = sVal.trim();
            retVal = Boolean.valueOf(sVal.toLowerCase());
        }
        return retVal;
    }

    public static int getPropertyAsInt(Properties props, String propName, int defaultValue) {
        String sVal;
        int retVal = defaultValue;
        if (props != null && (sVal = props.getProperty(propName)) != null && !sVal.equals("")) {
            sVal = sVal.trim();
            retVal = Integer.parseInt(sVal);
        }
        return retVal;
    }

    public static long getPropertyAsLong(Properties props, String propName, long defaultVal) {
        String sVal;
        long retVal = defaultVal;
        if (props != null && (sVal = props.getProperty(propName)) != null && !sVal.equals("")) {
            sVal = sVal.trim();
            retVal = Long.parseLong(sVal);
        }
        return retVal;
    }

    public String getPath() {
        return this.m_configurationPath;
    }

    public String getProperty(String strPropertyName, String strDefaultValue) {
        return ConfigurationHelper.getProperty(this.m_properties, strPropertyName, strDefaultValue);
    }

    public boolean getPropertyAsBoolean(String strPropertyName, boolean bDefaultValue) {
        return ConfigurationHelper.getPropertyAsBoolean(this.m_properties, strPropertyName, bDefaultValue);
    }

    public int getPropertyAsInt(String strPropertyName, int iDefaultValue) {
        return ConfigurationHelper.getPropertyAsInt(this.m_properties, strPropertyName, iDefaultValue);
    }

    public long getPropertyAsLong(String strPropertyName, long lDefaultValue) {
        return ConfigurationHelper.getPropertyAsLong(this.m_properties, strPropertyName, lDefaultValue);
    }
}

