/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.uri.internal.Condition;
import com.crystaldecisions.sdk.uri.internal.Conditions;
import com.crystaldecisions.sdk.uri.internal.OrderByEntry;
import java.util.LinkedList;
import java.util.List;

class CustomOrderByEntry
extends OrderByEntry {
    String[] boundaryValues;
    private String lastLowerValue;

    public CustomOrderByEntry(String propertyName, String[] boundaryValues) {
        super(propertyName);
        this.boundaryValues = boundaryValues;
    }

    public CustomOrderByEntry(String propertyName, String boundaryString) {
        super(propertyName);
        String[] params = boundaryString.split(",", -1);
        for (int i = 0; i < params.length; ++i) {
            params[i] = params[i].trim();
            if (!params[i].startsWith("'") || !params[i].endsWith("'")) continue;
            params[i] = params[i].substring(1, params[i].length() - 1);
        }
        this.boundaryValues = params;
    }

    public boolean containsValue(String value) {
        String[] bounds = this.boundaryValues;
        for (int k = 0; k < bounds.length; ++k) {
            String bd = bounds[k];
            if (!value.equalsIgnoreCase(bd)) continue;
            return true;
        }
        return false;
    }

    public List getSubRangeString(String lowerValue, String upperValue) {
        LinkedList<String> subValues = new LinkedList<String>();
        boolean appendValue = false;
        for (int k = 0; k < this.boundaryValues.length; ++k) {
            String bd = this.boundaryValues[k];
            if (appendValue) {
                if (upperValue.equalsIgnoreCase(bd)) break;
                subValues.add(bd);
            }
            if (!lowerValue.equalsIgnoreCase(bd)) continue;
            appendValue = true;
        }
        return subValues;
    }

    public Conditions getEqualsClause(String value) {
        Conditions conditions = new Conditions(true);
        LinkedList<String> valList = new LinkedList<String>();
        String[] bounds = this.boundaryValues;
        for (int k = 0; k < bounds.length; ++k) {
            if (value.equals(bounds[k])) {
                conditions.add(new Condition(this.getPropertyName(), "=", bounds[k]));
                return conditions;
            }
            valList.add(bounds[k]);
        }
        conditions.add(new Condition(this.getPropertyName(), false, valList));
        return conditions;
    }

    public Conditions getLowerBoundClause(int objID, String value, boolean isLastEntry, boolean lowerBoundObjInclusive) {
        this.lastLowerValue = value;
        Conditions conditions = new Conditions(true);
        LinkedList<String> valList = new LinkedList<String>();
        String[] bounds = this.boundaryValues;
        for (int k = 0; k < bounds.length; ++k) {
            valList.add(bounds[k]);
            if (!value.equals(bounds[k])) continue;
            if (isLastEntry && lowerBoundObjInclusive) {
                valList.remove(valList.size() - 1);
                if (k == 0) {
                    conditions.add(new Condition.TrueCondition());
                    return conditions;
                }
            }
            conditions.add(new Condition(this.getPropertyName(), false, valList));
            return conditions;
        }
        if (isLastEntry) {
            conditions.add(new Condition(this.getPropertyName(), false, valList));
            if (lowerBoundObjInclusive) {
                conditions.add(new Condition("SI_ID", ">=", String.valueOf(objID)));
            } else {
                conditions.add(new Condition("SI_ID", ">", String.valueOf(objID)));
            }
            return conditions;
        }
        return null;
    }

    public Conditions getUpperBoundClause(int objID, String value, boolean isLastEntry) {
        Conditions conditions = new Conditions(true);
        LinkedList<String> valList = new LinkedList<String>();
        LinkedList<String> lastEntryValList = new LinkedList<String>();
        boolean lowerBoundInBoundValues = false;
        String[] bounds = this.boundaryValues;
        for (int k = 0; k < bounds.length; ++k) {
            if (value.equals(bounds[k])) {
                if (k == 0) {
                    return null;
                }
                if (isLastEntry) {
                    valList.add(bounds[k]);
                }
                conditions.add(new Condition(this.getPropertyName(), true, valList));
                return conditions;
            }
            if (isLastEntry && objID > -1 && this.lastLowerValue.equals(bounds[k]) || lowerBoundInBoundValues) {
                lowerBoundInBoundValues = true;
                lastEntryValList.add(bounds[k]);
            }
            valList.add(bounds[k]);
        }
        if (isLastEntry && objID > -1) {
            if (!lastEntryValList.isEmpty()) {
                conditions.add(new Condition(this.getPropertyName(), true, lastEntryValList));
                conditions.setDisjunction();
            }
            conditions.add(new Condition("SI_ID", "<=", String.valueOf(objID)));
            return conditions;
        }
        conditions.add(new Condition(this.getPropertyName(), true, valList));
        return conditions;
    }

    public int getOrderType() {
        return 3;
    }
}

