/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.uri.internal.BoundPredicate;
import com.crystaldecisions.sdk.uri.internal.Condition;
import com.crystaldecisions.sdk.uri.internal.Conditions;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;

class PagingPredicate {
    private static final TreeSet m_constantProperties = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private Conditions predefinedConditions = new Conditions(true);
    private Conditions definingConditions;

    public PagingPredicate(Conditions definingConditions) {
        this.definingConditions = definingConditions;
    }

    public void addDefiningCondition(Condition cond) {
        this.definingConditions.add(cond);
    }

    public void addDefiningConditions(Conditions conditions) {
        this.definingConditions.addAll(conditions);
    }

    public void addPredefinedCondition(Condition cond) {
        this.predefinedConditions.add(cond);
    }

    public void addPredefinedConditions(Conditions conditions) {
        this.predefinedConditions.addAll(conditions);
    }

    public Conditions getDefiningConditions() {
        return this.definingConditions;
    }

    public Iterator getDefiningCondIterator() {
        return this.definingConditions.iterator();
    }

    public String getDefiningProperty() {
        Condition cond = this.definingConditions.get(0);
        return cond.getProperty();
    }

    public Iterator getPredefinedCondIterator() {
        return this.predefinedConditions.iterator();
    }

    public boolean hasPredefinedConditions() {
        return !this.predefinedConditions.isEmpty();
    }

    public boolean isDefinedOnCustomOrderByEntry() {
        if (this.definingConditions.isEmpty()) {
            return false;
        }
        Condition firstCond = this.definingConditions.get(0);
        return firstCond.getOperator().equalsIgnoreCase("IN") || firstCond.getOperator().equalsIgnoreCase("NOT IN");
    }

    public void removeDefiningCondition(int pos) {
        this.definingConditions.remove(pos);
    }

    public void removePredefinedCondition(int pos) {
        this.predefinedConditions.remove(pos);
    }

    public String toString() {
        boolean needsParenthesis;
        StringBuffer result = new StringBuffer();
        StringBuffer predefinedString = new StringBuffer();
        StringBuffer definingString = new StringBuffer();
        predefinedString.append(this.predefinedConditions);
        definingString.append(this.definingConditions);
        if (predefinedString.length() > 0) {
            boolean bl = needsParenthesis = !this.predefinedConditions.isConjunction() && this.predefinedConditions.size() > 1 && definingString.length() > 0;
            if (needsParenthesis) {
                result.append('(');
            }
            result.append(predefinedString);
            if (needsParenthesis) {
                result.append(')');
            }
            if (definingString.length() > 0) {
                result.append(" AND ");
            }
        }
        if (definingString.length() > 0) {
            boolean bl = needsParenthesis = !this.definingConditions.isConjunction() && this.definingConditions.size() > 1 && predefinedString.length() > 0;
            if (needsParenthesis) {
                result.append('(');
            }
            result.append(definingString);
            if (needsParenthesis) {
                result.append(')');
            }
        }
        return result.toString();
    }

    public static void optimizeConditions(BoundPredicate lowerBound, BoundPredicate upperBound) {
        PagingPredicate.removeTrueConditions(lowerBound);
        PagingPredicate.removeTrueConditions(upperBound);
        PagingPredicate.optimizeExcessNulls(lowerBound, upperBound);
        PagingPredicate.factorOutConditions(lowerBound, upperBound);
    }

    private static void removeTrueConditions(BoundPredicate pagingPredicates) {
        Iterator it = pagingPredicates.getPagingPredicatesIterator();
        while (it.hasNext()) {
            Object o;
            PagingPredicate currPP = (PagingPredicate)it.next();
            Iterator condIt = currPP.getDefiningCondIterator();
            while (condIt.hasNext()) {
                o = condIt.next();
                if (!(o instanceof Condition.TrueCondition)) continue;
                currPP.definingConditions.clear();
                if (!currPP.predefinedConditions.isEmpty()) break;
                it.remove();
                break;
            }
            condIt = currPP.getPredefinedCondIterator();
            while (condIt.hasNext()) {
                o = condIt.next();
                if (!(o instanceof Condition.TrueCondition)) continue;
                condIt.remove();
            }
        }
    }

    private static void optimizeExcessNulls(BoundPredicate lowerBound, BoundPredicate upperBound) {
        PagingPredicate.optimizeExcessNullsHelper(lowerBound, upperBound);
        PagingPredicate.optimizeExcessNullsHelper(upperBound, lowerBound);
    }

    private static void optimizeExcessNullsHelper(BoundPredicate targetBound, BoundPredicate comparisonBound) {
        if (targetBound.isEmpty() || comparisonBound.isEmpty()) {
            return;
        }
        Iterator it1 = targetBound.getPagingPredicatesIterator();
        while (it1.hasNext()) {
            PagingPredicate currPred = (PagingPredicate)it1.next();
            if (currPred.definingConditions.size() <= 1) continue;
            Iterator condIt = currPred.definingConditions.iterator();
            boolean ltCondExists = false;
            int nullCondIndex = -1;
            int i = 0;
            while (condIt.hasNext()) {
                Condition nullCondition;
                Condition currCond = (Condition)condIt.next();
                if (currCond.getOperator().equalsIgnoreCase("<") || currCond.getOperator().equalsIgnoreCase("<=")) {
                    ltCondExists = true;
                } else if (currCond.getOperator().equalsIgnoreCase("IS") && (nullCondition = new Condition(currCond.getProperty(), true)).equals(currCond)) {
                    nullCondIndex = i;
                }
                if (nullCondIndex >= 0 && ltCondExists) break;
                ++i;
            }
            if (nullCondIndex < 0) continue;
            if (m_constantProperties.contains(currPred.getDefiningProperty())) {
                currPred.definingConditions.remove(nullCondIndex);
                continue;
            }
            Iterator pred2It = comparisonBound.getPagingPredicatesIterator();
            while (pred2It.hasNext()) {
                Condition notNullCondition;
                PagingPredicate currPred2 = (PagingPredicate)pred2It.next();
                if (!currPred2.getDefiningProperty().equalsIgnoreCase(currPred.getDefiningProperty()) || (notNullCondition = new Condition(currPred2.getDefiningProperty(), false)).equals(currPred2.definingConditions.get(0))) continue;
                currPred.definingConditions.remove(nullCondIndex);
            }
        }
    }

    private static void factorOutConditions(BoundPredicate lowerBound, BoundPredicate upperBound) {
        if (lowerBound.numPagingPredicates() < 1) {
            return;
        }
        Iterator ppIt = lowerBound.getPagingPredicatesIterator();
        PagingPredicate firstPagePred = (PagingPredicate)ppIt.next();
        if (firstPagePred.predefinedConditions.size() == 0) {
            return;
        }
        LinkedHashSet commonConditions = new LinkedHashSet();
        Iterator precondIt = firstPagePred.predefinedConditions.iterator();
        while (precondIt.hasNext()) {
            Object o = precondIt.next();
            commonConditions.add(o);
        }
        while (ppIt.hasNext() && firstPagePred.predefinedConditions.size() > 0) {
            PagingPredicate currPagePred = (PagingPredicate)ppIt.next();
            Iterator ccIt = commonConditions.iterator();
            while (ccIt.hasNext()) {
                Condition currCC = (Condition)ccIt.next();
                if (currPagePred.predefinedConditions.contains(currCC)) continue;
                ccIt.remove();
            }
        }
        Iterator ccIt = commonConditions.iterator();
        while (ccIt.hasNext()) {
            Condition currCC = (Condition)ccIt.next();
            lowerBound.addCommonCondition(currCC);
            ppIt = lowerBound.getPagingPredicatesIterator();
            while (ppIt.hasNext()) {
                PagingPredicate currPagePred = (PagingPredicate)ppIt.next();
                currPagePred.predefinedConditions.remove(currCC);
            }
            Iterator ppIt2 = upperBound.getPagingPredicatesIterator();
            while (ppIt2.hasNext()) {
                PagingPredicate currPagePred = (PagingPredicate)ppIt2.next();
                currPagePred.predefinedConditions.remove(currCC);
            }
        }
    }

    static {
        m_constantProperties.add("SI_APPLICATION_OBJECT");
        m_constantProperties.add("SI_CHILDREN");
        m_constantProperties.add("SI_CREATION_TIME");
        m_constantProperties.add("SI_COMPONENT");
        m_constantProperties.add("SI_CUID");
        m_constantProperties.add("SI_FLAGS");
        m_constantProperties.add("SI_GUID");
        m_constantProperties.add("SI_HAS_CHILDREN");
        m_constantProperties.add("SI_HIDDEN_OBJECT");
        m_constantProperties.add("SI_ID");
        m_constantProperties.add("SI_INSTANCE");
        m_constantProperties.add("SI_INSTANCE_OBJECT");
        m_constantProperties.add("SI_IS_SCHEDULABLE");
        m_constantProperties.add("SI_KIND");
        m_constantProperties.add("SI_LOCK_INFO");
        m_constantProperties.add("SI_NAME");
        m_constantProperties.add("SI_OBJ_VERSION");
        m_constantProperties.add("SI_OBTYPE");
        m_constantProperties.add("SI_OWNER");
        m_constantProperties.add("SI_OWNERID");
        m_constantProperties.add("SI_PARENTID");
        m_constantProperties.add("SI_PARENT_CUID");
        m_constantProperties.add("SI_PARENT_FOLDER");
        m_constantProperties.add("SI_PARENT_FOLDER_CUID");
        m_constantProperties.add("SI_PLUGIN_OBJECT");
        m_constantProperties.add("SI_PROGID");
        m_constantProperties.add("SI_ROLES_ON_OBJECT");
        m_constantProperties.add("SI_RUID");
        m_constantProperties.add("SI_RUNNABLE_OBJECT");
        m_constantProperties.add("SI_SENDABLE");
        m_constantProperties.add("SI_SYSTEM_OBJECT");
        m_constantProperties.add("SI_TABLE");
        m_constantProperties.add("SI_UPDATE_TS");
    }
}

