/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.uri.internal.ConfigurationHelper;
import com.crystaldecisions.sdk.uri.internal.StringHelper;

public class SearchHelper {
    public static final int SEARCH_NAME = 1;
    public static final int SEARCH_KEYWORDS = 2;
    public static final int SEARCH_DESCRIPTION = 4;
    public static final int SEARCH_CASE_SENSITIVE = 8;
    public static final int SEARCH_ALL_WORDS = 16;
    public static final int SEARCH_WITHOUT_WORDS = 32;
    public static final int SEARCH_EXACT = 64;
    public static final int SEARCH_INCLUDE_INSTANCES = 128;
    public static final int DEFAULT_SEARCH_OPTIONS = 3;
    private static String SEARCH_SELECT_LIST;
    private int searchOptions = 0;
    private boolean keywordDirty = false;
    private boolean nameDirty = false;
    private StringBuffer searchNameSQL = null;
    private StringBuffer searchKeywordSQL = null;
    private String querySelect = "";
    private String queryFrom = "";
    private String queryWhere = "";
    public static String PROP_SEARCH_SELECT_LIST;
    public static String PROP_DEF_SEARCH_SELECT_LIST;

    public String getQuerySelect() {
        return this.querySelect;
    }

    public String getQueryFrom() {
        return this.queryFrom;
    }

    public String getQueryWhere() {
        return this.queryWhere;
    }

    public SearchHelper(int searchOptions) {
        this.searchOptions = searchOptions;
        this.searchNameSQL = new StringBuffer("");
        this.searchKeywordSQL = new StringBuffer("");
        this.nameDirty = false;
        this.keywordDirty = false;
    }

    public boolean checkSearchOptions(int param) {
        return (this.searchOptions & param) > 0;
    }

    protected String finishSQL() {
        String returnSQL = "SELECT " + SEARCH_SELECT_LIST + " FROM CI_INFOOBJECTS WHERE ";
        String whereClause = "";
        int nameLength = this.searchNameSQL.length();
        int keywordLength = this.searchKeywordSQL.length();
        if (nameLength > 0 && keywordLength > 0) {
            whereClause = "(" + this.searchNameSQL.toString() + ") OR (" + this.searchKeywordSQL.toString() + ")";
        } else if (nameLength > 0) {
            whereClause = this.searchNameSQL.toString();
        } else if (keywordLength > 0) {
            whereClause = this.searchKeywordSQL.toString();
        }
        this.querySelect = SEARCH_SELECT_LIST;
        this.queryFrom = "CI_INFOOBJECTS";
        this.queryWhere = this.checkSearchOptions(32) ? "(NOT (" + whereClause + "))" : "(" + whereClause + ")";
        if (!this.checkSearchOptions(128)) {
            this.queryWhere = this.queryWhere + " AND (SI_INSTANCE=0)";
        }
        return returnSQL + this.queryWhere;
    }

    protected String formatSearchWord(String word) {
        String result = "";
        if (!this.checkSearchOptions(8)) {
            result = StringHelper.decodeURIToSQL(word);
        } else {
            word = StringHelper.decodeURI(word);
            int size = word.length();
            for (int i = 0; i < size; ++i) {
                char curChar = word.charAt(i);
                result = curChar == '\'' ? result + "''" : result + "[" + curChar + "]";
            }
        }
        if (!this.checkSearchOptions(64)) {
            result = "%" + result + "%";
        }
        return result;
    }

    protected void addSearchWord(String word) {
        if (this.checkSearchOptions(1)) {
            this.addNameSearch(word);
        }
        if (this.checkSearchOptions(2)) {
            this.addKeywordSearch(word);
        }
    }

    private void addNameSearch(String word) {
        if (this.nameDirty) {
            this.addNameConjunction();
        }
        this.searchNameSQL.append("SI_NAME LIKE '" + word + "'");
        this.nameDirty = true;
    }

    private void addKeywordSearch(String word) {
        if (this.keywordDirty) {
            this.addKeywordConjunction();
        }
        this.searchKeywordSQL.append("SI_KEYWORD LIKE '" + word + "'");
        this.keywordDirty = true;
    }

    private void addNameConjunction() {
        if (this.checkSearchOptions(16)) {
            this.searchNameSQL.append(" AND ");
        } else {
            this.searchNameSQL.append(" OR ");
        }
    }

    private void addKeywordConjunction() {
        if (this.checkSearchOptions(16)) {
            this.searchKeywordSQL.append(" AND ");
        } else {
            this.searchKeywordSQL.append(" OR ");
        }
    }

    static {
        PROP_SEARCH_SELECT_LIST = "searchSelectList";
        PROP_DEF_SEARCH_SELECT_LIST = "*";
        SEARCH_SELECT_LIST = ConfigurationHelper.getInstance("META-INF/CrystalEnterprise.Services/URIQueryParser.properties").getProperty(PROP_SEARCH_SELECT_LIST, PROP_DEF_SEARCH_SELECT_LIST);
    }
}

