/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.URIParserException;
import java.util.Locale;
import java.util.TimeZone;

public class StringHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)StringHelper.class.getName());
    private static final String TIMEZONE_PREFIX = "GMT";

    public static String escXML(String s) {
        if (s == null) {
            return s;
        }
        s = StringHelper.replace(s, "&", "&amp;");
        s = StringHelper.replace(s, "<", "&lt;");
        s = StringHelper.replace(s, ">", "&gt;");
        s = StringHelper.replace(s, "'", "&apos;");
        s = StringHelper.replace(s, "\"", "&quot;");
        return s;
    }

    public static String unescXML(String s) {
        if (s == null) {
            return s;
        }
        s = StringHelper.replace(s, "&amp;", "&");
        s = StringHelper.replace(s, "&lt;", "<");
        s = StringHelper.replace(s, "&gt;", ">");
        s = StringHelper.replace(s, "&apos;", "'");
        s = StringHelper.replace(s, "&quot;", "\"");
        return s;
    }

    public static String replace(String s, String s1, String s2) {
        StringBuffer buf = null;
        int new_i = 0;
        int i = 0;
        while ((new_i = s.indexOf(s1, i)) >= 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(s.substring(i, new_i));
            buf.append(s2);
            i = new_i + s1.length();
        }
        if (buf == null) {
            return s;
        }
        buf.append(s.substring(i));
        return buf.toString();
    }

    public static String escapeSQL(String expression) {
        StringBuffer result = new StringBuffer();
        int length = expression.length();
        for (int i = 0; i < length; ++i) {
            char toEscape = expression.charAt(i);
            result.append(StringHelper.encodeSQLChar(toEscape));
        }
        return result.toString();
    }

    public static String encodeURI(String uri, String escapeChar) throws URIParserException {
        StringBuffer result = new StringBuffer();
        int index = 0;
        while (true) {
            int nextEscape;
            if ((nextEscape = uri.indexOf(escapeChar, index)) < 0) break;
            result.append(uri.substring(index, nextEscape));
            index = nextEscape + 2;
            char toEscape = uri.charAt(nextEscape + 1);
            result.append(StringHelper.encodeChar(toEscape));
        }
        result.append(uri.substring(index));
        return result.toString();
    }

    public static String escapeURI(String expression, String escapeChar) {
        StringBuffer result = new StringBuffer();
        int length = expression.length();
        for (int i = 0; i < length; ++i) {
            char toEscape = expression.charAt(i);
            result.append(StringHelper.escapeURIChar(toEscape, escapeChar));
        }
        return result.toString();
    }

    public static String decodeURI(String query) {
        return StringHelper.decodeURI(query, false);
    }

    public static String decodeURIToSQL(String query) {
        return StringHelper.decodeURI(query, true);
    }

    private static String decodeURI(String query, boolean escapeToSQL) {
        StringBuffer result = new StringBuffer();
        int index = 0;
        int length = query.length();
        while (true) {
            int nextEscape;
            if ((nextEscape = query.indexOf("%", index)) < 0) {
                result.append(query.substring(index));
                break;
            }
            result.append(query.substring(index, nextEscape));
            index = nextEscape + 3;
            if (index > length) {
                result.append(query.substring(nextEscape));
                break;
            }
            String hexValue = query.substring(nextEscape + 1, nextEscape + 3);
            try {
                if (escapeToSQL) {
                    result.append(StringHelper.decodeCharToSQL(hexValue));
                    continue;
                }
                result.append(StringHelper.decodeChar(hexValue));
            }
            catch (Exception e) {
                result.append("%");
                index -= 2;
            }
        }
        return result.toString();
    }

    private static String encodeChar(char toEscape) throws URIParserException {
        switch (toEscape) {
            case '\"': {
                return "%22";
            }
            case '%': {
                return "%25";
            }
            case '&': {
                return "%26";
            }
            case '\'': {
                return "%27";
            }
            case '(': {
                return "%28";
            }
            case ')': {
                return "%29";
            }
            case '*': {
                return "%2A";
            }
            case ',': {
                return "%2C";
            }
            case '/': {
                return "%2F";
            }
            case '<': {
                return "%3C";
            }
            case '>': {
                return "%3E";
            }
            case '?': {
                return "%3F";
            }
            case '@': {
                return "%40";
            }
            case '[': {
                return "%5B";
            }
            case '\\': {
                return "%5C";
            }
            case ']': {
                return "%5D";
            }
            case '^': {
                return "%5E";
            }
            case '{': {
                return "%7B";
            }
            case '}': {
                return "%7D";
            }
        }
        LOG.error((Object)("The escape sequence \\" + toEscape + " is not valid."));
        return String.valueOf(toEscape);
    }

    private static String decodeChar(String hexValue) throws Exception {
        if (hexValue.equals("22")) {
            return "\"";
        }
        if (hexValue.equals("25")) {
            return "%";
        }
        if (hexValue.equals("26")) {
            return "&";
        }
        if (hexValue.equals("27")) {
            return "'";
        }
        if (hexValue.equals("28")) {
            return "(";
        }
        if (hexValue.equals("29")) {
            return ")";
        }
        if (hexValue.equals("2A")) {
            return "*";
        }
        if (hexValue.equals("2C")) {
            return ",";
        }
        if (hexValue.equals("2F")) {
            return "/";
        }
        if (hexValue.equals("3C")) {
            return "<";
        }
        if (hexValue.equals("3E")) {
            return ">";
        }
        if (hexValue.equals("3F")) {
            return "?";
        }
        if (hexValue.equals("40")) {
            return "@";
        }
        if (hexValue.equals("5B")) {
            return "[";
        }
        if (hexValue.equals("5C")) {
            return "\\";
        }
        if (hexValue.equals("5D")) {
            return "]";
        }
        if (hexValue.equals("5E")) {
            return "^";
        }
        if (hexValue.equals("7B")) {
            return "{";
        }
        if (hexValue.equals("7D")) {
            return "}";
        }
        throw new Exception("Invalid Hex Sequence");
    }

    private static String decodeCharToSQL(String hexValue) throws Exception {
        if (hexValue.equals("22")) {
            return "\"";
        }
        if (hexValue.equals("25")) {
            return "[%]";
        }
        if (hexValue.equals("26")) {
            return "&";
        }
        if (hexValue.equals("27")) {
            return "''";
        }
        if (hexValue.equals("28")) {
            return "(";
        }
        if (hexValue.equals("29")) {
            return ")";
        }
        if (hexValue.equals("2A")) {
            return "*";
        }
        if (hexValue.equals("2C")) {
            return ",";
        }
        if (hexValue.equals("2F")) {
            return "/";
        }
        if (hexValue.equals("3C")) {
            return "<";
        }
        if (hexValue.equals("3E")) {
            return ">";
        }
        if (hexValue.equals("3F")) {
            return "[?]";
        }
        if (hexValue.equals("40")) {
            return "@";
        }
        if (hexValue.equals("5B")) {
            return "[[]";
        }
        if (hexValue.equals("5C")) {
            return "\\";
        }
        if (hexValue.equals("5D")) {
            return "[]]";
        }
        if (hexValue.equals("5E")) {
            return "[^]";
        }
        if (hexValue.equals("7B")) {
            return "{";
        }
        if (hexValue.equals("7D")) {
            return "}";
        }
        throw new Exception("Invalid Hex Sequence");
    }

    private static String encodeSQLChar(char toEscape) {
        switch (toEscape) {
            case '%': {
                return "[%]";
            }
            case '\'': {
                return "''";
            }
            case '?': {
                return "[?]";
            }
            case '[': {
                return "[[]";
            }
            case ']': {
                return "[]]";
            }
            case '^': {
                return "[^]";
            }
        }
        return Character.toString(toEscape);
    }

    private static String escapeURIChar(char toEscape, String escapeChar) {
        switch (toEscape) {
            case '&': {
                return escapeChar + "&";
            }
            case '\'': {
                return escapeChar + "'";
            }
            case '*': {
                return escapeChar + "*";
            }
            case ',': {
                return escapeChar + ",";
            }
            case '/': {
                return escapeChar + "/";
            }
            case '<': {
                return escapeChar + "<";
            }
            case '>': {
                return escapeChar + ">";
            }
            case '?': {
                return escapeChar + "?";
            }
            case '@': {
                return escapeChar + "@";
            }
            case '[': {
                return escapeChar + "[";
            }
            case '\\': {
                return escapeChar + "\\";
            }
            case ']': {
                return escapeChar + "]";
            }
            case '{': {
                return escapeChar + "{";
            }
            case '}': {
                return escapeChar + "}";
            }
        }
        return Character.toString(toEscape);
    }

    public static Locale parseLocale(String localeStr) {
        if (localeStr == null || "".equals(localeStr) || localeStr.length() < 2) {
            return Locale.getDefault();
        }
        try {
            int pos = localeStr.indexOf(95);
            if (pos != -1) {
                String language = localeStr.substring(0, pos);
                int posCountry = localeStr.indexOf(95, pos + 1);
                String country = posCountry != -1 ? localeStr.substring(pos + 1, posCountry) : localeStr.substring(pos + 1);
                return new Locale(language, country, "");
            }
            return new Locale(localeStr, "", "");
        }
        catch (Exception exp) {
            return Locale.getDefault();
        }
    }

    public static TimeZone parseTimeZone(String tzStr) {
        if (tzStr == null || "".equals(tzStr) || tzStr.indexOf(TIMEZONE_PREFIX) != 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(tzStr);
    }
}

