/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.URIParserException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.uri.IPageResult;
import com.crystaldecisions.sdk.uri.IStatelessPageInfo;
import com.crystaldecisions.sdk.uri.PagingQueryOptions;
import com.crystaldecisions.sdk.uri.internal.ConfigurationHelper;
import com.crystaldecisions.sdk.uri.internal.PageBlock;
import com.crystaldecisions.sdk.uri.internal.SQLQueryHolder;
import com.crystaldecisions.sdk.uri.internal.StringHelper;
import com.crystaldecisions.sdk.uri.internal.URIPageInfo;
import com.crystaldecisions.sdk.uri.internal.URIPageResult;
import com.crystaldecisions.sdk.uri.internal.URIPageResultBase;
import com.crystaldecisions.sdk.uri.internal.URIQueryCache;
import com.crystaldecisions.sdk.uri.internal.URIQueryParser;
import java.util.Vector;

public class URIPageFactory {
    private static final ILogger LOG = LoggerManager.getLogger((String)URIPageFactory.class.getName());
    private static final int DEFAULT_MAX_OBJS = 1000;
    private static int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_RANGE_SIZE = 500;
    private static final int DEFAULT_RANGE_SIZE = 2;
    public static int NO_PAGING_QUERY_LIMIT;
    public static boolean USE_PAGING_CACHE;

    public static IStatelessPageInfo fetchPage(IInfoStore infoStore, String uri, PagingQueryOptions options) throws SDKException {
        SQLQueryHolder query = URIPageFactory.getSQLQueryHolder(infoStore, uri, options);
        if (query != null) {
            if (query.getEveryN() > 0 || query.getTopN() > 0) {
                return new URIPageInfo(query.getFullQueryTopLimit(NO_PAGING_QUERY_LIMIT));
            }
            return new URIPageInfo(query.getFullQueryTopLimit(options.getPageSize()));
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Unable to parse URI: " + uri));
        }
        throw new URIParserException.InvalidURI(uri);
    }

    public static IPageResult pageResult(IInfoStore infoStore, String uri, PagingQueryOptions options) throws SDKException {
        SQLQueryHolder query;
        if (options == null) {
            options = new PagingQueryOptions(DEFAULT_PAGE_SIZE);
        }
        if ((query = URIPageFactory.getSQLQueryHolder(infoStore, uri, options)) != null) {
            if (query.isPagingNeeded()) {
                if (options.getPageSize() > NO_PAGING_QUERY_LIMIT) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Specified page size was larger than max allowed.  Setting page size to " + NO_PAGING_QUERY_LIMIT + "."));
                    }
                    options.setPageSize(NO_PAGING_QUERY_LIMIT);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Paging SQL Query: Page Size = " + options.getPageSize() + ")" + ", URI='" + uri + "'" + ", Full SQL='" + query + "'"));
                }
                if (query.getEveryN() > 0 || query.getTopN() > 0) {
                    if (options.isIncremental()) {
                        throw new SDKException.InvalidOperation();
                    }
                    return URIPageFactory.getPagedResult(infoStore, uri, query, options);
                }
                if (options.getPageSize() < 1) {
                    options.setIsIncremental(false);
                }
                return URIPageFactory.getPagedResultEvery(infoStore, uri, query, options);
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("The given query has already been paged (repaging is not supported).  The full result set of URI='" + uri + "' will be returned (SQL='" + query.getFullQuery() + "')"));
            }
            throw new SDKException.InvalidArg(uri);
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("URIQueryParser indicated no query necessary, returning empty response (URI=" + uri + ")"));
        }
        throw new SDKException.InvalidArg(uri);
    }

    private static SQLQueryHolder getSQLQueryHolder(IInfoStore infoStore, String uri, PagingQueryOptions options) throws SDKException {
        SQLQueryHolder query = null;
        URIQueryCache queryCache = null;
        if (USE_PAGING_CACHE) {
            queryCache = URIQueryCache.getCache();
            query = queryCache.findQuery(uri);
        }
        if (query != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Query with URI='" + uri + "' was found in the cache.  Attempting to use cached query..."));
            }
            query.updatePaging(StringHelper.encodeURI(uri, "\\"));
        }
        if (query == null || query.isPagingNeeded()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Query with URI='" + uri + "' needs to be parsed (either the query was not in the cache or the query needs to be repaged)."));
            }
            URIQueryParser parser = new URIQueryParser(infoStore);
            if (options != null) {
                query = parser.processURI(uri, options.isOptionSet(PagingQueryOptions.SKIP_QUERY_URI_DECODE), options);
                if (options.isOptionSet(PagingQueryOptions.INCLUDE_SECURITY)) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Appending Security fields to select list of URI='" + uri + "'."));
                    }
                    query.addSecurityFields();
                }
                if (options.isOptionSet(PagingQueryOptions.EXCLUDE_TEMP_STORAGE)) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Appending exclusion fields to the where list of URI='" + uri + "'."));
                    }
                    query.dropTempStorageObjects();
                }
                if (query.getPageSize() > 0 && options.getPageSize() != query.getPageSize()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Specified page size is different from the pagesize uri is created.  Setting page size to " + query.getPageSize() + "."));
                    }
                    options.setPageSize(query.getPageSize());
                }
            } else {
                query = parser.processURI(uri, false, options);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Adding query with URI='" + uri + "' to the cache, full SQL='" + query + "'."));
            }
            if (USE_PAGING_CACHE) {
                queryCache.putQuery(uri, query);
            }
        }
        return query;
    }

    private static URIPageResultBase getPagedResult(IInfoStore infoStore, String uri, SQLQueryHolder query, PagingQueryOptions options) throws SDKException {
        int currNumObjects = 0;
        int totalNumObjects = 0;
        int currentLowerIndex = 0;
        boolean hasTopN = query.getTopN() >= 0;
        Vector<String> pageURIs = new Vector<String>();
        IInfoObject lowerObj = null;
        IInfoObject upperObj = null;
        int pageSize = options.getPageSize();
        int rangesize = 500;
        String indexQuery = query.getIndexQuery(-1, rangesize);
        if (options.isIncremental()) {
            throw new URIParserException.InvalidSQLQuery(indexQuery);
        }
        IInfoObjects indexedResponse = infoStore.query(indexQuery);
        if (indexedResponse == null) {
            LOG.error((Object)("IInfoStore returned null on a query call for query: " + indexQuery));
            throw new URIParserException.InvalidSQLQuery(indexQuery);
        }
        totalNumObjects = currNumObjects = indexedResponse.size();
        if (currNumObjects > 0) {
            lowerObj = (IInfoObject)indexedResponse.get(0);
            boolean breakLoop = false;
            while (!breakLoop) {
                if (currNumObjects >= currentLowerIndex + pageSize && pageSize > 0) {
                    upperObj = (IInfoObject)indexedResponse.get(currentLowerIndex + pageSize - 1);
                    pageURIs.add(URIPageFactory.buildPageURI(lowerObj, upperObj, uri, query, options));
                    if (currNumObjects == (currentLowerIndex += pageSize)) {
                        lowerObj = null;
                        continue;
                    }
                    lowerObj = (IInfoObject)indexedResponse.get(currentLowerIndex);
                    continue;
                }
                upperObj = (IInfoObject)indexedResponse.get(currNumObjects - 1);
                int numRemainderObjs = currNumObjects - currentLowerIndex;
                if (!hasTopN && currNumObjects == 1000) {
                    indexQuery = query.getIndexQuery(upperObj, -1, rangesize);
                    indexedResponse = infoStore.query(indexQuery);
                    currNumObjects = indexedResponse.size();
                    totalNumObjects += currNumObjects - 1;
                    currentLowerIndex = numRemainderObjs * -1;
                    if (indexedResponse.size() <= 1) {
                        if (lowerObj != null) {
                            pageURIs.add(URIPageFactory.buildPageURI(lowerObj, upperObj, uri, query, options));
                        }
                        breakLoop = true;
                        continue;
                    }
                    if (lowerObj != null) continue;
                    lowerObj = (IInfoObject)indexedResponse.get(1);
                    continue;
                }
                if (lowerObj != null) {
                    pageURIs.add(URIPageFactory.buildPageURI(lowerObj, upperObj, uri, query, options));
                }
                breakLoop = true;
            }
        }
        return new URIPageResultBase(pageURIs, totalNumObjects, pageSize);
    }

    static void updatePagedResultEveryHelper(int index, URIPageResult currResult) throws SDKException {
        int missingPages;
        int currPageCount = currResult.getPageCount();
        if (currPageCount > index) {
            return;
        }
        if (currPageCount == 0 && index == 0) {
            throw new SDKException.Unexpected();
        }
        PagingQueryOptions options = currResult.getOptions();
        int pageSize = currResult.getPageSize();
        int oldpageSize = 100;
        if (pageSize <= 0) {
            oldpageSize = pageSize;
            options.setPageSize(1000);
            pageSize = 1000;
        }
        String uri = currResult.getURI();
        int currResultSize = currResult.getResultSize();
        IInfoStore infoStore = currResult.getInfoStore();
        SQLQueryHolder query = currResult.getQuery();
        IInfoObject lastObj = currResult.getLastObject();
        Vector pageURIs = currResult.getPageURIs();
        int thisIndexedResponseSize = currPageCount * 2;
        int numOfPage = currPageCount;
        int hasOpenLastPage = 0;
        int rangesize = missingPages = index + 1 - currPageCount;
        if (missingPages > 500) {
            rangesize = 500;
        }
        int leftmissingPages = missingPages - rangesize;
        IInfoObjects indexedResponse = null;
        IInfoObject newlastObject = lastObj;
        int totalNumObjects = currResultSize;
        boolean isLastBatch = false;
        int resultsize = -1;
        do {
            indexedResponse = URIPageFactory.getPagedResultHelper(infoStore, uri, query, options, newlastObject, pageURIs, rangesize);
            resultsize = indexedResponse.getResultSize();
            thisIndexedResponseSize = indexedResponse.size();
            numOfPage = thisIndexedResponseSize / 2;
            hasOpenLastPage = thisIndexedResponseSize % 2;
            if (thisIndexedResponseSize == 0 || thisIndexedResponseSize < rangesize * 2) {
                isLastBatch = true;
                break;
            }
            int thisNumObjects = rangesize * pageSize;
            newlastObject = (IInfoObject)indexedResponse.get(thisIndexedResponseSize - 1);
            missingPages = leftmissingPages;
            rangesize = missingPages > 500 ? 500 : missingPages;
            leftmissingPages = missingPages - rangesize;
            if (missingPages <= 0) continue;
            totalNumObjects += thisNumObjects;
        } while (missingPages > 0);
        if (thisIndexedResponseSize > 0) {
            totalNumObjects = hasOpenLastPage > 0 ? (totalNumObjects += resultsize) : (totalNumObjects += numOfPage * pageSize);
            if (oldpageSize <= 0) {
                options.setPageSize(oldpageSize);
            }
            currResult.setResultSize(totalNumObjects);
        }
        if (isLastBatch) {
            currResult.setHasMorePage(false);
            currResult.setLastObject(null);
            currResult.setEstimatedTotalResultSize(totalNumObjects);
        } else {
            currResult.setHasMorePage(true);
            currResult.setLastObject(newlastObject);
        }
    }

    private static IPageResult getPagedResultEvery(IInfoStore infoStore, String uri, SQLQueryHolder query, PagingQueryOptions options) throws SDKException {
        if (!options.isIncremental()) {
            int totalNumObjects = 0;
            int pageSize = options.getPageSize();
            int oldpageSize = 100;
            if (pageSize <= 0) {
                oldpageSize = pageSize;
                options.setPageSize(1000);
                pageSize = 1000;
            }
            Vector pageURIs = new Vector();
            int rangesize = 500;
            IInfoObjects indexedResponse = URIPageFactory.getPagedResultHelper(infoStore, uri, query, options, null, pageURIs, rangesize);
            int thisIndexedResponseSize = indexedResponse.size();
            int numOfPage = thisIndexedResponseSize / 2;
            int hasOpenLastPage = thisIndexedResponseSize % 2;
            while (numOfPage == rangesize) {
                totalNumObjects += rangesize * pageSize;
                indexedResponse = URIPageFactory.getPagedResultHelper(infoStore, uri, query, options, (IInfoObject)indexedResponse.get(thisIndexedResponseSize - 1), pageURIs, rangesize);
                thisIndexedResponseSize = indexedResponse.size();
                numOfPage = thisIndexedResponseSize / 2;
                hasOpenLastPage = thisIndexedResponseSize % 2;
            }
            if (numOfPage < rangesize) {
                totalNumObjects += numOfPage * pageSize;
                if (hasOpenLastPage > 0) {
                    String lastpageuri = (String)pageURIs.get(pageURIs.size() - 1);
                    IStatelessPageInfo lastPageInfo = infoStore.getStatelessPageInfo(lastpageuri, options);
                    String nextSQL = lastPageInfo.getPageSQL();
                    IInfoObjects objs = infoStore.query(nextSQL);
                    totalNumObjects += objs.size();
                }
            }
            if (oldpageSize <= 0) {
                options.setPageSize(oldpageSize);
            }
            return new URIPageResultBase(pageURIs, totalNumObjects, pageSize);
        }
        int totalNumObjects = 0;
        int pageSize = options.getPageSize();
        int oldpageSize = 100;
        if (pageSize <= 0) {
            oldpageSize = pageSize;
            options.setPageSize(1000);
            pageSize = 1000;
        }
        Vector pageURIs = new Vector();
        int rangeSize = 2;
        IInfoObjects indexedResponse = URIPageFactory.getPagedResultHelper(infoStore, uri, query, options, null, pageURIs, rangeSize);
        int estimatedsize = indexedResponse.getResultSize();
        int thisIndexedResponseSize = indexedResponse.size();
        int numOfPage = pageSize > 1 ? thisIndexedResponseSize / 2 : thisIndexedResponseSize;
        int hasOpenLastPage = 0;
        if (pageSize > 1) {
            hasOpenLastPage = thisIndexedResponseSize % 2;
        }
        totalNumObjects = numOfPage < rangeSize ? (hasOpenLastPage > 0 ? estimatedsize : numOfPage * pageSize) : (pageSize == 1 ? numOfPage : rangeSize * pageSize);
        if (thisIndexedResponseSize == 0) {
            return new URIPageResultBase(pageURIs, 0, pageSize);
        }
        IInfoObject lastObject = (IInfoObject)indexedResponse.get(thisIndexedResponseSize - 1);
        if (oldpageSize <= 0) {
            options.setPageSize(oldpageSize);
        }
        URIPageResult result = null;
        result = numOfPage == 0 && hasOpenLastPage > 0 || numOfPage >= rangeSize ? new URIPageResult(uri, pageURIs, totalNumObjects, infoStore, pageSize, true, options, query, lastObject) : new URIPageResult(uri, pageURIs, totalNumObjects, infoStore, pageSize, false, options, query, null);
        result.setEstimatedTotalResultSize(estimatedsize);
        return result;
    }

    private static IInfoObjects getPagedResultHelper(IInfoStore infoStore, String uri, SQLQueryHolder query, PagingQueryOptions options, IInfoObject lowerobj, Vector pageURIs, int rangesize) throws SDKException {
        IInfoObjects indexedResponse;
        block8: {
            int pageSize = options.getPageSize();
            String indexQuery = query.getIndexQuery(lowerobj, pageSize, rangesize);
            indexedResponse = infoStore.query(indexQuery);
            if (indexedResponse == null) {
                LOG.error((Object)("IInfoStore returned null on a query call for query: " + indexQuery));
                throw new URIParserException.InvalidSQLQuery(indexQuery);
            }
            int thisIndexedResponseSize = indexedResponse.size();
            if (thisIndexedResponseSize <= 0) break block8;
            if (pageSize > 1) {
                IInfoObject upperObj;
                IInfoObject lowerObj;
                int i = 0;
                if (lowerobj == null && i < thisIndexedResponseSize) {
                    lowerObj = (IInfoObject)indexedResponse.get(i);
                    upperObj = null;
                    if (i + 1 < thisIndexedResponseSize) {
                        upperObj = (IInfoObject)indexedResponse.get(i + 1);
                    }
                    pageURIs.add(URIPageFactory.buildPageURIEx(lowerObj, upperObj, uri, query, options, true));
                    i = 2;
                }
                while (i < thisIndexedResponseSize) {
                    lowerObj = (IInfoObject)indexedResponse.get(i);
                    upperObj = null;
                    if (i + 1 < thisIndexedResponseSize) {
                        upperObj = (IInfoObject)indexedResponse.get(i + 1);
                    }
                    pageURIs.add(URIPageFactory.buildPageURIEx(lowerObj, upperObj, uri, query, options, false));
                    i += 2;
                }
            } else {
                for (int currIndexObj = 0; currIndexObj < thisIndexedResponseSize; ++currIndexObj) {
                    IInfoObject obj = (IInfoObject)indexedResponse.get(currIndexObj);
                    pageURIs.add(URIPageFactory.buildPageURIEx(obj, null, uri, query, options, currIndexObj == 0));
                }
            }
        }
        return indexedResponse;
    }

    private static String buildPageURI(IInfoObject lowerObj, IInfoObject upperObj, String uri, SQLQueryHolder query, PagingQueryOptions options) throws URIParserException {
        int sepIndex = uri.indexOf("://");
        if (sepIndex < 0) {
            LOG.error((Object)"URI must be of the form: 'protocol://pathexpression' where protocol is one of query, path, cuid, or search");
            throw new URIParserException.InvalidProtocol(uri);
        }
        String encodedUri = StringHelper.encodeURI(uri, "\\");
        int parametersIndex = encodedUri.indexOf(63);
        boolean parametersInURI = parametersIndex > -1;
        String protocol = uri.substring(0, sepIndex);
        boolean skipDecode = options.isOptionSet(PagingQueryOptions.SKIP_QUERY_URI_DECODE);
        if (protocol.equalsIgnoreCase("query") && skipDecode) {
            int queryEnd = uri.lastIndexOf(125);
            parametersInURI = uri.indexOf("?", queryEnd) > -1;
        }
        StringBuffer pagePath = new StringBuffer();
        StringBuffer existingOps = new StringBuffer();
        if (parametersInURI) {
            int endOpIndex = URIQueryParser.findOperatorEndIndex(parametersIndex + 1, uri);
            while (endOpIndex < uri.length() - 1 && uri.charAt(endOpIndex) == "\\".charAt(0)) {
                endOpIndex = URIQueryParser.findOperatorEndIndex(endOpIndex + 2, uri);
            }
            if (endOpIndex == uri.length() - 1) {
                pagePath.append(uri);
            } else {
                pagePath.append(uri.substring(0, endOpIndex + 1));
                existingOps.append(uri.substring(endOpIndex + 1));
            }
            pagePath.append("&");
        } else {
            pagePath.append(uri);
            pagePath.append("?");
            parametersInURI = true;
        }
        PageBlock thisPageBlock = PageBlock.buildPageBlock(lowerObj, upperObj, query.getOrderByEntries(), 0);
        pagePath.append(thisPageBlock.getURIPagingParameters());
        if (existingOps.length() > 0) {
            pagePath.append(existingOps);
        }
        return pagePath.toString();
    }

    private static String buildPageURIEx(IInfoObject lowerObj, IInfoObject upperObj, String uri, SQLQueryHolder query, PagingQueryOptions options, boolean isFirstPage) throws URIParserException {
        int sepIndex = uri.indexOf("://");
        if (sepIndex < 0) {
            LOG.error((Object)"URI must be of the form: 'protocol://pathexpression' where protocol is one of query, path, cuid, or search");
            throw new URIParserException.InvalidProtocol(uri);
        }
        String encodedUri = StringHelper.encodeURI(uri, "\\");
        int parametersIndex = encodedUri.indexOf(63);
        boolean parametersInURI = parametersIndex > -1;
        String protocol = uri.substring(0, sepIndex);
        boolean skipDecode = options.isOptionSet(PagingQueryOptions.SKIP_QUERY_URI_DECODE);
        if (protocol.equalsIgnoreCase("query") && skipDecode) {
            int queryEnd = uri.lastIndexOf(125);
            parametersInURI = uri.indexOf("?", queryEnd) > -1;
        }
        StringBuffer pagePath = new StringBuffer();
        StringBuffer existingOps = new StringBuffer();
        if (parametersInURI) {
            int endOpIndex = URIQueryParser.findOperatorEndIndex(parametersIndex + 1, uri);
            while (endOpIndex < uri.length() - 1 && uri.charAt(endOpIndex) == "\\".charAt(0)) {
                endOpIndex = URIQueryParser.findOperatorEndIndex(endOpIndex + 2, uri);
            }
            if (endOpIndex == uri.length() - 1) {
                pagePath.append(uri);
            } else {
                pagePath.append(uri.substring(0, endOpIndex + 1));
                existingOps.append(uri.substring(endOpIndex + 1));
            }
            pagePath.append("&");
        } else {
            pagePath.append(uri);
            pagePath.append("?");
            parametersInURI = true;
        }
        int pagesize = options.getPageSize();
        if (pagesize > 0) {
            pagePath.append(URIQueryParser.PAGESIZE + "=" + String.valueOf(pagesize) + "&");
        }
        if (!isFirstPage || query.getOrderBy().indexOf(PropertyIDs.idToName(PropertyIDs.SI_UPDATE_TS)) == -1) {
            PageBlock thisPageBlock = PageBlock.buildPageBlockEx(lowerObj, upperObj, query.getOrderByEntries(), 0);
            pagePath.append(thisPageBlock.getURIPagingParameters());
        }
        if (existingOps.length() > 0) {
            pagePath.append(existingOps);
        }
        String str = pagePath.toString();
        return str;
    }

    static {
        try {
            DEFAULT_PAGE_SIZE = ConfigurationHelper.getInstance("META-INF/CrystalEnterprise.Services/URIQueryParser.properties").getPropertyAsInt("defaultPageSize", 200);
            NO_PAGING_QUERY_LIMIT = ConfigurationHelper.getInstance("META-INF/CrystalEnterprise.Services/URIQueryParser.properties").getPropertyAsInt("noPagingQueryLimit", 1000);
            USE_PAGING_CACHE = false;
        }
        catch (Throwable t) {
            DEFAULT_PAGE_SIZE = 200;
            NO_PAGING_QUERY_LIMIT = 1000;
            USE_PAGING_CACHE = false;
        }
    }
}

