/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.uri.IPageResult;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class URIPageResultBase
implements IPageResult,
Serializable {
    static final long serialVersionUID = -3842907049732839211L;
    protected int resultSize;
    protected int pageSize;
    protected Vector allPageURIs;
    protected boolean hasMorePage;

    protected URIPageResultBase(Vector pageURIs, int resultSize, int pageSize) {
        if (pageURIs == null) {
            pageURIs = new Vector();
        }
        this.allPageURIs = pageURIs;
        this.resultSize = resultSize;
        this.pageSize = pageSize;
        this.hasMorePage = false;
    }

    protected URIPageResultBase(Vector pageURIs, int resultSize, int pageSize, boolean hasMorePage) {
        if (pageURIs == null) {
            pageURIs = new Vector();
        }
        this.allPageURIs = pageURIs;
        this.resultSize = resultSize;
        this.pageSize = pageSize;
        this.hasMorePage = hasMorePage;
    }

    public String getPageURI(int index) {
        if (index >= this.allPageURIs.size()) {
            return (String)this.allPageURIs.lastElement();
        }
        return (String)this.allPageURIs.get(index);
    }

    public String getLastPageURI() {
        return (String)this.allPageURIs.lastElement();
    }

    public int getPageCount() {
        return this.allPageURIs.size();
    }

    public int getResultSize() {
        return this.resultSize;
    }

    synchronized void setResultSize(int resultSize) {
        this.resultSize = resultSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public synchronized Iterator iterator() {
        return new Iterator(){
            private int index = -1;

            public boolean hasNext() {
                return URIPageResultBase.this.hasMorePage(this.index);
            }

            public Object next() {
                return URIPageResultBase.this.getPageURI(++this.index);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean hasMorePage(int pageindex) {
        return pageindex + 1 < this.getPageCount();
    }

    synchronized void setHasMorePage(boolean hasMorePage) {
        this.hasMorePage = hasMorePage;
    }

    public int getEstimatedTotalResultSize() {
        return this.resultSize;
    }
}

