/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.exception.URIParserException;
import com.crystaldecisions.sdk.uri.internal.SQLQueryHolder;
import com.crystaldecisions.sdk.uri.internal.StringHelper;
import java.io.Serializable;
import java.util.HashMap;

public class URIQueryCache
implements Serializable {
    static final long serialVersionUID = 537523586031238902L;
    public static URIQueryCache currentCache = null;
    private HashMap queryCache = null;

    public static synchronized URIQueryCache getCache() {
        if (currentCache == null) {
            currentCache = new URIQueryCache();
        }
        return currentCache;
    }

    private URIQueryCache() {
    }

    private synchronized String getURIKey(String uri) throws URIParserException {
        if (this.queryCache == null) {
            this.queryCache = new HashMap();
        }
        if (uri == null || uri.length() == 0) {
            throw new URIParserException.InvalidURI(uri);
        }
        String key = StringHelper.encodeURI(uri, "\\");
        int optionsPosition = key.indexOf(63);
        if (optionsPosition >= 0) {
            key = key.substring(0, optionsPosition);
        }
        return key;
    }

    public synchronized SQLQueryHolder findQuery(String uri) throws URIParserException {
        String key;
        boolean isPaging;
        boolean bl = isPaging = uri.indexOf("BIP1") >= 0;
        if (!isPaging) {
            return null;
        }
        if (this.queryCache == null) {
            this.queryCache = new HashMap();
        }
        if (!this.queryCache.containsKey(key = this.getURIKey(uri))) {
            return null;
        }
        return (SQLQueryHolder)this.queryCache.get(key);
    }

    public synchronized void putQuery(String uri, SQLQueryHolder query) throws URIParserException {
        if (this.queryCache == null) {
            this.queryCache = new HashMap();
        }
        String key = this.getURIKey(uri);
        this.queryCache.put(key, query);
    }

    public synchronized void cleanUp() {
        this.queryCache.clear();
        this.queryCache = null;
    }
}

