/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.BiDir;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.Logger;
import com.crystaldecisions.thirdparty.com.ooc.OB.OptionFilter;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactoryRegistry;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactoryRegistryHelper;
import com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir.AccFactory_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir.ConFactory_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir.TransportManager;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConFactoryRegistry;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConFactoryRegistryHelper;
import com.crystaldecisions.thirdparty.com.ooc.OCI.FactoryAlreadyExists;
import com.crystaldecisions.thirdparty.com.ooc.OCI.NoSuchFactory;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORBPackage.InvalidName;
import java.util.Enumeration;
import java.util.Properties;

public final class Util {
    private Util() {
    }

    public static void installFactories(ORB orb, int id, int tag, String peer, ConFactory conFactoryDelegate, AccFactory accFactoryDelegate) {
        ConFactoryRegistry conFactoryRegistry = null;
        try {
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = orb.resolve_initial_references("OCIConFactoryRegistry");
            conFactoryRegistry = ConFactoryRegistryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            throw new INITIALIZE("Cannot resolve OCIConFactoryRegistry");
        }
        ConFactory_impl conFactoryImpl = null;
        try {
            ConFactory f = conFactoryRegistry.get_factory(id);
            conFactoryImpl = (ConFactory_impl)f;
        }
        catch (NoSuchFactory ex) {
            // empty catch block
        }
        if (conFactoryImpl == null) {
            conFactoryImpl = new ConFactory_impl(id, tag, peer, conFactoryDelegate);
            try {
                conFactoryRegistry.add_factory(conFactoryImpl);
            }
            catch (FactoryAlreadyExists ex) {
                // empty catch block
            }
        }
        AccFactoryRegistry accFactoryRegistry = null;
        try {
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = orb.resolve_initial_references("OCIAccFactoryRegistry");
            accFactoryRegistry = AccFactoryRegistryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            throw new INITIALIZE("Cannot resolve OCIAccFactoryRegistry");
        }
        AccFactory_impl accFactoryImpl = null;
        try {
            AccFactory f = accFactoryRegistry.get_factory(id);
            accFactoryImpl = (AccFactory_impl)f;
        }
        catch (NoSuchFactory ex) {
            // empty catch block
        }
        if (accFactoryImpl == null) {
            TransportManager transportManager = conFactoryImpl.transportManager();
            accFactoryImpl = new AccFactory_impl(transportManager, accFactoryDelegate);
            try {
                accFactoryRegistry.add_factory(accFactoryImpl);
            }
            catch (FactoryAlreadyExists ex) {
                // empty catch block
            }
        }
    }

    public static String[] parseArgs(ORB orb, String[] args, Properties properties) {
        Assert.assertTrue(properties != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB oborb = (com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB)orb;
        Logger logger = oborb.logger();
        OptionFilter optionFilter = new OptionFilter("BiDir", "-BIDIR");
        optionFilter.add("peer", 1);
        OptionFilter.Option[] options = optionFilter.parse(logger, args);
        for (int i = 0; i < options.length; ++i) {
            String name = options[i].name;
            String[] value = options[i].value;
            if (!name.equals("peer")) continue;
            properties.put("ooc.bidir.peer", value[0]);
        }
        return optionFilter.filter(args);
    }

    public static void validateProperties(ORB orb, Properties properties) {
        String peer = null;
        String mode = "both";
        com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB oborb = (com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB)orb;
        Logger logger = oborb.logger();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("ooc.bidir.")) continue;
            String value = properties.getProperty(key);
            Assert.assertTrue(value != null);
            if (key.equals("ooc.bidir.peer")) {
                if (value.trim().length() == 0) {
                    String err = "BiDir: invalid value for ooc.bidir.peer";
                    logger.error(err);
                    throw new INITIALIZE(err);
                }
                peer = value;
                continue;
            }
            if (key.equals("ooc.bidir.mode")) {
                if (!(value.equals("client") || value.equals("server") || value.equals("both"))) {
                    String err = "BiDir: invalid value for ooc.bidir.mode: " + value;
                    logger.error(err);
                    throw new INITIALIZE(err);
                }
                mode = value;
                continue;
            }
            logger.warning("BiDir: unknown property `" + key + "'");
        }
        if (peer == null) {
            String err = "BiDir: no peer ID value specified";
            logger.error(err);
            throw new INITIALIZE(err);
        }
    }
}

