/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.CORBANameParser;
import com.crystaldecisions.thirdparty.com.ooc.OB.HexConverter;
import com.crystaldecisions.thirdparty.com.ooc.OB.InitialServiceManager;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.ObjectFactory;
import com.crystaldecisions.thirdparty.com.ooc.OB.TypeCodeFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.MARSHAL;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORBPackage.InvalidName;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Request;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StructMember;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TCKind;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TypeCode;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynAny;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynAnyFactory;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynAnyFactoryHelper;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynSequence;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynSequenceHelper;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynStruct;
import com.crystaldecisions.thirdparty.org.omg.DynamicAny.DynStructHelper;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_0;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_0Helper;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_1;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_1Helper;
import com.crystaldecisions.thirdparty.org.omg.IIOP.Version;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.IOP.IORHelper;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedComponent;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedProfile;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

class CorbaURL {
    private String urlStr_;
    private String scheme_;
    private Vector addresses_;
    private byte[] key_;
    private int fragmentStartIdx_;
    private boolean rirURL_;
    private static final String iorPrefix_ = "ior";
    private static final String corbalocPrefix_ = "corbaloc";
    private static final String corbanamePrefix_ = "corbaname";
    private static final String filePrefix_ = "file";
    private static final String relfilePrefix_ = "relfile";
    private static final String iiopProt_ = "iiop:";
    private static final String iiopProtColon_ = ":";
    private static final String rirProt_ = "rir:";

    public CorbaURL(String urlStr) {
        this.urlStr_ = urlStr;
        this.parseScheme();
    }

    public com.crystaldecisions.thirdparty.org.omg.CORBA.Object toObject(ORBInstance orbInstance) {
        if (this.scheme_.equals(iorPrefix_)) {
            return this.IORToObject(orbInstance);
        }
        if (this.scheme_.equals(corbalocPrefix_)) {
            return this.CORBALOCToObject(orbInstance);
        }
        if (this.scheme_.equals(corbanamePrefix_)) {
            return this.CORBANAMEToObject(orbInstance);
        }
        if (this.scheme_.equals(filePrefix_)) {
            return this.OBFileToObject(orbInstance, "/");
        }
        if (this.scheme_.equals(relfilePrefix_)) {
            return this.OBFileToObject(orbInstance, null);
        }
        throw new BAD_PARAM(MinorCodes.describeBadParam(1330446343) + ": `" + this.scheme_ + "'", 1330446343, CompletionStatus.COMPLETED_NO);
    }

    private com.crystaldecisions.thirdparty.org.omg.CORBA.Object OBFileToObject(ORBInstance orbInstance, String dirPrefix) {
        int startIdx = this.scheme_.length() + 1;
        for (int s = 0; s < 3 && startIdx < this.urlStr_.length() && this.urlStr_.charAt(startIdx) == '/'; ++s, ++startIdx) {
        }
        if (startIdx >= this.urlStr_.length()) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": no file specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        String fileName = new String();
        if (dirPrefix != null) {
            fileName = dirPrefix;
        }
        fileName = fileName + this.unescapeURL(this.urlStr_, startIdx, -1);
        try {
            FileInputStream file = new FileInputStream(fileName);
            BufferedReader in = new BufferedReader(new InputStreamReader(file));
            String ref = in.readLine();
            file.close();
            ObjectFactory objectFactory = orbInstance.getObjectFactory();
            return objectFactory.stringToObject(ref);
        }
        catch (IOException ex) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": file error", 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private com.crystaldecisions.thirdparty.org.omg.CORBA.Object CORBANAMEToObject(ORBInstance orbInstance) {
        com.crystaldecisions.thirdparty.org.omg.CORBA.Object service = this.CORBALOCToObject(orbInstance);
        if (this.fragmentStartIdx_ == -1) {
            return service;
        }
        try {
            if (this.fragmentStartIdx_ + 1 >= this.urlStr_.length()) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": stringified name is missing", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            InitialServiceManager initServiceManager = orbInstance.getInitialServiceManager();
            StructMember[] contents = new StructMember[2];
            contents[0] = new StructMember();
            contents[0].name = "id";
            contents[0].type = TypeCodeFactory.createStringTC(0);
            contents[1] = new StructMember();
            contents[1].name = "kind";
            contents[1].type = TypeCodeFactory.createStringTC(0);
            TypeCode tcNameComponent = TypeCodeFactory.createStructTC("IDL:omg.org/CosNaming/NameComponent:1.0", "NameComponent", contents);
            TypeCode tcName = TypeCodeFactory.createSequenceTC(0, tcNameComponent);
            String strName = this.unescapeURL(this.urlStr_, this.fragmentStartIdx_ + 1, -1);
            byte[] nameBytes = this.strToKey(strName);
            CORBANameParser parser = new CORBANameParser(nameBytes);
            if (!parser.isValid()) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": stringified name is invalid", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            String[] content = parser.getContents();
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = initServiceManager.resolveInitialReferences("DynAnyFactory");
            DynAnyFactory dynAnyFactory = DynAnyFactoryHelper.narrow(obj);
            Any[] as = new Any[content.length / 2];
            for (int i = 0; i < content.length; i += 2) {
                DynAny dynAny = dynAnyFactory.create_dyn_any_from_type_code(tcNameComponent);
                DynStruct name = DynStructHelper.narrow(dynAny);
                name.insert_string(content[i]);
                name.next();
                name.insert_string(content[i + 1]);
                as[i / 2] = name.to_any();
            }
            DynAny dynAny = dynAnyFactory.create_dyn_any_from_type_code(tcName);
            DynSequence seq = DynSequenceHelper.narrow(dynAny);
            seq.set_length(as.length);
            seq.set_elements(as);
            Request request = service._request("resolve");
            Any any = request.add_in_arg();
            Any seqany = seq.to_any();
            any.read_value(seqany.create_input_stream(), seqany.type());
            seq.destroy();
            request.set_return_type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_objref));
            request.invoke();
            if (request.env().exception() == null) {
                return request.return_value().extract_Object();
            }
        }
        catch (SystemException ex) {
        }
        catch (UserException userException) {
            // empty catch block
        }
        throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": corbaname evaluation error", 1330446346, CompletionStatus.COMPLETED_NO);
    }

    private com.crystaldecisions.thirdparty.org.omg.CORBA.Object CORBALOCToObject(ORBInstance orbInstance) {
        int addrEndIdx = this.parseCORBALOCAddresses();
        if (this.addresses_.size() == 0) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": no protocol address", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        String keyStr = null;
        if (addrEndIdx != -1 && this.urlStr_.charAt(addrEndIdx) == '/') {
            int keyStartIdx = addrEndIdx + 1;
            this.fragmentStartIdx_ = this.parseKey(keyStartIdx);
            keyStr = this.fragmentStartIdx_ == -1 ? this.urlStr_.substring(keyStartIdx) : this.urlStr_.substring(keyStartIdx, this.fragmentStartIdx_);
        } else if (addrEndIdx == -1 || this.urlStr_.charAt(addrEndIdx) == '#') {
            this.fragmentStartIdx_ = addrEndIdx;
            keyStr = this.rirURL_ || this.scheme_.equals(corbanamePrefix_) ? "NameService" : "";
            this.key_ = this.strToKey(keyStr);
        }
        if (keyStr.length() == 0) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": no key specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        if (this.rirURL_) {
            try {
                InitialServiceManager initServiceManager = orbInstance.getInitialServiceManager();
                return initServiceManager.resolveInitialReferences(keyStr);
            }
            catch (InvalidName invName) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": invalid initial reference token", 1330446345, CompletionStatus.COMPLETED_NO);
            }
        }
        IOR ior = new IOR();
        ior.type_id = "";
        ior.profiles = new TaggedProfile[this.addresses_.size()];
        for (int pr = 0; pr < this.addresses_.size(); ++pr) {
            URLAddr addr = (URLAddr)this.addresses_.elementAt(pr);
            addr.setProfile(ior, pr, this.key_);
        }
        ObjectFactory objectFactory = orbInstance.getObjectFactory();
        return objectFactory.createObject(ior);
    }

    private int parseKey(int keyStartIdx) {
        int keyEndIdx = this.urlStr_.indexOf(35, keyStartIdx);
        int endCopy = keyEndIdx != -1 ? keyEndIdx : this.urlStr_.length();
        String keyStr = this.unescapeURL(this.urlStr_, keyStartIdx, endCopy);
        this.key_ = this.strToKey(keyStr);
        return keyEndIdx;
    }

    private byte[] strToKey(String keyStr) {
        byte[] retKey = new byte[keyStr.length()];
        for (int i = 0; i < retKey.length; ++i) {
            if (keyStr.charAt(i) > '\u00ff') {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": key string characters out of range", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            retKey[i] = (byte)keyStr.charAt(i);
        }
        return retKey;
    }

    private int parseCORBALOCAddresses() {
        int addrStartIdx = this.scheme_.length() + 1;
        if (addrStartIdx >= this.urlStr_.length()) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": incomplete, only scheme specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.rirURL_ = false;
        String addrStr = this.urlStr_.substring(addrStartIdx);
        int addrEndIdx = -1;
        StringTokenizer addrToken = new StringTokenizer(addrStr, ",/#", true);
        this.addresses_ = new Vector();
        while (addrToken.hasMoreTokens()) {
            String token = addrToken.nextToken();
            if (token.equals(",")) continue;
            if (token.equals("#") || token.equals("/")) {
                addrEndIdx = this.urlStr_.indexOf(token.charAt(0));
                break;
            }
            this.addresses_.addElement(this.parseSingleProtocolAddr(token));
        }
        return addrEndIdx;
    }

    private com.crystaldecisions.thirdparty.org.omg.CORBA.Object IORToObject(ORBInstance orbInstance) {
        byte[] data = HexConverter.asciiToOctets(this.urlStr_, 4);
        if (data == null) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345), 1330446345, CompletionStatus.COMPLETED_NO);
        }
        try {
            Buffer buf = new Buffer(data, data.length);
            InputStream in = new InputStream(buf, 0, false, null, false);
            in._OB_readEndian();
            ObjectFactory objectFactory = orbInstance.getObjectFactory();
            return objectFactory.createObject(IORHelper.read(in));
        }
        catch (MARSHAL marshalErr) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345), 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parseScheme() {
        int schemeEnd = -1;
        if (this.urlStr_ != null) {
            schemeEnd = this.urlStr_.indexOf(58);
        }
        if (schemeEnd == -1) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": no scheme found", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        this.scheme_ = this.urlStr_.substring(0, schemeEnd).toLowerCase(Locale.ENGLISH);
    }

    URLAddr parseSingleProtocolAddr(String addrStr) {
        if ((addrStr = this.unescapeURL(addrStr, 0, -1)).startsWith(iiopProt_) || addrStr.startsWith(iiopProtColon_)) {
            return new IIOPAddr(addrStr);
        }
        if (addrStr.startsWith(rirProt_)) {
            this.rirURL_ = true;
            return new RIRAddr(addrStr);
        }
        throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": unknown protocol", 1330446345, CompletionStatus.COMPLETED_NO);
    }

    public String unescapeURL(String from, int readIdx, int endIdx) {
        if (endIdx == -1) {
            endIdx = from.length();
        }
        char[] to = new char[endIdx - readIdx];
        int writeIdx = 0;
        while (readIdx < endIdx) {
            char ch = from.charAt(readIdx);
            if (ch == '%') {
                if (readIdx + 2 >= endIdx) {
                    throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": bad escape sequence length", 1330446344, CompletionStatus.COMPLETED_NO);
                }
                int c1 = Character.digit(from.charAt(++readIdx), 16);
                int c2 = Character.digit(from.charAt(++readIdx), 16);
                if (c1 == -1 || c2 == -1) {
                    throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": escape sequence contains invalid characters", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                ch = (char)(c1 << 4 | c2);
            }
            to[writeIdx++] = ch;
            ++readIdx;
        }
        return new String(to, 0, writeIdx);
    }

    public static class IIOPAddr
    extends URLAddr {
        private int major_;
        private int minor_;
        private String host_;
        private int port_;
        public static final int DEFAULT_PORT = 2809;

        public IIOPAddr(String iiopStr) {
            int addrEndIdx = iiopStr.length();
            int addrIdx = iiopStr.charAt(0) == CorbaURL.iiopProtColon_.charAt(0) ? CorbaURL.iiopProtColon_.length() : CorbaURL.iiopProt_.length();
            int at = iiopStr.indexOf(64, addrIdx);
            if (at == -1) {
                this.major_ = 1;
                this.minor_ = 0;
            } else {
                int dot = iiopStr.indexOf(46, addrIdx);
                if (dot == -1) {
                    throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": iiop version must be of the form `X.Y@'", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                try {
                    String m = iiopStr.substring(addrIdx, dot);
                    this.major_ = Integer.parseInt(m);
                    m = iiopStr.substring(dot + 1, at);
                    this.minor_ = Integer.parseInt(m);
                    if (this.major_ < 1 || this.major_ > 1 || this.minor_ < 0 || this.minor_ > 255) {
                        throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": iiop version unsupported `" + this.major_ + "." + this.minor_ + "'", 1330446346, CompletionStatus.COMPLETED_NO);
                    }
                    if (this.minor_ > 2) {
                        this.minor_ = 1;
                    }
                }
                catch (NumberFormatException e) {
                    throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": iiop version format error", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                addrIdx = at + 1;
            }
            if (addrIdx >= addrEndIdx || iiopStr.charAt(addrIdx) == ':') {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": iiop host must be specified", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            int colon = iiopStr.indexOf(58, addrIdx);
            this.host_ = iiopStr.substring(addrIdx, colon == -1 ? addrEndIdx : colon);
            if (colon == -1) {
                this.port_ = 2809;
            } else {
                String portStr = iiopStr.substring(colon + 1, addrEndIdx);
                try {
                    this.port_ = Integer.parseInt(portStr);
                    if (this.port_ < 1 || this.port_ > 65535) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": iiop bad port number " + portStr, 1330446346, CompletionStatus.COMPLETED_NO);
                }
            }
        }

        public String getProtocolName() {
            return CorbaURL.iiopProtColon_;
        }

        public void setProfile(IOR ior, int prNo, byte[] key) {
            Version iiopVersion = new Version((byte)this.major_, (byte)this.minor_);
            short shortPort = this.port_ > 32768 ? (short)(this.port_ - 65535 - 1) : (short)this.port_;
            ior.profiles[prNo] = new TaggedProfile();
            ior.profiles[prNo].tag = 0;
            if (this.major_ == 1 && this.minor_ == 0) {
                ProfileBody_1_0 body = new ProfileBody_1_0();
                body.iiop_version = iiopVersion;
                body.host = this.host_;
                body.port = shortPort;
                body.object_key = key;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                ProfileBody_1_0Helper.write(out, body);
                ior.profiles[prNo].profile_data = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, ior.profiles[prNo].profile_data, 0, buf.length());
            } else {
                ProfileBody_1_1 body = new ProfileBody_1_1();
                body.iiop_version = iiopVersion;
                body.host = this.host_;
                body.port = shortPort;
                body.object_key = key;
                body.components = new TaggedComponent[0];
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                ProfileBody_1_1Helper.write(out, body);
                ior.profiles[prNo].profile_data = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, ior.profiles[prNo].profile_data, 0, buf.length());
            }
        }
    }

    public static class RIRAddr
    extends URLAddr {
        public RIRAddr(String rirStr) {
            if (rirStr.length() > CorbaURL.rirProt_.length()) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": rir protocol does not allow an address", 1330446346, CompletionStatus.COMPLETED_NO);
            }
        }

        public String getProtocolName() {
            return CorbaURL.rirProt_;
        }

        public void setProfile(IOR ior, int ProfileNumber, byte[] key) {
            Assert.assertTrue(false);
        }
    }

    public static abstract class URLAddr {
        public abstract String getProtocolName();

        public abstract void setProfile(IOR var1, int var2, byte[] var3);
    }
}

