/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.Client;
import com.crystaldecisions.thirdparty.com.ooc.OB.ClientManager;
import com.crystaldecisions.thirdparty.com.ooc.OB.ClientProfilePair;
import com.crystaldecisions.thirdparty.com.ooc.OB.CoreTraceLevels;
import com.crystaldecisions.thirdparty.com.ooc.OB.Downcall;
import com.crystaldecisions.thirdparty.com.ooc.OB.FailureException;
import com.crystaldecisions.thirdparty.com.ooc.OB.LocationForward;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.PIArgsDowncall;
import com.crystaldecisions.thirdparty.com.ooc.OB.PIDIIDowncall;
import com.crystaldecisions.thirdparty.com.ooc.OB.PIDowncall;
import com.crystaldecisions.thirdparty.com.ooc.OB.ParameterDesc;
import com.crystaldecisions.thirdparty.com.ooc.OB.RefCountPolicyList;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConnectorInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfoHolder;
import com.crystaldecisions.thirdparty.com.ooc.OCI.TransportInfo;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_INV_ORDER;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BooleanHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.COMM_FAILURE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ExceptionList;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_RESOURCES;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_RESPONSE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NVList;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NamedValue;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TypeCode;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.portable.ApplicationException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.portable.RemarshalException;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import java.util.Vector;

public final class DowncallStub {
    private ORBInstance orbInstance_;
    private IOR IOR_;
    private IOR origIOR_;
    private RefCountPolicyList policies_;
    private Vector clientProfilePairs_ = null;

    private synchronized Client getClientProfilePair(ProfileInfoHolder profileInfo) throws FailureException {
        if (this.clientProfilePairs_ == null) {
            ClientManager clientManager = this.orbInstance_.getClientManager();
            this.clientProfilePairs_ = clientManager.getClientProfilePairs(this.IOR_, this.policies_.value);
        }
        if (this.clientProfilePairs_.size() == 0) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceRetry() >= 2) {
                this.orbInstance_.getLogger().trace("retry", "no profiles available");
            }
            throw new FailureException(new NO_RESOURCES("No profiles available", 0, CompletionStatus.COMPLETED_NO));
        }
        int selected = 0;
        int smallestIndex = Integer.MAX_VALUE;
        for (int i = 0; i < this.clientProfilePairs_.size(); ++i) {
            int index = ((ClientProfilePair)this.clientProfilePairs_.elementAt((int)i)).profile.index;
            if (index >= smallestIndex) continue;
            selected = i;
            smallestIndex = index;
        }
        ClientProfilePair clientProfilePair = (ClientProfilePair)this.clientProfilePairs_.elementAt(selected);
        profileInfo.value = clientProfilePair.profile;
        return clientProfilePair.client;
    }

    private void destroy() {
        ClientManager clientManager = this.orbInstance_.getClientManager();
        if (clientManager != null && this.clientProfilePairs_ != null) {
            for (int i = 0; i < this.clientProfilePairs_.size(); ++i) {
                ClientProfilePair pair = (ClientProfilePair)this.clientProfilePairs_.elementAt(i);
                clientManager.releaseClient(pair.client);
            }
        }
        this.clientProfilePairs_.removeAllElements();
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public DowncallStub(ORBInstance orbInstance, IOR ior, IOR origIOR, RefCountPolicyList policies) {
        this.orbInstance_ = orbInstance;
        this.IOR_ = ior;
        this.origIOR_ = origIOR;
        this.policies_ = policies;
    }

    public Downcall createDowncall(String op, boolean resp) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert.assertTrue(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        return new PIDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_);
    }

    public Downcall createPIArgsDowncall(String op, boolean resp, ParameterDesc[] argDesc, ParameterDesc retDesc, TypeCode[] exceptionTC) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert.assertTrue(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        return new PIArgsDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, argDesc, retDesc, exceptionTC);
    }

    public Downcall createPIDIIDowncall(String op, boolean resp, NVList args, NamedValue result, ExceptionList exceptions) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert.assertTrue(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        return new PIDIIDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, args, result, exceptions);
    }

    public OutputStream preMarshal(Downcall down) throws LocationForward, FailureException {
        return down.preMarshal();
    }

    public void marshalEx(Downcall down, SystemException ex) throws LocationForward, FailureException {
        down.marshalEx(ex);
    }

    public void postMarshal(Downcall down) throws LocationForward, FailureException {
        down.postMarshal();
    }

    public void request(Downcall down) throws LocationForward, FailureException {
        down.request();
    }

    public void oneway(Downcall down) throws LocationForward, FailureException {
        down.oneway();
    }

    public void deferred(Downcall down) throws LocationForward, FailureException {
        down.deferred();
    }

    public void response(Downcall down) throws LocationForward, FailureException {
        down.response();
    }

    public boolean poll(Downcall down) throws LocationForward, FailureException {
        return down.poll();
    }

    public InputStream preUnmarshal(Downcall down) throws LocationForward, FailureException {
        return down.preUnmarshal();
    }

    public InputStream preUnmarshal(Downcall down, BooleanHolder uex) throws LocationForward, FailureException {
        InputStream in = down.preUnmarshal();
        uex.value = down.userException();
        return in;
    }

    public void unmarshalEx(Downcall down, SystemException ex) throws LocationForward, FailureException {
        down.unmarshalEx(ex);
    }

    public void postUnmarshal(Downcall down) throws LocationForward, FailureException {
        down.postUnmarshal();
    }

    public String unmarshalExceptionId(Downcall down) {
        return down.unmarshalExceptionId();
    }

    public void setUserException(Downcall down, UserException ex, String exId) {
        down.setUserException(ex, exId);
    }

    public void setUserException(Downcall down, UserException ex) {
        down.setUserException(ex);
    }

    public synchronized void handleFailureException(Downcall down, FailureException ex) throws FailureException {
        String msg;
        CoreTraceLevels coreTraceLevels;
        Assert.assertTrue(ex.exception != null);
        Client client = down.client();
        ProfileInfo profile = down.profileInfo();
        for (int i = 0; i < this.clientProfilePairs_.size(); ++i) {
            ClientProfilePair pair = (ClientProfilePair)this.clientProfilePairs_.elementAt(i);
            if (pair.client != client || pair.profile != profile) continue;
            ClientManager clientManager = this.orbInstance_.getClientManager();
            if (clientManager == null) {
                throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
            }
            clientManager.releaseClient(pair.client);
            this.clientProfilePairs_.removeElementAt(i);
            break;
        }
        try {
            throw ex.exception;
        }
        catch (COMM_FAILURE e) {
        }
        catch (TRANSIENT e) {
        }
        catch (NO_RESPONSE e) {
        }
        catch (SystemException e) {
            throw ex;
        }
        if (this.policies_.retry == 0) {
            throw ex;
        }
        if (this.policies_.retry == 1 && ex.exception.completed != CompletionStatus.COMPLETED_NO) {
            throw ex;
        }
        if (this.clientProfilePairs_.size() == 0) {
            coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceRetry() >= 2) {
                msg = "no profiles left to try\n" + ex.exception.getMessage();
                this.orbInstance_.getLogger().trace("retry", msg);
            }
            throw ex;
        }
        coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceRetry() >= 2) {
            msg = "trying next profile\n" + ex.exception.getMessage();
            this.orbInstance_.getLogger().trace("retry", msg);
        }
    }

    public ConnectorInfo get_oci_connector_info() {
        try {
            ProfileInfoHolder profileInfo = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfo);
            Assert.assertTrue(client != null);
            return client.connectorInfo();
        }
        catch (FailureException ex) {
            Assert.assertTrue(false);
            return null;
        }
    }

    public TransportInfo get_oci_transport_info() {
        try {
            ProfileInfoHolder profileInfo = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfo);
            Assert.assertTrue(client != null);
            return client.transportInfo();
        }
        catch (FailureException ex) {
            Assert.assertTrue(false);
            return null;
        }
    }

    public com.crystaldecisions.thirdparty.org.omg.CORBA.portable.OutputStream setupRequest(com.crystaldecisions.thirdparty.org.omg.CORBA.Object self, String operation, boolean responseExpected) throws LocationForward, FailureException {
        while (true) {
            Downcall downcall = this.createDowncall(operation, responseExpected);
            try {
                OutputStream out = this.preMarshal(downcall);
                InvocationContext ctx = new InvocationContext();
                ctx.downcallStub = this;
                ctx.downcall = downcall;
                out._OB_invocationContext(ctx);
                return out;
            }
            catch (FailureException ex) {
                this.handleFailureException(downcall, ex);
                continue;
            }
            break;
        }
    }

    public com.crystaldecisions.thirdparty.org.omg.CORBA.portable.InputStream invoke(com.crystaldecisions.thirdparty.org.omg.CORBA.Object self, com.crystaldecisions.thirdparty.org.omg.CORBA.portable.OutputStream out) throws ApplicationException, RemarshalException, LocationForward, FailureException {
        OutputStream o = (OutputStream)out;
        InvocationContext ctx = (InvocationContext)o._OB_invocationContext();
        Assert.assertTrue(ctx != null);
        if (ctx.downcallStub != this) {
            throw new RemarshalException();
        }
        Downcall down = ctx.downcall;
        try {
            down.postMarshal();
            boolean response = down.responseExpected();
            if (response) {
                down.request();
            } else {
                down.oneway();
            }
            if (response) {
                InputStream in = down.preUnmarshal();
                if (down.userException()) {
                    String id = null;
                    try {
                        id = down.unmarshalExceptionId();
                    }
                    catch (SystemException ex) {
                        down.unmarshalEx(ex);
                    }
                    down.setUserException(id);
                    down.postUnmarshal();
                    throw new ApplicationException(id, in);
                }
                down.postUnmarshal();
                return in;
            }
            down.preUnmarshal();
            down.postUnmarshal();
            return null;
        }
        catch (FailureException ex) {
            this.handleFailureException(down, ex);
            throw new RemarshalException();
        }
    }

    private class InvocationContext {
        DowncallStub downcallStub;
        Downcall downcall;

        private InvocationContext() {
        }
    }
}

