/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStreamHolder;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.Client;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverters;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetUtil;
import com.crystaldecisions.thirdparty.com.ooc.OB.CoreTraceLevels;
import com.crystaldecisions.thirdparty.com.ooc.OB.Downcall;
import com.crystaldecisions.thirdparty.com.ooc.OB.DowncallEmitter;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClientWorker;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClientWorkerBlocking;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClientWorkerThreaded;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClientWorkersPool;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPOutgoingMessage;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Connector;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConnectorInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.com.ooc.OCI.TransportInfo;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetContext;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetContextHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_RESPONSE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Policy;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.IOP.ServiceContext;
import java.util.Vector;

final class GIOPClient
extends Client {
    protected final ORBInstance orbInstance_;
    protected int nextRequestId_;
    protected Object nextRequestIdMutex_ = new Object();
    protected final Connector connector_;
    protected GIOPClientWorkersPool workers_;
    protected ServiceContext codeSetSC_;
    protected final int acmTimeout_;
    protected boolean destroy_;

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.destroy_);
        Assert.assertTrue(this.workers_ == null);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GIOPClientWorker getWorker(boolean create, int t) {
        GIOPClientWorkersPool workers;
        GIOPClient gIOPClient = this;
        synchronized (gIOPClient) {
            if (this.destroy_) {
                throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            workers = this.workers_;
            if (workers == null && create) {
                switch (this.concModel_) {
                    case 0: {
                        workers = this.workers_ = new GIOPClientWorkersPool(this, 1);
                        break;
                    }
                    case 2: {
                        workers = this.workers_ = new GIOPClientWorkersPool(this, this.numWokers_);
                    }
                }
            }
        }
        if (workers != null) {
            if (!create) {
                return workers.current();
            }
            GIOPClientWorker worker = workers.next(t);
            GIOPClient gIOPClient2 = this;
            synchronized (gIOPClient2) {
                if (this.codeSetSC_ == null) {
                    CodeSetContext ctx = new CodeSetContext();
                    CodeConverters conv = this.codeConverters();
                    ctx.char_data = conv.outputCharConverter.getTo().rgy_value;
                    ctx.wchar_data = conv.wcharConverter != null ? conv.wcharConverter.getTo().rgy_value : 0;
                    Buffer buf = new Buffer();
                    OutputStream outCSC = new OutputStream(buf);
                    outCSC._OB_writeEndian();
                    CodeSetContextHelper.write(outCSC, ctx);
                    this.codeSetSC_ = new ServiceContext();
                    this.codeSetSC_.context_id = 1;
                    int len = buf.length();
                    byte[] data = buf.data();
                    this.codeSetSC_.context_data = new byte[len];
                    System.arraycopy(data, 0, this.codeSetSC_.context_data, 0, len);
                }
            }
            return worker;
        }
        return null;
    }

    GIOPClientWorker createWorkerInternal(Transport transport) {
        GIOPClientWorker worker = null;
        switch (this.concModel_) {
            case 0: {
                worker = new GIOPClientWorkerBlocking(this.orbInstance_, this, transport, this.acmTimeout_);
                break;
            }
            case 2: {
                worker = new GIOPClientWorkerThreaded(this.orbInstance_, this, transport, this.acmTimeout_);
            }
        }
        return worker;
    }

    Transport createTransport(int t) {
        Transport transport;
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            ConnectorInfo info = this.connector_.get_info();
            String msg = "trying to establish connection\n";
            msg = msg + "timeout: ";
            if (t >= 0) {
                msg = msg + t;
                msg = msg + "ms\n";
            } else {
                msg = msg + "none\n";
            }
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("outgoing", msg);
        }
        if (t >= 0) {
            transport = this.connector_.connect_timeout(t);
            if (transport == null) {
                throw new NO_RESPONSE("Connection timeout", 0, CompletionStatus.COMPLETED_NO);
            }
        } else {
            transport = this.connector_.connect();
            Assert.assertTrue(transport != null);
        }
        return transport;
    }

    GIOPClient(ORBInstance orbInstance, Connector connector, int concModel, CodeConverters conv, int acmTimeout) {
        super(concModel, conv);
        this.orbInstance_ = orbInstance;
        this.connector_ = connector;
        this.acmTimeout_ = acmTimeout;
        this.destroy_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        GIOPClientWorkersPool workers = null;
        GIOPClient gIOPClient = this;
        synchronized (gIOPClient) {
            if (this.destroy_) {
                return;
            }
            this.destroy_ = true;
            workers = this.workers_;
            this.workers_ = null;
        }
        if (workers != null) {
            GIOPClientWorker[] pool = workers.getWorkers();
            for (int i = 0; i < pool.length; ++i) {
                GIOPClientWorker clientWorker = pool[i];
                if (clientWorker == null) continue;
                clientWorker.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorker(GIOPClientWorker worker) {
        GIOPClientWorkersPool workers;
        GIOPClient gIOPClient = this;
        synchronized (gIOPClient) {
            workers = this.workers_;
        }
        if (workers != null) {
            workers.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestId() {
        Object object = this.nextRequestIdMutex_;
        synchronized (object) {
            return this.nextRequestId_++;
        }
    }

    public ProfileInfo[] getUsableProfiles(IOR ior, Policy[] policies) {
        ProfileInfo[] all = this.connector_.get_usable_profiles(ior, policies);
        Vector<ProfileInfo> vec = new Vector<ProfileInfo>();
        for (int i = 0; i < all.length; ++i) {
            CodeConverters conv = CodeSetUtil.getCodeConverters(all[i]);
            if (!this.codeConverters().equals(conv)) continue;
            vec.addElement(all[i]);
        }
        Object[] result = new ProfileInfo[vec.size()];
        vec.copyInto(result);
        return result;
    }

    public ConnectorInfo connectorInfo() {
        return this.connector_.get_info();
    }

    public TransportInfo transportInfo() {
        GIOPClientWorker worker = this.getWorker(false, -1);
        if (worker == null) {
            return null;
        }
        Transport transport = worker.transport();
        if (transport != null) {
            return transport.get_info();
        }
        return null;
    }

    public DowncallEmitter startDowncall(Downcall down, OutputStreamHolder out) {
        GIOPClientWorker worker = null;
        try {
            worker = this.getWorker(true, down.policies().connectTimeout);
        }
        catch (SystemException ex) {
            Assert.assertTrue(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return null;
        }
        try {
            byte major = down.profileInfo().major;
            byte minor = down.profileInfo().minor;
            if (!(worker.messageSent() || major <= 1 && minor < 1)) {
                CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
                if (coreTraceLevels.traceConnections() >= 2) {
                    CodeConverters conv = this.codeConverters();
                    String msg = "sending transmission code sets";
                    msg = msg + "\nchar code set: ";
                    msg = msg + conv.outputCharConverter.getTo().description;
                    msg = msg + "\nwchar code set: ";
                    msg = conv.wcharConverter != null ? msg + conv.wcharConverter.getTo().description : msg + "none";
                    this.orbInstance_.getLogger().trace("outgoing", msg);
                }
                Assert.assertTrue(this.codeSetSC_ != null);
                down.addToRequestSCL(this.codeSetSC_);
            }
            ProfileInfo profileInfo = down.profileInfo();
            Buffer buf = new Buffer(12);
            buf.pos(12);
            out.value = new OutputStream(buf, this.codeConverters(), profileInfo.major == 1 && profileInfo.minor < 2);
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out.value, profileInfo);
            outgoing.writeRequestHeader(down.requestId(), down.operation(), down.responseExpected(), down.getRequestSCL());
            return worker;
        }
        catch (SystemException ex) {
            Assert.assertTrue(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return null;
        }
    }

    public boolean equal(Client cl) {
        GIOPClient client = null;
        try {
            client = (GIOPClient)cl;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (!this.connector_.equal(client.connector_)) {
            return false;
        }
        if (!this.codeConverters().equals(client.codeConverters())) {
            return false;
        }
        return this.acmTimeout_ == client.acmTimeout_;
    }
}

