/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.CoreTraceLevels;
import com.crystaldecisions.thirdparty.com.ooc.OB.Downcall;
import com.crystaldecisions.thirdparty.com.ooc.OB.DowncallEmitter;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClient;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPIncomingMessage;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPOutgoingMessage;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.Util;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.com.ooc.OCI.TransportInfo;
import com.crystaldecisions.thirdparty.org.omg.CORBA.COMM_FAILURE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;
import com.crystaldecisions.thirdparty.org.omg.GIOP.MsgType_1_1;
import com.crystaldecisions.thirdparty.org.omg.GIOP.ReplyStatusType_1_2Holder;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.IOP.IORHelper;
import com.crystaldecisions.thirdparty.org.omg.IOP.ServiceContextListHolder;
import java.util.Properties;
import java.util.Vector;

abstract class GIOPClientWorker
implements DowncallEmitter {
    protected ORBInstance orbInstance_;
    protected GIOPClient client_;
    protected Transport transport_;
    protected Buffer buf_;
    protected GIOPIncomingMessage incoming_;
    protected boolean messageSent_;
    protected byte minor_;
    protected boolean closeLogged_;
    protected int shutdownTimeout_;
    protected int acmTimeout_;
    protected long timestamp_;
    protected Vector unsent_ = new Vector();
    protected Vector pending_ = new Vector();
    public static final int StateActive = 0;
    public static final int StateClosing = 1;
    public static final int StateError = 2;
    public static final int StateClosed = 4;
    protected int state_;
    protected SystemException exception_;

    protected void logCloseConnection() {
        if (!this.closeLogged_) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                TransportInfo info = this.transport_.get_info();
                String msg = "closing connection\n";
                msg = msg + info.describe();
                this.orbInstance_.getLogger().trace("outgoing", msg);
            }
            this.closeLogged_ = true;
        }
    }

    protected void addCloseConnection() {
        if (this.minor_ < 2) {
            return;
        }
        Buffer buf = new Buffer(12);
        OutputStream out = new OutputStream(buf);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
        this.addUnsent(buf);
    }

    protected void addMessageError() {
        Buffer buf = new Buffer(12);
        OutputStream out = new OutputStream(buf);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
        this.addUnsent(buf);
    }

    protected void addMessageHeader(Downcall down) {
        OutputStream out = down.output();
        int pos = out._OB_pos();
        out._OB_pos(0);
        ProfileInfo profileInfo = down.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
        out._OB_pos(pos);
    }

    protected void addUnsent(Buffer buf) {
        this.updateTimestamp();
        if (this.state_ == 2 || this.state_ == 4) {
            return;
        }
        this.unsent_.addElement(new UnsentMessage(buf));
    }

    protected void addUnsent(Downcall down) {
        this.updateTimestamp();
        if (this.exception_ != null) {
            down.setFailureException(this.exception_);
            return;
        }
        Assert.assertTrue(this.state_ != 1 && this.state_ != 2 && this.state_ != 4);
        try {
            OutputStream out = down.output();
            int pos = out._OB_pos();
            out._OB_pos(0);
            ProfileInfo profileInfo = down.profileInfo();
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
            outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
            out._OB_pos(pos);
        }
        catch (SystemException ex) {
            Assert.assertTrue(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return;
        }
        byte minor = down.profileInfo().minor;
        if (minor > this.minor_) {
            this.minor_ = minor;
        }
        this.unsent_.addElement(new UnsentMessage(down));
    }

    protected void moveFirstUnsentToPending() {
        if (this.unsent_.isEmpty()) {
            Assert.assertTrue(this.exception_ != null);
            return;
        }
        UnsentMessage m = (UnsentMessage)this.unsent_.firstElement();
        Downcall down = m.down;
        this.unsent_.removeElementAt(0);
        this.messageSent_ = true;
        if (down != null) {
            if (down.responseExpected()) {
                down.setPending();
                this.pending_.addElement(down);
            } else {
                down.setNoException(null);
            }
        }
    }

    protected Downcall findAndRemovePending(int reqId) {
        for (int i = 0; i < this.pending_.size(); ++i) {
            Downcall d = (Downcall)this.pending_.elementAt(i);
            if (d.requestId() != reqId) continue;
            this.pending_.removeElementAt(i);
            return d;
        }
        return null;
    }

    protected boolean exception(int state, SystemException ex, boolean notCompleted) {
        if (this.state_ == state) {
            return false;
        }
        if (state < this.state_) {
            return false;
        }
        if (this.exception_ == null) {
            this.exception_ = Util.copySystemException(ex);
            this.exception_.completed = CompletionStatus.COMPLETED_NO;
            while (!this.unsent_.isEmpty()) {
                UnsentMessage m = (UnsentMessage)this.unsent_.firstElement();
                if (m.down != null) {
                    m.down.setFailureException(this.exception_);
                }
                this.unsent_.removeElementAt(0);
            }
            SystemException except = Util.copySystemException(this.exception_);
            if (!notCompleted) {
                except.completed = CompletionStatus.COMPLETED_MAYBE;
            }
            while (!this.pending_.isEmpty()) {
                Downcall down = (Downcall)this.pending_.firstElement();
                down.setFailureException(except);
                this.pending_.removeElementAt(0);
            }
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                this.addCloseConnection();
                this.client_.removeWorker(this);
                break;
            }
            case 2: {
                this.addMessageError();
                this.client_.removeWorker(this);
                break;
            }
            case 4: {
                this.logCloseConnection();
                this.transport_.close();
                this.client_.removeWorker(this);
            }
        }
        this.state_ = state;
        return true;
    }

    protected final void exception(int state, SystemException ex) {
        this.exception(state, ex, false);
    }

    int load() {
        return this.unsent_.size() + this.pending_.size();
    }

    protected void execute() {
        boolean complete;
        Assert.assertTrue(this.state_ == 0 || this.state_ == 1);
        this.updateTimestamp();
        try {
            Buffer buf = this.buf_;
            this.buf_ = null;
            complete = this.incoming_.consumeBuffer(buf);
        }
        catch (SystemException ex) {
            this.exception(2, ex);
            return;
        }
        byte minor = this.incoming_.version().minor;
        if (minor > this.minor_) {
            this.minor_ = minor;
        }
        if (!complete) {
            return;
        }
        block2 : switch (this.incoming_.type().value()) {
            case 1: {
                int reqId = 0;
                ReplyStatusType_1_2Holder status = new ReplyStatusType_1_2Holder();
                ServiceContextListHolder scl = new ServiceContextListHolder();
                try {
                    reqId = this.incoming_.readReplyHeader(status, scl);
                }
                catch (SystemException ex) {
                    this.exception(2, ex);
                    return;
                }
                Downcall down = this.findAndRemovePending(reqId);
                if (down == null) {
                    this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577432) + ": " + reqId, 1330577432, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                down.setReplySCL(scl.value);
                InputStream in = this.incoming_.input();
                switch (status.value.value()) {
                    case 0: {
                        down.setNoException(in);
                        break block2;
                    }
                    case 1: {
                        down.setUserException(in);
                        break block2;
                    }
                    case 2: {
                        SystemException ex = Util.unmarshalSystemException(in);
                        down.setSystemException(ex);
                        break block2;
                    }
                    case 3: {
                        IOR ior = IORHelper.read(in);
                        down.setLocationForward(ior, false);
                        break block2;
                    }
                    case 4: {
                        IOR ior = IORHelper.read(in);
                        down.setLocationForward(ior, true);
                        break block2;
                    }
                    case 5: {
                        Assert.assertTrue(false);
                        break block2;
                    }
                }
                Assert.assertTrue(false);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 4: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 5: {
                this.exception(4, new TRANSIENT(MinorCodes.describeTransient(1330577410), 1330577410, CompletionStatus.COMPLETED_MAYBE), true);
                break;
            }
            case 6: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577429), 1330577429, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 7: {
                Assert.assertTrue(false);
            }
        }
    }

    protected void updateTimestamp() {
        if (this.acmTimeout_ > 0) {
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }
    }

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.state_ == 4);
        super.finalize();
    }

    GIOPClientWorker(ORBInstance orbInstance, GIOPClient client, Transport transport, int acmTimeout) {
        this.orbInstance_ = orbInstance;
        this.client_ = client;
        this.transport_ = transport;
        this.incoming_ = new GIOPIncomingMessage(this.orbInstance_);
        this.messageSent_ = false;
        this.minor_ = 0;
        this.closeLogged_ = false;
        this.acmTimeout_ = acmTimeout;
        this.state_ = 0;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.client_shutdown_timeout");
        this.shutdownTimeout_ = value != null ? Integer.parseInt(value) : 2;
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo info = this.transport_.get_info();
            String msg = "new connection\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("outgoing", msg);
        }
        this.updateTimestamp();
    }

    abstract void destroy();

    final Transport transport() {
        return this.transport_;
    }

    final boolean messageSent() {
        return this.messageSent_;
    }

    protected class UnsentMessage {
        Buffer buf;
        Downcall down;

        UnsentMessage(Buffer buf) {
            this.buf = buf;
            this.buf.pos(0);
        }

        UnsentMessage(Downcall down) {
            this.down = down;
            this.buf = down.output()._OB_buffer();
            this.buf.pos(0);
        }
    }
}

