/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.Downcall;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClient;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClientWorker;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.IMP_LIMIT;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;

final class GIOPClientWorkerThreaded
extends GIOPClientWorker {
    protected Thread senderThread_;
    protected Thread receiverThread_;

    protected void addUnsent(Buffer buf) {
        super.addUnsent(buf);
        this.notifyAll();
    }

    protected void addUnsent(Downcall down) {
        down.initStateMonitor();
        super.addUnsent(down);
        this.notifyAll();
    }

    protected Downcall findAndRemovePending(int reqId) {
        while (!this.unsent_.isEmpty()) {
            GIOPClientWorker.UnsentMessage m = (GIOPClientWorker.UnsentMessage)this.unsent_.firstElement();
            if (m.down == null || m.down.requestId() != reqId) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Downcall down = super.findAndRemovePending(reqId);
        if (this.acmTimeout_ > 0 && this.unsent_.isEmpty() && this.pending_.isEmpty()) {
            this.notifyAll();
        }
        return down;
    }

    protected boolean exception(int state, SystemException ex, boolean notCompleted) {
        if (!super.exception(state, ex, notCompleted)) {
            return false;
        }
        this.notifyAll();
        return true;
    }

    GIOPClientWorkerThreaded(ORBInstance orbInstance, GIOPClient client, Transport transport, int acmTimeout) {
        super(orbInstance, client, transport, acmTimeout);
        try {
            ThreadGroup group = this.orbInstance_.getClientWorkerGroup();
            this.senderThread_ = new SenderThread(group, this);
            this.senderThread_.start();
            this.receiverThread_ = new ReceiverThread(group, this);
            this.receiverThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.transport_.close();
            this.state_ = 4;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    synchronized void destroy() {
        this.exception(1, new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Downcall down, boolean block) {
        GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
        synchronized (gIOPClientWorkerThreaded) {
            this.addUnsent(down);
        }
        try {
            return down.waitUntilSent(block);
        }
        catch (SystemException ex) {
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded2 = this;
            synchronized (gIOPClientWorkerThreaded2) {
                this.exception(4, ex);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(Downcall down, boolean block) {
        try {
            return down.waitUntilCompleted(block);
        }
        catch (SystemException ex) {
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                this.exception(4, ex);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendReceive(Downcall down) {
        GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
        synchronized (gIOPClientWorkerThreaded) {
            this.addUnsent(down);
        }
        return this.receive(down, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void senderRun() {
        boolean first = true;
        while (true) {
            Buffer buf;
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                if (!first) {
                    this.moveFirstUnsentToPending();
                    this.notifyAll();
                } else {
                    first = false;
                }
                while (true) {
                    long current;
                    if (this.state_ == 4) {
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 1) {
                        this.logCloseConnection();
                        this.transport_.shutdown();
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 2) {
                        this.exception(4, new TRANSIENT(MinorCodes.describeTransient(0x4F4F0004), 0x4F4F0004, CompletionStatus.COMPLETED_MAYBE));
                        return;
                    }
                    if (!this.unsent_.isEmpty()) break;
                    if (this.acmTimeout_ > 0 && this.unsent_.isEmpty() && this.pending_.isEmpty() && (current = System.currentTimeMillis() / 1000L) >= this.timestamp_ + (long)this.acmTimeout_) {
                        this.exception(1, new TRANSIENT(MinorCodes.describeTransient(1330577411), 1330577411, CompletionStatus.COMPLETED_MAYBE));
                        continue;
                    }
                    try {
                        if (this.acmTimeout_ > 0 && this.unsent_.isEmpty() && this.pending_.isEmpty()) {
                            this.wait(this.acmTimeout_ * 1000);
                            continue;
                        }
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                GIOPClientWorker.UnsentMessage m = (GIOPClientWorker.UnsentMessage)this.unsent_.firstElement();
                buf = m.buf;
            }
            try {
                this.transport_.send(buf, true);
                Assert.assertTrue(buf.is_full());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded2 = this;
                synchronized (gIOPClientWorkerThreaded2) {
                    this.exception(4, ex);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiverRun() {
        while (true) {
            Assert.assertTrue(this.buf_ == null);
            this.buf_ = new Buffer(12);
            try {
                this.transport_.receive(this.buf_, true);
                Assert.assertTrue(this.buf_.is_full());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(4, ex);
                    return;
                }
            }
            try {
                this.incoming_.extractHeader(this.buf_);
                this.buf_.realloc(12 + this.incoming_.size());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(2, ex);
                    return;
                }
            }
            if (!this.buf_.is_full()) {
                try {
                    this.transport_.receive(this.buf_, true);
                    Assert.assertTrue(this.buf_.is_full());
                }
                catch (SystemException ex) {
                    GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                    synchronized (gIOPClientWorkerThreaded) {
                        this.exception(4, ex);
                        return;
                    }
                }
            }
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                if (this.state_ != 0 && this.state_ != 1) {
                    return;
                }
                this.execute();
            }
        }
    }

    protected static final class ReceiverThread
    extends Thread {
        private GIOPClientWorkerThreaded worker_;

        ReceiverThread(ThreadGroup group, GIOPClientWorkerThreaded worker) {
            super(group, "ORBacus:Client:ReceiverThread");
            this.setDaemon(true);
            this.worker_ = worker;
        }

        public void run() {
            try {
                this.worker_.receiverRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert.assertTrue(false);
            }
            this.worker_ = null;
        }
    }

    protected static final class SenderThread
    extends Thread {
        private GIOPClientWorkerThreaded worker_;

        SenderThread(ThreadGroup group, GIOPClientWorkerThreaded worker) {
            super(group, "ORBacus:Client:SenderThread");
            this.setDaemon(true);
            this.worker_ = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.worker_.senderRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert.assertTrue(false);
            }
            while (true) {
                try {
                    if (this.worker_.shutdownTimeout_ > 0) {
                        this.worker_.receiverThread_.join(this.worker_.shutdownTimeout_ * 1000);
                        break;
                    }
                    this.worker_.receiverThread_.join();
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this.worker_;
            synchronized (gIOPClientWorkerThreaded) {
                this.worker_.exception(4, new TRANSIENT(MinorCodes.describeTransient(0x4F4F0004), 0x4F4F0004, CompletionStatus.COMPLETED_MAYBE));
            }
            this.worker_ = null;
        }
    }
}

