/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClient;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClientWorker;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;

class GIOPClientWorkersPool {
    private final int m_size;
    private final GIOPClientWorker[] m_workers;
    private final GIOPClient m_client;
    private int m_index;
    private static final int THRESHOLD = 1;

    GIOPClientWorkersPool(GIOPClient client, int size) {
        this.m_size = size;
        this.m_workers = new GIOPClientWorker[size];
        this.m_index = 0;
        this.m_client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GIOPClientWorker next(int timeout) {
        boolean needToClose;
        GIOPClientWorker worker;
        int picked;
        GIOPClientWorkersPool gIOPClientWorkersPool = this;
        synchronized (gIOPClientWorkersPool) {
            int i;
            GIOPClientWorker[] workers = this.m_workers;
            int size = this.m_size;
            int index = this.m_index;
            int lessBusy = i = this.m_index;
            int lastEmpty = -1;
            do {
                GIOPClientWorker worker2;
                if ((worker2 = workers[i]) == null) {
                    if (lastEmpty != -1) continue;
                    lastEmpty = i;
                    continue;
                }
                if (worker2.load() < 1) {
                    this.m_index = i;
                    return worker2;
                }
                if (workers[lessBusy] != null && workers[lessBusy].load() <= worker2.load()) continue;
                lessBusy = i;
            } while ((i = (i + 1) % size) != index);
            if (lastEmpty == -1 || workers[lessBusy] != null && workers[lessBusy].load() < 1) {
                this.m_index = lessBusy;
                return workers[lessBusy];
            }
            this.m_index = picked = lastEmpty;
        }
        Transport transport = this.m_client.createTransport(timeout);
        GIOPClientWorkersPool index = this;
        synchronized (index) {
            worker = this.m_workers[picked];
            if (worker == null) {
                this.m_workers[picked] = worker = this.m_client.createWorkerInternal(transport);
                needToClose = false;
            } else {
                needToClose = true;
            }
        }
        if (needToClose) {
            try {
                transport.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return worker;
    }

    public synchronized GIOPClientWorker current() {
        return this.m_workers[this.m_index];
    }

    public synchronized GIOPClientWorker[] getWorkers() {
        GIOPClientWorker[] workers = new GIOPClientWorker[this.m_size];
        System.arraycopy(this.m_workers, 0, workers, 0, this.m_size);
        return workers;
    }

    public synchronized void remove(GIOPClientWorker worker) {
        GIOPClientWorker[] workers = this.m_workers;
        for (int i = 0; i < workers.length; ++i) {
            GIOPClientWorker w = workers[i];
            if (w != worker) continue;
            workers[i] = null;
            break;
        }
    }
}

