/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverters;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetDatabase;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetUtil;
import com.crystaldecisions.thirdparty.com.ooc.OB.CoreTraceLevels;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPIncomingMessage;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPOutgoingMessage;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerStarter;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.OAInterface;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.Upcall;
import com.crystaldecisions.thirdparty.com.ooc.OB.UpcallReturn;
import com.crystaldecisions.thirdparty.com.ooc.OB.Util;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.com.ooc.OCI.TransportInfo;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetContext;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetContextHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BooleanHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.COMM_FAILURE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import com.crystaldecisions.thirdparty.org.omg.GIOP.LocateStatusType_1_2;
import com.crystaldecisions.thirdparty.org.omg.GIOP.MsgType_1_1;
import com.crystaldecisions.thirdparty.org.omg.GIOP.ReplyStatusType_1_2;
import com.crystaldecisions.thirdparty.org.omg.GIOP.TargetAddressHolder;
import com.crystaldecisions.thirdparty.org.omg.GIOP.Version;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.IOP.IORHelper;
import com.crystaldecisions.thirdparty.org.omg.IOP.IORHolder;
import com.crystaldecisions.thirdparty.org.omg.IOP.ServiceContext;
import com.crystaldecisions.thirdparty.org.omg.IOP.ServiceContextListHolder;
import java.util.Properties;
import java.util.Vector;

abstract class GIOPServerWorker
implements UpcallReturn {
    protected ORBInstance orbInstance_;
    protected GIOPServerStarter starter_;
    protected Transport transport_;
    protected OAInterface oaInterface_;
    protected Buffer buf_;
    protected GIOPIncomingMessage incoming_;
    protected CodeConverters codeConverters_;
    protected Vector unsent_ = new Vector();
    protected int upcallCount_;
    protected byte minor_;
    protected boolean closeLogged_;
    protected boolean closeConnection_;
    protected int shutdownTimeout_;
    protected int acmTimeout_;
    protected long timestamp_;
    public static final int StateActive = 0;
    public static final int StateHolding = 1;
    public static final int StateClosing = 2;
    public static final int StateError = 3;
    public static final int StateClosed = 4;
    protected int state_;

    protected void logCloseConnection() {
        if (!this.closeLogged_) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                TransportInfo info = this.transport_.get_info();
                String msg = "closing connection\n";
                msg = msg + info.describe();
                if (this.minor_ >= 2 && !this.closeConnection_) {
                    msg = msg + "\nclient disconnected without sending a `CloseConnection' message";
                }
                this.orbInstance_.getLogger().trace("incoming", msg);
            }
            this.closeLogged_ = true;
        }
    }

    protected void addCloseConnection() {
        this.closeConnection_ = true;
        Buffer buf = new Buffer(12);
        OutputStream out = new OutputStream(buf);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
        this.add(buf);
    }

    protected void addMessageError() {
        Buffer buf = new Buffer(12);
        OutputStream out = new OutputStream(buf);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
        this.add(buf);
    }

    protected void add(Buffer buf) {
        this.updateTimestamp();
        if (this.state_ == 3 || this.state_ == 4) {
            return;
        }
        buf.pos(0);
        this.unsent_.addElement(buf);
    }

    protected void addUpcall(Upcall upcall) {
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int pos = out._OB_pos();
        out._OB_pos(0);
        try {
            outgoing.writeMessageHeader(MsgType_1_1.Reply, false, pos - 12);
        }
        catch (SystemException ex) {
            Assert.assertTrue(false);
        }
        Buffer buf = new Buffer();
        buf.consume(out._OB_buffer());
        this.add(buf);
        Assert.assertTrue(this.upcallCount_ > 0);
        --this.upcallCount_;
        if (this.upcallCount_ == 0 && this.state_ == 2) {
            this.addCloseConnection();
        }
    }

    protected void getCodeConverters(ServiceContext[] scl) {
        if (this.codeConverters_ == null) {
            for (int i = 0; i < scl.length; ++i) {
                if (scl[i].context_id != 1) continue;
                CodeSetContextHolder codeSetContextH = new CodeSetContextHolder();
                CodeSetUtil.extractCodeSetContext(scl[i], codeSetContextH);
                CodeSetContext codeSetContext = codeSetContextH.value;
                this.codeConverters_ = new CodeConverters();
                this.codeConverters_.inputCharConverter = CodeSetDatabase.instance().getConverter(CodeSetUtil.native_cs(), codeSetContext.char_data);
                this.codeConverters_.outputCharConverter = CodeSetDatabase.instance().getConverter(codeSetContext.char_data, CodeSetUtil.native_cs());
                this.codeConverters_.wcharConverter = CodeSetDatabase.instance().getConverter(codeSetContext.wchar_data, CodeSetUtil.native_wcs());
                CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
                if (coreTraceLevels.traceConnections() < 2) break;
                String msg = "receiving transmission code sets";
                msg = msg + "\nchar code set: ";
                msg = this.codeConverters_.inputCharConverter != null ? msg + this.codeConverters_.inputCharConverter.getFrom().description : msg + "none";
                msg = msg + "\nwchar code set: ";
                msg = this.codeConverters_.wcharConverter != null ? msg + this.codeConverters_.wcharConverter.getTo().description : msg + "none";
                this.orbInstance_.getLogger().trace("incoming", msg);
                break;
            }
        }
    }

    protected void exception(int state, SystemException ex) {
        String msg = "communications error with client\n";
        msg = msg + ex.getMessage();
        this.orbInstance_.getLogger().warning(msg);
        this.setStateNoSync(state);
    }

    protected boolean setStateNoSync(int state) {
        if (this.state_ == state) {
            return false;
        }
        if (this.state_ != 1 && state < this.state_) {
            return false;
        }
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (this.upcallCount_ == 0) {
                    this.addCloseConnection();
                }
                this.starter_.removeWorker(this);
                break;
            }
            case 3: {
                this.addMessageError();
                this.starter_.removeWorker(this);
                break;
            }
            case 4: {
                this.logCloseConnection();
                this.transport_.close();
                this.starter_.removeWorker(this);
            }
        }
        this.state_ = state;
        return true;
    }

    protected Upcall execute() {
        boolean complete;
        Assert.assertTrue(this.state_ == 0 || this.state_ == 2);
        this.updateTimestamp();
        try {
            Buffer buf = this.buf_;
            this.buf_ = null;
            complete = this.incoming_.consumeBuffer(buf);
        }
        catch (SystemException ex) {
            this.exception(3, ex);
            return null;
        }
        byte minor = this.incoming_.version().minor;
        if (minor > this.minor_) {
            this.minor_ = minor;
        }
        if (!complete) {
            return null;
        }
        Upcall upcall = null;
        switch (this.incoming_.type().value()) {
            case 0: {
                if (this.state_ != 0) break;
                upcall = this.executeRequest();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.state_ != 0) break;
                this.executeLocate();
                break;
            }
            case 1: 
            case 4: {
                this.exception(3, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 5: {
                if (this.incoming_.version().minor < 2) {
                    this.exception(4, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427) + ": invalid version for CloseConnection", 1330577427, CompletionStatus.COMPLETED_MAYBE));
                    break;
                }
                this.closeConnection_ = true;
                this.setStateNoSync(4);
                break;
            }
            case 6: {
                this.exception(3, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577429), 1330577429, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 7: {
                Assert.assertTrue(false);
            }
        }
        return upcall;
    }

    protected Upcall executeRequest() {
        int reqId;
        Assert.assertTrue(this.state_ == 0);
        BooleanHolder response = new BooleanHolder();
        StringHolder op = new StringHolder();
        ServiceContextListHolder scl = new ServiceContextListHolder();
        TargetAddressHolder target = new TargetAddressHolder();
        try {
            reqId = this.incoming_.readRequestHeader(response, target, op, scl);
            Assert.assertTrue(target.value.discriminator() == 0);
        }
        catch (SystemException ex) {
            this.exception(3, ex);
            return null;
        }
        Version version = this.incoming_.version();
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = version.major;
        profileInfo.minor = version.minor;
        profileInfo.key = target.value.object_key();
        InputStream in = this.incoming_.input();
        this.getCodeConverters(scl.value);
        if (this.codeConverters_ != null) {
            in._OB_codeConverters(this.codeConverters_, version.major == 1 && version.minor < 2);
        }
        if (response.value) {
            ++this.upcallCount_;
        }
        return this.oaInterface_.createUpcall(response.value ? this : null, profileInfo, this.transport_.get_info(), reqId, op.value, in, scl.value);
    }

    protected void executeLocate() {
        Assert.assertTrue(this.state_ == 0);
        try {
            TargetAddressHolder target = new TargetAddressHolder();
            int reqId = this.incoming_.readLocateRequestHeader(target);
            Assert.assertTrue(target.value.discriminator() == 0);
            byte[] key = target.value.object_key();
            IORHolder ior = new IORHolder();
            int val = this.oaInterface_.findByKey(key, ior);
            LocateStatusType_1_2 status = LocateStatusType_1_2.from_int(val);
            Buffer buf = new Buffer(12);
            buf.pos(12);
            OutputStream out = new OutputStream(buf);
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.major = this.incoming_.version().major;
            profileInfo.minor = this.incoming_.version().minor;
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
            outgoing.writeLocateReplyHeader(reqId, status);
            if (status == LocateStatusType_1_2.OBJECT_FORWARD || status == LocateStatusType_1_2.OBJECT_FORWARD_PERM) {
                IORHelper.write(out, ior.value);
            }
            int pos = out._OB_pos();
            out._OB_pos(0);
            outgoing.writeMessageHeader(MsgType_1_1.LocateReply, false, pos - 12);
            out._OB_pos(pos);
            Buffer b = new Buffer();
            b.consume(out._OB_buffer());
            this.add(b);
        }
        catch (SystemException ex) {
            this.exception(3, ex);
        }
    }

    protected void updateTimestamp() {
        if (this.acmTimeout_ > 0) {
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }
    }

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.state_ == 4);
        super.finalize();
    }

    GIOPServerWorker(ORBInstance orbInstance, GIOPServerStarter starter, Transport transport, OAInterface oaInterface) {
        this.orbInstance_ = orbInstance;
        this.starter_ = starter;
        this.transport_ = transport;
        this.oaInterface_ = oaInterface;
        this.incoming_ = new GIOPIncomingMessage(this.orbInstance_);
        this.codeConverters_ = null;
        this.upcallCount_ = 0;
        this.minor_ = 0;
        this.closeLogged_ = false;
        this.closeConnection_ = false;
        this.state_ = 1;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.server_shutdown_timeout");
        this.shutdownTimeout_ = value != null ? Integer.parseInt(value) : 2;
        value = properties.getProperty("ooc.orb.server_timeout");
        if (value != null) {
            this.acmTimeout_ = Integer.parseInt(value);
            this.updateTimestamp();
        } else {
            this.acmTimeout_ = 0;
            this.timestamp_ = 0L;
        }
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo info = this.transport_.get_info();
            String msg = "new connection\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("incoming", msg);
        }
    }

    public abstract boolean setState(int var1);

    public void upcallBeginReply(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.NO_EXCEPTION, replySCL);
        }
        catch (SystemException ex) {
            Assert.assertTrue(false);
        }
    }

    public void upcallBeginUserException(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.USER_EXCEPTION, replySCL);
        }
        catch (SystemException ex) {
            Assert.assertTrue(false);
        }
    }

    public void upcallEndUserException(Upcall upcall) {
        this.upcallEndReply(upcall);
    }

    public void upcallUserException(Upcall upcall, UserException ex, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.USER_EXCEPTION, replySCL);
            Assert.assertTrue(false);
        }
        catch (SystemException e) {
            Assert.assertTrue(false);
        }
        this.upcallEndReply(upcall);
    }

    public void upcallSystemException(Upcall upcall, SystemException ex, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.SYSTEM_EXCEPTION, replySCL);
            Util.marshalSystemException(out, ex);
        }
        catch (SystemException e) {
            Assert.assertTrue(false);
        }
        this.upcallEndReply(upcall);
    }

    public void upcallForward(Upcall upcall, IOR ior, boolean perm, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        ReplyStatusType_1_2 status = perm ? ReplyStatusType_1_2.LOCATION_FORWARD_PERM : ReplyStatusType_1_2.LOCATION_FORWARD;
        try {
            outgoing.writeReplyHeader(reqId, status, replySCL);
            IORHelper.write(out, ior);
        }
        catch (SystemException ex) {
            Assert.assertTrue(false);
        }
        this.upcallEndReply(upcall);
    }
}

