/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

public final class HexConverter {
    private static final char[] asciiToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] octetsToAsciiBytes(byte[] oct, int count) {
        if (count > oct.length) {
            throw new InternalError();
        }
        byte[] result = new byte[count * 2];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            byte b = oct[i];
            result[pos++] = (byte)asciiToHex[b >> 4 & 0xF];
            result[pos++] = (byte)asciiToHex[b & 0xF];
        }
        return result;
    }

    private static char[] octetsToAsciiChars(byte[] oct, int count) {
        if (count > oct.length) {
            throw new InternalError();
        }
        char[] result = new char[count * 2];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            byte b = oct[i];
            result[pos++] = asciiToHex[b >> 4 & 0xF];
            result[pos++] = asciiToHex[b & 0xF];
        }
        return result;
    }

    public static String octetsToAscii(byte[] oct, int count) {
        StringBuffer buf = new StringBuffer(count * 2);
        buf.append(HexConverter.octetsToAsciiChars(oct, count));
        return buf.toString();
    }

    public static byte[] asciiToOctets(String str, int offset) {
        int slen = str.length() - offset;
        if ((slen & 1) != 0) {
            return null;
        }
        int len = slen >> 1;
        byte[] oct = new byte[len];
        int j = offset;
        for (int i = 0; i < len; ++i) {
            int low;
            int high;
            char highChar = str.charAt(j++);
            char lowChar = str.charAt(j++);
            if (highChar >= '0' && highChar <= '9') {
                high = highChar - 48;
            } else if (highChar >= 'a' && highChar <= 'f') {
                high = 10 + highChar - 97;
            } else if (highChar >= 'A' && highChar <= 'F') {
                high = 10 + highChar - 65;
            } else {
                return null;
            }
            if (lowChar >= '0' && lowChar <= '9') {
                low = lowChar - 48;
            } else if (lowChar >= 'a' && lowChar <= 'f') {
                low = 10 + lowChar - 97;
            } else if (lowChar >= 'A' && lowChar <= 'F') {
                low = 10 + lowChar - 65;
            } else {
                return null;
            }
            oct[i] = (byte)(16 * high + low);
        }
        return oct;
    }

    public static byte[] asciiToOctets(String str) {
        return HexConverter.asciiToOctets(str, 0);
    }
}

