/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.Any;
import com.crystaldecisions.thirdparty.com.ooc.OB.Logger;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Param;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringSeqHelper;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class IIOPConfig {
    private Properties props_;
    private Logger logger_;
    private Vector params_;

    private Param findParam(String name) {
        for (int i = 0; i < this.params_.size(); ++i) {
            Param p = (Param)this.params_.elementAt(i);
            if (!p.name.equals(name)) continue;
            return p;
        }
        Param param = new Param(name, new Any());
        this.params_.addElement(param);
        return param;
    }

    private void parseHost(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, " ,");
            int count = tokenizer.countTokens();
            if (count == 0) {
                String err = prop + ": no hosts specified";
                this.logger_.error(err);
                throw new INITIALIZE(err);
            }
            String[] hosts = new String[count];
            int n = 0;
            while (tokenizer.hasMoreTokens()) {
                hosts[n++] = tokenizer.nextToken();
            }
            Param param = this.findParam("host");
            StringSeqHelper.insert(param.value, hosts);
        }
    }

    private void parsePort(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            int po = Integer.parseInt(value);
            if (po < 1 || po > 65535) {
                String err = prop + ": port must be between 1 and 65535";
                this.logger_.error(err);
                throw new INITIALIZE(err);
            }
            short port = po >= 32768 ? (short)(po - 65535 - 1) : (short)po;
            Param param = this.findParam("port");
            param.value.insert_ushort(port);
        }
    }

    private void parseBacklog(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            int b = Integer.parseInt(value);
            if (b < 0) {
                String err = prop + ": backlog must be between 0 and 65535";
                this.logger_.error(err);
                throw new INITIALIZE(err);
            }
            short backlog = b >= 32768 ? (short)(b - 65535 - 1) : (short)b;
            Param param = this.findParam("backlog");
            param.value.insert_ushort(backlog);
        }
    }

    private void parseBind(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            String addr = value.trim();
            if (addr.length() == 0) {
                String err = prop + ": no address specified";
                this.logger_.error(err);
                throw new INITIALIZE(err);
            }
            Param param = this.findParam("bind");
            param.value.insert_string(addr);
        }
    }

    private void parseBindIPv6(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            String addr = value.trim();
            if (addr.length() == 0) {
                String err = prop + ": no address specified";
                this.logger_.error(err);
                throw new INITIALIZE(err);
            }
            Param param = this.findParam("bindipv6");
            param.value.insert_string(addr);
        }
    }

    private void parseNumeric(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            boolean numeric = value.equals("true");
            Param param = this.findParam("numeric");
            param.value.insert_boolean(numeric);
        }
    }

    private void parseMultiProfile(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            boolean multiProfile = value.equals("true");
            Param param = this.findParam("multi_profile");
            param.value.insert_boolean(multiProfile);
        }
    }

    private void parseIPv4(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            boolean ipv4 = value.equals("true");
            Param param = this.findParam("ipv4");
            param.value.insert_boolean(ipv4);
        }
    }

    private void parseIPv6(String prop) {
        String value = this.props_.getProperty(prop);
        if (value != null) {
            boolean ipv6 = value.equals("true");
            Param param = this.findParam("ipv6");
            param.value.insert_boolean(ipv6);
        }
    }

    public IIOPConfig(Properties props, Logger logger) {
        this.props_ = props;
        this.logger_ = logger;
        this.params_ = new Vector();
    }

    public Param[] getParams() {
        Object[] result = new Param[this.params_.size()];
        this.params_.copyInto(result);
        return result;
    }

    public void parseDeprecatedDefaults() {
        this.parseHost("ooc.orb.oa.host");
        this.parseNumeric("ooc.orb.oa.numeric");
    }

    public void parseDeprecatedForName(String name) {
        String rootKey = "ooc.orb.poamanager." + name + ".";
        String prop = rootKey + "host";
        this.parseHost(prop);
        prop = rootKey + "numeric";
        this.parseNumeric(prop);
        prop = rootKey + "port";
        this.parsePort(prop);
    }

    public void parseDeprecatedDefaultPort() {
        this.parsePort("ooc.orb.oa.port");
    }

    public void parseDefaultPort() {
        this.parsePort("ooc.iiop.port");
    }

    public void parseDefaultBind() {
        this.parseBind("ooc.iiop.bind");
    }

    public void parseDefaultBindIPv6() {
        this.parseBindIPv6("ooc.iiop.bindipv6");
    }

    public void parseDefaults() {
        this.parseHost("ooc.iiop.host");
        this.parseNumeric("ooc.iiop.numeric");
        this.parseMultiProfile("ooc.iiop.multi_profile");
        this.parseBacklog("ooc.iiop.backlog");
        this.parseIPv4("ooc.iiop.ipv4");
        this.parseIPv6("ooc.iiop.ipv6");
    }

    public void parseForName(String name) {
        String rootKey = "ooc.iiop.acceptor." + name + ".";
        String prop = rootKey + "host";
        this.parseHost(prop);
        prop = rootKey + "numeric";
        this.parseNumeric(prop);
        prop = rootKey + "port";
        this.parsePort(prop);
        prop = rootKey + "backlog";
        this.parseBacklog(prop);
        prop = rootKey + "bind";
        this.parseBind(prop);
        prop = rootKey + "bindipv6";
        this.parseBindIPv6(prop);
        prop = rootKey + "multi_profile";
        this.parseMultiProfile(prop);
    }

    public void parseAll(String name) {
        this.parseDeprecatedDefaults();
        if (name.equals("RootPOAManager")) {
            this.parseDeprecatedDefaultPort();
        }
        this.parseDefaults();
        if (name.equals("RootPOAManager")) {
            this.parseDefaultPort();
            this.parseDefaultBind();
            this.parseDefaultBindIPv6();
        }
        this.parseDeprecatedForName(name);
        this.parseForName(name);
    }
}

