/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class Net {
    public static final short FAMILY_IPV4 = 2;
    public static final short FAMILY_IPV6 = 6;
    public static final short FAMILY_ANY = 0;

    public static String getCanonicalHostname(boolean numeric) {
        return Net.getCanonicalHostname(numeric, false);
    }

    public static String getCanonicalHostname(boolean numeric, boolean isIPv6) {
        String host;
        try {
            InetAddress localHost = Net.getCanonicalHost(isIPv6);
            if (localHost == null) {
                return null;
            }
            if (!numeric) {
                host = localHost.getCanonicalHostName();
                if (host.lastIndexOf(46) == -1) {
                    host = localHost.getHostAddress();
                }
            } else {
                host = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException ex) {
            host = null;
        }
        return host;
    }

    public static String getLocalHostName(boolean numeric, boolean isIPv6) {
        if (numeric) {
            if (isIPv6) {
                return "::1";
            }
            return "127.0.0.1";
        }
        return "localhost";
    }

    public static boolean isLocalHostName(String name) {
        return name.equals("::1") || name.equals("127.0.0.1") || name.equalsIgnoreCase("localhost");
    }

    public static InetAddress getCanonicalHost(boolean isIPv6) throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getCanonicalHostName();
        if (Net.isLocalHostName(hostName)) {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        return Net.getCanonicalHost(hostName, isIPv6);
    }

    public static short getFamily(String hostName) throws UnknownHostException {
        boolean hasIPv4 = false;
        boolean hasIPv6 = false;
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress address = addresses[i];
            if (address instanceof Inet6Address) {
                hasIPv6 = true;
            }
            if (!(address instanceof Inet4Address)) continue;
            hasIPv4 = true;
        }
        if (hasIPv6 && hasIPv4) {
            return 0;
        }
        if (hasIPv4) {
            return 2;
        }
        if (hasIPv6) {
            return 6;
        }
        return 0;
    }

    public static InetAddress getCanonicalHost(String hostName, boolean isIPv6) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostName);
        if (isIPv6 && address instanceof Inet6Address || !isIPv6 && address instanceof Inet4Address) {
            return address;
        }
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress address2 = addresses[i];
            if ((!isIPv6 || !(address2 instanceof Inet6Address)) && (isIPv6 || !(address2 instanceof Inet4Address))) continue;
            return address2;
        }
        throw new UnknownHostException(hostName);
    }

    public static boolean matches(short family, InetAddress address) {
        switch (family) {
            case 2: {
                return address instanceof Inet4Address;
            }
            case 6: {
                return address instanceof Inet6Address;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }
}

