/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OBPortableServer;

import com.crystaldecisions.thirdparty.com.ooc.OB.LocationForward;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ActiveObjectOnlyStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.DefaultServantHolder;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ObjectIdHasher;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAPolicies;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ServantActivatorStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ServantManagerStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.TableEntry;
import com.crystaldecisions.thirdparty.com.ooc.PortableServer.Current_impl;
import com.crystaldecisions.thirdparty.org.omg.CORBA.OBJECT_NOT_EXIST;
import com.crystaldecisions.thirdparty.org.omg.CORBA.OBJ_ADAPTER;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POA;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.Servant;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import java.util.Enumeration;

class RetainStrategy
extends ActiveObjectOnlyStrategy {
    private ServantActivatorStrategy servantManager_;
    private DefaultServantHolder defaultServant_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void etherealize(ObjectIdHasher oid, POA poa, Servant servant, boolean cleanup) {
        if (this.servantManager_ != null) {
            boolean remaining = false;
            if (this.servantIdTable_ == null) {
                Enumeration keys = this.activeObjectTable_.keys();
                while (keys.hasMoreElements()) {
                    TableEntry entry = (TableEntry)this.activeObjectTable_.get(keys.nextElement());
                    if (entry == null) continue;
                    TableEntry tableEntry = entry;
                    synchronized (tableEntry) {
                        if (entry.getServant() == servant) {
                            remaining = true;
                            break;
                        }
                    }
                }
            }
            this.servantManager_.etherealize(oid.getObjectId(), poa, servant, cleanup, remaining);
        }
    }

    protected void completeDeactivate(POA poa, ObjectIdHasher oid, TableEntry entry) {
        Servant servant = entry.getServant();
        super.completeDeactivate(poa, oid, entry);
        this.etherealize(oid, poa, servant, false);
    }

    RetainStrategy(POAPolicies policies, ORBInstance orbInstance, ServantActivatorStrategy servantManager, DefaultServantHolder defaultServant) {
        super(policies, orbInstance);
        this.servantManager_ = servantManager;
        this.defaultServant_ = defaultServant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(POA poa, boolean e) {
        if (this.servantManager_ != null && e) {
            Enumeration keys = this.activeObjectTable_.keys();
            while (keys.hasMoreElements()) {
                ObjectIdHasher key = (ObjectIdHasher)keys.nextElement();
                TableEntry entry = (TableEntry)this.activeObjectTable_.get(key);
                if (entry == null) continue;
                TableEntry tableEntry = entry;
                synchronized (tableEntry) {
                    this.activeObjectTable_.remove(key);
                    Servant servant = entry.getServant();
                    entry.clearServant();
                    this.etherealize(key, poa, servant, true);
                }
            }
        }
        super.destroy(poa, e);
        if (this.servantManager_ != null) {
            this.servantManager_.destroy();
        }
        if (this.defaultServant_ != null) {
            this.defaultServant_.destroy();
        }
    }

    public void etherealize(POA poa) {
        this.destroy(poa, true);
    }

    public byte[] servantToId(Servant servant, Current_impl poaCurrent) {
        byte[] oid = super.servantToId(servant, poaCurrent);
        if (oid == null && this.defaultServant_ != null) {
            return this.defaultServant_.servantToId(servant, poaCurrent);
        }
        return oid;
    }

    public Servant idToServant(byte[] oid, boolean useDefaultServant) {
        Servant servant = super.idToServant(oid, useDefaultServant);
        if (servant == null && useDefaultServant && this.defaultServant_ != null) {
            servant = this.defaultServant_.getDefaultServant();
        }
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant locate(byte[] rawoid, POA poa, String op, CookieHolder cookie) throws LocationForward {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        while (true) {
            Object object;
            TableEntry entry;
            if ((entry = (TableEntry)this.activeObjectTable_.get(oid)) != null) {
                object = entry;
                synchronized (object) {
                    if (!entry.active()) {
                        entry.waitDeactivated();
                        continue;
                    }
                    return entry.getServant();
                }
            }
            if (this.defaultServant_ != null) {
                Servant servant = this.defaultServant_.getDefaultServant();
                if (servant == null) {
                    throw new OBJ_ADAPTER("No default servant");
                }
                return servant;
            }
            if (this.servantManager_ == null) {
                throw new OBJECT_NOT_EXIST();
            }
            object = this.activeObjectTable_;
            synchronized (object) {
                if (!this.activeObjectTable_.containsKey(oid)) {
                    byte[] oid2;
                    Servant servant = this.servantManager_.incarnate(oid.getObjectId(), poa);
                    if (this.servantIdTable_ != null && this.servantIdTable_.containsKey(servant) && !ObjectIdHasher.comp(rawoid, oid2 = (byte[])this.servantIdTable_.get(servant))) {
                        throw new OBJ_ADAPTER("ServantActivator returned a servant that is already active for a different object ID");
                    }
                    entry = (TableEntry)this.activeObjectTable_.get(oid);
                    if (entry != null) {
                        Servant es = entry.getServant();
                        if (es != servant) {
                            throw new OBJ_ADAPTER("ServantActivator returned a servant that does not match the active object map");
                        }
                    } else {
                        entry = new TableEntry(servant);
                        this.activeObjectTable_.put(oid, entry);
                        this.completeActivation(oid, servant);
                    }
                    return servant;
                }
            }
        }
    }

    public ServantManagerStrategy getServantManagerStrategy() {
        return this.servantManager_;
    }

    public DefaultServantHolder getDefaultServantHolder() {
        return this.defaultServant_;
    }
}

