/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir;

import com.crystaldecisions.thirdparty.com.ooc.BiDirIOP.Header;
import com.crystaldecisions.thirdparty.com.ooc.BiDirIOP.HeaderHelper;
import com.crystaldecisions.thirdparty.com.ooc.BiDirIOP.Version;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir.Message;
import com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir.ShutdownStatus;
import com.crystaldecisions.thirdparty.com.ooc.OCI.BiDir.TransportObserver;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.com.ooc.OCI.TransportInfo;
import com.crystaldecisions.thirdparty.org.omg.CORBA.COMM_FAILURE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.Vector;

class ActiveTransport {
    private static final byte[] magic_ = new byte[]{79, 79, 67, 66};
    private String localPeer_;
    private String remotePeer_;
    private TransportObserver observer_;
    private Transport delegate_;
    private boolean callbackMessage_;
    private Vector incoming_ = new Vector();
    private Object incomingCond_ = new Object();
    private Vector incomingCallback_ = new Vector();
    private Object incomingCallbackCond_ = new Object();
    private SystemException receiveEx_;
    private ReceiverThread receiverThread_;
    private SenderThread senderThread_;
    private Vector outgoing_ = new Vector();
    private Object outgoingMonitor_ = new Object();
    private boolean shutdown_;
    static final int Outgoing = 0;
    static final int Incoming = 1;
    private int type_;

    private Buffer createHeader(boolean callback, int size) {
        Header h = new Header();
        h.magic = magic_;
        h.bidiriop_version = new Version(1, 0);
        h.flags = 0;
        if (callback) {
            h.flags = (byte)(h.flags | 2);
        }
        h.reserved = new byte[5];
        h.message_size = size;
        Buffer buf = new Buffer();
        OutputStream out = new OutputStream(buf);
        HeaderHelper.write(out, h);
        buf.pos(0);
        return buf;
    }

    private Header extractHeader(Buffer buf) {
        InputStream in = new InputStream(buf);
        Header h = HeaderHelper.read(in);
        if ((h.flags & 1) != 0) {
            in = new InputStream(buf, 0, true);
            h = HeaderHelper.read(in);
        }
        if (h.magic[0] != magic_[0] || h.magic[1] != magic_[1] || h.magic[2] != magic_[2] || h.magic[3] != magic_[3]) {
            throw new COMM_FAILURE("Bad magic key");
        }
        return h;
    }

    private void fillBuffer(Buffer dst, boolean callback) {
        Vector vec = callback ? this.incomingCallback_ : this.incoming_;
        while (!dst.is_full() && !vec.isEmpty()) {
            Buffer src = (Buffer)vec.elementAt(0);
            int dstLen = dst.rest_length();
            int srcLen = src.rest_length();
            int len = srcLen > dstLen ? dstLen : srcLen;
            System.arraycopy(src.data(), src.pos(), dst.data(), dst.pos(), len);
            dst.advance(len);
            src.advance(len);
            if (src.rest_length() != 0) continue;
            vec.removeElementAt(0);
        }
    }

    ActiveTransport(String localPeer, String remotePeer, TransportObserver observer, Transport delegate) {
        this.localPeer_ = localPeer;
        this.remotePeer_ = remotePeer;
        this.observer_ = observer;
        this.delegate_ = delegate;
        this.callbackMessage_ = false;
        this.receiveEx_ = null;
        this.shutdown_ = false;
        this.type_ = 0;
        this.receiverThread_ = new ReceiverThread(this);
        this.receiverThread_.start();
        this.senderThread_ = new SenderThread(this);
        this.senderThread_.start();
    }

    ActiveTransport(String localPeer, TransportObserver observer, Transport delegate) {
        this.localPeer_ = localPeer;
        this.remotePeer_ = null;
        this.observer_ = observer;
        this.delegate_ = delegate;
        this.callbackMessage_ = false;
        this.receiveEx_ = null;
        this.shutdown_ = false;
        this.type_ = 1;
        this.receiverThread_ = new ReceiverThread(this);
        this.receiverThread_.start();
        this.senderThread_ = new SenderThread(this);
        this.senderThread_.start();
    }

    String localPeer() {
        return this.localPeer_;
    }

    String remotePeer() {
        return this.remotePeer_;
    }

    int type() {
        return this.type_;
    }

    Transport delegate() {
        return this.delegate_;
    }

    TransportInfo info() {
        return this.delegate_.get_info();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean callback) {
        if (callback) {
            Object object = this.incomingCallbackCond_;
            synchronized (object) {
                this.incomingCallbackCond_.notifyAll();
                if (this.incomingCallback_.isEmpty()) {
                    this.callbackMessage_ = false;
                } else {
                    this.observer_.callbackConnection(this);
                }
            }
        }
        this.observer_.shutdown(this);
        Object object = this.outgoingMonitor_;
        synchronized (object) {
            if (!this.shutdown_) {
                this.shutdown_ = true;
                this.outgoingMonitor_.notify();
            }
        }
        this.delegate_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(boolean callback) {
        if (callback) {
            Object object = this.incomingCallbackCond_;
            synchronized (object) {
                this.incomingCallbackCond_.notifyAll();
            }
        }
        this.observer_.shutdown(this);
        Object object = this.outgoingMonitor_;
        synchronized (object) {
            this.shutdown_ = true;
            this.outgoingMonitor_.notify();
        }
        this.delegate_.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(Buffer buf, boolean block, boolean callback, ShutdownStatus status) {
        Object mutex = callback ? this.incomingCallbackCond_ : this.incomingCond_;
        Object object = mutex;
        synchronized (object) {
            this.fillBuffer(buf, callback);
            if (!buf.is_full() && this.receiveEx_ != null) {
                throw this.receiveEx_;
            }
            if (block) {
                while (!buf.is_full()) {
                    try {
                        mutex.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    this.fillBuffer(buf, callback);
                    if (buf.is_full()) continue;
                    if (this.receiveEx_ != null) {
                        throw this.receiveEx_;
                    }
                    if (status == null || !status.isShutdown()) continue;
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean receiveDetect(Buffer buf, boolean block, boolean callback, ShutdownStatus status) {
        Object mutex = callback ? this.incomingCallbackCond_ : this.incomingCond_;
        Object object = mutex;
        synchronized (object) {
            this.fillBuffer(buf, callback);
            if (!buf.is_full() && this.receiveEx_ != null) {
                return false;
            }
            if (block) {
                while (!buf.is_full()) {
                    try {
                        mutex.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    this.fillBuffer(buf, callback);
                    if (buf.is_full()) continue;
                    if (this.receiveEx_ != null) {
                        return false;
                    }
                    if (status == null || !status.isShutdown()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveTimeout(Buffer buf, int t, boolean callback, ShutdownStatus status) {
        Object mutex = callback ? this.incomingCallbackCond_ : this.incomingCond_;
        Object object = mutex;
        synchronized (object) {
            long now;
            this.fillBuffer(buf, callback);
            if (!buf.is_full() && this.receiveEx_ != null) {
                throw this.receiveEx_;
            }
            long timeDone = System.currentTimeMillis() + (long)t;
            while (!buf.is_full() && timeDone > (now = System.currentTimeMillis())) {
                long interval = timeDone - now;
                try {
                    mutex.wait(interval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.fillBuffer(buf, callback);
                if (buf.is_full()) continue;
                if (this.receiveEx_ != null) {
                    throw this.receiveEx_;
                }
                if (status == null || !status.isShutdown()) continue;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Buffer buf, boolean block, boolean callback) {
        if (this.shutdown_) {
            throw new COMM_FAILURE();
        }
        Buffer hbuf = this.createHeader(callback, buf.rest_length());
        Message msg = new Message(hbuf, buf);
        Object object = this.outgoingMonitor_;
        synchronized (object) {
            if (this.shutdown_) {
                throw new COMM_FAILURE();
            }
            this.outgoing_.addElement(msg);
            this.outgoingMonitor_.notify();
        }
        msg.waitUntilSent(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendDetect(Buffer buf, boolean block, boolean callback) {
        if (this.shutdown_) {
            return false;
        }
        Buffer hbuf = this.createHeader(callback, buf.rest_length());
        Message msg = new Message(hbuf, buf);
        Object object = this.outgoingMonitor_;
        synchronized (object) {
            if (this.shutdown_) {
                return false;
            }
            this.outgoing_.addElement(msg);
            this.outgoingMonitor_.notify();
        }
        try {
            msg.waitUntilSent(block);
        }
        catch (SystemException ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendTimeout(Buffer buf, int t, boolean callback) {
        if (this.shutdown_) {
            throw new COMM_FAILURE();
        }
        Buffer hbuf = this.createHeader(callback, buf.rest_length());
        Message msg = new Message(hbuf, buf);
        Object object = this.outgoingMonitor_;
        synchronized (object) {
            if (this.shutdown_) {
                throw new COMM_FAILURE();
            }
            this.outgoing_.addElement(msg);
            this.outgoingMonitor_.notify();
        }
        msg.waitUntilSent(t);
    }

    void sendLocalPeerId() {
        Assert.assertTrue(this.type_ == 0);
        Buffer buf = new Buffer();
        OutputStream out = new OutputStream(buf);
        out._OB_writeEndian();
        int len = this.localPeer_.length();
        out.write_ulong(len);
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)this.localPeer_.charAt(i);
        }
        out.write_octet_array(bytes, 0, len);
        buf.pos(0);
        this.send(buf, true, false);
    }

    void receiveRemotePeerId() {
        Assert.assertTrue(this.type_ == 1);
        Buffer buf = new Buffer(8);
        this.receive(buf, true, false, null);
        Assert.assertTrue(buf.is_full());
        InputStream in = new InputStream(buf);
        in._OB_readEndian();
        int len = in.read_ulong();
        buf.alloc(len);
        this.receive(buf, true, false, null);
        Assert.assertTrue(buf.is_full());
        this.remotePeer_ = new String(buf.data(), 0, buf.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiverRun() {
        try {
            Buffer buf = new Buffer();
            while (true) {
                Object object;
                buf.alloc(16);
                this.delegate_.receive(buf, true);
                Assert.assertTrue(buf.is_full());
                Header hdr = this.extractHeader(buf);
                buf.alloc(hdr.message_size);
                this.delegate_.receive(buf, true);
                Assert.assertTrue(buf.is_full());
                Buffer b = new Buffer();
                b.consume(buf);
                b.pos(0);
                if ((hdr.flags & 2) == 2) {
                    object = this.incomingCallbackCond_;
                    synchronized (object) {
                        if (!this.callbackMessage_) {
                            this.callbackMessage_ = true;
                            this.observer_.callbackConnection(this);
                        }
                        this.incomingCallback_.addElement(b);
                        this.incomingCallbackCond_.notifyAll();
                        continue;
                    }
                }
                object = this.incomingCond_;
                synchronized (object) {
                    this.incoming_.addElement(b);
                    this.incomingCond_.notifyAll();
                }
            }
        }
        catch (SystemException ex) {
            this.receiveEx_ = ex;
            Object object = this.incomingCond_;
            synchronized (object) {
                this.incomingCond_.notifyAll();
            }
            object = this.incomingCallbackCond_;
            synchronized (object) {
                this.incomingCallbackCond_.notifyAll();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void senderRun() {
        while (true) {
            try {
                while (true) {
                    if (!this.shutdown_) {
                        msg = null;
                        var2_3 = this.outgoingMonitor_;
                        synchronized (var2_3) {
                            break;
                        }
                    }
                    msg = this.outgoingMonitor_;
                    synchronized (msg) {
                        i = 0;
                        while (i < this.outgoing_.size()) {
                            m = (Message)this.outgoing_.elementAt(i);
                            m.exception(new COMM_FAILURE());
                            ++i;
                        }
                        return;
                    }
                    break;
                }
            }
            catch (SystemException ex) {
                var2_6 = this.outgoingMonitor_;
                synchronized (var2_6) {
                    i = 0;
                    while (i < this.outgoing_.size()) {
                        m = (Message)this.outgoing_.elementAt(i);
                        m.exception(ex);
                        ++i;
                    }
                    return;
                }
            }
            {
                while (!this.shutdown_ && this.outgoing_.isEmpty()) {
                    try {
                        this.outgoingMonitor_.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                if (!this.shutdown_) {
                    msg = (Message)this.outgoing_.firstElement();
                    this.outgoing_.removeElementAt(0);
                }
            }
            if (msg == null) ** continue;
            try {
                header = msg.header();
                this.delegate_.send(header, true);
                Assert.assertTrue(header.is_full());
                body = msg.body();
                this.delegate_.send(body, true);
                Assert.assertTrue(body.is_full());
                msg.sent();
            }
            catch (SystemException ex) {
                msg.exception(ex);
                throw ex;
            }
        }
    }

    private static class SenderThread
    extends Thread {
        private ActiveTransport activeTransport_;

        SenderThread(ActiveTransport activeTransport) {
            super("ORBacus:BiDirIOP:Transport:SenderThread");
            this.activeTransport_ = activeTransport;
        }

        public void run() {
            this.activeTransport_.senderRun();
            this.activeTransport_ = null;
        }
    }

    private static class ReceiverThread
    extends Thread {
        private ActiveTransport activeTransport_;

        ReceiverThread(ActiveTransport activeTransport) {
            super("ORBacus:BiDirIOP:Transport:ReceiverThread");
            this.activeTransport_ = activeTransport;
        }

        public void run() {
            this.activeTransport_.receiverRun();
            this.activeTransport_ = null;
        }
    }
}

