/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OCI.IIOP;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.LocalObject;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.Net;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactoryInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Acceptor;
import com.crystaldecisions.thirdparty.com.ooc.OCI.IIOP.AccFactoryInfo_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.IIOP.Acceptor_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.InvalidParam;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Param;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_OPERATION;
import com.crystaldecisions.thirdparty.org.omg.CORBA.COMM_FAILURE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringSeqHelper;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

final class AccFactory_impl
extends LocalObject
implements AccFactory {
    private AccFactoryInfo_impl info_ = new AccFactoryInfo_impl();

    public int id() {
        return 1330577409;
    }

    public int tag() {
        return 0;
    }

    public AccFactoryInfo get_info() {
        return this.info_;
    }

    public Acceptor[] create_acceptors(Param[] params) throws InvalidParam {
        String bind = null;
        Param bindParam = null;
        String bindipv6 = null;
        String[] hosts = null;
        short[] families = null;
        boolean multiProfile = false;
        int port = 0;
        int backlog = 0;
        boolean numeric = false;
        boolean ipv4Acceptor = true;
        boolean ipv6Acceptor = true;
        for (int i = 0; i < params.length; ++i) {
            short s;
            if (params[i].name.equals("bind")) {
                try {
                    bindParam = params[i];
                    bind = params[i].value.extract_string();
                    if (bind.trim().length() != 0) continue;
                    throw new InvalidParam(params[i], "address cannot be empty");
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("bindipv6")) {
                try {
                    bindipv6 = params[i].value.extract_string();
                    if (bindipv6.trim().length() != 0) continue;
                    throw new InvalidParam(params[i], "address cannot be empty");
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("host")) {
                try {
                    hosts = StringSeqHelper.extract(params[i].value);
                    if (hosts.length == 0) {
                        throw new InvalidParam(params[i], "no host");
                    }
                    families = new short[hosts.length];
                    for (int j = 0; j < families.length; ++j) {
                        try {
                            families[j] = Net.getFamily(hosts[j]);
                            continue;
                        }
                        catch (UnknownHostException e) {
                            throw new InvalidParam(params[i], "unknown hostname:" + e);
                        }
                    }
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("multi_profile")) {
                try {
                    multiProfile = params[i].value.extract_boolean();
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("ipv4")) {
                try {
                    ipv4Acceptor = params[i].value.extract_boolean();
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("ipv6")) {
                try {
                    ipv6Acceptor = params[i].value.extract_boolean();
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("port")) {
                try {
                    s = params[i].value.extract_ushort();
                    if (s < 0) {
                        port = 65535 + s + 1;
                        continue;
                    }
                    port = s;
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("backlog")) {
                try {
                    s = params[i].value.extract_ushort();
                    if (s < 0) {
                        backlog = 65535 + s + 1;
                        continue;
                    }
                    backlog = s;
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            if (params[i].name.equals("numeric")) {
                try {
                    numeric = params[i].value.extract_boolean();
                    continue;
                }
                catch (BAD_OPERATION ex) {
                    throw new InvalidParam(params[i], "wrong type");
                }
            }
            throw new InvalidParam(params[i], "unknown parameter");
        }
        if (hosts == null) {
            String IPv4HostName = Net.getCanonicalHostname(numeric, false);
            String IPv6HostName = Net.getCanonicalHostname(numeric, true);
            if (IPv4HostName == null && IPv6HostName == null) {
                IPv4HostName = Net.getLocalHostName(numeric, false);
                IPv6HostName = Net.getLocalHostName(numeric, true);
            } else if (IPv4HostName != null && IPv6HostName != null) {
                if (Net.isLocalHostName(IPv4HostName) && !Net.isLocalHostName(IPv6HostName)) {
                    IPv4HostName = null;
                } else if (!Net.isLocalHostName(IPv4HostName) && Net.isLocalHostName(IPv6HostName)) {
                    IPv6HostName = null;
                }
            }
            if (!ipv4Acceptor) {
                IPv4HostName = null;
            }
            if (!ipv6Acceptor) {
                IPv6HostName = null;
            }
            int length = 1;
            if (IPv4HostName != null && IPv6HostName != null) {
                length = 2;
            }
            hosts = new String[length];
            families = new short[length];
            int index = 0;
            if (IPv4HostName != null) {
                hosts[index] = IPv4HostName;
                families[index] = 2;
                ++index;
            }
            if (IPv6HostName != null) {
                hosts[index] = IPv6HostName;
                families[index] = 6;
                ++index;
            }
        }
        ArrayList<Acceptor_impl> acceptors = new ArrayList<Acceptor_impl>();
        if (bind == null && bindipv6 == null) {
            acceptors.add(new Acceptor_impl(hosts, families, multiProfile, port, backlog));
        } else {
            boolean ipv4IsLoopback = false;
            boolean ipv6IsLoopback = false;
            InetAddress[] addresses = null;
            if (bindipv6 == null) {
                try {
                    InetAddress inetAddress;
                    int i;
                    addresses = InetAddress.getAllByName(bind);
                    bindipv6 = bind;
                    for (i = 0; i < addresses.length; ++i) {
                        inetAddress = addresses[i];
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        ipv4IsLoopback = inetAddress.isLoopbackAddress();
                        break;
                    }
                    for (i = 0; i < addresses.length; ++i) {
                        inetAddress = addresses[i];
                        if (!(inetAddress instanceof Inet6Address)) continue;
                        ipv6IsLoopback = inetAddress.isLoopbackAddress();
                        break;
                    }
                }
                catch (UnknownHostException ex) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577422) + ": " + ex.toString(), 1330577422, CompletionStatus.COMPLETED_NO);
                }
                if (!ipv4IsLoopback || !ipv6IsLoopback) {
                    if (ipv4IsLoopback) {
                        bind = null;
                    }
                    if (ipv6IsLoopback) {
                        bindipv6 = null;
                    }
                }
            }
            if (bind != null) {
                short[] specifiedFamilies = new short[families.length];
                for (int j = 0; j < specifiedFamilies.length; ++j) {
                    specifiedFamilies[j] = 2;
                }
                acceptors.add(new Acceptor_impl(bind, hosts, specifiedFamilies, multiProfile, port, backlog));
            }
            if (bindipv6 != null) {
                if (addresses != null) {
                    for (int i = 0; i < addresses.length; ++i) {
                        InetAddress inetAddress = addresses[i];
                        if (!(inetAddress instanceof Inet6Address)) continue;
                        short[] specifiedFamilies = new short[]{6};
                        String[] specifiedHosts = new String[]{inetAddress.getHostAddress()};
                        acceptors.add(new Acceptor_impl(inetAddress.getHostAddress(), specifiedHosts, specifiedFamilies, multiProfile, port, backlog));
                    }
                } else {
                    short[] specifiedFamilies = new short[]{6};
                    String[] specifiedHosts = new String[]{bindipv6};
                    acceptors.add(new Acceptor_impl(bindipv6, specifiedHosts, specifiedFamilies, multiProfile, port, backlog));
                }
            }
        }
        return acceptors.toArray(new Acceptor[acceptors.size()]);
    }
}

