/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.JCO;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class XMLReaderBase {
    public static final String NAMESPACE_URN_SAP_RFC = "urn:sap-com:document:sap:rfc:functions";
    protected static final int NAMESPACE_URN_SAP_RFC_MODE = 0;
    public static final String NAMESPACE_URN_SOAP_UC = "urn:sap-com:document:sap:soap:functions:uc-style";
    protected static final int NAMESPACE_URN_SOAP_UC_MODE = 1;
    private static final int TAG_START = 0;
    private static final int TAG_END = 1;
    private static final String ITEM_UPPER = "ITEM";
    private static final String ITEM_LOWER = "item";
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private char[] tagBuffer = new char[0];
    protected XMLReaderBase m_parent;
    protected JCO.Record m_record;
    protected char[] m_buffer;
    protected int m_offset;
    protected int m_length;
    protected int m_tag_start;
    protected int m_tag_end;
    protected int m_tag_typ;
    private int m_namespace_mode = 0;
    private static final int MAX_CHUNK_SIZE = 10240;
    private static final int TYPE_ITEM = 133;
    private static char[] entitySearchChars = new char[]{'\u0000', 'a', 'p', 'o', 's', '\u0000', 'c', 'u', 't', 'e', '\u0000', 'i', 'r', 'c', '\u0000', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 't', 'i', 'l', 'd', 'e', '\u0000', 'u', 'm', 'l', '\u0000', 'r', 'i', 'n', 'g', '\u0000', 'e', 'l', 'i', 'g', '\u0000', 'l', 'p', 'h', 'a', '\u0000', 'e', 'f', 's', 'y', 'm', '\u0000', 'n', 'g', '\u0000', 'd', '\u0000', 's', 'y', 'm', 'p', '\u0000', 'm', 'p', '\u0000', 'n', 'b', 's', 'p', '\u0000', 'o', 't', 'i', 'n', '\u0000', 't', 'i', 'l', 'd', 'e', '\u0000', 'u', '\u0000', 'a', 'b', 'l', 'a', '\u0000', 'i', '\u0000', 'e', '\u0000', 's', 'u', 'b', '\u0000', 'd', 'a', 's', 'h', '\u0000', 'i', 'e', 'x', 'c', 'l', '\u0000', 'q', 'u', 'e', 's', 't', '\u0000', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 'u', 'm', 'l', '\u0000', 'o', 't', 'a', '\u0000', 'm', 'a', 'g', 'e', '\u0000', 's', 'i', 'n', '\u0000', 'n', 'f', 'i', 'n', '\u0000', 't', '\u0000', 'c', 'e', 'n', 't', '\u0000', 'd', 'i', 'l', '\u0000', 'u', 'r', 'r', 'e', 'n', '\u0000', 'p', '\u0000', 'o', 'p', 'y', '\u0000', 'n', 'g', '\u0000', 'c', 'e', 'd', 'i', 'l', '\u0000', 'h', 'i', '\u0000', 'r', 'a', 'r', 'r', '\u0000', 'a', 'p', '\u0000', 'l', 'u', 'b', 's', '\u0000', 'i', 'r', 'c', '\u0000', 'p', 'o', 'u', 'n', 'd', '\u0000', 'l', 'u', 's', 'm', 'n', '\u0000', 'a', 'r', 'a', '\u0000', 't', '\u0000', 'i', 'v', '\u0000', 'h', 'i', '\u0000', 's', 'i', '\u0000', 'r', 'i', 'm', 'e', '\u0000', 'o', 'd', '\u0000', 'p', '\u0000', 'e', 'r', 'p', '\u0000', 'm', 'i', 'l', '\u0000', 'y', 'e', 'n', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'u', 'm', 'l', '\u0000', 'b', 'r', 'v', 'b', 'a', 'r', '\u0000', 'e', 't', 'a', '\u0000', 'u', 'l', 'l', '\u0000', 'd', 'q', 'u', 'o', '\u0000', 's', 'e', 'c', 't', '\u0000', 'h', 'y', '\u0000', 'u', 'p', '2', '\u0000', '3', '\u0000', '1', '\u0000', 'e', '\u0000', 'm', '\u0000', 'b', 'e', '\u0000', 'z', 'l', 'i', 'g', '\u0000', 'i', 'g', 'm', 'a', 'f', '\u0000', 'm', '\u0000', 'd', 'o', 't', '\u0000', 'p', 'a', 'd', 'e', 's', '\u0000', 'c', 'a', 'r', 'o', 'n', '\u0000', 'b', 'q', 'u', 'o', '\u0000', 'u', 'm', 'l', '\u0000', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'r', 'r', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 'u', 'm', 'l', '\u0000', 'p', 's', 'i', 'l', 'o', 'n', '\u0000', 'h', '\u0000', 'A', 'r', 'r', '\u0000', 'o', 'r', 'd', 'f', '\u0000', 'm', '\u0000', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 't', 'i', 'l', 'd', 'e', '\u0000', 'm', 'e', 's', '\u0000', 'u', 'm', 'l', '\u0000', 's', 'l', 'a', 's', 'h', '\u0000', 'm', 'i', 'c', 'r', 'o', 'n', '\u0000', 'e', 'g', 'a', '\u0000', 'l', 'i', 'n', 'e', '\u0000', 'p', 'l', 'u', 's', '\u0000', 'e', 'l', 'i', 'g', '\u0000', 'l', 'a', 'q', 'u', 'o', '\u0000', 'm', 'b', 'd', 'a', '\u0000', 'r', 'r', '\u0000', 'n', 'g', '\u0000', 'A', 'r', 'r', '\u0000', 'o', 'w', 'a', 's', 't', '\u0000', 'z', '\u0000', 'e', '\u0000', 'c', 'e', 'i', 'l', '\u0000', 'f', 'l', 'o', 'o', 'r', '\u0000', 't', '\u0000', 'r', 'm', '\u0000', 's', 'q', 'u', 'o', '\u0000', 'a', 'q', 'u', 'o', '\u0000', 'd', 'q', 'u', 'o', '\u0000', 'r', 'e', 'g', '\u0000', 'a', 'l', '\u0000', 'a', 'q', 'u', 'o', '\u0000', 'r', 'r', '\u0000', 'd', 'i', 'c', '\u0000', 'n', 'g', '\u0000', 'h', 'o', '\u0000', 'A', 'r', 'r', '\u0000', 'c', 'e', 'i', 'l', '\u0000', 'f', 'l', 'o', 'o', 'r', '\u0000', 'l', 'm', '\u0000', 's', 'q', 'u', 'o', '\u0000', 'a', 'q', 'u', 'o', '\u0000', 'd', 'q', 'u', 'o', '\u0000', 'm', 'a', 'c', 'r', '\u0000', 'i', 'c', 'r', 'o', '\u0000', 'd', 'd', 'o', 't', '\u0000', 'n', 'u', 's', '\u0000', 'u', '\u0000', 'd', 'a', 's', 'h', '\u0000', 'd', 'e', 'g', '\u0000', 'l', 't', 'a', '\u0000', 'i', 'v', 'i', 'd', 'e', '\u0000', 'a', 'm', 's', '\u0000', 'a', 'r', 'r', '\u0000', 'g', 'g', 'e', 'r', '\u0000', 'A', 'r', 'r', '\u0000', 'f', 'r', 'a', 'c', '1', '4', '\u0000', '2', '\u0000', '3', '4', '\u0000', 's', 'l', '\u0000', 'n', 'o', 'f', '\u0000', 'o', 'r', 'a', 'l', 'l', '\u0000', 'A', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 't', 'i', 'l', 'd', 'e', '\u0000', 'u', 'm', 'l', '\u0000', 'r', 'i', 'n', 'g', '\u0000', 'E', 'l', 'i', 'g', '\u0000', 'l', 'p', 'h', 'a', '\u0000', 'C', 'c', 'e', 'd', 'i', 'l', '\u0000', 'h', 'i', '\u0000', 'E', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 'u', 'm', 'l', '\u0000', 'T', 'H', '\u0000', 'p', 's', 'i', 'l', 'o', 'n', '\u0000', 't', 'a', '\u0000', 'I', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 'u', 'm', 'l', '\u0000', 'o', 't', 'a', '\u0000', 'N', 't', 'i', 'l', 'd', 'e', '\u0000', 'u', '\u0000', 'O', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 't', 'i', 'l', 'd', 'e', '\u0000', 'u', 'm', 'l', '\u0000', 's', 'l', 'a', 's', 'h', '\u0000', 'm', 'i', 'c', 'r', 'o', 'n', '\u0000', 'e', 'g', 'a', '\u0000', 'E', 'l', 'i', 'g', '\u0000', 't', 'i', 'm', 'e', 's', '\u0000', 'l', 'd', 'e', '\u0000', 'h', 'o', 'r', 'n', '\u0000', 'e', 't', 'a', 's', 'y', 'm', '\u0000', 'r', 'e', '4', '\u0000', 'i', 'n', 's', 'p', '\u0000', 'a', 'u', '\u0000', 'r', 'a', 'd', 'e', '\u0000', 'U', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 'u', 'm', 'l', '\u0000', 'p', 's', 'i', 'l', 'o', 'n', '\u0000', 'Y', 'a', 'c', 'u', 't', 'e', '\u0000', 'u', 'm', 'l', '\u0000', 'T', 'H', 'O', 'R', 'N', '\u0000', 'h', 'e', 't', 'a', '\u0000', 'a', 'u', '\u0000', 'e', 'g', 'r', 'a', 'v', 'e', '\u0000', 'a', 'c', 'u', 't', 'e', '\u0000', 'c', 'i', 'r', 'c', '\u0000', 'u', 'm', 'l', '\u0000', 'r', 'o', '\u0000', 't', 'h', '\u0000', 'a', '\u0000', 'p', 's', 'i', 'l', 'o', 'n', '\u0000', 'x', 'i', 's', 't', '\u0000', 'm', 'p', 't', 'y', '\u0000', 's', 'p', '\u0000', 'q', 'u', 'i', 'v', '\u0000', 'n', 's', 'p', '\u0000', 'B', 'e', 't', 'a', '\u0000', 'G', 'a', 'm', 'm', 'a', '\u0000', 'D', 'e', 'l', 't', 'a', '\u0000', 'a', 'g', 'g', 'e', 'r', '\u0000', 'Z', 'e', 't', 'a', '\u0000', 'K', 'a', 'p', 'p', 'a', '\u0000', 'L', 'a', 'm', 'b', 'd', 'a', '\u0000', 'M', 'u', '\u0000', 'X', 'i', '\u0000', 'P', 'i', '\u0000', 'h', 'i', '\u0000', 's', 'i', '\u0000', 'r', 'i', 'm', 'e', '\u0000', 'R', 'h', 'o', '\u0000', 'S', 'i', 'g', 'm', 'a', '\u0000', 'c', 'a', 'r', 'o', 'n', '\u0000', 'g', 'a', 'm', 'm', 'a', '\u0000', 'e', '\u0000', 't', '\u0000', 'z', 'e', 't', 'a', '\u0000', 'w', 'n', 'j', '\u0000', 'j', '\u0000', 'k', 'a', 'p', 'p', 'a', '\u0000', 'x', 'i', '\u0000', 'h', 'e', 'l', 'l', 'i', 'p', '\u0000', 'a', 'r', 't', 's', '\u0000', 'a', 'r', 'r', '\u0000', 'A', 'r', 'r', '\u0000', 'w', 'e', 'i', 'e', 'r', 'p', '\u0000', 'q', 'u', 'o', 't', '\u0000'};
    private static int[] entitySearchIdxs = new int[]{0, 71, 6, 0, 0, 0, 15, 11, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 0, 37, 0, 0, 0, 42, 0, 0, 0, 0, 47, 0, 0, 0, 0, 58, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 61, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 107, 76, 0, 0, 0, 81, 0, 0, 0, 0, 87, 0, 0, 0, 0, 0, 89, 0, 94, 0, 0, 0, 0, 96, 0, 98, 0, 102, 0, 0, 0, 0, 0, 0, 0, 0, 160, 113, 0, 0, 0, 0, 119, 0, 0, 0, 0, 0, 125, 0, 0, 0, 0, 0, 131, 0, 0, 0, 0, 0, 136, 0, 0, 0, 0, 140, 0, 0, 0, 144, 0, 0, 0, 149, 0, 0, 0, 0, 153, 0, 0, 0, 0, 158, 0, 0, 0, 0, 0, 210, 169, 165, 0, 0, 0, 0, 0, 0, 177, 175, 0, 0, 0, 0, 0, 0, 184, 181, 0, 0, 0, 0, 0, 190, 0, 0, 0, 0, 0, 193, 0, 0, 198, 0, 0, 0, 0, 201, 0, 0, 206, 0, 0, 0, 0, 0, 0, 0, 0, 255, 216, 0, 0, 0, 0, 222, 0, 0, 0, 0, 0, 228, 0, 226, 0, 0, 0, 231, 0, 0, 234, 0, 0, 237, 0, 0, 247, 242, 0, 0, 0, 0, 245, 0, 0, 0, 0, 0, 251, 0, 0, 0, 0, 0, 269, 259, 0, 0, 265, 0, 0, 0, 0, 0, 0, 0, 0, 0, 289, 276, 0, 0, 0, 0, 0, 280, 0, 0, 0, 284, 0, 0, 0, 0, 0, 0, 0, 0, 346, 294, 0, 0, 0, 297, 0, 0, 312, 307, 301, 0, 303, 0, 305, 0, 0, 0, 309, 0, 0, 0, 0, 317, 0, 0, 0, 0, 325, 323, 0, 0, 0, 0, 0, 0, 329, 0, 0, 0, 335, 0, 0, 0, 0, 0, 341, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 387, 350, 0, 0, 356, 0, 0, 0, 0, 0, 365, 362, 0, 0, 0, 0, 0, 0, 0, 370, 0, 0, 0, 0, 374, 0, 0, 0, 383, 0, 0, 381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 457, 394, 0, 392, 0, 0, 0, 400, 0, 0, 0, 0, 0, 406, 0, 0, 0, 0, 0, 411, 0, 0, 0, 0, 421, 0, 417, 0, 0, 0, 0, 0, 0, 0, 425, 0, 0, 0, 431, 0, 0, 0, 0, 0, 442, 438, 0, 0, 0, 0, 0, 0, 0, 0, 0, 447, 0, 0, 0, 0, 452, 0, 0, 0, 0, 0, 0, 0, 0, 0, 519, 474, 463, 0, 0, 0, 468, 0, 0, 0, 0, 471, 0, 0, 0, 0, 0, 478, 0, 0, 0, 486, 484, 0, 0, 0, 0, 0, 0, 488, 0, 493, 0, 0, 0, 0, 499, 0, 0, 0, 0, 0, 501, 0, 504, 0, 0, 514, 509, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 577, 526, 523, 0, 0, 0, 0, 541, 531, 0, 0, 0, 534, 0, 0, 538, 0, 0, 0, 0, 0, 0, 544, 0, 0, 548, 0, 0, 0, 553, 0, 0, 0, 0, 559, 0, 0, 0, 0, 0, 562, 0, 0, 572, 567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 603, 582, 0, 0, 0, 596, 587, 0, 0, 0, 592, 0, 0, 0, 0, 0, 0, 0, 0, 598, 0, 0, 0, 0, 0, 0, 634, 611, 607, 0, 0, 0, 0, 0, 621, 617, 0, 0, 0, 0, 0, 0, 0, 0, 630, 625, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 659, 649, 0, 646, 643, 641, 0, 0, 0, 0, 0, 0, 0, 0, 0, 653, 0, 0, 0, 0, 0, 0, 0, 0, 0, 702, 666, 0, 0, 0, 0, 0, 672, 0, 0, 0, 0, 0, 677, 0, 0, 0, 0, 683, 0, 0, 0, 0, 0, 687, 0, 0, 0, 692, 0, 0, 0, 0, 697, 0, 0, 0, 0, 0, 0, 0, 0, 0, 712, 709, 0, 0, 0, 0, 0, 0, 0, 0, 747, 719, 0, 0, 0, 0, 0, 725, 0, 0, 0, 0, 0, 730, 0, 0, 0, 0, 734, 0, 0, 0, 737, 0, 0, 744, 0, 0, 0, 0, 0, 0, 0, 0, 0, 773, 754, 0, 0, 0, 0, 0, 760, 0, 0, 0, 0, 0, 765, 0, 0, 0, 0, 769, 0, 0, 0, 0, 0, 0, 0, 782, 780, 0, 0, 0, 0, 0, 0, 0, 832, 789, 0, 0, 0, 0, 0, 795, 0, 0, 0, 0, 0, 800, 0, 0, 0, 0, 806, 0, 0, 0, 0, 0, 810, 0, 0, 0, 816, 0, 0, 0, 0, 0, 827, 823, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 871, 842, 838, 0, 0, 0, 0, 0, 0, 0, 863, 847, 0, 0, 0, 858, 854, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 866, 0, 0, 0, 0, 0, 0, 0, 900, 878, 0, 0, 0, 0, 0, 884, 0, 0, 0, 0, 0, 889, 0, 0, 0, 0, 893, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 911, 907, 0, 0, 0, 0, 0, 0, 0, 0, 0, 925, 917, 0, 0, 0, 0, 922, 0, 0, 0, 0, 0, 0, 0, 984, 932, 0, 0, 0, 0, 0, 938, 0, 0, 0, 0, 0, 943, 0, 0, 0, 0, 950, 947, 0, 0, 0, 0, 0, 955, 953, 0, 0, 0, 962, 0, 0, 0, 0, 0, 0, 967, 0, 0, 0, 0, 975, 972, 0, 0, 0, 0, 0, 0, 980, 0, 0, 0, 0, 0, 0, 0, 0, 989, 0, 0, 0, 0, 995, 0, 0, 0, 0, 0, 1007, 1001, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1012, 0, 0, 0, 0, 1018, 0, 0, 0, 0, 0, 1025, 0, 0, 0, 0, 0, 0, 1028, 0, 0, 1031, 0, 0, 1045, 1034, 0, 1037, 0, 0, 1040, 0, 0, 0, 0, 0, 0, 0, 1049, 0, 0, 0, 1061, 1055, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1071, 1067, 0, 0, 0, 0, 1069, 0, 0, 0, 1082, 1076, 0, 0, 0, 0, 1080, 0, 0, 0, 0, 1088, 0, 0, 0, 0, 0, 1091, 0, 0, 1111, 1103, 1098, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1107, 0, 0, 0, 0, 0, 0, 0, 1118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static char[] entityValues = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\'', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b4', '\u0000', '\u0000', '\u0000', '\u00e2', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e3', '\u0000', '\u0000', '\u0000', '\u00e4', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e5', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e6', '\u0000', '\u0000', '\u0000', '\u0000', '\u03b1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2135', '\u0000', '\u0000', '\u2220', '\u0000', '\u2227', '\u0000', '\u0000', '\u0000', '\u0000', '\u2248', '\u0000', '\u0000', '&', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a0', '\u0000', '\u0000', '\u00ac', '\u0000', '\u2209', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f1', '\u0000', '\u03bd', '\u0000', '\u0000', '\u0000', '\u0000', '\u2207', '\u0000', '\u220b', '\u0000', '\u2260', '\u0000', '\u0000', '\u0000', '\u2284', '\u0000', '\u0000', '\u0000', '\u0000', '\u2013', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00bf', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ec', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ed', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ee', '\u0000', '\u0000', '\u0000', '\u00ef', '\u0000', '\u0000', '\u0000', '\u03b9', '\u0000', '\u0000', '\u0000', '\u0000', '\u2111', '\u0000', '\u0000', '\u0000', '\u2208', '\u0000', '\u0000', '\u0000', '\u0000', '\u221e', '\u0000', '\u222b', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a2', '\u0000', '\u0000', '\u0000', '\u00b8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a4', '\u0000', '\u222a', '\u0000', '\u0000', '\u0000', '\u00a9', '\u0000', '\u0000', '\u2245', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e7', '\u0000', '\u0000', '\u03c7', '\u0000', '\u0000', '\u0000', '\u0000', '\u21b5', '\u0000', '\u0000', '\u2229', '\u0000', '\u0000', '\u0000', '\u0000', '\u2663', '\u0000', '\u0000', '\u0000', '\u02c6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b1', '\u0000', '\u0000', '\u0000', '\u00b6', '\u0000', '\u2202', '\u0000', '\u03c0', '\u03d6', '\u0000', '\u0000', '\u03c6', '\u0000', '\u0000', '\u03c8', '\u0000', '\u0000', '\u0000', '\u0000', '\u2032', '\u0000', '\u0000', '\u220f', '\u0000', '\u221d', '\u0000', '\u0000', '\u0000', '\u22a5', '\u0000', '\u0000', '\u0000', '\u2030', '\u0000', '\u0000', '\u0000', '\u00a5', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00fd', '\u0000', '\u0000', '\u0000', '\u00ff', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a6', '\u0000', '\u0000', '\u0000', '\u03b2', '\u0000', '\u0000', '\u0000', '\u2022', '\u0000', '\u0000', '\u0000', '\u0000', '\u201e', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a7', '\u0000', '\u0000', '\u00ad', '\u0000', '\u0000', '\u2283', '\u00b2', '\u0000', '\u00b3', '\u0000', '\u00b9', '\u0000', '\u2287', '\u0000', '\u2211', '\u0000', '\u2282', '\u2286', '\u0000', '\u0000', '\u0000', '\u0000', '\u00df', '\u0000', '\u0000', '\u0000', '\u0000', '\u03c3', '\u03c2', '\u0000', '\u223c', '\u0000', '\u0000', '\u0000', '\u22c5', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2660', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0161', '\u0000', '\u0000', '\u0000', '\u0000', '\u201a', '\u0000', '\u0000', '\u0000', '\u00a8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00fa', '\u0000', '\u0000', '\u2191', '\u0000', '\u0000', '\u0000', '\u0000', '\u00fb', '\u0000', '\u0000', '\u0000', '\u00fc', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03c5', '\u0000', '\u03d2', '\u0000', '\u0000', '\u0000', '\u21d1', '\u0000', '\u0000', '\u2228', '\u0000', '\u00aa', '\u0000', '\u00ba', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f2', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f3', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f5', '\u0000', '\u0000', '\u0000', '\u2297', '\u0000', '\u0000', '\u0000', '\u00f6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03bf', '\u0000', '\u0000', '\u0000', '\u03c9', '\u0000', '\u0000', '\u0000', '\u0000', '\u203e', '\u0000', '\u0000', '\u0000', '\u0000', '\u2295', '\u0000', '\u0000', '\u0000', '\u0000', '\u0153', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ab', '\u0000', '\u0000', '\u0000', '\u0000', '\u03bb', '\u0000', '\u0000', '\u2190', '\u0000', '\u0000', '\u2329', '\u0000', '\u0000', '\u0000', '\u21d0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2217', '\u0000', '\u25ca', '\u0000', '\u2264', '\u0000', '\u0000', '\u0000', '\u0000', '\u2308', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u230a', '\u0000', '<', '\u0000', '\u0000', '\u200e', '\u0000', '\u0000', '\u0000', '\u0000', '\u2018', '\u0000', '\u0000', '\u0000', '\u0000', '\u2039', '\u0000', '\u0000', '\u0000', '\u0000', '\u201c', '\u0000', '\u0000', '\u0000', '\u00ae', '\u0000', '\u0000', '\u211c', '\u0000', '\u0000', '\u0000', '\u0000', '\u00bb', '\u0000', '\u0000', '\u2192', '\u0000', '\u0000', '\u0000', '\u221a', '\u0000', '\u0000', '\u232a', '\u0000', '\u0000', '\u03c1', '\u0000', '\u0000', '\u0000', '\u21d2', '\u0000', '\u0000', '\u0000', '\u0000', '\u2309', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u230b', '\u0000', '\u0000', '\u200f', '\u0000', '\u0000', '\u0000', '\u0000', '\u2019', '\u0000', '\u0000', '\u0000', '\u0000', '\u203a', '\u0000', '\u0000', '\u0000', '\u0000', '\u201d', '\u0000', '\u0000', '\u0000', '\u0000', '\u00af', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b5', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b7', '\u0000', '\u0000', '\u0000', '\u2212', '\u0000', '\u03bc', '\u0000', '\u0000', '\u0000', '\u0000', '\u2014', '\u0000', '\u0000', '\u0000', '\u00b0', '\u0000', '\u0000', '\u0000', '\u03b4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00f7', '\u0000', '\u0000', '\u0000', '\u2666', '\u0000', '\u0000', '\u0000', '\u2193', '\u0000', '\u0000', '\u0000', '\u0000', '\u2020', '\u0000', '\u0000', '\u0000', '\u21d3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00bc', '\u0000', '\u00bd', '\u0000', '\u0000', '\u00be', '\u0000', '\u0000', '\u2044', '\u0000', '\u0000', '\u0000', '\u0192', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2200', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c1', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c2', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c3', '\u0000', '\u0000', '\u0000', '\u00c4', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c5', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0391', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c7', '\u0000', '\u0000', '\u03a7', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00c9', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ca', '\u0000', '\u0000', '\u0000', '\u00cb', '\u0000', '\u0000', '\u00d0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0395', '\u0000', '\u0000', '\u0397', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00cc', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00cd', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ce', '\u0000', '\u0000', '\u0000', '\u00cf', '\u0000', '\u0000', '\u0000', '\u0399', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d1', '\u0000', '\u039d', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d2', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d3', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d5', '\u0000', '\u0000', '\u0000', '\u00d6', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u039f', '\u0000', '\u0000', '\u0000', '\u03a9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0152', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d7', '\u0000', '\u0000', '\u0000', '\u02dc', '\u0000', '\u0000', '\u0000', '\u0000', '\u00fe', '\u0000', '\u0000', '\u0000', '\u03b8', '\u0000', '\u0000', '\u03d1', '\u0000', '\u0000', '\u0000', '\u2234', '\u0000', '\u0000', '\u0000', '\u0000', '\u2009', '\u0000', '\u0000', '\u03c4', '\u0000', '\u0000', '\u0000', '\u0000', '\u2122', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00da', '\u0000', '\u0000', '\u0000', '\u0000', '\u00db', '\u0000', '\u0000', '\u0000', '\u00dc', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03a5', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00dd', '\u0000', '\u0000', '\u0000', '\u0178', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00de', '\u0000', '\u0000', '\u0000', '\u0000', '\u0398', '\u0000', '\u0000', '\u03a4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00e9', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ea', '\u0000', '\u0000', '\u0000', '\u00eb', '\u0000', '\u0000', '\u20ac', '\u0000', '\u0000', '\u00f0', '\u0000', '\u03b7', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03b5', '\u0000', '\u0000', '\u0000', '\u0000', '\u2203', '\u0000', '\u0000', '\u0000', '\u0000', '\u2205', '\u0000', '\u0000', '\u2003', '\u0000', '\u0000', '\u0000', '\u0000', '\u2261', '\u0000', '\u0000', '\u0000', '\u2002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0392', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0393', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0394', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2021', '\u0000', '\u0000', '\u0000', '\u0000', '\u0396', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u039a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u039b', '\u0000', '\u0000', '\u039c', '\u0000', '\u0000', '\u039e', '\u0000', '\u0000', '\u03a0', '\u0000', '\u0000', '\u03a6', '\u0000', '\u0000', '\u03a8', '\u0000', '\u0000', '\u0000', '\u0000', '\u2033', '\u0000', '\u0000', '\u0000', '\u03a1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03a3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0160', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03b3', '\u0000', '\u2265', '\u0000', '>', '\u0000', '\u0000', '\u0000', '\u0000', '\u03b6', '\u0000', '\u0000', '\u0000', '\u200c', '\u0000', '\u200d', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u03ba', '\u0000', '\u0000', '\u03be', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2026', '\u0000', '\u0000', '\u0000', '\u0000', '\u2665', '\u0000', '\u0000', '\u0000', '\u2194', '\u0000', '\u0000', '\u0000', '\u21d4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2118', '\u0000', '\u0000', '\u0000', '\u0000', '\"'};
    private static int[] lookupFirstChar = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 659, 984, 702, 995, 712, 0, 989, 0, 747, 0, 1012, 1018, 1025, 773, 782, 1031, 0, 1045, 1049, 911, 871, 0, 0, 1028, 900, 1007, 0, 0, 0, 0, 0, 0, 1, 269, 160, 603, 925, 634, 1061, 1091, 107, 0, 1082, 457, 577, 71, 387, 210, 1118, 519, 289, 832, 346, 0, 1111, 1088, 255, 1071, 0, 0, 0, 0};

    protected XMLReaderBase(JCO.Record record) {
        this(null, record);
    }

    protected XMLReaderBase(XMLReaderBase parent, JCO.Record record) {
        this.m_parent = parent;
        this.m_record = record;
        if (this.m_parent == null) {
            this.m_buffer = new char[0];
            this.m_offset = 0;
            this.m_length = 0;
        } else {
            this.m_buffer = this.m_parent.m_buffer;
            this.m_offset = this.m_parent.m_offset;
            this.m_length = this.m_buffer.length;
        }
        this.m_record.clear();
    }

    public void parse(String data) {
        if (JCO.getTraceLevel() > 9) {
            StringBuffer buffer = new StringBuffer(data);
            int i = 0;
            while (i < buffer.length()) {
                buffer.insert(i, "\n");
                i += 80;
            }
            JCO.fireTrace(10, "[JAV-LAYER] XMLReaderBase.parse():\n" + buffer.toString());
        }
        char[] buf = new char[data.length()];
        data.getChars(0, buf.length, buf, 0);
        this.parse(buf, 0, buf.length);
    }

    public void parse(char[] buffer, int offset, int length) {
        block5: {
            try {
                this.m_buffer = buffer;
                this.m_offset = offset;
                this.m_length = length;
                this.nextProlog();
                if (this.nextTag(true, true) != 1) {
                    this.nextStatement(this.m_record, false);
                    this.nextTag(false);
                }
            }
            catch (Throwable ex) {
                if (JCO.getTraceLevel() > 0) {
                    StringWriter w = new StringWriter();
                    ex.printStackTrace(new PrintWriter((Writer)w, true));
                    JCO.fireTrace(1, "[JAV-LAYER] XMLReaderBase.parse() throws exception \n" + w.toString());
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (!(ex instanceof Error)) break block5;
                throw (Error)ex;
            }
        }
    }

    public void parse(Reader is) {
        int offset = 0;
        int length = 0;
        int chunk_size = 0;
        char[] ibuffer = null;
        try {
            ibuffer = new char[10240];
            while ((chunk_size = is.read(ibuffer, offset, 10240)) > 0) {
                length += chunk_size;
                if (chunk_size >= 10240) {
                    char[] old = ibuffer;
                    offset = length;
                    ibuffer = new char[length + 10240];
                    System.arraycopy(old, 0, ibuffer, 0, old.length);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new JCO.Exception(130, "JCO_ERROR_XML_PARSER", ex.getMessage());
        }
        this.parse(ibuffer, 0, length);
    }

    private final void skipWhitespaces() {
        char c = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : (char)'\u0000';
        while (Character.isWhitespace(c) && this.m_offset < this.m_length) {
            ++this.m_offset;
            char c2 = c = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : (char)'\u0000';
        }
    }

    private void nextProlog() {
        char c2;
        this.skipWhitespaces();
        char c1 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : (char)'\u0000';
        char c = c2 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset + 1] : (char)'\u0000';
        if (c1 == '<' && c2 == '?') {
            c1 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset++] : (char)'\u0000';
            while (this.m_offset < this.m_length && c1 != '>') {
                char c3 = c1 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset++] : (char)'\u0000';
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void nextStatement(JCO.Record record, boolean inRow) {
        char c2;
        this.skipWhitespaces();
        char c1 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : (char)'\u0000';
        char c = c2 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset + 1] : (char)'\u0000';
        if (inRow && c1 == '<' && c2 != '/') {
            int saveOffset = this.m_offset;
            this.nextTag(false);
            String item_tag = this.m_namespace_mode == 1 ? (record.getLineTypeName() != null ? this.escape(record.getLineTypeName()) : ITEM_UPPER) : ITEM_LOWER;
            this.m_offset = saveOffset;
            if (this.equals(this.m_buffer, this.m_tag_start, this.m_tag_end - this.m_tag_start + 1, item_tag)) {
                if (!(record instanceof JCO.Table)) {
                    throw new JCO.Exception(130, "JCO_ERROR_XML_PARSER", "XML represents a nested table in record " + record.getName() + ". Not fitting to real structure.");
                }
                record = record.getTable(0);
            }
        }
        while (c1 == '<' && c2 != '/') {
            this.nextElement(record);
            this.skipWhitespaces();
            c1 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : (char)'\u0000';
            char c3 = c2 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset + 1] : (char)'\u0000';
        }
    }

    private int nextTag(boolean unescape) {
        return this.nextTag(unescape, false);
    }

    /*
     * Unable to fully structure code
     */
    private int nextTag(boolean unescape, boolean check_namespace) {
        block23: {
            tag_type = 0;
            needs_unescaping = false;
            has_namespace = false;
            this.skipWhitespaces();
            v0 = c = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : '\u0000';
            if (c == '<') {
                ++this.m_offset;
            } else {
                throw new JCO.Exception(130, "JCO_ERROR_XML_PARSER", "Expecting a tag to begin with '<' instead of '" + c + "', in \"" + new String(this.m_buffer, Math.max(0, this.m_offset - 10), Math.min(10, this.m_offset) + Math.min(this.m_length - this.m_offset, 10)) + "\"");
            }
            v1 = c = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : '\u0000';
            if (c == '/') {
                tag_type = 1;
                ++this.m_offset;
            }
            this.m_tag_start = this.m_tag_end = this.m_offset;
            c = this.m_offset < this.m_length ? this.m_buffer[this.m_offset++] : '\u0000';
            while (this.m_offset < this.m_length && c != ' ' && c != '>') {
                if (c == '_' && (this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : 0) == 45) {
                    ++this.m_tag_end;
                    needs_unescaping = true;
                } else if (c == ':' && !has_namespace) {
                    this.m_tag_start = this.m_tag_end = this.m_offset;
                    has_namespace = true;
                } else {
                    ++this.m_tag_end;
                }
                v2 = c = this.m_offset < this.m_length ? this.m_buffer[this.m_offset++] : '\u0000';
            }
            --this.m_tag_end;
            if (!check_namespace) ** GOTO lbl39
            start = this.m_offset;
            while (this.m_offset < this.m_length && c != '>') {
                c = this.m_buffer[this.m_offset++];
            }
            if (this.m_offset - start <= 1) break block23;
            namespace = new String(this.m_buffer, start, this.m_offset - start - 1);
            this.m_namespace_mode = namespace.indexOf("urn:sap-com:document:sap:soap:functions:uc-style") >= 0 ? 1 : 0;
            break block23;
lbl-1000:
            // 1 sources

            {
                c = this.m_buffer[this.m_offset++];
lbl39:
                // 2 sources

                ** while (this.m_offset < this.m_length && c != '>')
            }
        }
        if (c != '>') {
            throw new JCO.Exception(130, "JCO_ERROR_XML_PARSER", "Expecting a tag to end with '>' instead of '" + c + "', in \"" + new String(this.m_buffer, Math.max(0, this.m_offset - 10), Math.min(10, this.m_offset) + Math.min(this.m_length - this.m_offset, 10)) + "\"");
        }
        if (this.m_offset >= 2 && this.m_buffer[this.m_offset - 2] == '/') {
            tag_type = 1;
        }
        if (unescape && needs_unescaping) {
            i = this.m_tag_start;
            j = this.m_tag_start;
            while (i <= this.m_tag_end) {
                if (this.m_buffer[i] == '_') {
                    if (this.m_buffer[++i] == '-') {
                        if (this.m_buffer[++i] == '-') {
                            ++i;
                            try {
                                this.m_buffer[j++] = (char)Integer.parseInt(new String(this.m_buffer, i, 2), 16);
                            }
                            catch (NumberFormatException ex) {
                                throw new JCO.Exception(130, "JCO_ERROR_XML_PARSER", "Illegal escape sequence _--" + new String(this.m_buffer, i, 2) + " encountered");
                            }
                            i += 2;
                            continue;
                        }
                        this.m_buffer[j++] = 47;
                        continue;
                    }
                    this.m_buffer[j++] = 95;
                    continue;
                }
                this.m_buffer[j++] = this.m_buffer[i++];
            }
            this.m_tag_end = j - 1;
        }
        this.m_tag_typ = tag_type;
        return tag_type;
    }

    public void nextElement(JCO.Record record) {
        if (this.nextTag(true) == 1) {
            return;
        }
        if (this.m_offset >= this.m_length) {
            throw new JCO.Exception(130, "JCO_ERROR_XML_PARSER", "Unexpecting end of buffer after <" + new String(this.m_buffer, this.m_tag_start, this.m_tag_end - this.m_tag_start + 1) + ">");
        }
        String item_tag = this.m_namespace_mode == 1 ? (record.getLineTypeName() != null ? record.getLineTypeName() : ITEM_UPPER) : ITEM_LOWER;
        int index = -1;
        int type = -1;
        if (this.equals(this.m_buffer, this.m_tag_start, this.m_tag_end - this.m_tag_start + 1, item_tag)) {
            type = 133;
        } else {
            try {
                index = record.indexOf(new String(this.m_buffer, this.m_tag_start, this.m_tag_end - this.m_tag_start + 1));
                type = record.getType(index);
            }
            catch (Exception ex) {
                index = -1;
            }
        }
        if (type == 133 && record instanceof JCO.Table) {
            JCO.Table t = (JCO.Table)record;
            t.appendRow();
            if (t.getNumFields() == 1 && t.getName(0).length() == 0 && !t.isTable(0) && !t.isStructure(0) && this.m_buffer[this.m_offset] != '<') {
                this.nextValue(record, 0, true);
            } else {
                this.nextStatement(record, true);
            }
        } else if (index >= 0) {
            if (type == 17 || type == 99) {
                record = (JCO.Record)record.getValue(index);
                this.nextStatement(record, false);
            } else {
                this.nextValue(record, index, true);
            }
        } else {
            this.nextValue(record, index, false);
        }
        this.nextTag(false);
    }

    private void unescapeValue() {
        char c;
        int i = this.m_offset;
        int start = this.m_offset;
        int value = 0;
        if ((c = this.m_buffer[i++]) != '&' || i >= this.m_length) {
            return;
        }
        if ((c = this.m_buffer[i++]) != '#' || i >= this.m_length) {
            return;
        }
        c = this.m_buffer[i++];
        while (i < this.m_length && c >= '0' && c <= '9') {
            value = value * 10 + (c - 48);
            c = this.m_buffer[i++];
        }
        if (c != ';') {
            return;
        }
        this.m_offset = i;
        this.m_buffer[start++] = (char)value;
        System.arraycopy(this.m_buffer, this.m_offset, this.m_buffer, start, this.m_length - this.m_offset);
        this.m_length -= this.m_offset - start;
        this.m_offset = start - 1;
    }

    private void nextValue(JCO.Record record, int index, boolean store) {
        char c2;
        char c1 = this.m_offset < this.m_length ? this.m_buffer[this.m_offset] : (char)'\u0000';
        char c = c2 = this.m_offset + 1 < this.m_length ? this.m_buffer[this.m_offset + 1] : (char)'\u0000';
        if (c1 == '<' && c2 == '/') {
            return;
        }
        int value_start = this.m_offset;
        int value_end = this.m_offset;
        while (this.m_offset < this.m_length && (c1 = this.m_buffer[this.m_offset++]) != '<') {
            if (c1 == '&' && this.m_offset < this.m_length) {
                if (this.m_buffer[this.m_offset] == '#') {
                    int start = this.m_offset++;
                    int value = 0;
                    while (this.m_offset < this.m_length && (c2 = this.m_buffer[this.m_offset++]) >= '0' && c2 <= '9') {
                        value = value * 10 + (c2 - 48);
                    }
                    if (c2 != ';') {
                        this.m_offset = start;
                    } else {
                        c1 = (char)value;
                    }
                } else if (this.m_buffer[this.m_offset] < '\u007f') {
                    char value;
                    int idx = this.m_offset;
                    int i = lookupFirstChar[this.m_buffer[idx]];
                    while (idx < this.m_length && this.m_buffer[idx] != ';' && this.m_buffer[idx] != '<' && i != 0) {
                        if (entitySearchChars[i] != this.m_buffer[idx]) {
                            i = entitySearchIdxs[i];
                            continue;
                        }
                        ++idx;
                        ++i;
                    }
                    if (idx <= this.m_length && this.m_buffer[idx] == ';' && (value = entityValues[i]) != '\u0000') {
                        c1 = value;
                        this.m_offset = ++idx;
                    }
                }
            }
            this.m_buffer[value_end++] = c1;
        }
        --this.m_offset;
        if (store) {
            this.store(record, this.m_buffer, value_start, value_end - value_start, index);
        }
    }

    protected abstract void store(JCO.Record var1, char[] var2, int var3, int var4, int var5);

    private boolean equals(char[] array1, int start, int length, String string) {
        int slength = string.length();
        if (slength != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (array1[start + i] != string.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String escape(String tag) {
        int ioffset = 0;
        int length = tag.length();
        if (length * 5 > this.tagBuffer.length) {
            this.tagBuffer = new char[length * 5];
        }
        int i = 0;
        while (i < length) {
            char c = tag.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || i > 0 && (c >= '0' && c <= '9' || c == '.')) {
                this.tagBuffer[ioffset++] = c;
            } else if (c == '/') {
                this.tagBuffer[ioffset++] = 95;
                this.tagBuffer[ioffset++] = 45;
            } else {
                this.tagBuffer[ioffset++] = 95;
                this.tagBuffer[ioffset++] = 45;
                this.tagBuffer[ioffset++] = 45;
                this.tagBuffer[ioffset++] = hex[c >> 4 & 0xF];
                this.tagBuffer[ioffset++] = hex[c >> 0 & 0xF];
            }
            ++i;
        }
        return new String(this.tagBuffer, 0, ioffset);
    }
}

