/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class BinaryFloatBinder
extends Binder {
    Binder theBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(Binder x) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            x.type = (short)100;
            x.bytelen = 4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BinaryFloatBinder() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            BinaryFloatBinder.init(this);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Binder copyingBinder() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.theBinaryFloatCopyingBinder);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Binder binder = this.theBinaryFloatCopyingBinder;
            return binder;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        long __ol_nanos__ = 0L;
        try {
            int intBits;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] b2 = bindBytes;
            int offset = byteoffset;
            float val = stmt.parameterFloat[rank][bindPosition];
            if ((double)val == 0.0) {
                val = 0.0f;
            } else if (val != val) {
                val = Float.NaN;
            }
            int b3 = intBits = Float.floatToIntBits(val);
            int b22 = intBits >>= 8;
            int b1 = intBits >>= 8;
            int b0 = intBits >>= 8;
            if ((b0 & 0x80) == 0) {
                b0 |= 0x80;
            } else {
                b0 ^= 0xFFFFFFFF;
                b1 ^= 0xFFFFFFFF;
                b22 ^= 0xFFFFFFFF;
                b3 ^= 0xFFFFFFFF;
            }
            b2[offset + 3] = (byte)b3;
            b2[offset + 2] = (byte)b22;
            b2[offset + 1] = (byte)b1;
            b2[offset] = (byte)b0;
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = 4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryFloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.BinaryFloatBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

