/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class BufferCache<T> {
    private static final double ln2 = Math.log(2.0);
    private static final int BUFFERS_PER_BUCKET = 8;
    private static final int MIN_INDEX = 12;
    private final InternalStatistics stats;
    private final int[] bufferSize;
    private final SoftReference<T>[][] buckets;
    private final int[] top;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferCache(int maxCachedBufferSize) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(maxCachedBufferSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int maxIndex = maxCachedBufferSize < 31 ? maxCachedBufferSize : (int)Math.ceil(Math.log(maxCachedBufferSize) / ln2);
            int numBuckets = Math.max(0, maxIndex - 12 + 1);
            this.buckets = new SoftReference[numBuckets][8];
            this.top = new int[numBuckets];
            this.bufferSize = new int[numBuckets];
            int s2 = 4096;
            for (int i2 = 0; i2 < this.bufferSize.length; ++i2) {
                this.bufferSize[i2] = s2;
                s2 <<= 1;
            }
            this.stats = new InternalStatistics(this.bufferSize);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T get(Class<?> baseType, int length) {
        long __ol_nanos__ = 0L;
        try {
            int b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b2 = this.bufferIndex(length)) >= this.buckets.length) {
                this.stats.requestTooBig();
                Object __result__ = Array.newInstance(baseType, length);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object object = __result__;
                return (T)object;
            }
            while (this.top[b2] > 0) {
                int n2 = b2;
                int n3 = this.top[n2] - 1;
                this.top[n2] = n3;
                SoftReference<T> ref = this.buckets[b2][n3];
                this.buckets[b2][this.top[b2]] = null;
                T buf = ref.get();
                if (buf == null) continue;
                this.stats.cacheHit(b2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + buf);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                T t = buf;
                return t;
            }
            this.stats.cacheMiss(b2);
            Object __result__ = Array.newInstance(baseType, this.bufferSize[b2]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = __result__;
            return (T)object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(T buffer) {
        block32: {
            long __ol_nanos__ = 0L;
            try {
                int len;
                int b2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((b2 = this.bufferIndex(len = Array.getLength(buffer))) >= this.buckets.length || len != this.bufferSize[b2]) {
                    this.stats.cacheTooBig();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                if (this.top[b2] < 8) {
                    this.stats.bufferCached(b2);
                    int n2 = b2;
                    int n3 = this.top[n2];
                    this.top[n2] = n3 + 1;
                    this.buckets[b2][n3] = new SoftReference<T>(buffer);
                    break block32;
                }
                int i2 = this.top[b2];
                while (i2 > 0) {
                    if (this.buckets[b2][--i2].get() != null) continue;
                    this.stats.refCleared(b2);
                    this.buckets[b2][i2] = new SoftReference<T>(buffer);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                this.stats.bucketFull(b2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        BufferCache.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    OracleConnection.BufferCacheStatistics getStatistics() {
        return this.stats;
    }

    private int bufferIndex(int n2) {
        for (int i2 = 0; i2 < this.bufferSize.length; ++i2) {
            if (n2 > this.bufferSize[i2]) continue;
            return i2;
        }
        return Integer.MAX_VALUE;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.BufferCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class InternalStatistics
    implements OracleConnection.BufferCacheStatistics {
        private static int CACHE_COUNT = 0;
        private final int cacheId = ++CACHE_COUNT;
        private final int[] sizes;
        private final int[] nCacheHit;
        private final int[] nCacheMiss;
        private int nRequestTooBig;
        private final int[] nBufferCached;
        private final int[] nBucketFull;
        private final int[] nRefCleared;
        private int nCacheTooBig;

        InternalStatistics(int[] sizes) {
            this.sizes = sizes;
            int n2 = sizes.length;
            this.nCacheHit = new int[n2];
            this.nCacheMiss = new int[n2];
            this.nRequestTooBig = 0;
            this.nBufferCached = new int[n2];
            this.nBucketFull = new int[n2];
            this.nRefCleared = new int[n2];
            this.nCacheTooBig = 0;
        }

        void cacheHit(int b2) {
            int n2 = b2;
            this.nCacheHit[n2] = this.nCacheHit[n2] + 1;
        }

        void cacheMiss(int b2) {
            int n2 = b2;
            this.nCacheMiss[n2] = this.nCacheMiss[n2] + 1;
        }

        void requestTooBig() {
            ++this.nRequestTooBig;
        }

        void bufferCached(int b2) {
            int n2 = b2;
            this.nBufferCached[n2] = this.nBufferCached[n2] + 1;
        }

        void bucketFull(int b2) {
            int n2 = b2;
            this.nBucketFull[n2] = this.nBucketFull[n2] + 1;
        }

        void refCleared(int b2) {
            int n2 = b2;
            this.nRefCleared[n2] = this.nRefCleared[n2] + 1;
        }

        void cacheTooBig() {
            ++this.nCacheTooBig;
        }

        @Override
        public int getId() {
            return this.cacheId;
        }

        @Override
        public int[] getBufferSizes() {
            int[] a2 = new int[this.sizes.length];
            System.arraycopy(this.sizes, 0, a2, 0, this.sizes.length);
            return a2;
        }

        @Override
        public int getCacheHits(int n2) {
            return this.nCacheHit[n2];
        }

        @Override
        public int getCacheMisses(int n2) {
            return this.nCacheMiss[n2];
        }

        public int getRequestsTooBig() {
            return this.nRequestTooBig;
        }

        @Override
        public int getBuffersCached(int n2) {
            return this.nBufferCached[n2];
        }

        @Override
        public int getBucketsFull(int n2) {
            return this.nBucketFull[n2];
        }

        @Override
        public int getReferencesCleared(int n2) {
            return this.nRefCleared[n2];
        }

        @Override
        public int getTooBigToCache() {
            return this.nCacheTooBig;
        }

        public String toString() {
            int totalHits = 0;
            int totalMisses = 0;
            int totalCached = 0;
            int totalDropped = 0;
            int totalCleared = 0;
            for (int i2 = 0; i2 < this.sizes.length; ++i2) {
                totalHits += this.nCacheHit[i2];
                totalMisses += this.nCacheMiss[i2];
                totalCached += this.nBufferCached[i2];
                totalDropped += this.nBucketFull[i2];
                totalCleared += this.nRefCleared[i2];
            }
            String s2 = "oracle.jdbc.driver.BufferCache<" + this.cacheId + ">\n" + "\tTotal Hits   :\t" + totalHits + "\n" + "\tTotal Misses :\t" + (totalMisses + this.nRequestTooBig) + "\n" + "\tTotal Cached :\t" + totalCached + "\n" + "\tTotal Dropped:\t" + (totalDropped + this.nCacheTooBig) + "\n" + "\tTotal Cleared:\t" + totalCleared + "\n";
            return s2;
        }
    }
}

