/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

class ClassRef {
    private final ThreadLocal<Class> ref = new ThreadLocal();
    private final String className;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ClassRef newInstance(String name) throws ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ClassRef __result__ = new ClassRef(name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ClassRef classRef = __result__;
            return classRef;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassRef(String name) throws ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.className = name;
            this.ref.set(Class.forName(this.className, true, Thread.currentThread().getContextClassLoader()));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class get() {
        long __ol_nanos__ = 0L;
        try {
            Class<?> result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((result = this.ref.get()) == null) {
                try {
                    result = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    NoClassDefFoundError e2 = new NoClassDefFoundError(ex.getMessage());
                    e2.initCause(ex);
                    throw e2;
                }
                this.ref.set(result);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Class<?> clazz = result;
            return clazz;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ClassRef"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

