/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFDCNRowChanges;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;

class NTFDCNTableChanges
implements TableChangeDescription {
    final EnumSet<TableChangeDescription.TableOperation> opcode;
    String tableName;
    final int objectNumber;
    final int numberOfRows;
    final RowChangeDescription.RowOperation[] rowOpcode;
    final int[] rowIdLength;
    final byte[][] rowid;
    final CharacterSet charset;
    NTFDCNRowChanges[] rowsDescription = null;
    private static final byte OPERATION_ANY = 0;
    private static final byte OPERATION_UNKNOWN = 64;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNTableChanges(ByteBuffer buffer, int _csid) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.charset = CharacterSet.make(_csid);
            this.opcode = TableChangeDescription.TableOperation.getTableOperations(buffer.getInt());
            short tableNameLength = buffer.getShort();
            byte[] tableNameBuffer = new byte[tableNameLength];
            buffer.get(tableNameBuffer, 0, tableNameLength);
            this.tableName = this.charset.toStringWithReplacement(tableNameBuffer, 0, tableNameLength);
            this.objectNumber = buffer.getInt();
            if (!this.opcode.contains((Object)TableChangeDescription.TableOperation.ALL_ROWS)) {
                this.numberOfRows = buffer.getShort();
                this.rowOpcode = new RowChangeDescription.RowOperation[this.numberOfRows];
                this.rowIdLength = new int[this.numberOfRows];
                this.rowid = new byte[this.numberOfRows][];
                for (int i2 = 0; i2 < this.numberOfRows; ++i2) {
                    this.rowOpcode[i2] = RowChangeDescription.RowOperation.getRowOperation(buffer.getInt());
                    this.rowIdLength[i2] = buffer.getShort();
                    this.rowid[i2] = new byte[this.rowIdLength[i2]];
                    buffer.get(this.rowid[i2], 0, this.rowIdLength[i2]);
                }
            } else {
                this.numberOfRows = 0;
                this.rowid = null;
                this.rowOpcode = null;
                this.rowIdLength = null;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tableName);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.tableName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getObjectNumber() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.objectNumber);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.objectNumber;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public RowChangeDescription[] getRowChangeDescription() {
        long __ol_nanos__ = 0L;
        try {
            RowChangeDescription[] rowChangeDescriptionArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowsDescription == null) {
                rowChangeDescriptionArray = this;
                // MONITORENTER : this
                if (this.rowsDescription == null) {
                    this.rowsDescription = new NTFDCNRowChanges[this.numberOfRows];
                    for (int i2 = 0; i2 < this.rowsDescription.length; ++i2) {
                        this.rowsDescription[i2] = new NTFDCNRowChanges(this.rowOpcode[i2], this.rowIdLength[i2], this.rowid[i2]);
                    }
                }
                // MONITOREXIT : rowChangeDescriptionArray
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsDescription);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rowChangeDescriptionArray = this.rowsDescription;
            return rowChangeDescriptionArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<TableChangeDescription.TableOperation> getTableOperations() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.opcode);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            EnumSet<TableChangeDescription.TableOperation> enumSet = this.opcode;
            return enumSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("    operation=" + this.getTableOperations() + ", tableName=" + this.tableName + ", objectNumber=" + this.objectNumber + "\n");
            RowChangeDescription[] rdesc = this.getRowChangeDescription();
            if (rdesc != null && rdesc.length > 0) {
                sb.append("    Row Change Description (length=" + rdesc.length + "):\n");
                for (int i2 = 0; i2 < rdesc.length; ++i2) {
                    sb.append(rdesc[i2].toString());
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNTableChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNTableChanges"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

