/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSQLXML;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

class NamedTypeAccessor
extends TypeAccessor {
    private static final Class xmlType;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 109, 109, form, forBind);
            this.initForDataAccess(external_type, 0, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 109, 109, form, false);
            this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.initForDataAccess(0, max_len, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(otype));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 109, 109, form, false);
            this.describeOtype = otype;
            this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.internalOtype = otype;
            this.initForDataAccess(0, max_len, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleType otypeFromName(String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.outBind) {
                OracleNamedType __result__ = TypeDescriptor.getTypeDescriptor(typeName, this.statement.connection).getPickler();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleNamedType oracleNamedType = __result__;
                return oracleNamedType;
            }
            if (this.externalType == 2003) {
                OracleTypeCOLLECTION __result__ = ArrayDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeCOLLECTION();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleTypeCOLLECTION oracleTypeCOLLECTION = __result__;
                return oracleTypeCOLLECTION;
            }
            if (this.externalType == 2007 || this.externalType == 2009) {
                OracleNamedType __result__ = OpaqueDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getPickler();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleNamedType oracleNamedType = __result__;
                return oracleNamedType;
            }
            OracleTypeADT __result__ = StructDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeADT();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeADT oracleTypeADT = __result__;
            return oracleTypeADT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            super.initForDataAccess(external_type, max_len, typeName);
            this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object __result__ = this.getObject(currentRow, this.statement.connection.getTypeMap());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        __ol_nanos__ = 0L;
        try {
            block124: {
                if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.rowSpaceIndicator == null) {
                    if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) break block124;
                if (this.externalType == 0) {
                    named_obj = this.getOracleObject(currentRow);
                    if (named_obj == null) {
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var6_11 = null;
                        return var6_11;
                    }
                    if (named_obj instanceof STRUCT) {
                        __result__ = ((STRUCT)named_obj).toJdbc(map);
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var7_23 = __result__;
                        return var7_23;
                    }
                    if (named_obj instanceof OPAQUE) {
                        obj = ((OPAQUE)named_obj).toJdbc(map);
                        if (NamedTypeAccessor.xmlType != null && NamedTypeAccessor.xmlType.isInstance(obj)) {
                            if (this.statement.connection.getObjectReturnsXmlType) {
                                if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + obj);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                var7_24 = obj;
                                return var7_24;
                            }
                            __result__ = new OracleSQLXML((Connection)this.statement.connection, (XMLType)obj);
                            if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var8_31 = __result__;
                            return var8_31;
                        }
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + obj);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var7_26 = obj;
                        return var7_26;
                    }
                    obj = named_obj.toJdbc();
                    return obj;
                }
                switch (this.externalType) {
                    case 2008: {
                        map = null;
                    }
                    case 2000: 
                    case 2002: 
                    case 2003: 
                    case 2007: {
                        named_obj = this.getOracleObject(currentRow);
                        if (named_obj != null) ** GOTO lbl103
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        obj = null;
                        return obj;
lbl103:
                        // 1 sources

                        if (!(named_obj instanceof STRUCT)) ** GOTO lbl114
                        __result__ = ((STRUCT)named_obj).toJdbc(map);
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var7_27 = __result__;
                        return var7_27;
lbl114:
                        // 1 sources

                        __result__ = named_obj.toJdbc();
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var7_28 = __result__;
                        return var7_28;
                    }
                    case 2009: {
                        named_obj = this.getOracleObject(currentRow);
                        if (named_obj != null) ** GOTO lbl136
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        __result__ = null;
                        return __result__;
lbl136:
                        // 1 sources

                        if (!(named_obj instanceof OPAQUE)) ** GOTO lbl147
                        __result__ = new OracleSQLXML((Connection)this.statement.connection, (OPAQUE)named_obj);
                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var7_29 = __result__;
                        return var7_29;
lbl147:
                        // 1 sources

                        if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var5_9 = null;
            return var5_9;
        }
        finally {
            if (NamedTypeAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            DatumWithConnection result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] data = this.pickledBytes(currentRow);
            if (data == null || data.length == 0) {
                Datum datum = null;
                return datum;
            }
            PhysicalConnection conn = this.statement.connection;
            OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
            TypeDescriptor desc = TypeDescriptor.getTypeDescriptor(otype.getFullName(), conn, data, 0L);
            switch (desc.getTypeCode()) {
                case 2003: {
                    result = new ARRAY((ArrayDescriptor)desc, data, conn);
                    break;
                }
                case 2002: {
                    result = new STRUCT((StructDescriptor)desc, data, conn);
                    break;
                }
                case 2007: 
                case 2009: {
                    result = new OPAQUE((OpaqueDescriptor)desc, data, conn);
                    break;
                }
                case 2008: {
                    result = new JAVA_STRUCT((StructDescriptor)desc, data, conn);
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DatumWithConnection datumWithConnection = result;
            return datumWithConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ARRAY getARRAY(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ARRAY __result__ = (ARRAY)this.getOracleObject(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY = __result__;
            return aRRAY;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    STRUCT getSTRUCT(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            STRUCT __result__ = (STRUCT)this.getOracleObject(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT sTRUCT = __result__;
            return sTRUCT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OPAQUE getOPAQUE(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OPAQUE __result__ = (OPAQUE)this.getOracleObject(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OPAQUE oPAQUE = __result__;
            return oPAQUE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isNull(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] data = this.pickledBytes(currentRow);
            boolean bl = __result__ = data == null || data.length == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    SQLXML getSQLXML(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            OPAQUE xmlType;
            block32: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    xmlType = (OPAQUE)this.getOracleObject(currentRow);
                    if (xmlType != null) break block32;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLXML sQLXML = null;
                    return sQLXML;
                }
                catch (ClassCastException ex) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            OracleSQLXML __result__ = new OracleSQLXML((Connection)this.statement.connection, xmlType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleSQLXML oracleSQLXML = __result__;
            return oracleSQLXML;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        Class<?> c2 = null;
        try {
            c2 = Class.forName("oracle.xdb.XMLType");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        xmlType = c2;
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NamedTypeAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

