/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDiagnosabilityMBean;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;

public class OracleDriver
implements Driver {
    public static final String oracle_string = "oracle";
    public static final String jdbc_string = "jdbc";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    public static final String prelim_auth_string = "prelim_auth";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static OracleDriver defaultDriver;
    public static final Map<String, ClassRef> systemTypeMap;
    private static final String DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME = "/oracle/jdbc/defaultConnectionProperties.properties";
    protected static final Properties DEFAULT_CONNECTION_PROPERTIES;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE;
    private static Logger LOGGER;

    public static void registerMBeans() {
        block13: {
            try {
                MBeanServer mbs = null;
                try {
                    ClassRef cls = ClassRef.newInstance("oracle.as.jmx.framework.PortableMBeanFactory");
                    Constructor con = cls.get().getConstructor(new Class[0]);
                    Object factory = con.newInstance(new Object[0]);
                    Method mthd = cls.get().getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (ClassNotFoundException ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    ClassLoader loader = OracleDriver.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    while (true) {
                        String name = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        ObjectName oname = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + name);
                        try {
                            mbs.registerMBean(new OracleDiagnosabilityMBean(), oname);
                            break block13;
                        }
                        catch (InstanceAlreadyExistsException ex) {
                            continue;
                        }
                        break;
                    }
                }
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
            }
            catch (JMException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
            }
            catch (Throwable ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        PhysicalConnection physicalConnection;
        int extensionType;
        long __ol_nanos__;
        block49: {
            __ol_nanos__ = 0L;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(url) + ", " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (url.regionMatches(0, "jdbc:default:connection", 0, 23)) {
                String url1 = "jdbc:oracle:kprb";
                int l2 = url.length();
                url = l2 > 23 ? url1.concat(url.substring(23, url.length())) : url1.concat(":");
                url1 = null;
            }
            if ((extensionType = OracleDriver.oracleDriverExtensionTypeFromURL(url)) != -2) break block49;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection l2 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return l2;
        }
        try {
            Driver driverobj;
            if (extensionType == -3) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleDriverExtension driverExtension = null;
            driverExtension = this.driverExtensions[extensionType];
            if (driverExtension == null) {
                try {
                    OracleDriver oracleDriver = this;
                    synchronized (oracleDriver) {
                        if (driverExtension == null) {
                            this.driverExtensions[extensionType] = driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[extensionType]).newInstance();
                        } else {
                            driverExtension = this.driverExtensions[extensionType];
                        }
                    }
                }
                catch (Exception e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleDriver.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (info == null) {
                info = new Properties();
            }
            Enumeration<Driver> enumdrivers = DriverManager.getDrivers();
            while (enumdrivers.hasMoreElements() && !((driverobj = enumdrivers.nextElement()) instanceof OracleDriver)) {
            }
            while (enumdrivers.hasMoreElements()) {
                driverobj = enumdrivers.nextElement();
                if (!(driverobj instanceof OracleDriver)) continue;
                DriverManager.deregisterDriver(driverobj);
            }
            PhysicalConnection conn = (PhysicalConnection)driverExtension.getConnection(url, info);
            conn.protocolId = extensionType;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + conn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            physicalConnection = conn;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Connection defaultConnection() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (defaultConn == null || defaultConn.isClosed()) {
                object = OracleDriver.class;
                // MONITORENTER : oracle.jdbc.driver.OracleDriver.class
                if (defaultConn == null || defaultConn.isClosed()) {
                    defaultConn = this.connect("jdbc:oracle:kprb:", new Properties());
                }
                // MONITOREXIT : object
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + defaultConn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = defaultConn;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int oracleDriverExtensionTypeFromURL(String url) {
        long __ol_nanos__ = 0L;
        try {
            int second_colon;
            int first_colon;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(url));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((first_colon = url.indexOf(58)) == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: -2");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = -2;
                return n2;
            }
            if (!url.regionMatches(true, 0, jdbc_string, 0, first_colon)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: -2");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = -2;
                return n3;
            }
            if ((second_colon = url.indexOf(58, ++first_colon)) == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: -2");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n4 = -2;
                return n4;
            }
            if (!url.regionMatches(true, first_colon, oracle_string, 0, second_colon - first_colon)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: -2");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n5 = -2;
                return n5;
            }
            int third_colon = url.indexOf(58, ++second_colon);
            String sub_name = null;
            if (third_colon == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: -3");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n6 = -3;
                return n6;
            }
            sub_name = url.substring(second_colon, third_colon);
            if (sub_name.equals("thin")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n7 = 0;
                return n7;
            }
            if (sub_name.equals("oci8") || sub_name.equals("oci")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(Level.FINER, "         Return: 2");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n8 = 2;
                return n8;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Return: -3");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n9 = -3;
            return n9;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptsURL(String url) {
        long __ol_nanos__;
        block24: {
            boolean bl;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(url));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!url.startsWith("jdbc:oracle:")) break block24;
                boolean bl2 = bl = OracleDriver.oracleDriverExtensionTypeFromURL(url) > -2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = false;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Class oracleConnectionClass = null;
            try {
                oracleConnectionClass = ClassRef.newInstance("oracle.jdbc.OracleConnection").get();
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            int offset = 0;
            String[] propertyNames = new String[150];
            String[] propertyValues = new String[150];
            Field[] publicPropertiesFields = oracleConnectionClass.getFields();
            for (int i2 = 0; i2 < publicPropertiesFields.length; ++i2) {
                if (!publicPropertiesFields[i2].getName().startsWith("CONNECTION_PROPERTY_") || publicPropertiesFields[i2].getName().endsWith("_DEFAULT") || publicPropertiesFields[i2].getName().endsWith("_ACCESSMODE")) continue;
                try {
                    String propertyName = (String)publicPropertiesFields[i2].get(null);
                    Field propertyDefaultField = oracleConnectionClass.getField(publicPropertiesFields[i2].getName() + "_DEFAULT");
                    String propertyValue = (String)propertyDefaultField.get(null);
                    if (offset == propertyNames.length) {
                        String[] propertyNames2 = new String[propertyNames.length * 2];
                        String[] propertyValues2 = new String[propertyNames.length * 2];
                        System.arraycopy(propertyNames, 0, propertyNames2, 0, propertyNames.length);
                        System.arraycopy(propertyValues, 0, propertyValues2, 0, propertyNames.length);
                        propertyNames = propertyNames2;
                        propertyValues = propertyValues2;
                    }
                    propertyNames[offset] = propertyName;
                    propertyValues[offset] = propertyValue;
                    ++offset;
                    continue;
                }
                catch (IllegalAccessException ex) {
                    continue;
                }
                catch (NoSuchFieldException ex2) {
                    // empty catch block
                }
            }
            DriverPropertyInfo[] ret = new DriverPropertyInfo[offset];
            for (int i3 = 0; i3 < offset; ++i3) {
                ret[i3] = new DriverPropertyInfo(propertyNames[i3], propertyValues[i3]);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            driverPropertyInfoArray = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return driverPropertyInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMajorVersion() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = OracleDatabaseMetaData.getDriverMajorVersionInfo();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinorVersion() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = OracleDatabaseMetaData.getDriverMinorVersionInfo();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean jdbcCompliant() {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processSqlEscapes(String sqlString) throws SQLException {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sqlString));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleSql sql = new OracleSql(null);
            sql.initialize(sqlString);
            String __result__ = sql.parse(sqlString);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDriver.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompileTime() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String string = BUILD_DATE;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(defaultValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = PhysicalConnection.getSystemPropertyFastConnectionFailover(defaultValue);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDriver.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        defaultConn = null;
        defaultDriver = null;
        try {
            if (defaultDriver == null) {
                defaultDriver = new oracle.jdbc.OracleDriver();
                DriverManager.registerDriver(defaultDriver);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    OracleDriver.registerMBeans();
                    return null;
                }
            });
            Timestamp ignore = Timestamp.valueOf("2000-01-01 00:00:00.0");
        }
        catch (SQLException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "SQLException in static block.", ex);
        }
        catch (RuntimeException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "RuntimeException in static block.", ex);
        }
        try {
            ClassRef pkiProv = ClassRef.newInstance("oracle.security.pki.OraclePKIProvider");
            Object t = pkiProv.get().newInstance();
        }
        catch (Throwable t) {
            // empty catch block
        }
        systemTypeMap = new Hashtable<String, ClassRef>(3);
        try {
            systemTypeMap.put("SYS.XMLTYPE", ClassRef.newInstance("oracle.xdb.XMLTypeFactory"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            systemTypeMap.put("SYS.ANYDATA", ClassRef.newInstance("oracle.sql.AnyDataFactory"));
            systemTypeMap.put("SYS.ANYTYPE", ClassRef.newInstance("oracle.sql.TypeDescriptorFactory"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        DEFAULT_CONNECTION_PROPERTIES = new Properties();
        try {
            InputStream in = PhysicalConnection.class.getResourceAsStream(DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME);
            if (in != null) {
                DEFAULT_CONNECTION_PROPERTIES.load(in);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleDriver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

