/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTimeoutPollingThread() {
        super(threadName);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.setDaemon(true);
            this.setPriority(10);
            this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
            this.count = 0;
            this.sleepMillis = Long.parseLong(PhysicalConnection.getSystemPropertyPollInterval());
            this.start();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTimeout(OracleTimeoutThreadPerVM t) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(t));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int i2 = 0;
            if (this.count >= this.knownTimeouts.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "growing knownTimeouts--new size = " + this.knownTimeouts.length * 4);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleTimeoutThreadPerVM[] bigger = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
                System.arraycopy(this.knownTimeouts, 0, bigger, 0, this.knownTimeouts.length);
                i2 = this.knownTimeouts.length;
                this.knownTimeouts = bigger;
            }
            while (i2 < this.knownTimeouts.length) {
                if (this.knownTimeouts[i2] == null) {
                    this.knownTimeouts[i2] = t;
                    ++this.count;
                    if (!TRACE || !OracleLog.recursiveEnter()) break;
                    try {
                        OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "added at " + i2);
                        break;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ++i2;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeTimeout(OracleTimeoutThreadPerVM t) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(t));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                if (this.knownTimeouts[i2] != t) continue;
                this.knownTimeouts[i2] = null;
                --this.count;
                if (!TRACE || !OracleLog.recursiveEnter()) break;
                try {
                    OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "removed from " + i2);
                    break;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pollOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollOnce() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.count > 0) {
                long now = System.currentTimeMillis();
                for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                    try {
                        if (this.knownTimeouts[i2] == null) continue;
                        this.knownTimeouts[i2].interruptIfAppropriate(now);
                        continue;
                    }
                    catch (NullPointerException e2) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutPollingThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeoutPollingThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

