/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;
import oracle.sql.RAW;

class RawCommonAccessor
extends Accessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    RawCommonAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = Integer.MAX_VALUE;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b_array;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b_array = this.getBytes(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = null;
                return string;
            }
            int len = b_array.length;
            if (len == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = null;
                return string;
            }
            String __result__ = RepConversion.bArray2String(b_array);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            PhysicalConnection conn = this.statement.connection;
            InputStream __result__ = conn.conversion.ConvertStream(new ByteArrayInputStream(b2), 2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = __result__;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            PhysicalConnection conn = this.statement.connection;
            InputStream __result__ = conn.conversion.ConvertStream(new ByteArrayInputStream(b2), 3);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = __result__;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Reader reader = null;
                return reader;
            }
            int rlen = b2.length;
            char[] charBuf = new char[rlen << 1];
            DBConversion cfr_ignored_0 = this.statement.connection.conversion;
            int chars_read = DBConversion.RAWBytesToHexChars(b2, rlen, charBuf);
            CharArrayReader __result__ = new CharArrayReader(charBuf, 0, chars_read);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader charArrayReader = __result__;
            return charArrayReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            ByteArrayInputStream __result__ = new ByteArrayInputStream(b2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayInputStream byteArrayInputStream = __result__;
            return byteArrayInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.getBytes(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.getBytes(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            RAW __result__ = this.getRAW(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW = __result__;
            return rAW;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RAW getRAW(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                RAW rAW = null;
                return rAW;
            }
            RAW __result__ = new RAW(b2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW = __result__;
            return rAW;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RawCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.RawCommonAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

