/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CCallableStatement
extends OracleCallableStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    static final int T2C_OUTPUT_USE_NIO = 5;
    static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
    int extractedCharOffset;
    int extractedByteOffset;
    static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
    static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
    static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
    static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
    static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
    static int PREAMBLE_PER_POSITION = 5;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T2CCallableStatement(T2CConnection conn, String sqlText, int batchValue, int rowPrefetchValue, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, sqlText, batchValue, rowPrefetchValue, UserResultSetType, UserResultSetConcur);
        this.userResultSetType = UserResultSetType;
        this.userResultSetConcur = UserResultSetConcur;
        this.connection = conn;
    }

    String bytes2String(byte[] bytes, int offset, int size) throws SQLException {
        byte[] tmp = new byte[size];
        System.arraycopy(bytes, offset, tmp, 0, size);
        return this.connection.conversion.CharBytesToString(tmp, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int currentShort = this.connection.queryMetaData1Offset;
        int currentChar = this.connection.queryMetaData2Offset;
        short[] s2 = this.connection.queryMetaData1;
        byte[] c2 = this.connection.queryMetaData2;
        int i2 = 0;
        while (i2 < this.numberOfDefinePositions) {
            String columnName;
            block33: {
                Accessor accessor;
                OracleTypeADT otype;
                block32: {
                    short accessorType = s2[currentShort + 0];
                    short maxLength = s2[currentShort + 1];
                    short maxCharLength = s2[currentShort + 11];
                    boolean nullable = s2[currentShort + 2] != 0;
                    short precision = s2[currentShort + 3];
                    short scale = s2[currentShort + 4];
                    int flags = 0;
                    int contflag = 0;
                    int totalElems = 0;
                    short formOfUse = s2[currentShort + 5];
                    short columnNameLen = s2[currentShort + 6];
                    columnName = this.bytes2String(c2, currentChar, columnNameLen);
                    short typeNameLen = s2[currentShort + 12];
                    String typeName = null;
                    otype = null;
                    currentChar += columnNameLen;
                    if (typeNameLen > 0) {
                        typeName = this.bytes2String(c2, currentChar, typeNameLen);
                        currentChar += typeNameLen;
                        otype = new OracleTypeADT(typeName, (Connection)this.connection);
                        otype.tdoCState = ((long)s2[currentShort + 7] & 0xFFFFL) << 48 | ((long)s2[currentShort + 8] & 0xFFFFL) << 32 | ((long)s2[currentShort + 9] & 0xFFFFL) << 16 | (long)s2[currentShort + 10] & 0xFFFFL;
                    }
                    if ((accessor = this.accessors[i2]) != null && !accessor.useForDescribeIfPossible(accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName)) {
                        accessor = null;
                    }
                    if (accessor != null) break block32;
                    switch (accessorType) {
                        case 1: {
                            accessor = new VarcharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            if (maxCharLength <= 0) break;
                            accessor.setDisplaySize(maxCharLength);
                            break;
                        }
                        case 96: {
                            accessor = new CharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            if (maxCharLength <= 0) break;
                            accessor.setDisplaySize(maxCharLength);
                            break;
                        }
                        case 2: {
                            accessor = new NumberAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 23: {
                            accessor = new RawAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 100: {
                            accessor = new BinaryFloatAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 101: {
                            accessor = new BinaryDoubleAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 8: {
                            accessor = new LongAccessor(this, i2 + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            this.rowPrefetch = 1;
                            break;
                        }
                        case 24: {
                            accessor = new LongRawAccessor(this, i2 + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            this.rowPrefetch = 1;
                            break;
                        }
                        case 104: {
                            accessor = new RowidAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 102: 
                        case 116: {
                            accessor = new T2CResultSetAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 12: {
                            accessor = new DateAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 180: {
                            accessor = new TimestampAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 181: {
                            accessor = new TimestamptzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 231: {
                            accessor = new TimestampltzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 182: {
                            accessor = new IntervalymAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 183: {
                            accessor = new IntervaldsAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 112: {
                            accessor = new ClobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 113: {
                            accessor = new BlobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 114: {
                            accessor = new BfileAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                            break;
                        }
                        case 109: {
                            accessor = new NamedTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                            break;
                        }
                        case 111: {
                            accessor = new RefTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                            break;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T2CCallableStatement.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Unknown or unimplemented accessor type: " + accessorType);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + accessorType);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    this.accessors[i2] = accessor;
                    break block33;
                }
                if (otype != null) {
                    accessor.initMetadata();
                }
            }
            accessor.columnName = columnName;
            ++i2;
            currentShort += 13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForDescribe() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean try_again;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.t2cOutput[0] = 0L;
            this.t2cOutput[2] = 0L;
            this.lobPrefetchMetaData = null;
            boolean need_to_describe = !this.described;
            boolean executed = false;
            do {
                try_again = false;
                if (this.connection.endToEndAnyChanged) {
                    this.pushEndToEndValues();
                    this.connection.endToEndAnyChanged = false;
                }
                byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
                int status = 0;
                try {
                    status = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, need_to_describe, executed, array_sql, array_sql.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, this.preparedAllBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
                }
                catch (IOException iox) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 266);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.validRows = (int)this.t2cOutput[1];
                if (status == -1 || status == -4) {
                    this.connection.checkError(status);
                } else if (status == T2C_EXTEND_BUFFER) {
                    status = this.connection.queryMetaData1Size * 2;
                }
                if (this.t2cOutput[3] != 0L) {
                    this.foundPlsqlCompilerWarning();
                } else if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
                this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
                this.needToParse = false;
                executed = true;
                if (this.sqlKind == 1) {
                    this.numberOfDefinePositions = status;
                    if (this.numberOfDefinePositions <= this.connection.queryMetaData1Size) continue;
                    try_again = true;
                    executed = true;
                    this.connection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                    continue;
                }
                this.numberOfDefinePositions = 0;
                this.validRows = status;
            } while (try_again);
            this.processDescribeData();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushEndToEndValues() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            T2CConnection c2 = this.connection;
            byte[] e2e_action = new byte[]{};
            byte[] e2e_clientid = new byte[]{};
            byte[] e2e_ecid = new byte[]{};
            byte[] e2e_module = new byte[]{};
            if (c2.endToEndValues != null) {
                if (c2.endToEndHasChanged[0]) {
                    String action = c2.endToEndValues[0];
                    if (action != null) {
                        e2e_action = DBConversion.stringToDriverCharBytes(action, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[0] = false;
                }
                if (c2.endToEndHasChanged[1]) {
                    String clientid = c2.endToEndValues[1];
                    if (clientid != null) {
                        e2e_clientid = DBConversion.stringToDriverCharBytes(clientid, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[1] = false;
                }
                if (c2.endToEndHasChanged[2]) {
                    String ecid = c2.endToEndValues[2];
                    if (ecid != null) {
                        e2e_ecid = DBConversion.stringToDriverCharBytes(ecid, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[2] = false;
                }
                if (c2.endToEndHasChanged[3]) {
                    String module = c2.endToEndValues[3];
                    if (module != null) {
                        e2e_module = DBConversion.stringToDriverCharBytes(module, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[3] = false;
                }
                T2CStatement.t2cEndToEndUpdate(this.c_state, e2e_action, e2e_action.length, e2e_clientid, e2e_clientid.length, e2e_ecid, e2e_ecid.length, e2e_module, e2e_module.length, c2.endToEndECIDSequenceNumber);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean executed_for_describe) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(executed_for_describe));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            if (!executed_for_describe) {
                if (this.numberOfDefinePositions > 0) {
                    this.doDefineExecuteFetch();
                } else {
                    this.executeForDescribe();
                }
            } else if (this.numberOfDefinePositions > 0) {
                this.doDefineFetch();
            }
            this.needToPrepareDefineBuffer = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupForDefine() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.numberOfDefinePositions > this.connection.queryMetaData1Size) {
                int n2 = this.numberOfDefinePositions / 100 + 1;
                this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * n2, this.connection.queryMetaData2Size * n2 * 8);
            }
            short[] s2 = this.connection.queryMetaData1;
            int currentShort = this.connection.queryMetaData1Offset;
            int i2 = 0;
            while (i2 < this.numberOfDefinePositions) {
                Accessor currentAccessor = this.accessors[i2];
                if (currentAccessor == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                s2[currentShort + 0] = (short)currentAccessor.defineType;
                s2[currentShort + 11] = (short)currentAccessor.charLength;
                s2[currentShort + 1] = (short)currentAccessor.byteLength;
                s2[currentShort + 5] = currentAccessor.formOfUse;
                if (currentAccessor.internalOtype != null) {
                    long tdo = ((OracleTypeADT)currentAccessor.internalOtype).getTdoCState();
                    s2[currentShort + 7] = (short)((tdo & 0xFFFF000000000000L) >> 48);
                    s2[currentShort + 8] = (short)((tdo & 0xFFFF00000000L) >> 32);
                    s2[currentShort + 9] = (short)((tdo & 0xFFFF0000L) >> 16);
                    s2[currentShort + 10] = (short)(tdo & 0xFFFFL);
                }
                switch (currentAccessor.internalType) {
                    case 112: 
                    case 113: {
                        if (currentAccessor.lobPrefetchSizeForThisColumn == -1) {
                            currentAccessor.lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
                        }
                        s2[currentShort + 7] = (short)currentAccessor.lobPrefetchSizeForThisColumn;
                    }
                }
                ++i2;
                currentShort += 13;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getLobPrefetchMetaData() {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object[] lobPrefetchMetaData = null;
            Object isPrefetchEnabled = null;
            int[] lobPrefetchSizeForThisColumnArray = null;
            int noOfLobColumnsWithPrefetch = 0;
            int lastStreamColumnIndex = 0;
            if (this.accessors != null) {
                block21: for (i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                    switch (this.accessors[i2].internalType) {
                        case 8: 
                        case 24: {
                            lastStreamColumnIndex = i2;
                            continue block21;
                        }
                        case 112: 
                        case 113: {
                            if (lobPrefetchSizeForThisColumnArray == null) {
                                lobPrefetchSizeForThisColumnArray = new int[this.accessors.length];
                            }
                            if (this.accessors[i2].lobPrefetchSizeForThisColumn != -1) {
                                ++noOfLobColumnsWithPrefetch;
                                lobPrefetchSizeForThisColumnArray[i2] = this.accessors[i2].lobPrefetchSizeForThisColumn;
                                continue block21;
                            }
                            lobPrefetchSizeForThisColumnArray[i2] = -1;
                        }
                    }
                }
            }
            if (noOfLobColumnsWithPrefetch > 0) {
                if (lobPrefetchMetaData == null) {
                    lobPrefetchMetaData = new Object[]{null, new long[this.rowPrefetch * noOfLobColumnsWithPrefetch], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * noOfLobColumnsWithPrefetch]};
                }
                for (i2 = 0; i2 < lastStreamColumnIndex; ++i2) {
                    switch (this.accessors[i2].internalType) {
                        case 112: 
                        case 113: {
                            this.accessors[i2].lobPrefetchSizeForThisColumn = -1;
                            lobPrefetchSizeForThisColumnArray[i2] = -1;
                        }
                    }
                }
                lobPrefetchMetaData[0] = lobPrefetchSizeForThisColumnArray;
            }
            Object[] __result__ = lobPrefetchMetaData;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = __result__;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processLobPrefetchMetaData(Object[] lobPrefetchMetaData) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int lobColumnCount = 0;
            int noOfRowsFetched = this.validRows == -2 ? 1 : this.validRows;
            byte[] prefetchedClobFormOfUse = (byte[])lobPrefetchMetaData[2];
            int[] prefetchedLobChunkSize = (int[])lobPrefetchMetaData[3];
            long[] prefetchedLobSize = (long[])lobPrefetchMetaData[1];
            Object[] prefetchedLobData = (Object[])lobPrefetchMetaData[4];
            int[] lobPrefetchSizeForThisColumnArray = (int[])lobPrefetchMetaData[0];
            if (this.accessors != null) {
                block14: for (int col = 0; col < this.numberOfDefinePositions; ++col) {
                    switch (this.accessors[col].internalType) {
                        case 112: 
                        case 113: {
                            if (this.accessors[col].lobPrefetchSizeForThisColumn < 0) continue block14;
                            Accessor accessor = this.accessors[col];
                            if (accessor.prefetchedLobDataL == null || accessor.prefetchedLobDataL.length < this.rowPrefetch) {
                                if (accessor.internalType == 112) {
                                    accessor.prefetchedLobCharData = new char[this.rowPrefetch][];
                                } else {
                                    accessor.prefetchedLobData = new byte[this.rowPrefetch][];
                                }
                                accessor.prefetchedLobChunkSize = new int[this.rowPrefetch];
                                accessor.prefetchedClobFormOfUse = new byte[this.rowPrefetch];
                                accessor.prefetchedLobDataL = new int[this.rowPrefetch];
                                accessor.prefetchedLobSize = new long[this.rowPrefetch];
                            }
                            int offset = noOfRowsFetched * lobColumnCount;
                            for (int row = 0; row < noOfRowsFetched; ++row) {
                                accessor.prefetchedLobChunkSize[row] = prefetchedLobChunkSize[col];
                                accessor.prefetchedClobFormOfUse[row] = prefetchedClobFormOfUse[col];
                                accessor.prefetchedLobSize[row] = prefetchedLobSize[offset + row];
                                accessor.prefetchedLobDataL[row] = 0;
                                if (lobPrefetchSizeForThisColumnArray[col] <= 0 || prefetchedLobSize[offset + row] <= 0L) continue;
                                if (accessor.internalType == 112) {
                                    accessor.prefetchedLobCharData[row] = (char[])prefetchedLobData[offset + row];
                                    if (accessor.prefetchedLobCharData[row] == null) continue;
                                    accessor.prefetchedLobDataL[row] = accessor.prefetchedLobCharData[row].length;
                                    continue;
                                }
                                accessor.prefetchedLobData[row] = (byte[])prefetchedLobData[offset + row];
                                if (accessor.prefetchedLobData[row] == null) continue;
                                accessor.prefetchedLobDataL[row] = accessor.prefetchedLobData[row].length;
                            }
                            ++lobColumnCount;
                            continue block14;
                        }
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDefineFetch() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.needToPrepareDefineBuffer) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Error: " + "doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
            }
            this.setupForDefine();
            this.t2cOutput[2] = 0L;
            this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
            this.t2cOutput[6] = this.defaultLobPrefetchSize;
            if (this.connection.useNio) {
                this.resetNioAttributesBeforeFetch();
                this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
            }
            if (this.lobPrefetchMetaData == null) {
                this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
            }
            this.validRows = T2CStatement.t2cDefineFetch(this, this.c_state, this.rowPrefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
            if (this.validRows == -1 || this.validRows == -4) {
                this.connection.checkError(this.validRows);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            if (this.connection.useNio && (this.validRows > 0 || this.validRows == -2)) {
                this.extractNioDefineBuffers(0);
            }
            if (this.lobPrefetchMetaData != null) {
                this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateNioBuffersIfRequired(int charSize, int byteSize, int indSize) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(charSize) + ", " + OracleLog.argument(byteSize) + ", " + OracleLog.argument(indSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.nioBuffers == null) {
                this.nioBuffers = new ByteBuffer[4];
            }
            if (byteSize > 0) {
                if (this.nioBuffers[0] == null || this.nioBuffers[0].capacity() < byteSize) {
                    this.nioBuffers[0] = ByteBuffer.allocateDirect(byteSize);
                } else if (this.nioBuffers[0] != null) {
                    this.nioBuffers[0].rewind();
                }
            }
            if ((charSize *= 2) > 0) {
                if (this.nioBuffers[1] == null || this.nioBuffers[1].capacity() < charSize) {
                    this.nioBuffers[1] = ByteBuffer.allocateDirect(charSize);
                } else if (this.nioBuffers[1] != null) {
                    this.nioBuffers[1].rewind();
                }
            }
            if ((indSize *= 2) > 0) {
                if (this.nioBuffers[2] == null || this.nioBuffers[2].capacity() < indSize) {
                    this.nioBuffers[2] = ByteBuffer.allocateDirect(indSize);
                } else if (this.nioBuffers[2] != null) {
                    this.nioBuffers[2].rewind();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDefineExecuteFetch() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            short[] queryMetaData1 = null;
            if (this.needToPrepareDefineBuffer || this.needToParse) {
                this.setupForDefine();
                queryMetaData1 = this.connection.queryMetaData1;
            }
            this.t2cOutput[0] = 0L;
            this.t2cOutput[2] = 0L;
            byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
            this.t2cOutput[6] = this.defaultLobPrefetchSize;
            if (this.connection.useNio) {
                this.resetNioAttributesBeforeFetch();
                this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
            }
            if (this.lobPrefetchMetaData == null) {
                this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
            }
            try {
                this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, array_sql, array_sql.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.preparedAllBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.nioBuffers, this.lobPrefetchMetaData);
            }
            catch (IOException iox) {
                this.validRows = 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iox);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.validRows == -1) {
                this.connection.checkError(this.validRows);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            if (this.connection.useNio && (this.validRows > 0 || this.validRows == -2)) {
                this.extractNioDefineBuffers(0);
            }
            if (this.lobPrefetchMetaData != null) {
                this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
            }
            this.needToParse = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetch() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.numberOfDefinePositions > 0) {
                if (this.needToPrepareDefineBuffer) {
                    this.doDefineFetch();
                } else {
                    this.t2cOutput[2] = 0L;
                    this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
                    this.t2cOutput[6] = this.defaultLobPrefetchSize;
                    if (this.connection.useNio) {
                        this.resetNioAttributesBeforeFetch();
                        this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
                    }
                    if (this.lobPrefetchMetaData == null) {
                        this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
                    }
                    this.validRows = T2CStatement.t2cFetch(this.c_state, this.needToPrepareDefineBuffer, this.rowPrefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
                    if (this.validRows == -1 || this.validRows == -4) {
                        this.connection.checkError(this.validRows);
                    }
                    if (this.t2cOutput[2] != 0L) {
                        this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                    }
                    if (this.lobPrefetchMetaData != null) {
                        this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
                    }
                    if (this.connection.useNio && (this.validRows > 0 || this.validRows == -2)) {
                        this.extractNioDefineBuffers(0);
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetNioAttributesBeforeFetch() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.extractedCharOffset = 0;
            this.extractedByteOffset = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void extractNioDefineBuffers(int columnIndex) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.accessors == null || this.defineIndicators == null || columnIndex == this.numberOfDefinePositions) {
                return;
            }
            int sizeToCopyBytes = 0;
            int sizeToCopyChars = 0;
            int sizeToCopyIndicators = 0;
            int lengthOffset = 0;
            int indOffset = 0;
            if (!this.hasStream) {
                sizeToCopyBytes = this.defineBytes != null ? this.defineBytes.length : 0;
                sizeToCopyChars = this.defineChars != null ? this.defineChars.length : 0;
                sizeToCopyIndicators = this.defineIndicators.length;
            } else {
                if (this.numberOfDefinePositions > columnIndex) {
                    indOffset = this.accessors[columnIndex].indicatorIndex;
                    lengthOffset = this.accessors[columnIndex].lengthIndex;
                }
                block17: for (int i2 = columnIndex; i2 < this.numberOfDefinePositions; ++i2) {
                    switch (this.accessors[i2].internalType) {
                        case 8: 
                        case 24: {
                            break block17;
                        }
                        default: {
                            sizeToCopyBytes += this.accessors[i2].byteLength;
                            sizeToCopyChars += this.accessors[i2].charLength;
                            ++sizeToCopyIndicators;
                            continue block17;
                        }
                    }
                }
            }
            ByteBuffer b2 = this.nioBuffers[0];
            if (b2 != null && this.defineBytes != null && sizeToCopyBytes > 0) {
                b2.position(this.extractedByteOffset);
                b2.get(this.defineBytes, this.extractedByteOffset, sizeToCopyBytes);
                this.extractedByteOffset += sizeToCopyBytes;
            }
            if (this.nioBuffers[1] != null && this.defineChars != null) {
                b2 = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
                CharBuffer c2 = b2.asCharBuffer();
                if (sizeToCopyChars > 0) {
                    c2.position(this.extractedCharOffset);
                    c2.get(this.defineChars, this.extractedCharOffset, sizeToCopyChars);
                    this.extractedCharOffset += sizeToCopyChars;
                }
            }
            if (this.nioBuffers[2] != null) {
                b2 = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
                ShortBuffer s2 = b2.asShortBuffer();
                if (this.hasStream) {
                    if (sizeToCopyIndicators > 0) {
                        s2.position(indOffset);
                        s2.get(this.defineIndicators, indOffset, sizeToCopyIndicators);
                        s2.position(lengthOffset);
                        s2.get(this.defineIndicators, lengthOffset, sizeToCopyIndicators);
                    }
                } else {
                    s2.get(this.defineIndicators);
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClose() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.defineBytes != null) {
                this.defineBytes = null;
                this.accessorByteOffset = 0;
            }
            if (this.defineChars != null) {
                this.defineChars = null;
                this.accessorCharOffset = 0;
            }
            if (this.defineIndicators != null) {
                this.defineIndicators = null;
                this.accessorShortOffset = 0;
            }
            int returnCode = T2CStatement.t2cCloseStatement(this.c_state);
            this.nioBuffers = null;
            if (returnCode != 0) {
                this.connection.checkError(returnCode);
            }
            this.t2cOutput = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeQuery() throws SQLException {
        block21: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.streamList == null) break block21;
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (internal_type == 116 || internal_type == 102) {
                T2CResultSetAccessor result;
                if (forBind && typeName != null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                T2CResultSetAccessor __ex__ = result = new T2CResultSetAccessor(this, max_len, form, external_type, forBind);
                return __ex__;
            }
            Accessor __result__ = super.allocateAccessor(internal_type, external_type, col_index, max_len, form, typeName, forBind);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Accessor accessor = __result__;
            return accessor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeUsedStreams(int columnIndex) throws SQLException {
        block33: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CCallableStatement.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "closeUsedStream(" + columnIndex + ") closing " + this.nextStream + " at index " + this.nextStream.columnIndex);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
                if (this.nextStream == null) break block33;
                try {
                    this.nextStream.needBytes();
                }
                catch (IOException e2) {
                    this.interalCloseOnIOException(e2);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void interalCloseOnIOException(IOException ea) throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetchDmlReturnParams() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
            if (this.rowsDmlReturned != 0) {
                this.allocateDmlReturnStorage();
                int status = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this.returnParamAccessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
                if (status == -1 || status == -4) {
                    this.connection.checkError(status);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
                if (this.connection.useNio && (status > 0 || status == -2)) {
                    this.extractNioDefineBuffers(0);
                }
            }
            this.returnParamsFetched = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeIndicatorSubRange() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.bindIndicatorSubRange = this.numberOfBindPositions * PREAMBLE_PER_POSITION;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int calculateIndicatorSubRangeSize() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.numberOfBindPositions * PREAMBLE_PER_POSITION;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    short getInoutIndicator(int bindPosition) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            short __result__ = this.bindIndicators[bindPosition * PREAMBLE_PER_POSITION];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void prepareBindPreambles(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(number_of_rows_to_be_bound) + ", " + OracleLog.argument(number_of_rows_to_be_set_up));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int preambleSize = this.calculateIndicatorSubRangeSize();
            int currentPreambleIndex = this.bindIndicatorSubRange - preambleSize;
            OracleTypeADT[] otypes = this.parameterOtype == null ? null : this.parameterOtype[this.firstRowInBatch];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int inout;
                OracleTypeADT otype;
                Binder binder = this.lastBinders[i2];
                if (binder == this.theReturnParamBinder) {
                    otype = (OracleTypeADT)this.returnParamAccessors[i2].internalOtype;
                    inout = 0;
                } else {
                    OracleTypeADT oracleTypeADT = otype = otypes == null ? null : otypes[i2];
                    if (this.outBindAccessors == null) {
                        inout = 0;
                    } else {
                        Accessor accessor = this.outBindAccessors[i2];
                        if (accessor == null) {
                            inout = 0;
                        } else if (binder == this.theOutBinder) {
                            inout = 1;
                            if (otype == null) {
                                otype = (OracleTypeADT)accessor.internalOtype;
                            }
                        } else {
                            inout = 2;
                        }
                    }
                    inout = binder.updateInoutIndicatorValue((short)inout);
                }
                this.bindIndicators[currentPreambleIndex++] = inout;
                if (otype != null) {
                    long tdo = otype.getTdoCState();
                    this.bindIndicators[currentPreambleIndex + 0] = (short)(tdo >> 48 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 1] = (short)(tdo >> 32 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 2] = (short)(tdo >> 16 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 3] = (short)(tdo & 0xFFFFL);
                }
                currentPreambleIndex += 4;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseBuffers() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            super.releaseBuffers();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doDescribe(boolean includeNames) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean try_again;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(includeNames));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.described) {
                return;
            }
            if (!this.isOpen) {
                this.connection.open(this);
                this.isOpen = true;
            }
            do {
                try_again = false;
                boolean needToExecute = this.sqlKind == 1 && this.needToParse && (!this.described || !this.serverCursor);
                byte[] array_sql = needToExecute ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, array_sql, array_sql.length, needToExecute);
                if (!this.described) {
                    this.described = true;
                }
                if (this.numberOfDefinePositions == -1) {
                    this.connection.checkError(this.numberOfDefinePositions);
                }
                if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
                try_again = true;
                this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
            } while (try_again);
            this.processDescribeData();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void registerOutParameterInternal(int paramIndex, int external_type, int scale, int maxLength, String sqlName) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        int internal_type = this.getInternalType(external_type);
        if (internal_type == 995) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (external_type) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.currentRowFormOfUse[index] = 2;
                break;
            }
            case 2011: {
                maxLength = 0;
                this.currentRowFormOfUse[index] = 2;
                break;
            }
            case 2009: {
                maxLength = 0;
                sqlName = "SYS.XMLTYPE";
                break;
            }
            default: {
                maxLength = 0;
            }
        }
        this.currentRowBindAccessors[index] = this.allocateAccessor(internal_type, external_type, paramIndex, maxLength, this.currentRowFormOfUse[index], sqlName, true);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CCallableStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

