/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CConnection;

class T2CInputStream
extends OracleInputStream {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, byte[] var7, int var8, char[] var9, int var10, short[] var11, int var12, Object[] var13, Object[] var14, long var15);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T2CInputStream(OracleStatement stmt, int index, Accessor a2) {
        block12: {
            super(stmt, index, a2);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    T2CInputStream.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(a2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CInputStream.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(int howMany) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CInputStream.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (howMany > this.currentBufferSize) {
                    this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                    this.resizableBuffer = new byte[this.currentBufferSize];
                }
                long flags = this.statement.connection.useNio ? 1 : 0;
                if (this.statement.connection.useNio) {
                    if (this.statement.nioBuffers[3] == null || this.statement.nioBuffers[3].capacity() < this.resizableBuffer.length) {
                        this.statement.nioBuffers[3] = ByteBuffer.allocateDirect(this.resizableBuffer.length);
                    } else {
                        this.statement.nioBuffers[3].rewind();
                    }
                }
                int dataSize = this.t2cGetBytes(this.statement.c_state, this.columnIndex, this.resizableBuffer, this.currentBufferSize, this.statement.accessors, this.statement.defineBytes, this.statement.accessorByteOffset, this.statement.defineChars, this.statement.accessorCharOffset, this.statement.defineIndicators, this.statement.accessorShortOffset, this.statement.nioBuffers, this.statement.lobPrefetchMetaData, flags);
                boolean needToUpdateNioBuffers = false;
                try {
                    if (dataSize == -1) {
                        ((T2CConnection)this.statement.connection).checkError(dataSize, this.statement.sqlWarning);
                    } else if (dataSize == -2) {
                        needToUpdateNioBuffers = true;
                        this.accessor.setNull(this.statement.currentRow == -1 ? 0 : this.statement.currentRow, true);
                        dataSize = 0;
                    } else if (this.statement.connection.useNio && dataSize >= 0) {
                        this.accessor.setNull(this.statement.currentRow == -1 ? 0 : this.statement.currentRow, false);
                    }
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing java.io.IOException: " + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new IOException(e2.getMessage());
                }
                if (dataSize <= 0) {
                    dataSize = -1;
                    needToUpdateNioBuffers = true;
                }
                if (this.statement.connection.useNio) {
                    ByteBuffer b2 = this.statement.nioBuffers[3];
                    if (b2 != null && dataSize > 0) {
                        b2.get(this.resizableBuffer, 0, dataSize);
                    }
                    if (needToUpdateNioBuffers) {
                        try {
                            this.statement.extractNioDefineBuffers(this.columnIndex);
                        }
                        catch (SQLException e3) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T2CInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing java.io.IOException: " + e3.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new IOException(e3.getMessage());
                        }
                    }
                }
                if (needToUpdateNioBuffers && this.statement.lobPrefetchMetaData != null) {
                    this.statement.processLobPrefetchMetaData(this.statement.lobPrefetchMetaData);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CInputStream.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dataSize);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = dataSize;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CInputStream.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CInputStream.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

