/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTILobd
extends T4CTTIMsg {
    static final int LOBD_STATE0 = 0;
    static final int LOBD_STATE1 = 1;
    static final int LOBD_STATE2 = 2;
    static final int LOBD_STATE3 = 3;
    static final int LOBD_STATE_EXIT = 4;
    static final short TTCG_LNG = 254;
    static final short LOBDATALENGTH = 252;
    static byte[] ucs2Char = new byte[2];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4C8TTILobd(T4CConnection _conn) {
        super(_conn, (byte)14);
    }

    void marshalLobData(byte[] inBuffer, long inBufferOffset, long numBytes, boolean useZeroCopyIO) throws IOException {
        long length = numBytes;
        this.marshalTTCcode();
        if (useZeroCopyIO) {
            this.meg.outStream.flush();
            this.meg.outStream.writeZeroCopyIO(inBuffer, (int)inBufferOffset, (int)numBytes);
        } else {
            boolean ttcgLong = false;
            if (length > 252L) {
                ttcgLong = true;
                this.meg.marshalUB1((short)254);
            }
            long count = 0L;
            while (length > 252L) {
                this.meg.marshalUB1((short)252);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 252L), 252);
                ++count;
                length -= 252L;
            }
            if (length > 0L) {
                this.meg.marshalUB1((short)length);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 252L), (int)length);
            }
            if (ttcgLong) {
                this.meg.marshalUB1((short)0);
            }
        }
    }

    void marshalClobUB2_For9iDB(byte[] inBuffer, long inBufferOffset, long numChars) throws IOException {
        long numUB2 = numChars;
        boolean ttcgLong = false;
        this.marshalTTCcode();
        if (numUB2 > 84L) {
            ttcgLong = true;
            this.meg.marshalUB1((short)254);
        }
        long count = 0L;
        while (numUB2 > 84L) {
            this.meg.marshalUB1((short)252);
            for (int j2 = 0; j2 < 84; ++j2) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 168L + (long)(j2 * 2)), 2);
            }
            ++count;
            numUB2 -= 84L;
        }
        if (numUB2 > 0L) {
            long length = numUB2 * 3L;
            this.meg.marshalUB1((short)length);
            int j3 = 0;
            while ((long)j3 < numUB2) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 168L + (long)(j3 * 2)), 2);
                ++j3;
            }
        }
        if (ttcgLong) {
            this.meg.marshalUB1((short)0);
        }
    }

    long unmarshalLobData(byte[] outBuffer, int offsetInOutBuffer, boolean useZeroCopyIO) throws SQLException, IOException {
        long bytesRead = 0L;
        if (useZeroCopyIO) {
            int nbOfBytesReadSoFar = 0;
            int[] nbOfByteRead = new int[1];
            boolean isMarked = false;
            while (!isMarked) {
                isMarked = this.meg.inStream.readZeroCopyIO(outBuffer, offsetInOutBuffer + nbOfBytesReadSoFar, nbOfByteRead);
                nbOfBytesReadSoFar += nbOfByteRead[0];
            }
            bytesRead = nbOfBytesReadSoFar;
        } else {
            long offset = offsetInOutBuffer;
            short length = 0;
            int state = 0;
            block7: while (state != 4) {
                switch (state) {
                    case 0: {
                        length = this.meg.unmarshalUB1();
                        if (length == 254) {
                            state = 2;
                            continue block7;
                        }
                        state = 1;
                        continue block7;
                    }
                    case 1: {
                        this.meg.getNBytes(outBuffer, (int)offset, length);
                        bytesRead += (long)length;
                        state = 4;
                        continue block7;
                    }
                    case 2: {
                        length = this.meg.unmarshalUB1();
                        if (length > 0) {
                            state = 3;
                            continue block7;
                        }
                        state = 4;
                        continue block7;
                    }
                    case 3: {
                        this.meg.getNBytes(outBuffer, (int)offset, length);
                        bytesRead += (long)length;
                        offset += (long)length;
                        state = 2;
                        continue block7;
                    }
                }
            }
        }
        return bytesRead;
    }

    long unmarshalClobUB2_For9iDB(byte[] outBuffer, int offsetInOutBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        long offset = offsetInOutBuffer;
        int length = 0;
        int i2 = 0;
        int numBytes = 0;
        int state = 0;
        block6: while (state != 4) {
            switch (state) {
                case 0: {
                    length = this.meg.unmarshalUB1();
                    if (length == 254) {
                        state = 2;
                        continue block6;
                    }
                    state = 1;
                    continue block6;
                }
                case 1: {
                    i2 = 0;
                    while (i2 < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i2 += numBytes;
                        offset += 2L;
                    }
                    bytesRead += (long)length;
                    state = 4;
                    continue block6;
                }
                case 2: {
                    length = this.meg.unmarshalUB1();
                    if (length > 0) {
                        state = 3;
                        continue block6;
                    }
                    state = 4;
                    continue block6;
                }
                case 3: {
                    i2 = 0;
                    while (i2 < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i2 += numBytes;
                        offset += 2L;
                    }
                    bytesRead += (long)length;
                    state = 2;
                    continue block6;
                }
            }
        }
        return bytesRead;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTILobd"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

