/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;

class T4CClobAccessor
extends ClobAccessor {
    T4CMAREngine mare;
    short[] prefetchedClobCharset = null;
    boolean[] prefetchedClobDBVary = null;
    final int[] meta = new int[1];
    ArrayList<LinkedList<CLOB>> registeredCLOBs = new ArrayList(10);
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CClobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, form, external_type, forBind);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.mare = _mare;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CClobAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, nullable, flags, precision, scale, contflag, total_elems, form);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 32 && this.statement.sqlKind != 64) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 32 || this.statement.sqlKind == 64 || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            int len = (int)this.mare.unmarshalUB4();
            if (len == 0) {
                this.meta[0] = -1;
                this.processIndicator(0);
                ++this.lastRowProcessed;
                return false;
            }
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int len = (int)this.mare.unmarshalUB4();
        if (len == 0) {
            this.meta[0] = -1;
            this.processIndicator(0);
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            return false;
        }
        if (this.lobPrefetchSizeForThisColumn != -1) {
            this.handlePrefetch();
        }
        this.mare.unmarshalCLR(this.rowSpaceByte, tmpSpaceByteOffset, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndex + lastRowOffset * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceByteOffset = this.columnIndex + (newPrefetchSize - 1) * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceByteLastRow, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
    }

    byte[][] checkAndAllocateLobPrefetchMemory(byte[][] existingBuffers, int statementPrefetchSize, int currentRowNumber, int bufferSizeAtCurrentRow) {
        Object retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new byte[Math.max(statementPrefetchSize, currentRowNumber + 1)][];
            retBuff[currentRowNumber] = new byte[bufferSizeAtCurrentRow];
        } else {
            if (((byte[][])retBuff).length < currentRowNumber + 1) {
                byte[][] retBuff2 = new byte[(currentRowNumber + 1) * 2][];
                System.arraycopy(retBuff, 0, retBuff2, 0, ((byte[][])retBuff).length);
                retBuff = retBuff2;
            }
            if (retBuff[currentRowNumber] == null || retBuff[currentRowNumber].length < bufferSizeAtCurrentRow) {
                retBuff[currentRowNumber] = new byte[bufferSizeAtCurrentRow];
            }
        }
        return retBuff;
    }

    char[][] checkAndAllocateLobPrefetchMemory(char[][] existingBuffers, int statementPrefetchSize, int currentRowNumber, int bufferSizeAtCurrentRow) {
        Object retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new char[Math.max(statementPrefetchSize, currentRowNumber + 1)][];
            retBuff[currentRowNumber] = new char[bufferSizeAtCurrentRow];
        } else {
            if (((char[][])retBuff).length < currentRowNumber + 1) {
                char[][] retBuff2 = new char[(currentRowNumber + 1) * 2][];
                System.arraycopy(retBuff, 0, retBuff2, 0, ((char[][])retBuff).length);
                retBuff = retBuff2;
            }
            if (retBuff[currentRowNumber] == null || retBuff[currentRowNumber].length < bufferSizeAtCurrentRow) {
                retBuff[currentRowNumber] = new char[bufferSizeAtCurrentRow];
            }
        }
        return retBuff;
    }

    long[] checkAndAllocateLobPrefetchMemory(long[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        long[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new long[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            long[] retBuff2 = new long[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    int[] checkAndAllocateLobPrefetchMemory(int[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        int[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new int[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            int[] retBuff2 = new int[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    short[] checkAndAllocateLobPrefetchMemory(short[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        short[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new short[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            short[] retBuff2 = new short[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    byte[] checkAndAllocateLobPrefetchMemory(byte[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        byte[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new byte[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            byte[] retBuff2 = new byte[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    boolean[] checkAndAllocateLobPrefetchMemory(boolean[] existingBuffers, int statementPrefetchSize, int currentRowNumber) {
        boolean[] retBuff = existingBuffers;
        if (retBuff == null) {
            retBuff = new boolean[Math.max(statementPrefetchSize, currentRowNumber + 1)];
        } else if (retBuff.length < currentRowNumber + 1) {
            boolean[] retBuff2 = new boolean[(currentRowNumber + 1) * 2];
            System.arraycopy(retBuff, 0, retBuff2, 0, retBuff.length);
            retBuff = retBuff2;
        }
        return retBuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = null;
                return string;
            }
            if (this.lobPrefetchSizeForThisColumn != -1 && this.prefetchedLobSize != null) {
                if (this.prefetchedLobSize[currentRow] > Integer.MAX_VALUE) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CClobAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 151);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.prefetchedLobCharData != null && (long)this.lobPrefetchSizeForThisColumn >= this.prefetchedLobSize[currentRow]) {
                    String ret = new String(this.prefetchedLobCharData[currentRow], 0, this.prefetchedLobDataL[currentRow]);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = ret;
                    return string;
                }
                CLOB clob = this.getCLOB(currentRow);
                if (clob == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = null;
                    return string;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + clob.getSubString(1L, (int)this.prefetchedLobSize[currentRow]));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = clob.getSubString(1L, (int)this.prefetchedLobSize[currentRow]);
                return string;
            }
            String __result__ = super.getString(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void handlePrefetch() throws SQLException, IOException {
        this.prefetchedLobSize = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobSize, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
        this.prefetchedLobSize[this.lastRowProcessed] = this.mare.unmarshalSB8();
        this.prefetchedLobChunkSize = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobChunkSize, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
        this.prefetchedLobChunkSize[this.lastRowProcessed] = (int)this.mare.unmarshalUB4();
        if (this.lobPrefetchSizeForThisColumn > 0) {
            this.prefetchedClobDBVary = this.checkAndAllocateLobPrefetchMemory(this.prefetchedClobDBVary, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
            byte dbVary = (byte)this.mare.unmarshalUB1();
            this.prefetchedClobDBVary[this.lastRowProcessed] = dbVary == 1;
            this.prefetchedClobCharset = this.checkAndAllocateLobPrefetchMemory(this.prefetchedClobCharset, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
            this.prefetchedClobCharset[this.lastRowProcessed] = this.prefetchedClobDBVary[this.lastRowProcessed] ? (short)this.mare.unmarshalUB2() : (short)0;
            this.prefetchedClobFormOfUse = this.checkAndAllocateLobPrefetchMemory(this.prefetchedClobFormOfUse, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
            this.prefetchedClobFormOfUse[this.lastRowProcessed] = (byte)this.mare.unmarshalUB1();
            this.prefetchedLobDataL = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobDataL, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
            int maxNbOfChars = this.lobPrefetchSizeForThisColumn;
            int maxNbOfBytes = -1;
            maxNbOfBytes = this.prefetchedClobDBVary[this.lastRowProcessed] ? maxNbOfChars * 2 : maxNbOfChars * 3;
            this.prefetchedLobData = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobData, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed, maxNbOfBytes);
            this.mare.unmarshalCLR(this.prefetchedLobData[this.lastRowProcessed], 0, this.meta);
            int nbOfBytesFromNetwork = this.meta[0];
            this.disablePrefetchBufferForPreviousCLOBs(this.lastRowProcessed);
            this.prefetchedLobCharData = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobCharData, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed, maxNbOfChars);
            char[] charsData = this.prefetchedLobCharData[this.lastRowProcessed];
            byte[] prefetchedData = this.prefetchedLobData[this.lastRowProcessed];
            int nbOfCharsFromConversion = -1;
            if (dbVary == 1) {
                nbOfCharsFromConversion = this.prefetchedClobCharset[this.lastRowProcessed] == 2000 ? CharacterSet.convertAL16UTF16BytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesFromNetwork, true) : CharacterSet.convertAL16UTF16LEBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesFromNetwork, true);
            } else {
                int[] nbOfBytesArr = new int[]{nbOfBytesFromNetwork};
                nbOfCharsFromConversion = this.formOfUse == 1 ? this.statement.connection.conversion.CHARBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesArr, charsData.length) : this.statement.connection.conversion.NCHARBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesArr, charsData.length);
            }
            this.prefetchedLobDataL[this.lastRowProcessed] = nbOfCharsFromConversion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCLOBReference(int rowPosition, CLOB clob) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            LinkedList<Object> clobsAtThisRow = null;
            if (this.registeredCLOBs.size() > rowPosition) {
                clobsAtThisRow = this.registeredCLOBs.get(rowPosition);
            } else {
                clobsAtThisRow = new LinkedList();
                while (this.registeredCLOBs.size() < rowPosition) {
                    this.registeredCLOBs.add(new LinkedList());
                }
                this.registeredCLOBs.add(rowPosition, clobsAtThisRow);
            }
            if (clobsAtThisRow == null) {
                clobsAtThisRow = new LinkedList();
            }
            clobsAtThisRow.add(clob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disablePrefetchBufferForPreviousCLOBs(int rowPosition) {
        long __ol_nanos__ = 0L;
        try {
            LinkedList<CLOB> blobsAtThisRow;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.registeredCLOBs.size() > rowPosition && (blobsAtThisRow = this.registeredCLOBs.get(rowPosition)) != null && !blobsAtThisRow.isEmpty()) {
                ListIterator it = blobsAtThisRow.listIterator();
                while (it.hasNext()) {
                    ((CLOB)it.next()).setPrefetchedData(null);
                }
                blobsAtThisRow.clear();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        Object result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case 2005: {
                    return this.getCLOB(currentRow);
                }
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(currentRow);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CClobAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    @Override
    void initializeClobForPrefetch(int currentRow, CLOB result) throws SQLException {
        if (currentRow >= 0) {
            this.saveCLOBReference(currentRow, result);
            result.setPrefetchedData(this.prefetchedLobCharData[currentRow], this.prefetchedLobDataL[currentRow]);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CClobAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

