/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIk2rpc
extends T4CTTIfun {
    static final int K2RPClogon = 1;
    static final int K2RPCbegin = 2;
    static final int K2RPCend = 3;
    static final int K2RPCrecover = 4;
    static final int K2RPCsession = 5;
    private int k2rpctyp;
    private int command;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIk2rpc(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)67);
    }

    void doOK2RPC(int _k2rpctyp, int _command) throws IOException, SQLException {
        this.k2rpctyp = _k2rpctyp;
        this.command = _command;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(this.k2rpctyp);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(this.command);
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(0L);
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int k2rpco4l = this.meg.unmarshalUB2();
        for (int i2 = 0; i2 < k2rpco4l; ++i2) {
            this.meg.unmarshalUB4();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIk2rpc.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIk2rpc.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIk2rpc.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIk2rpc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

