/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIoxsscs
extends T4CTTIfun {
    private String userName = null;
    private KeywordValueLong[] inKV = null;
    private int inFlags;
    private byte[] userNameArr = null;
    private byte[] sessionId = null;
    private KeywordValueLong[] outKV = null;
    private int outFlags = -1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIoxsscs(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)155);
    }

    void doOXSSCS(String _userName, KeywordValueLong[] _inKV, int _inFlags) throws IOException, SQLException {
        this.userName = _userName;
        this.inKV = _inKV;
        this.inFlags = _inFlags;
        this.userNameArr = (byte[])(this.userName != null && this.userName.length() > 0 ? this.meg.conv.StringToCharBytes(this.userName) : null);
        this.sessionId = null;
        this.outKV = null;
        this.outFlags = -1;
        if (this.inKV != null) {
            for (int i2 = 0; i2 < this.inKV.length; ++i2) {
                ((KeywordValueLongI)this.inKV[i2]).doCharConversion(this.meg.conv);
            }
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.userNameArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.userNameArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        boolean sendInKV = false;
        if (this.inKV != null && this.inKV.length > 0) {
            sendInKV = true;
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.inKV.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(this.inFlags);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.userNameArr != null) {
            this.meg.marshalCHR(this.userNameArr);
        }
        if (sendInKV) {
            for (int i2 = 0; i2 < this.inKV.length; ++i2) {
                ((KeywordValueLongI)this.inKV[i2]).marshal(this.meg);
            }
        }
    }

    byte[] getSessionId() {
        return this.sessionId;
    }

    KeywordValueLong[] getOutKV() {
        return this.outKV;
    }

    int getOutFlags() {
        return this.outFlags;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int sessionIdLength = (int)this.meg.unmarshalUB4();
        this.sessionId = this.meg.unmarshalNBytes(sessionIdLength);
        int xsscsovn = (int)this.meg.unmarshalUB4();
        this.outKV = new KeywordValueLong[xsscsovn];
        for (int i2 = 0; i2 < xsscsovn; ++i2) {
            this.outKV[i2] = KeywordValueLongI.unmarshal(this.meg);
        }
        this.outFlags = (int)this.meg.unmarshalUB4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoxsscs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoxsscs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoxsscs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoxsscs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

