/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    T4CConnection physicalConn;
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int errorNumber;
    private String password;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CXAResource(T4CConnection _physicalConn, OracleXAConnection xaconn, boolean _isTransLoose) throws XAException {
        super(_physicalConn, xaconn);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_physicalConn) + ", " + OracleLog.argument(xaconn) + ", " + OracleLog.argument(_isTransLoose));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.physicalConn = _physicalConn;
            this.isTransLoose = _isTransLoose;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doStart(Xid xid, int flag) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            long __ol_nanos__ = 0L;
            try {
                int returnVal;
                block47: {
                    int swtch;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    returnVal = -1;
                    if (this.isTransLoose) {
                        flag |= 0x10000;
                    }
                    if ((swtch = flag & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                        int n2 = 0;
                        return n2;
                    }
                    this.applicationValueArr[0] = 0;
                    try {
                        try {
                            T4CTTIOtxse otxse = this.physicalConn.otxse;
                            byte[] xidxid = null;
                            byte[] gtrid = xid.getGlobalTransactionId();
                            byte[] bqual = xid.getBranchQualifier();
                            int gtrid_l = 0;
                            int bqual_l = 0;
                            if (gtrid != null && bqual != null) {
                                gtrid_l = Math.min(gtrid.length, 64);
                                bqual_l = Math.min(bqual.length, 64);
                                xidxid = new byte[128];
                                System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                                System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                            }
                            int t4cflag = 0;
                            t4cflag = (flag & 0x200000) != 0 || (flag & 0x8000000) != 0 ? (t4cflag |= 4) : (t4cflag |= 1);
                            if ((flag & 0x100) != 0) {
                                t4cflag |= 0x100;
                            }
                            if ((flag & 0x200) != 0) {
                                t4cflag |= 0x200;
                            }
                            if ((flag & 0x400) != 0) {
                                t4cflag |= 0x400;
                            }
                            if ((flag & 0x10000) != 0) {
                                t4cflag |= 0x10000;
                            }
                            this.physicalConn.needLine();
                            this.physicalConn.sendPiggyBackedMessages();
                            otxse.doOTXSE(1, null, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = otxse.getApplicationValue();
                            byte[] ctx = otxse.getContext();
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                        }
                        catch (IOException ioe) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_start: IOException caught:" + ioe.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioe);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    catch (SQLException s2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_start: SQLException caught:" + s2.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if ((returnVal = s2.getErrorCode()) != 0) break block47;
                        throw new XAException(-6);
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = returnVal;
                return n3;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            long __ol_nanos__ = 0L;
            try {
                int returnVal;
                block51: {
                    int bqual_l;
                    int gtrid_l;
                    byte[] xidxid;
                    T4CTTIOtxse otxse;
                    block49: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag) + ", " + OracleLog.argument(isLocallySuspended));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        returnVal = -1;
                        otxse = this.physicalConn.otxse;
                        xidxid = null;
                        byte[] gtrid = xid.getGlobalTransactionId();
                        byte[] bqual = xid.getBranchQualifier();
                        gtrid_l = 0;
                        bqual_l = 0;
                        if (gtrid != null && bqual != null) {
                            gtrid_l = Math.min(gtrid.length, 64);
                            bqual_l = Math.min(bqual.length, 64);
                            xidxid = new byte[128];
                            System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                            System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                        }
                        if (this.context != null || (returnVal = this.doStart(xid, 0x8000000)) == 0) break block49;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        int n2 = returnVal;
                        return n2;
                    }
                    try {
                        try {
                            byte[] txctx = this.context;
                            int t4cflag = 0;
                            if ((flag & 2) == 2) {
                                t4cflag = 0x100000;
                            } else if ((flag & 0x2000000) == 0x2000000 && (flag & 0x100000) != 0x100000) {
                                t4cflag = 0x100000;
                            }
                            this.applicationValueArr[0] = this.applicationValueArr[0] >> 16;
                            this.physicalConn.needLine();
                            this.physicalConn.sendPiggyBackedMessages();
                            otxse.doOTXSE(2, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = otxse.getApplicationValue();
                            byte[] ctx = otxse.getContext();
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                        }
                        catch (IOException ioe) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_end: IOException caught:" + ioe.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioe);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    catch (SQLException s2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_end: SQLException caught:" + s2.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if ((returnVal = s2.getErrorCode()) != 0) break block51;
                        throw new XAException(-6);
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = returnVal;
                return n3;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(Xid xid, boolean onePhaseCommit) throws SQLException, XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            block53: {
                long __ol_nanos__ = 0L;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(onePhaseCommit));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    int inTransactionState = onePhaseCommit ? 4 : 2;
                    try {
                        int outState = this.doTransaction(xid, 1, inTransactionState);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.doCommit: server returns " + outState);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (onePhaseCommit) {
                            if (outState == 2) break block53;
                            if (outState == 4) {
                                break block53;
                            }
                        }
                        if (!onePhaseCommit && outState == 5) {
                            break block53;
                        }
                        if (outState == 8) {
                            throw new XAException(106);
                        }
                        throw new XAException(-6);
                    }
                    catch (SQLException sqlex) {
                        int errorCode = sqlex.getErrorCode();
                        if (errorCode == 24756) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_commit: got a 24756. Will try to recover.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            this.kputxrec(xid, 1, this.timeout + 120, sqlex);
                            break block53;
                        }
                        if (errorCode == 24780) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_commit: got a 24780. Will try to commit from a different connection.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            OracleXADataSource oxds = null;
                            PooledConnection pc = null;
                            try {
                                oxds = new OracleXADataSource();
                                oxds.setURL(this.physicalConn.url);
                                oxds.setUser(this.physicalConn.userName);
                                this.physicalConn.getPasswordInternal(this);
                                oxds.setPassword(this.password);
                                pc = oxds.getXAConnection();
                                XAResource oxar = pc.getXAResource();
                                oxar.commit(xid, onePhaseCommit);
                                break block53;
                            }
                            catch (SQLException e2) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_commit: Got a SQLException while processing a 24780." + e2.getMessage());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                XAException xaex = new XAException(-6);
                                xaex.initCause(e2);
                                throw xaex;
                            }
                            finally {
                                try {
                                    if (pc != null) {
                                        pc.close();
                                    }
                                    if (oxds != null) {
                                        oxds.close();
                                    }
                                }
                                catch (Exception ee) {}
                            }
                        }
                        throw sqlex;
                    }
                }
                finally {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                int returnVal;
                block52: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    returnVal = -1;
                    try {
                        int outState = this.doTransaction(xid, 3, 0);
                        if (outState == 8) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_prepare: server returns K2CMDtimeout");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new XAException(106);
                        }
                        if (outState == 4) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_prepare: server returns K2CMDrdonly");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            returnVal = 3;
                            break block52;
                        }
                        if (outState == 1) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_prepare: server returns K2CMDrqcommit");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            returnVal = 0;
                            break block52;
                        }
                        if (outState == 3) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_prepare: server returns K2CMDabort");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new XAException(100);
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_prepare: server returns " + outState);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-6);
                    }
                    catch (SQLException sqlex) {
                        int errorCode = sqlex.getErrorCode();
                        if (errorCode == 25351) {
                            XAException xae = new XAException(-6);
                            xae.initCause(sqlex);
                            throw xae;
                        }
                        throw sqlex;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = returnVal;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doForget(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                int returnVal = -1;
                if (OracleXid.isLocalTransaction(xid)) {
                    int n2 = 24771;
                    return n2;
                }
                int resumeReturn = this.doStart(xid, 0x8000000);
                if (resumeReturn != 24756) {
                    block47: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_forget : resume returned : " + resumeReturn);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (resumeReturn == 0) {
                            try {
                                this.doEnd(xid, 0, false);
                            }
                            catch (Exception e2) {
                                if (!TRACE || !OracleLog.recursiveEnter()) break block47;
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_forget : end txn that existsts throws exception : " + e2.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                        }
                    }
                    if (resumeReturn == 0 || resumeReturn == 2079 || resumeReturn == 24754 || resumeReturn == 24761 || resumeReturn == 24774 || resumeReturn == 24776 || resumeReturn == 25351) {
                        int n3 = 24769;
                        return n3;
                    }
                    if (resumeReturn == 24752) {
                        int n4 = 24771;
                        return n4;
                    }
                    int n5 = resumeReturn;
                    return n5;
                }
                this.kputxrec(xid, 4, 1, null);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n6 = returnVal;
                return n6;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRollback(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            block48: {
                long __ol_nanos__ = 0L;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    try {
                        int outState = this.doTransaction(xid, 2, 3);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_rollback: server returns " + outState);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (outState == 8) {
                            throw new XAException(106);
                        }
                        if (outState == 3) {
                            break block48;
                        }
                        throw new XAException(-6);
                    }
                    catch (SQLException sqle) {
                        int errorCode = sqle.getErrorCode();
                        if (errorCode == 24756) {
                            this.kputxrec(xid, 2, this.timeout + 120, sqle);
                            break block48;
                        }
                        if (errorCode == 24780) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_rollback: got a 24780.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            OracleXADataSource oxds = null;
                            PooledConnection pc = null;
                            try {
                                oxds = new OracleXADataSource();
                                oxds.setURL(this.physicalConn.url);
                                oxds.setUser(this.physicalConn.userName);
                                this.physicalConn.getPasswordInternal(this);
                                oxds.setPassword(this.password);
                                pc = oxds.getXAConnection();
                                XAResource oxar = pc.getXAResource();
                                oxar.rollback(xid);
                                break block48;
                            }
                            catch (SQLException e2) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_rollback: Got a SQLException while processing a 24780." + e2.getMessage());
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                XAException xaex = new XAException(-6);
                                xaex.initCause(e2);
                                throw xaex;
                            }
                            finally {
                                try {
                                    if (pc != null) {
                                        pc.close();
                                    }
                                    if (oxds != null) {
                                        oxds.close();
                                    }
                                }
                                catch (Exception ee) {}
                            }
                        }
                        if (errorCode == 25402) {
                            break block48;
                        }
                        throw sqle;
                    }
                }
                finally {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doTransaction(Xid xid, int mode, int inTransactionState) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int transactionOutState;
            block32: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(inTransactionState));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                transactionOutState = -1;
                try {
                    T4CTTIOtxen otxen = this.physicalConn.otxen;
                    byte[] xidxid = null;
                    byte[] gtrid = xid.getGlobalTransactionId();
                    byte[] bqual = xid.getBranchQualifier();
                    int gtrid_l = 0;
                    int bqual_l = 0;
                    if (gtrid != null && bqual != null) {
                        gtrid_l = Math.min(gtrid.length, 64);
                        bqual_l = Math.min(bqual.length, 64);
                        xidxid = new byte[128];
                        System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                        System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                    }
                    byte[] txctx = this.context;
                    this.physicalConn.needLine();
                    this.physicalConn.sendPiggyBackedMessages();
                    otxen.doOTXEN(mode, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, inTransactionState, 0);
                    transactionOutState = otxen.getOutStateFromServer();
                    if (!TRACE || !OracleLog.recursiveEnter()) break block32;
                    try {
                        T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_transaction: transactionOutState=" + transactionOutState);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (IOException ioe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.do_transaction: IOException caught:" + ioe.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.physicalConn.handleIOException(ioe);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioe);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + transactionOutState);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = transactionOutState;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void kputxrec(Xid xid, int opcode, int tries, SQLException sqlexCause) throws XAException, SQLException {
        long __ol_nanos__ = 0L;
        try {
            int incmd;
            int inTransactionMode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(opcode) + ", " + OracleLog.argument(tries) + ", " + OracleLog.argument(sqlexCause));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            switch (opcode) {
                case 1: {
                    inTransactionMode = 3;
                    break;
                }
                case 4: {
                    inTransactionMode = 2;
                    break;
                }
                default: {
                    inTransactionMode = 0;
                }
            }
            int endstate = 0;
            while (tries-- > 0 && (endstate = this.doTransaction(xid, 5, inTransactionMode)) == 7) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {}
            }
            if (endstate == 7) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.kputxrec: Try to recover but transaction " + "operation cannot be completed now. Transaction not ready for recovery.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            int xaErrorCode = -1;
            switch (endstate) {
                case 3: {
                    if (opcode == 1) {
                        incmd = 7;
                        break;
                    }
                    incmd = 8;
                    xaErrorCode = -3;
                    break;
                }
                case 0: {
                    if (opcode == 4) {
                        incmd = 8;
                        xaErrorCode = -3;
                        break;
                    }
                    incmd = 7;
                    if (opcode != 1) break;
                    xaErrorCode = -4;
                    break;
                }
                case 2: {
                    if (opcode == 4) {
                        incmd = 8;
                        xaErrorCode = -6;
                        break;
                    }
                }
                case 5: {
                    if (opcode == 4) {
                        incmd = 7;
                        break;
                    }
                    xaErrorCode = 7;
                    incmd = 8;
                    break;
                }
                case 4: {
                    if (opcode == 4) {
                        incmd = 7;
                        break;
                    }
                    xaErrorCode = 6;
                    incmd = 8;
                    break;
                }
                case 6: {
                    if (opcode == 4) {
                        incmd = 7;
                        break;
                    }
                    xaErrorCode = 5;
                    incmd = 8;
                    break;
                }
                default: {
                    xaErrorCode = -3;
                    incmd = 8;
                }
            }
            T4CTTIk2rpc k2rpc = this.physicalConn.k2rpc;
            try {
                k2rpc.doOK2RPC(3, incmd);
            }
            catch (IOException ioe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.kputxrec: IOException caught:" + ioe.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                XAException xae = new XAException(-7);
                xae.initCause(ioe);
                throw xae;
            }
            catch (SQLException s2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CXAResource.kputxrec: SQLException caught:" + s2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                XAException xar = new XAException(-6);
                xar.initCause(s2);
                throw xar;
            }
            if (xaErrorCode != -1) {
                OracleXAException xae = null;
                if (sqlexCause != null) {
                    xae = new OracleXAException(sqlexCause.getErrorCode(), xaErrorCode);
                    xae.initCause(sqlexCause);
                } else {
                    xae = new OracleXAException(0, xaErrorCode);
                }
                throw xae;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    final void setPasswordInternal(String p2) {
        this.password = p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.physicalConn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.physicalConn;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

