/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleTypeCHAR() {
        block12: {
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCHAR(OracleConnection conn) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.form = 0;
            this.charset = 0;
            this.length = 0;
            this.connection = conn;
            this.pickleCharaterSetId = 0;
            this.pickleNcharCharacterSet = 0;
            this.pickleCharacterSet = null;
            try {
                this.pickleCharaterSetId = this.connection.getStructAttrCsId();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        String z = sw.toString();
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.pickleCharaterSetId = (short)-1;
            }
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleTypeCHAR(OracleConnection conn, int typecode) {
        super(typecode);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(typecode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.form = 0;
            this.charset = 0;
            this.length = 0;
            this.connection = conn;
            this.pickleCharaterSetId = 0;
            this.pickleNcharCharacterSet = 0;
            this.pickleCharacterSet = null;
            try {
                this.pickleCharaterSetId = this.connection.getStructAttrCsId();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        String z = sw.toString();
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.pickleCharaterSetId = (short)-1;
            }
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            CHAR datum;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (value == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum2 = null;
                return datum2;
            }
            CHAR cHAR = datum = value instanceof CHAR ? (CHAR)value : new CHAR(value, this.pickleCharacterSet);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR cHAR2 = datum;
            return cHAR2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum[] datumArray = null;
            if (obj != null) {
                if (obj instanceof Object[] && !(obj instanceof char[][])) {
                    Datum[] __result__ = super.toDatumArray(obj, conn, beginIdx, count);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Datum[] datumArray2 = __result__;
                    return datumArray2;
                }
                datumArray = this.cArrayToDatumArray(obj, conn, beginIdx, count);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray3 = datumArray;
            return datumArray3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tdsReader));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            super.parseTDSrec(tdsReader);
            try {
                this.length = tdsReader.readUB2();
                this.form = tdsReader.readByte();
                this.characterSemantic = this.form & 0x80;
                this.form &= 0x7F;
                this.charset = tdsReader.readUB2();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 47 + "parseTDS");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.form != 2 || this.pickleNcharCharacterSet != 0) {
                return;
            }
            try {
                this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        String z = sw.toString();
                        OracleTypeCHAR.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.pickleNcharCharacterSet = (short)2000;
            }
            this.pickleCharaterSetId = this.pickleNcharCharacterSet;
            this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int pickle81(PickleContext context, Datum data) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(data));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CHAR dbchar = this.getDbCHAR(data);
            if (this.characterSemantic != 0 && this.form != 2) {
                if (dbchar.getStringWithReplacement().length() > this.length) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 72 + "\"" + dbchar.getStringWithReplacement() + "\"");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else if (dbchar.getLength() > (long)this.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 72 + "\"" + dbchar.getStringWithReplacement() + "\"");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = super.pickle81(context, dbchar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (bytes == null || bytes.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var6_6 = null;
                return var6_6;
            }
            CHAR result = null;
            switch (this.form) {
                case 1: 
                case 2: {
                    result = new CHAR(bytes, this.pickleCharacterSet);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    result = new CHAR(bytes, null);
                }
            }
            if (type == 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CHAR cHAR = result;
                return cHAR;
            }
            if (type == 2) {
                String __result__ = result.stringValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            if (type == 3) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] __result__ = bytes;
                return __result__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, bytes);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CHAR getDbCHAR(Datum data) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(data));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CHAR in_char_obj = (CHAR)data;
            CHAR db_char_obj = null;
            if (in_char_obj.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
                db_char_obj = in_char_obj;
            } else {
                try {
                    db_char_obj = new CHAR(in_char_obj.toString(), this.pickleCharacterSet);
                }
                catch (SQLException ex) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            ex.printStackTrace(pw);
                            String z = sw.toString();
                            OracleTypeCHAR.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + z);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    db_char_obj = in_char_obj;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + db_char_obj);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR cHAR = db_char_obj;
            return cHAR;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum[] cArrayToDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum[] datumArray = null;
            if (obj != null) {
                Object parray;
                if (obj instanceof char[][]) {
                    parray = (char[][])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i2 = 0; i2 < len; ++i2) {
                        datumArray[i2] = new CHAR(new String(parray[(int)beginIdx + i2 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof boolean[]) {
                    parray = (boolean[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i3 = 0; i3 < len; ++i3) {
                        datumArray[i3] = new CHAR((boolean)parray[(int)beginIdx + i3 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof short[]) {
                    parray = (short[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i4 = 0; i4 < len; ++i4) {
                        datumArray[i4] = new CHAR((int)parray[(int)beginIdx + i4 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof int[]) {
                    parray = (int[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i5 = 0; i5 < len; ++i5) {
                        datumArray[i5] = new CHAR((int)parray[(int)beginIdx + i5 - 1], this.pickleCharacterSet);
                    }
                } else if (obj instanceof long[]) {
                    parray = (long[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i6 = 0; i6 < len; ++i6) {
                        datumArray[i6] = new CHAR(new Long((long)parray[(int)beginIdx + i6 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof float[]) {
                    parray = (float[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i7 = 0; i7 < len; ++i7) {
                        datumArray[i7] = new CHAR(new Float((float)parray[(int)beginIdx + i7 - 1]), this.pickleCharacterSet);
                    }
                } else if (obj instanceof double[]) {
                    parray = (double[])obj;
                    int len = (int)(count == -1 ? (long)((char[][])parray).length : Math.min((long)((char[][])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i8 = 0; i8 < len; ++i8) {
                        datumArray[i8] = new CHAR(new Double((double)parray[(int)beginIdx + i8 - 1]), this.pickleCharacterSet);
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeCHAR.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + obj);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray2 = datumArray;
            return datumArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.length);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.length;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(out));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            out.writeInt(this.form);
            out.writeInt(this.charset);
            out.writeInt(this.length);
            out.writeInt(this.characterSemantic);
            out.writeShort(this.pickleCharaterSetId);
            out.writeShort(this.pickleNcharCharacterSet);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.form = in.readInt();
            this.charset = in.readInt();
            this.length = in.readInt();
            this.characterSemantic = in.readInt();
            this.pickleCharaterSetId = in.readShort();
            this.pickleNcharCharacterSet = in.readShort();
            this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connection = conn;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCHAR() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = this.form == 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.connection;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeCHAR.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeCHAR"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

