/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleDatabaseInstance;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleGravitateConnectionCacheThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread;
import oracle.jdbc.xa.client.OracleXADataSource;

class OracleImplicitConnectionCache {
    protected OracleDataSource cacheEnabledDS = null;
    protected String cacheName = null;
    protected OracleConnectionPoolDataSource connectionPoolDS = null;
    protected boolean fastConnectionFailoverEnabled = false;
    protected String defaultUser = null;
    protected String defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
    protected static final int ABORT_AND_CLOSE_ALL_CONNECTIONS = 32;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int cacheMinLimit = 0;
    protected int cacheMaxLimit = Integer.MAX_VALUE;
    protected int cacheInitialLimit = 0;
    protected int cacheMaxStatementsLimit = 0;
    protected Properties cacheAttributeWeights = null;
    protected int cacheInactivityTimeout = 0;
    protected int cacheTimeToLiveTimeout = 0;
    protected int cacheAbandonedConnectionTimeout = 0;
    protected int cacheLowerThresholdLimit = 20;
    protected int cachePropertyCheckInterval = 900;
    protected boolean cacheClosestConnectionMatch = false;
    protected boolean cacheValidateConnection = false;
    protected int cacheConnectionWaitTimeout = 0;
    static final String MIN_LIMIT_KEY = "MinLimit";
    static final String MAX_LIMIT_KEY = "MaxLimit";
    static final String INITIAL_LIMIT_KEY = "InitialLimit";
    static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
    static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
    static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
    static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
    static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
    static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
    static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
    static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
    static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
    static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
    static final String LOCAL_TXN_COMMIT_ON_CLOSE = "LocalTransactionCommitOnClose";
    static final int INSTANCE_GOOD = 1;
    static final int INSTANCE_UNKNOWN = 2;
    static final int INSTANCE_VIOLATING = 3;
    static final int INSTANCE_NO_DATA = 4;
    static final int INSTANCE_BLOCKED = 5;
    static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    int dbInstancePercentTotal = 0;
    boolean useGoodGroup = false;
    Vector instancesToRetireQueue = null;
    OracleDatabaseInstance instanceToRetire = null;
    int retireConnectionsCount = 0;
    int countTotal = 0;
    protected OracleConnectionCacheManager cacheManager = null;
    protected boolean disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread timeoutThread = null;
    protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
    protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
    protected int connectionsToRemove = 0;
    private HashMap userMap = null;
    Vector checkedOutConnectionList = null;
    LinkedList databaseInstancesList = null;
    int cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean isEntireServiceDownProcessed = false;
    protected int defaultUserPreFailureSize = 0;
    protected String dataSourceServiceName = null;
    protected OracleFailoverWorkerThread failoverWorkerThread = null;
    protected Random rand = null;
    protected int downEventCount = 0;
    protected int upEventCount = 0;
    protected int pendingCreationRequests = 0;
    protected int connectionClosedCount = 0;
    protected int connectionCreatedCount = 0;
    boolean cacheLocalTxnCommitOnClose = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleImplicitConnectionCache(OracleDataSource ds, Properties cacheProps) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ds) + ", " + OracleLog.argument(cacheProps));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cacheEnabledDS = ds;
            this.initializeConnectionCache();
            this.setConnectionCacheProperties(cacheProps);
            this.defaultUserPrePopulateCache(this.cacheInitialLimit);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultUserPrePopulateCache(int sz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (sz > 0) {
                String user = this.defaultUser;
                String passwd = this.defaultPassword;
                this.validateUser(user, passwd);
                OraclePooledConnection pc = null;
                for (int i2 = 0; i2 < sz; ++i2) {
                    pc = this.makeOneConnection(user, passwd);
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                    synchronized (oracleImplicitConnectionCache) {
                        if (pc != null) {
                            --this.cacheSize;
                            this.storeCacheConnection(null, pc);
                        }
                        continue;
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConnectionCache() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.userMap = new HashMap();
            this.checkedOutConnectionList = new Vector();
            if (this.cacheManager == null) {
                this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            }
            this.defaultUser = this.cacheEnabledDS.user != null && !this.cacheEnabledDS.user.startsWith("\"") ? this.cacheEnabledDS.user.toLowerCase() : this.cacheEnabledDS.user;
            this.defaultPassword = this.cacheEnabledDS.password;
            if (this.connectionPoolDS == null) {
                this.connectionPoolDS = this.cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
                this.cacheEnabledDS.copy(this.connectionPoolDS);
            }
            if (this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.rand = new Random(0L);
                this.instancesToRetireQueue = new Vector();
                ++this.cacheManager.failoverEnabledCacheCount;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUser(String user, String passwd) throws SQLException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (user != null && passwd != null) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 79);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 79);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(String user, String passwd, Properties connAttr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Connection conn;
            block47: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(connAttr));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OraclePooledConnection pc = null;
                conn = null;
                try {
                    if (this.disableConnectionRequest) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 142);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 142);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.validateUser(user, passwd);
                    if (!user.startsWith("\"")) {
                        user = user.toLowerCase();
                    }
                    if (this.getNumberOfCheckedOutConnections() < this.cacheMaxLimit) {
                        pc = this.getCacheConnection(user, passwd, connAttr);
                    }
                    if (pc == null) {
                        this.processConnectionCacheCallback();
                        if (this.cacheSize > 0) {
                            pc = this.getCacheConnection(user, passwd, connAttr);
                        }
                        if (pc == null && this.cacheConnectionWaitTimeout > 0) {
                            long localCacheConnectionWaitTimeout = (long)this.cacheConnectionWaitTimeout * 1000L;
                            long beforeWait = System.currentTimeMillis();
                            long afterWait = 0L;
                            do {
                                this.processConnectionWaitTimeout(localCacheConnectionWaitTimeout);
                                if (this.cacheSize > 0) {
                                    pc = this.getCacheConnection(user, passwd, connAttr);
                                }
                                afterWait = System.currentTimeMillis();
                                beforeWait = afterWait;
                            } while (pc == null && (localCacheConnectionWaitTimeout -= System.currentTimeMillis() - beforeWait) > 0L);
                        }
                    }
                    if (pc == null || pc.physicalConn == null || (conn = pc.getConnection()) == null) break block47;
                    if (this.cacheValidateConnection && this.testDatabaseConnection((OracleConnection)conn) != 0) {
                        ((OracleConnection)conn).close(4096);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 143);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 143);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (this.cacheAbandonedConnectionTimeout > 0) {
                        ((OracleConnection)conn).setAbandonedTimeoutEnabled(true);
                    }
                    if (this.cacheTimeToLiveTimeout > 0) {
                        ((OracleConnection)conn).setStartTime(System.currentTimeMillis());
                    }
                    OracleImplicitConnectionCache __ex__ = this;
                    synchronized (__ex__) {
                        --this.cacheSize;
                        this.checkedOutConnectionList.addElement(pc);
                    }
                }
                catch (SQLException ea) {
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                    synchronized (oracleImplicitConnectionCache) {
                        if (pc != null) {
                            --this.cacheSize;
                            this.abortConnection(pc);
                        }
                    }
                    throw ea;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + conn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = conn;
            return connection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection getCacheConnection(String user, String passwd, Properties connAttr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            OraclePooledConnection pc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(connAttr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((pc = this.retrieveCacheConnection(user, passwd, connAttr)) == null && (pc = this.makeOneConnection(user, passwd)) != null && connAttr != null && !connAttr.isEmpty()) {
                this.setUnMatchedAttributes(connAttr, pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePooledConnection oraclePooledConnection = pc;
            return oraclePooledConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OraclePooledConnection makeOneConnection(String _user, String _passwd) throws SQLException {
        OraclePooledConnection pc = null;
        boolean doMakeCacheConnection = false;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit) {
                ++this.pendingCreationRequests;
                doMakeCacheConnection = true;
            }
        }
        if (doMakeCacheConnection) {
            try {
                pc = this.makeCacheConnection(_user, _passwd);
            }
            finally {
                oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (pc != null) {
                        ++this.connectionCreatedCount;
                    }
                    --this.pendingCreationRequests;
                }
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTotalCachedConnections() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.cacheSize + this.getNumberOfCheckedOutConnections();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfCheckedOutConnections() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.checkedOutConnectionList.size();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized OraclePooledConnection retrieveCacheConnection(String user, String passwd, Properties connAttr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(connAttr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OraclePooledConnection pc = null;
            OracleConnectionCacheEntry m_userConnEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(user, passwd));
            if (m_userConnEntry != null) {
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    if (m_userConnEntry.userConnList != null) {
                        pc = this.retrieveFromConnectionList(m_userConnEntry.userConnList);
                    }
                } else if (m_userConnEntry.attrConnMap != null) {
                    String attrKey = this.buildAttrKey(connAttr);
                    Vector attrMapEntry = (Vector)m_userConnEntry.attrConnMap.get(attrKey);
                    if (attrMapEntry != null) {
                        pc = this.retrieveFromConnectionList(attrMapEntry);
                    }
                    if (pc == null && this.cacheClosestConnectionMatch) {
                        pc = this.retrieveClosestConnectionMatch(m_userConnEntry.attrConnMap, connAttr);
                    }
                    if (pc == null && m_userConnEntry.userConnList != null) {
                        pc = this.retrieveFromConnectionList(m_userConnEntry.userConnList);
                    }
                }
            }
            if (pc != null && connAttr != null && !connAttr.isEmpty()) {
                this.setUnMatchedAttributes(connAttr, pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePooledConnection oraclePooledConnection = pc;
            return oraclePooledConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection retrieveClosestConnectionMatch(HashMap attrConnMap, Properties inAttr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attrConnMap) + ", " + OracleLog.argument(inAttr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OraclePooledConnection opc = null;
            OraclePooledConnection currOpc = null;
            Vector currOpcVector = null;
            int reqMatchCount = inAttr.size();
            int reqWeightCount = 0;
            int actualWeightCount = 0;
            int currWeightCount = 0;
            int actualMatchCount = 0;
            int currMatchCount = 0;
            if (this.cacheAttributeWeights != null) {
                reqWeightCount = this.getAttributesWeightCount(inAttr, null);
            }
            if (attrConnMap != null && !attrConnMap.isEmpty()) {
                for (Map.Entry me : attrConnMap.entrySet()) {
                    Vector aList = (Vector)me.getValue();
                    Object[] aObjArr = aList.toArray();
                    int asz = aList.size();
                    for (int l2 = 0; l2 < asz; ++l2) {
                        opc = (OraclePooledConnection)aObjArr[l2];
                        if (opc.cachedConnectionAttributes == null || opc.cachedConnectionAttributes.isEmpty() || opc.cachedConnectionAttributes.size() > reqMatchCount) continue;
                        if (reqWeightCount > 0) {
                            currWeightCount = this.getAttributesWeightCount(inAttr, opc.cachedConnectionAttributes);
                            if (currWeightCount <= actualWeightCount) continue;
                            currOpc = opc;
                            actualWeightCount = currWeightCount;
                            currOpcVector = aList;
                            continue;
                        }
                        currMatchCount = this.getAttributesMatchCount(inAttr, opc.cachedConnectionAttributes);
                        if (currMatchCount <= actualMatchCount) continue;
                        currOpc = opc;
                        actualMatchCount = currMatchCount;
                        currOpcVector = aList;
                    }
                }
            }
            if (currOpcVector != null) {
                currOpcVector.remove(currOpc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + currOpc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePooledConnection oraclePooledConnection = currOpc;
            return oraclePooledConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAttributesMatchCount(Properties in, Properties curr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(curr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int matchCount = 0;
            Map.Entry<Object, Object> me2 = null;
            Object inKeyObj = null;
            Object inValueObj = null;
            for (Map.Entry<Object, Object> me2 : in.entrySet()) {
                inKeyObj = me2.getKey();
                inValueObj = me2.getValue();
                if (!curr.containsKey(inKeyObj) || !inValueObj.equals(curr.get(inKeyObj))) continue;
                ++matchCount;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + matchCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = matchCount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAttributesWeightCount(Properties inAttr, Properties currAttr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(inAttr) + ", " + OracleLog.argument(currAttr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Map.Entry<Object, Object> me2 = null;
            Object inKeyObj = null;
            Object inValueObj = null;
            int weightCount = 0;
            for (Map.Entry<Object, Object> me2 : inAttr.entrySet()) {
                inKeyObj = me2.getKey();
                inValueObj = me2.getValue();
                if (currAttr == null) {
                    if (!this.cacheAttributeWeights.containsKey(inKeyObj)) continue;
                    weightCount += Integer.parseInt((String)this.cacheAttributeWeights.get(inKeyObj));
                    continue;
                }
                if (!currAttr.containsKey(inKeyObj) || !inValueObj.equals(currAttr.get(inKeyObj))) continue;
                if (this.cacheAttributeWeights.containsKey(inKeyObj)) {
                    weightCount += Integer.parseInt((String)this.cacheAttributeWeights.get(inKeyObj));
                    continue;
                }
                ++weightCount;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + weightCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = weightCount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnMatchedAttributes(Properties inAttr, OraclePooledConnection opc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(inAttr) + ", " + OracleLog.argument(opc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (opc.unMatchedCachedConnAttr == null) {
                opc.unMatchedCachedConnAttr = new Properties();
            } else {
                opc.unMatchedCachedConnAttr.clear();
            }
            if (!this.cacheClosestConnectionMatch) {
                opc.unMatchedCachedConnAttr.putAll((Map<?, ?>)inAttr);
            } else {
                Properties curr = opc.cachedConnectionAttributes;
                Map.Entry<Object, Object> me2 = null;
                Object inKeyObj = null;
                Object inValueObj = null;
                for (Map.Entry<Object, Object> me2 : inAttr.entrySet()) {
                    inKeyObj = me2.getKey();
                    inValueObj = me2.getValue();
                    if (curr.containsKey(inKeyObj) || inValueObj.equals(curr.get(inKeyObj))) continue;
                    opc.unMatchedCachedConnAttr.put(inKeyObj, inValueObj);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection retrieveFromConnectionList(Vector list) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(list));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.retrieveFromConnectionList" + "( of Conns=" + list.size() + ", list=" + list + ")");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (list.isEmpty()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OraclePooledConnection oraclePooledConnection = null;
                return oraclePooledConnection;
            }
            OraclePooledConnection pc = null;
            if (this.fastConnectionFailoverEnabled) {
                if (this.useGoodGroup && this.databaseInstancesList != null && this.databaseInstancesList.size() > 0) {
                    LinkedList linkedList = this.databaseInstancesList;
                    synchronized (linkedList) {
                        int numInstances = this.databaseInstancesList.size();
                        OracleDatabaseInstance dbInstance = null;
                        int randomPercent = 0;
                        boolean[] tried = new boolean[numInstances];
                        int total = this.dbInstancePercentTotal;
                        block29: for (int j2 = 0; j2 < numInstances; ++j2) {
                            int percentSum = 0;
                            randomPercent = total <= 1 ? 0 : this.rand.nextInt(total - 1);
                            for (int i2 = 0; i2 < numInstances; ++i2) {
                                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                                if (tried[i2] || dbInstance.flag > 3) continue;
                                percentSum += dbInstance.percent;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache." + "retrieveFromConnectionList()" + "RandomPercent=" + randomPercent + ": percentSum=" + percentSum);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                if (randomPercent > percentSum) continue;
                                if (j2 == 0) {
                                    ++dbInstance.attemptedConnRequestCount;
                                }
                                if ((pc = this.selectConnectionFromList(list, dbInstance)) != null) break block29;
                                total -= dbInstance.percent;
                                tried[i2] = true;
                                continue block29;
                            }
                        }
                    }
                }
                int sz = list.size();
                int pos = this.rand.nextInt(sz);
                OraclePooledConnection tmpPc = null;
                for (int i3 = 0; i3 < sz; ++i3) {
                    tmpPc = (OraclePooledConnection)list.get((pos++ + sz) % sz);
                    if (tmpPc.connectionMarkedDown) continue;
                    pc = tmpPc;
                    list.remove(pc);
                    break;
                }
            } else {
                pc = (OraclePooledConnection)list.remove(0);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePooledConnection oraclePooledConnection = pc;
            return oraclePooledConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection selectConnectionFromList(Vector list, OracleDatabaseInstance dbInstance) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(list) + ", " + OracleLog.argument(dbInstance));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OraclePooledConnection pc = null;
            OraclePooledConnection tmpPc = null;
            int sz = list.size();
            for (int i2 = 0; i2 < sz; ++i2) {
                tmpPc = (OraclePooledConnection)list.get(i2);
                if (tmpPc.connectionMarkedDown || tmpPc.dataSourceDbUniqNameKey != dbInstance.databaseUniqName || tmpPc.dataSourceInstanceNameKey != dbInstance.instanceName) continue;
                pc = tmpPc;
                list.remove(pc);
                break;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB) OracleImplicitConnectionCache.selectConnectionFromList" + "(pc=" + pc + ")" + " <<< ServiceName=" + this.dataSourceServiceName + ", Connections to " + dbInstance.instanceName + " = " + dbInstance.numberOfConnectionsCount + ", Attempted Connection Requests to this instance=" + dbInstance.attemptedConnRequestCount + ", Total Connections=" + this.getTotalCachedConnections() + " >>>");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePooledConnection oraclePooledConnection = pc;
            return oraclePooledConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheConnection(OraclePooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean pcRemoved = false;
            OracleConnectionCacheEntry m_userConnEntry = pc.removeFromImplictCache(this.userMap);
            if (m_userConnEntry != null) {
                String attrKey;
                Vector attrMapEntry;
                Properties connAttr = pc.cachedConnectionAttributes;
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    if (m_userConnEntry.userConnList != null) {
                        pcRemoved = m_userConnEntry.userConnList.removeElement(pc);
                    }
                } else if (m_userConnEntry.attrConnMap != null && (attrMapEntry = (Vector)m_userConnEntry.attrConnMap.get(attrKey = this.buildAttrKey(connAttr))) != null) {
                    if (pc.unMatchedCachedConnAttr != null) {
                        pc.unMatchedCachedConnAttr.clear();
                        pc.unMatchedCachedConnAttr = null;
                    }
                    if (pc.cachedConnectionAttributes != null) {
                        pc.cachedConnectionAttributes.clear();
                        pc.cachedConnectionAttributes = null;
                    }
                    connAttr = null;
                    pcRemoved = attrMapEntry.removeElement(pc);
                }
            }
            if (pcRemoved) {
                --this.cacheSize;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForEveryCachedConnection(int task) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(task));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int repSize = 0;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                if (this.userMap != null && !this.userMap.isEmpty()) {
                    for (Map.Entry e2 : this.userMap.entrySet()) {
                        OraclePooledConnection pc;
                        OracleConnectionCacheEntry occe = (OracleConnectionCacheEntry)e2.getValue();
                        if (occe.userConnList != null && !occe.userConnList.isEmpty()) {
                            Vector uList = occe.userConnList;
                            Object[] objArr = uList.toArray();
                            for (int k2 = 0; k2 < objArr.length; ++k2) {
                                pc = (OraclePooledConnection)objArr[k2];
                                if (pc == null || !this.performPooledConnectionTask(pc, task)) continue;
                                ++repSize;
                            }
                        }
                        if (occe.attrConnMap == null || occe.attrConnMap.isEmpty()) continue;
                        for (Map.Entry me : occe.attrConnMap.entrySet()) {
                            Vector aList = (Vector)me.getValue();
                            Object[] objArr = aList.toArray();
                            for (int l2 = 0; l2 < objArr.length; ++l2) {
                                pc = (OraclePooledConnection)objArr[l2];
                                if (pc == null || !this.performPooledConnectionTask(pc, task)) continue;
                                ++repSize;
                            }
                        }
                        if (task != 1 && task != 32) continue;
                        occe.attrConnMap.clear();
                    }
                    if (task == 1 || task == 32) {
                        this.userMap.clear();
                        this.cacheSize = 0;
                    }
                }
            }
            if (repSize > 0) {
                this.defaultUserPrePopulateCache(repSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performPooledConnectionTask(OraclePooledConnection pc, int task) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(task));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean mustReplace = false;
            switch (task) {
                case 2: {
                    if (!pc.connectionMarkedDown) break;
                    pc.needToAbort = true;
                    this.closeAndRemovePooledConnection(pc);
                    break;
                }
                case 8: {
                    if (this.connectionsToRemove <= 0) break;
                    this.closeAndRemovePooledConnection(pc);
                    --this.connectionsToRemove;
                    break;
                }
                case 24: {
                    if (this.retireConnectionsCount <= 0 || this.instanceToRetire.databaseUniqName != pc.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != pc.dataSourceInstanceNameKey) break;
                    this.closeAndRemovePooledConnection(pc);
                    --this.retireConnectionsCount;
                    if (this.getTotalCachedConnections() >= this.cacheMinLimit) break;
                    mustReplace = true;
                    break;
                }
                case 4096: {
                    Connection conn = pc.getLogicalHandle();
                    if (conn == null && (conn = pc.getPhysicalHandle()) == null || this.testDatabaseConnection((OracleConnection)conn) == 0) break;
                    this.closeAndRemovePooledConnection(pc);
                    mustReplace = true;
                    break;
                }
                case 8192: {
                    this.closeAndRemovePooledConnection(pc);
                    mustReplace = true;
                    break;
                }
                case 1: {
                    this.closeAndRemovePooledConnection(pc);
                    break;
                }
                case 4: {
                    this.processInactivityTimeout(pc);
                    break;
                }
                case 16: {
                    this.setStatementCaching(pc, this.cacheMaxStatementsLimit, false);
                    break;
                }
                case 18: {
                    this.setStatementCaching(pc, this.cacheMaxStatementsLimit, true);
                    break;
                }
                case 32: {
                    this.abortConnection(pc);
                    this.closeAndRemovePooledConnection(pc);
                    break;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + mustReplace);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = mustReplace;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doForEveryCheckedOutConnection(int task) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(task));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int sz = this.checkedOutConnectionList.size();
            switch (task) {
                case 1: {
                    for (int i2 = 0; i2 < sz; ++i2) {
                        this.closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(i2), false);
                    }
                    this.checkedOutConnectionList.removeAllElements();
                    break;
                }
                case 24: {
                    for (int i3 = 0; i3 < sz && this.retireConnectionsCount > 0; ++i3) {
                        OraclePooledConnection pc = (OraclePooledConnection)this.checkedOutConnectionList.get(i3);
                        if (this.instanceToRetire.databaseUniqName != pc.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != pc.dataSourceInstanceNameKey) continue;
                        pc.closeOption = 4096;
                        this.retireConnectionsCount -= 2;
                    }
                    break;
                }
                case 32: {
                    for (int i4 = 0; i4 < sz; ++i4) {
                        OraclePooledConnection pc = null;
                        pc = (OraclePooledConnection)this.checkedOutConnectionList.get(i4);
                        this.abortConnection(pc);
                        this.closeCheckedOutConnection(pc, false);
                    }
                    this.checkedOutConnectionList.removeAllElements();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void closeCheckedOutConnection(OraclePooledConnection pc, boolean isReuse) throws SQLException {
        __ol_nanos__ = 0L;
        try {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(isReuse));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pc != null) {
                block36: {
                    conn = (OracleConnection)pc.getLogicalHandle();
                    try {
                        if (!conn.getAutoCommit() && !pc.needToAbort) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException e) {
                        if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) break block36;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.closeCheckedOutConnection():" + "rollback() - SQLException Occurred " + e.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (isReuse) {
                    savedValue = pc.localTxnCommitOnClose;
                    try {
                        pc.localTxnCommitOnClose = false;
                        conn.cleanupAndClose(true);
                    }
                    catch (SQLException e) {
                        if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl46
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.closeCheckedOutConnection" + "():close() - SQLException Occurred " + e.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    finally {
                        if (pc.localTxnCommitOnClose != savedValue) {
                            pc.localTxnCommitOnClose = savedValue;
                        }
                    }
                } else {
                    this.actualPooledConnectionClose(pc);
                }
            }
lbl46:
            // 6 sources

            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storeCacheConnection(Properties connAttr, OraclePooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            OracleConnectionCacheEntry m_userConnEntry;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connAttr) + ", " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean pcAdded = false;
            if (pc == null || pc.physicalConn == null) {
                return;
            }
            if (this.cacheInactivityTimeout > 0) {
                pc.setLastAccessedTime(System.currentTimeMillis());
            }
            if (pc.unMatchedCachedConnAttr != null) {
                pc.unMatchedCachedConnAttr.clear();
                pc.unMatchedCachedConnAttr = null;
            }
            if ((m_userConnEntry = pc.removeFromImplictCache(this.userMap)) != null) {
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    if (m_userConnEntry.userConnList == null) {
                        m_userConnEntry.userConnList = new Vector();
                    }
                    pcAdded = m_userConnEntry.userConnList.add(pc);
                } else {
                    String attrKey;
                    Vector<OraclePooledConnection> attrMapEntry;
                    pc.cachedConnectionAttributes = connAttr;
                    if (m_userConnEntry.attrConnMap == null) {
                        m_userConnEntry.attrConnMap = new HashMap();
                    }
                    if ((attrMapEntry = (Vector<OraclePooledConnection>)m_userConnEntry.attrConnMap.get(attrKey = this.buildAttrKey(connAttr))) != null) {
                        pcAdded = attrMapEntry.add(pc);
                    } else {
                        attrMapEntry = new Vector<OraclePooledConnection>();
                        pcAdded = attrMapEntry.add(pc);
                        m_userConnEntry.attrConnMap.put(attrKey, attrMapEntry);
                    }
                }
            } else {
                m_userConnEntry = new OracleConnectionCacheEntry();
                pc.addToImplicitCache(this.userMap, m_userConnEntry);
                if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                    Vector<OraclePooledConnection> userMapEntry = new Vector<OraclePooledConnection>();
                    pcAdded = userMapEntry.add(pc);
                    m_userConnEntry.userConnList = userMapEntry;
                } else {
                    String attrKey = this.buildAttrKey(connAttr);
                    pc.cachedConnectionAttributes = connAttr;
                    HashMap userMapEntry = new HashMap();
                    Vector<OraclePooledConnection> attrMapEntry = new Vector<OraclePooledConnection>();
                    pcAdded = attrMapEntry.add(pc);
                    userMapEntry.put(attrKey, attrMapEntry);
                    m_userConnEntry.attrConnMap = userMapEntry;
                }
            }
            if (pcAdded) {
                ++this.cacheSize;
            }
            if (this.cacheConnectionWaitTimeout > 0) {
                this.notifyAll();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildAttrKey(Properties connAttr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connAttr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int sz = connAttr.keySet().size();
            Object[] origArray = connAttr.keySet().toArray();
            boolean isChanged = true;
            StringBuffer buf = new StringBuffer();
            while (isChanged) {
                isChanged = false;
                for (i2 = 0; i2 < sz - 1; ++i2) {
                    if (((String)origArray[i2]).compareTo((String)origArray[i2 + 1]) <= 0) continue;
                    isChanged = true;
                    Object tempObj = origArray[i2];
                    origArray[i2] = origArray[i2 + 1];
                    origArray[i2 + 1] = tempObj;
                }
            }
            for (i2 = 0; i2 < sz; ++i2) {
                buf.append(origArray[i2] + ATTRKEY_DELIM + connAttr.get(origArray[i2]));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + buf.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OraclePooledConnection makeCacheConnection(String user, String passwd) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Object object;
            OraclePooledConnection pc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(passwd));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((pc = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(user, passwd)) != null) {
                if (this.cacheMaxStatementsLimit > 0) {
                    this.setStatementCaching(pc, this.cacheMaxStatementsLimit, true);
                }
                pc.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
                pc.cachedConnectionAttributes = new Properties();
                if (this.fastConnectionFailoverEnabled) {
                    this.initFailoverParameters(pc);
                }
                object = this;
                synchronized (object) {
                    ++this.cacheSize;
                    if (this.fastConnectionFailoverEnabled && this.runtimeLoadBalancingThread == null) {
                        this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
                        this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
                    }
                }
                pc.localTxnCommitOnClose = this.cacheLocalTxnCommitOnClose;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = pc;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatementCaching(OraclePooledConnection pc, int maxLimit, boolean flag) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(maxLimit) + ", " + OracleLog.argument(flag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (maxLimit > 0) {
                pc.setStatementCacheSize(maxLimit);
            }
            pc.setImplicitCachingEnabled(flag);
            pc.setExplicitCachingEnabled(flag);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reusePooledConnection(PooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            OraclePooledConnection opc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((opc = (OraclePooledConnection)pc) != null && opc.physicalConn != null) {
                if (opc.localTxnCommitOnClose) {
                    opc.physicalConn.commit();
                }
                this.storeCacheConnection(opc.cachedConnectionAttributes, opc);
                this.checkedOutConnectionList.removeElement(opc);
                opc.logicalHandle = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePooledConnection(PooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pc != null) {
                this.actualPooledConnectionClose((OraclePooledConnection)pc);
                if (((OraclePooledConnection)pc).closeOption == 4096) {
                    this.checkedOutConnectionList.removeElement(pc);
                }
                pc = null;
                if (this.getTotalCachedConnections() < this.cacheMinLimit) {
                    this.defaultUserPrePopulateCache(1);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshCacheConnections(int mode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.doForEveryCachedConnection(mode);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitializeCacheConnections(Properties cp) throws SQLException {
        int connectionsToCreate = 0;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cp));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                this.defaultUser = this.cacheEnabledDS.user;
                this.defaultPassword = this.cacheEnabledDS.password;
                this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
                this.cleanupTimeoutThread();
                this.doForEveryCheckedOutConnection(1);
                int origCacheInitialLimit = this.cacheInitialLimit;
                int origCacheMaxLimit = this.cacheMaxLimit;
                int origCacheMaxStatementsLimit = this.cacheMaxStatementsLimit;
                this.setConnectionCacheProperties(cp);
                if (this.cacheInitialLimit > origCacheInitialLimit) {
                    connectionsToCreate = this.cacheInitialLimit - origCacheInitialLimit;
                }
                if (origCacheMaxLimit != Integer.MAX_VALUE && this.cacheMaxLimit < origCacheMaxLimit && this.cacheSize > this.cacheMaxLimit) {
                    this.connectionsToRemove = this.cacheSize - this.cacheMaxLimit;
                    this.doForEveryCachedConnection(8);
                    this.connectionsToRemove = 0;
                }
                if (this.cacheMaxStatementsLimit != origCacheMaxStatementsLimit) {
                    if (this.cacheMaxStatementsLimit == 0) {
                        this.doForEveryCachedConnection(16);
                    } else {
                        this.doForEveryCachedConnection(18);
                    }
                }
            }
            if (connectionsToCreate > 0) {
                this.defaultUserPrePopulateCache(connectionsToCreate);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setConnectionCacheProperties(Properties cp) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cp));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                if (cp != null) {
                    Properties caw;
                    String inVal = null;
                    inVal = cp.getProperty(MIN_LIMIT_KEY);
                    if (inVal != null && (this.cacheMinLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheMinLimit = 0;
                    }
                    if ((inVal = cp.getProperty(MAX_LIMIT_KEY)) != null && (this.cacheMaxLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheMaxLimit = Integer.MAX_VALUE;
                    }
                    if (this.cacheMaxLimit < this.cacheMinLimit) {
                        this.cacheMinLimit = this.cacheMaxLimit;
                    }
                    if ((inVal = cp.getProperty(INITIAL_LIMIT_KEY)) != null && (this.cacheInitialLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheInitialLimit = 0;
                    }
                    if (this.cacheInitialLimit > this.cacheMaxLimit) {
                        this.cacheInitialLimit = this.cacheMaxLimit;
                    }
                    if ((inVal = cp.getProperty(MAX_STATEMENTS_LIMIT_KEY)) != null && (this.cacheMaxStatementsLimit = Integer.parseInt(inVal)) < 0) {
                        this.cacheMaxStatementsLimit = 0;
                    }
                    if ((caw = (Properties)cp.get(ATTRIBUTE_WEIGHTS_KEY)) != null) {
                        Map.Entry<Object, Object> me2 = null;
                        int weight = 0;
                        Object inKeyObj = null;
                        for (Map.Entry<Object, Object> me2 : caw.entrySet()) {
                            inKeyObj = me2.getKey();
                            inVal = (String)caw.get(inKeyObj);
                            if (inVal == null || (weight = Integer.parseInt(inVal)) >= 0) continue;
                            caw.put(inKeyObj, DEFAULT_ATTRIBUTE_WEIGHT);
                        }
                        if (this.cacheAttributeWeights == null) {
                            this.cacheAttributeWeights = new Properties();
                        }
                        this.cacheAttributeWeights.putAll((Map<?, ?>)caw);
                    }
                    if ((inVal = cp.getProperty(INACTIVITY_TIMEOUT_KEY)) != null && (this.cacheInactivityTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheInactivityTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(TIME_TO_LIVE_TIMEOUT_KEY)) != null && (this.cacheTimeToLiveTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheTimeToLiveTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(ABANDONED_CONNECTION_TIMEOUT_KEY)) != null && (this.cacheAbandonedConnectionTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheAbandonedConnectionTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(LOWER_THRESHOLD_LIMIT_KEY)) != null) {
                        this.cacheLowerThresholdLimit = Integer.parseInt(inVal);
                        if (this.cacheLowerThresholdLimit < 0 || this.cacheLowerThresholdLimit > 100) {
                            this.cacheLowerThresholdLimit = 20;
                        }
                    }
                    if ((inVal = cp.getProperty(PROPERTY_CHECK_INTERVAL_KEY)) != null && (this.cachePropertyCheckInterval = Integer.parseInt(inVal)) < 0) {
                        this.cachePropertyCheckInterval = 900;
                    }
                    if ((inVal = cp.getProperty(VALIDATE_CONNECTION_KEY)) != null) {
                        this.cacheValidateConnection = Boolean.valueOf(inVal);
                    }
                    if ((inVal = cp.getProperty(CLOSEST_CONNECTION_MATCH_KEY)) != null) {
                        this.cacheClosestConnectionMatch = Boolean.valueOf(inVal);
                    }
                    if ((inVal = cp.getProperty(CONNECTION_WAIT_TIMEOUT_KEY)) != null && (this.cacheConnectionWaitTimeout = Integer.parseInt(inVal)) < 0) {
                        this.cacheConnectionWaitTimeout = 0;
                    }
                    if ((inVal = cp.getProperty(LOCAL_TXN_COMMIT_ON_CLOSE)) != null) {
                        this.cacheLocalTxnCommitOnClose = inVal.equalsIgnoreCase("true");
                    }
                } else {
                    this.cacheMinLimit = 0;
                    this.cacheMaxLimit = Integer.MAX_VALUE;
                    this.cacheInitialLimit = 0;
                    this.cacheMaxStatementsLimit = 0;
                    this.cacheAttributeWeights = null;
                    this.cacheInactivityTimeout = 0;
                    this.cacheTimeToLiveTimeout = 0;
                    this.cacheAbandonedConnectionTimeout = 0;
                    this.cacheLowerThresholdLimit = 20;
                    this.cachePropertyCheckInterval = 900;
                    this.cacheClosestConnectionMatch = false;
                    this.cacheValidateConnection = false;
                    this.cacheConnectionWaitTimeout = 0;
                    this.cacheLocalTxnCommitOnClose = false;
                }
                if ((this.cacheInactivityTimeout > 0 || this.cacheTimeToLiveTimeout > 0 || this.cacheAbandonedConnectionTimeout > 0) && this.cachePropertyCheckInterval > 0) {
                    if (this.timeoutThread == null) {
                        this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
                    }
                    this.cacheManager.checkAndStartThread(this.timeoutThread);
                }
                if (this.cachePropertyCheckInterval == 0) {
                    this.cleanupTimeoutThread();
                }
            }
            catch (NumberFormatException nfe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 139 + "" + "OracleImplicitConnectionCache:setConnectionCacheProperties()" + " - NumberFormatException Occurred :" + nfe.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 139, "OracleImplicitConnectionCache:setConnectionCacheProperties() - NumberFormatException Occurred :" + nfe.getMessage());
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getConnectionCacheProperties() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Properties cacheProp = new Properties();
            cacheProp.setProperty(MIN_LIMIT_KEY, String.valueOf(this.cacheMinLimit));
            cacheProp.setProperty(MAX_LIMIT_KEY, String.valueOf(this.cacheMaxLimit));
            cacheProp.setProperty(INITIAL_LIMIT_KEY, String.valueOf(this.cacheInitialLimit));
            cacheProp.setProperty(MAX_STATEMENTS_LIMIT_KEY, String.valueOf(this.cacheMaxStatementsLimit));
            if (this.cacheAttributeWeights != null) {
                cacheProp.put(ATTRIBUTE_WEIGHTS_KEY, this.cacheAttributeWeights);
            } else {
                cacheProp.setProperty(ATTRIBUTE_WEIGHTS_KEY, "NULL");
            }
            cacheProp.setProperty(INACTIVITY_TIMEOUT_KEY, String.valueOf(this.cacheInactivityTimeout));
            cacheProp.setProperty(TIME_TO_LIVE_TIMEOUT_KEY, String.valueOf(this.cacheTimeToLiveTimeout));
            cacheProp.setProperty(ABANDONED_CONNECTION_TIMEOUT_KEY, String.valueOf(this.cacheAbandonedConnectionTimeout));
            cacheProp.setProperty(LOWER_THRESHOLD_LIMIT_KEY, String.valueOf(this.cacheLowerThresholdLimit));
            cacheProp.setProperty(PROPERTY_CHECK_INTERVAL_KEY, String.valueOf(this.cachePropertyCheckInterval));
            cacheProp.setProperty(CONNECTION_WAIT_TIMEOUT_KEY, String.valueOf(this.cacheConnectionWaitTimeout));
            cacheProp.setProperty(VALIDATE_CONNECTION_KEY, String.valueOf(this.cacheValidateConnection));
            cacheProp.setProperty(CLOSEST_CONNECTION_MATCH_KEY, String.valueOf(this.cacheClosestConnectionMatch));
            cacheProp.setProperty(LOCAL_TXN_COMMIT_ON_CLOSE, String.valueOf(this.cacheLocalTxnCommitOnClose));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cacheProp);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties properties = cacheProp;
            return properties;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int testDatabaseConnection(OracleConnection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = conn.pingDatabase();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeConnectionCache(int mode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cleanupTimeoutThread();
            this.purgeCacheConnections(true, mode);
            this.connectionPoolDS = null;
            this.cacheEnabledDS = null;
            this.checkedOutConnectionList = null;
            this.userMap = null;
            this.cacheManager = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void disableConnectionCache() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.disableConnectionRequest = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enableConnectionCache() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.disableConnectionRequest = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFailoverParameters(OraclePooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String instanceNameKey = null;
            String DBUniqNameKey = null;
            String val = null;
            Properties prop = ((OracleConnection)pc.getPhysicalHandle()).getServerSessionInfo();
            val = prop.getProperty("INSTANCE_NAME");
            if (val != null) {
                instanceNameKey = pc.dataSourceInstanceNameKey = val.trim().toLowerCase().intern();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Instance Name = " + val);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((val = prop.getProperty("SERVER_HOST")) != null) {
                pc.dataSourceHostNameKey = val.trim().toLowerCase().intern();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Host Name = " + val);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((val = prop.getProperty("SERVICE_NAME")) != null) {
                this.dataSourceServiceName = val.trim();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Service Name = " + val);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((val = prop.getProperty("DATABASE_NAME")) != null) {
                DBUniqNameKey = pc.dataSourceDbUniqNameKey = val.trim().toLowerCase().intern();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "DBUniq Name = " + val);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.databaseInstancesList == null) {
                this.databaseInstancesList = new LinkedList();
            }
            int numInstances = this.databaseInstancesList.size();
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance dbInstance = null;
                boolean found = false;
                for (int i2 = 0; i2 < numInstances; ++i2) {
                    dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    if (dbInstance.databaseUniqName != DBUniqNameKey || dbInstance.instanceName != instanceNameKey) continue;
                    ++dbInstance.numberOfConnectionsCount;
                    found = true;
                    break;
                }
                if (!found) {
                    OracleDatabaseInstance tmpInstance = new OracleDatabaseInstance(DBUniqNameKey, instanceNameKey);
                    ++tmpInstance.numberOfConnectionsCount;
                    this.databaseInstancesList.add(tmpInstance);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFailoverEvent(int eventType, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (eventType == 256) {
                if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                    ++this.downEventCount;
                    this.markDownLostConnections(true, false, instNameKey, dbUniqNameKey, hostNameKey, status);
                    this.cleanupFailoverConnections(true, false, instNameKey, dbUniqNameKey, hostNameKey, status);
                } else if (status.equalsIgnoreCase("up")) {
                    block35: {
                        if (this.downEventCount > 0) {
                            ++this.upEventCount;
                        }
                        try {
                            this.processUpEvent(card);
                        }
                        catch (Exception e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block35;
                            try {
                                OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:processFailoverEvent()" + " - Exception Occurred :" + e2.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                    this.isEntireServiceDownProcessed = false;
                }
            } else if (eventType == 512 && status.equalsIgnoreCase("nodedown")) {
                this.markDownLostConnections(false, true, instNameKey, dbUniqNameKey, hostNameKey, status);
                this.cleanupFailoverConnections(false, true, instNameKey, dbUniqNameKey, hostNameKey, status);
            } else if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:processFailoverEvent UnKnown " + "Event:" + eventType);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void processUpEvent(int card) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean isRecreate;
            int connectionsToLoadBalance;
            int selectedConnections;
            block38: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(card));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                selectedConnections = 0;
                connectionsToLoadBalance = 0;
                int totalConnections = this.getTotalCachedConnections();
                isRecreate = false;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                // MONITORENTER : oracleImplicitConnectionCache
                if (card <= 1) {
                    card = 2;
                }
                if ((selectedConnections = this.downEventCount == 0 && this.upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0 ? (int)((double)this.cacheSize * 0.25) : this.defaultUserPreFailureSize) <= 0) {
                    if (this.getNumberOfDefaultUserConnections() > 0) {
                        connectionsToLoadBalance = (int)((double)this.cacheSize * 0.25);
                        isRecreate = true;
                        break block38;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                                return;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        // MONITOREXIT : oracleImplicitConnectionCache
                        return;
                    }
                }
                connectionsToLoadBalance = selectedConnections / card;
                if (connectionsToLoadBalance + totalConnections > this.cacheMaxLimit) {
                    isRecreate = true;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.processUpEvent()" + "selectedConnections=" + selectedConnections + ": connectionsToLoadBalance=" + connectionsToLoadBalance);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.downEventCount == this.upEventCount) {
                this.defaultUserPreFailureSize = 0;
                this.downEventCount = 0;
                this.upEventCount = 0;
            }
            // MONITOREXIT : oracleImplicitConnectionCache
            if (connectionsToLoadBalance > 0) {
                this.loadBalanceConnections(connectionsToLoadBalance, isRecreate);
            }
            if (!TRACE) return;
            if (!OracleLog.recursiveEnter()) return;
            try {
                OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                return;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadBalanceConnections(int connectionsToLoadBalance, boolean isRecreate) throws SQLException {
        __ol_nanos__ = 0L;
        try {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connectionsToLoadBalance) + ", " + OracleLog.argument(isRecreate));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (isRecreate) {
                this.connectionsToRemove = connectionsToLoadBalance;
                this.doForEveryCachedConnection(8);
                this.connectionsToRemove = 0;
            }
            if (connectionsToLoadBalance <= 10) {
                try {
                    this.defaultUserPrePopulateCache(connectionsToLoadBalance);
                }
                catch (Exception e) {
                    if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl41
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:loadBalanceConnections():" + "defaultUserPrePopulateCache() - Exception Occurred :" + e.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            } else {
                val = (int)((double)connectionsToLoadBalance * 0.25);
                for (i = 0; i < 4; ++i) {
                    try {
                        this.defaultUserPrePopulateCache(val);
                        continue;
                    }
                    catch (Exception e) {
                        if (!OracleImplicitConnectionCache.TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:loadBalanceConnections()" + ":defaultUserPrePopulateCache() - Exception Occurred :" + e.getMessage());
                            continue;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
lbl41:
            // 4 sources

            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (OracleImplicitConnectionCache.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfDefaultUserConnections() {
        long __ol_nanos__ = 0L;
        try {
            OracleConnectionCacheEntry occe;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int defaultUserConnections = 0;
            if (this.userMap != null && !this.userMap.isEmpty() && (occe = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(this.defaultUser, this.defaultPassword))) != null && occe.userConnList != null && !occe.userConnList.isEmpty()) {
                defaultUserConnections = occe.userConnList.size();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + defaultUserConnections);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = defaultUserConnections;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void markDownLostConnections(boolean serviceDownEvent, boolean hostDownEvent, String instNameKey, String dbUniqNameKey, String hostNameKey, String status) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(serviceDownEvent) + ", " + OracleLog.argument(hostDownEvent) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isEntireServiceDownProcessed) {
                if (this.userMap != null && !this.userMap.isEmpty()) {
                    Iterator i2 = this.userMap.entrySet().iterator();
                    while (i2.hasNext()) {
                        OracleConnectionCacheEntry occe;
                        boolean isDefaultUser = false;
                        Map.Entry e2 = i2.next();
                        String defaultKey = null;
                        if (this.defaultUser != null && this.defaultPassword != null) {
                            defaultKey = this.defaultUser + this.defaultPassword;
                        }
                        if (defaultKey != null && defaultKey.equalsIgnoreCase((String)e2.getKey())) {
                            isDefaultUser = true;
                        }
                        if ((occe = (OracleConnectionCacheEntry)e2.getValue()) != null && occe.userConnList != null && !occe.userConnList.isEmpty()) {
                            boolean markedDown = false;
                            for (OraclePooledConnection pc : occe.userConnList) {
                                if (serviceDownEvent) {
                                    markedDown = this.markDownConnectionsForServiceEvent(instNameKey, dbUniqNameKey, pc);
                                } else if (hostDownEvent) {
                                    markedDown = this.markDownConnectionsForHostEvent(hostNameKey, pc);
                                }
                                if (!markedDown || !isDefaultUser) continue;
                                ++this.defaultUserPreFailureSize;
                            }
                        }
                        if (occe == null || occe.attrConnMap == null || occe.attrConnMap.isEmpty()) continue;
                        for (Map.Entry me : occe.attrConnMap.entrySet()) {
                            for (OraclePooledConnection pc : (Vector)me.getValue()) {
                                if (serviceDownEvent) {
                                    this.markDownConnectionsForServiceEvent(instNameKey, dbUniqNameKey, pc);
                                    continue;
                                }
                                if (!hostDownEvent) continue;
                                this.markDownConnectionsForHostEvent(hostNameKey, pc);
                            }
                        }
                    }
                }
                if (instNameKey == null) {
                    this.isEntireServiceDownProcessed = true;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markDownConnectionsForServiceEvent(String instanceNameKey, String dbUniqNameKey, OraclePooledConnection pc) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(instanceNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean markedDown = false;
            if (instanceNameKey == null || dbUniqNameKey == pc.dataSourceDbUniqNameKey && instanceNameKey == pc.dataSourceInstanceNameKey) {
                pc.connectionMarkedDown = true;
                markedDown = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + markedDown);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = markedDown;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markDownConnectionsForHostEvent(String hostNameKey, OraclePooledConnection pc) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean markedDown = false;
            if (hostNameKey == pc.dataSourceHostNameKey) {
                pc.connectionMarkedDown = true;
                pc.needToAbort = true;
                markedDown = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + markedDown);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = markedDown;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanupFailoverConnections(boolean serviceDownEvent, boolean hostDownEvent, String instNameKey, String dbUniqNameKey, String hostNameKey, String status) {
        long __ol_nanos__ = 0L;
        try {
            int sz;
            Object[] objArr;
            block43: {
                int k2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(serviceDownEvent) + ", " + OracleLog.argument(hostDownEvent) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OraclePooledConnection pc = null;
                objArr = this.checkedOutConnectionList.toArray();
                sz = this.checkedOutConnectionList.size();
                OraclePooledConnection[] abortedConnections = new OraclePooledConnection[sz];
                int abortedConnectionsCount = 0;
                for (k2 = 0; k2 < sz; ++k2) {
                    try {
                        pc = (OraclePooledConnection)objArr[k2];
                        if ((!serviceDownEvent || instNameKey != null && instNameKey != pc.dataSourceInstanceNameKey || dbUniqNameKey != pc.dataSourceDbUniqNameKey) && (!hostDownEvent || hostNameKey != pc.dataSourceHostNameKey)) continue;
                        if (pc.isSameUser(this.defaultUser, this.defaultPassword) && pc.cachedConnectionAttributes != null && pc.cachedConnectionAttributes.isEmpty()) {
                            ++this.defaultUserPreFailureSize;
                        }
                        this.checkedOutConnectionList.removeElement(pc);
                        this.abortConnection(pc);
                        pc.needToAbort = true;
                        abortedConnections[abortedConnectionsCount++] = pc;
                        continue;
                    }
                    catch (Exception e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:cleanupFailoverConnections()" + "- Exception Occurred :" + e2.getMessage());
                            continue;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                for (k2 = 0; k2 < abortedConnectionsCount; ++k2) {
                    try {
                        this.closeCheckedOutConnection(abortedConnections[k2], false);
                        continue;
                    }
                    catch (SQLException e3) {
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:cleanupFailoverConnections" + "():closeCheckedOutConnection() - Exception Occurred :" + e3.getMessage());
                            continue;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (this.checkedOutConnectionList.size() < sz && this.cacheConnectionWaitTimeout > 0) {
                    this.notifyAll();
                }
                try {
                    this.doForEveryCachedConnection(2);
                }
                catch (SQLException e4) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block43;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:cleanupFailoverConnections()" + ":doForEveryCachedConnection() - Exception Occurred :" + e4.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (this.databaseInstancesList != null && (sz = this.databaseInstancesList.size()) > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    OracleDatabaseInstance dbInstance = null;
                    objArr = this.databaseInstancesList.toArray();
                    for (int k3 = 0; k3 < sz; ++k3) {
                        dbInstance = (OracleDatabaseInstance)objArr[k3];
                        if (dbInstance.databaseUniqName != dbUniqNameKey || dbInstance.instanceName != instNameKey) continue;
                        if (dbInstance.flag <= 3) {
                            this.dbInstancePercentTotal -= dbInstance.percent;
                        }
                        this.databaseInstancesList.remove(dbInstance);
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zapRLBInfo() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.databaseInstancesList.clear();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pc != null) {
                if (pc.needToAbort) {
                    this.abortConnection(pc);
                }
                this.actualPooledConnectionClose(pc);
                this.removeCacheConnection(pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortConnection(OraclePooledConnection pc) {
        block19: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    ((OracleConnection)pc.getPhysicalHandle()).abort();
                }
                catch (Exception ex) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block19;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleImplicitConnectionCache:abortConnection()" + " - Exception Occurred :" + ex.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualPooledConnectionClose(OraclePooledConnection pc) throws SQLException {
        block24: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                int sz = 0;
                if (this.databaseInstancesList != null && (sz = this.databaseInstancesList.size()) > 0) {
                    LinkedList linkedList = this.databaseInstancesList;
                    synchronized (linkedList) {
                        OracleDatabaseInstance dbInstance = null;
                        for (int i2 = 0; i2 < sz; ++i2) {
                            dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                            if (dbInstance.databaseUniqName != pc.dataSourceDbUniqNameKey || dbInstance.instanceName != pc.dataSourceInstanceNameKey) continue;
                            if (dbInstance.numberOfConnectionsCount <= 0) break;
                            --dbInstance.numberOfConnectionsCount;
                            break;
                        }
                    }
                }
                try {
                    ++this.connectionClosedCount;
                    pc.close();
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block24;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:actualPooledConnectionClose()" + " - Exception Occurred :" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCacheTimeToLiveTimeout() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheTimeToLiveTimeout);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.cacheTimeToLiveTimeout;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCacheInactivityTimeout() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheInactivityTimeout);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.cacheInactivityTimeout;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCachePropertyCheckInterval() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cachePropertyCheckInterval);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.cachePropertyCheckInterval;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCacheAbandonedTimeout() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheAbandonedConnectionTimeout);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.cacheAbandonedConnectionTimeout;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processConnectionCacheCallback() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            float cachePct = (float)this.cacheMaxLimit / 100.0f;
            int expectedCacheSize = (int)((float)this.cacheLowerThresholdLimit * cachePct);
            this.releaseBasedOnPriority(1024, expectedCacheSize);
            if (this.cacheSize < expectedCacheSize) {
                this.releaseBasedOnPriority(512, expectedCacheSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBasedOnPriority(int priority, int expCacheSz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(priority) + ", " + OracleLog.argument(expCacheSz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object[] objArr = this.checkedOutConnectionList.toArray();
            for (int i2 = 0; i2 < objArr.length && this.cacheSize < expCacheSz; ++i2) {
                OracleConnectionCacheCallback occc;
                OraclePooledConnection pc = (OraclePooledConnection)objArr[i2];
                OracleConnection conn = null;
                if (pc != null) {
                    conn = (OracleConnection)pc.getLogicalHandle();
                }
                if (conn == null || (occc = conn.getConnectionCacheCallbackObj()) == null || conn.getConnectionCacheCallbackFlag() != 2 && conn.getConnectionCacheCallbackFlag() != 4 || priority != conn.getConnectionReleasePriority()) continue;
                Object userObj = conn.getConnectionCacheCallbackPrivObj();
                occc.releaseConnection(conn, userObj);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processConnectionWaitTimeout(long waitTimeout) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            block23: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(waitTimeout));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    this.wait(waitTimeout);
                }
                catch (InterruptedException ea) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block23;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:processConnectionWaitTimeout()" + " -Got an InterruptedException:" + ea.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInactivityTimeout(OraclePooledConnection pc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long lastAccessedTime = pc.getLastAccessedTime();
            long currentTime = System.currentTimeMillis();
            if (this.getTotalCachedConnections() > this.cacheMinLimit && currentTime - lastAccessedTime > (long)(this.cacheInactivityTimeout * 1000)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.processInactivityTimeout()" + ":PooledConnection in cache closed:" + pc);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.closeAndRemovePooledConnection(pc);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTimeoutThread() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.timeoutThread != null) {
                this.timeoutThread.timeToLive = false;
                if (this.timeoutThread.isSleeping) {
                    this.timeoutThread.interrupt();
                }
                this.timeoutThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeCacheConnections(boolean cleanupCheckedOutConnections, int mode) {
        long __ol_nanos__ = 0L;
        try {
            block24: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cleanupCheckedOutConnections) + ", " + OracleLog.argument(mode));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (cleanupCheckedOutConnections) {
                        this.doForEveryCheckedOutConnection(mode);
                    }
                    this.doForEveryCachedConnection(mode);
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block24;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:purgeCacheConnections() " + "- Got an Exception:" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDatabaseInstance(String dbUniqNameKey, String instNameKey, int percent, int flag) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(percent) + ", " + OracleLog.argument(flag));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.databaseInstancesList == null) {
                this.databaseInstancesList = new LinkedList();
            }
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                int numInstances = this.databaseInstancesList.size();
                boolean updated = false;
                for (int i2 = 0; i2 < numInstances; ++i2) {
                    OracleDatabaseInstance dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    if (dbInstance.databaseUniqName != dbUniqNameKey || dbInstance.instanceName != instNameKey) continue;
                    dbInstance.percent = percent;
                    dbInstance.flag = flag;
                    updated = true;
                    break;
                }
                if (!updated) {
                    OracleDatabaseInstance tmpInstance = new OracleDatabaseInstance(dbUniqNameKey, instNameKey);
                    tmpInstance.percent = percent;
                    tmpInstance.flag = flag;
                    this.databaseInstancesList.add(tmpInstance);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDatabaseInstances() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleDatabaseInstance dbInstance = null;
            if (this.databaseInstancesList != null) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    int i2;
                    int goodGroupSum = 0;
                    boolean resetDBInstanceValues = false;
                    this.useGoodGroup = false;
                    int numInstances = this.databaseInstancesList.size();
                    for (i2 = 0; i2 < numInstances; ++i2) {
                        dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                        if (dbInstance.flag <= 3) {
                            goodGroupSum += dbInstance.percent;
                        }
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB) OracleImplicitConnectionCache." + "processDatabaseInstances:" + " <<< ServiceName=" + this.dataSourceServiceName + ", Connections to " + dbInstance.instanceName + " = " + dbInstance.numberOfConnectionsCount + ", Attempted Connection" + " Requests to this instance=" + dbInstance.attemptedConnRequestCount + ", Total Connections=" + this.getTotalCachedConnections() + " >>>");
                            continue;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (goodGroupSum > 0) {
                        this.dbInstancePercentTotal = goodGroupSum;
                        this.useGoodGroup = true;
                    }
                    if (numInstances > 1) {
                        for (i2 = 0; i2 < numInstances; ++i2) {
                            dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                            this.countTotal += dbInstance.attemptedConnRequestCount;
                        }
                        if (this.countTotal > numInstances * 1000) {
                            for (i2 = 0; i2 < numInstances; ++i2) {
                                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                                float ACRRatio = (float)dbInstance.attemptedConnRequestCount / (float)this.countTotal;
                                float connRatio = (float)dbInstance.numberOfConnectionsCount / (float)this.getTotalCachedConnections();
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache." + "processDatabaseInstances() \n Total ACR count since last" + " gravitation=" + this.countTotal + "\nNumberofInstances=" + numInstances + "\nInstanceName=" + dbInstance.instanceName + "\nAttemptedConnectionRequestRatio=" + ACRRatio + "\nConnectionRequestRatio=" + connRatio);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                if (!(connRatio > ACRRatio * 2.0f)) continue;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache." + "processDatabaseInstances: For Instance being retired::" + "\nInstanceName=" + dbInstance.instanceName + "\nAttemptedConnectionRequestRatio=" + ACRRatio + "\nConnectionRequestRatio=" + connRatio);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                if ((int)((double)dbInstance.numberOfConnectionsCount * 0.25) >= 1) {
                                    this.instancesToRetireQueue.addElement(dbInstance);
                                }
                                resetDBInstanceValues = true;
                            }
                            if (resetDBInstanceValues) {
                                for (i2 = 0; i2 < numInstances; ++i2) {
                                    dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                                    dbInstance.attemptedConnRequestCount = 0;
                                }
                                resetDBInstanceValues = false;
                            }
                        }
                    }
                }
                if (this.instancesToRetireQueue.size() > 0) {
                    if (this.gravitateCacheThread != null) {
                        block52: {
                            try {
                                this.gravitateCacheThread.interrupt();
                                this.gravitateCacheThread.join();
                            }
                            catch (InterruptedException ie) {
                                if (!TRACE || !OracleLog.recursiveEnter()) break block52;
                                try {
                                    OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache:processDatabaseInstances" + "() - Got an InterruptedException:" + ie.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                        }
                        this.gravitateCacheThread = null;
                    }
                    this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
                    this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gravitateCache() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            while (this.instancesToRetireQueue.size() > 0) {
                block38: {
                    this.instanceToRetire = (OracleDatabaseInstance)this.instancesToRetireQueue.remove(0);
                    this.retireConnectionsCount = (int)((double)this.instanceToRetire.numberOfConnectionsCount * 0.25);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache() :" + " Available conns to retire from: " + this.instanceToRetire.instanceName + " = " + this.retireConnectionsCount);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    try {
                        this.doForEveryCachedConnection(24);
                    }
                    catch (SQLException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block38;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache():" + "doForEveryCachedConnection() - Got a SQLException:" + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (this.retireConnectionsCount <= 0) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache():" + " checkedout conns to retire from: " + this.instanceToRetire.instanceName + " = " + this.retireConnectionsCount);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                try {
                    this.doForEveryCheckedOutConnection(24);
                }
                catch (SQLException e3) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.gravitateCache():" + "doForEveryCheckedOutConnection() - Got an SQLException:" + e3.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            this.retireConnectionsCount = 0;
            this.instanceToRetire = null;
            this.countTotal = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupRLBThreads() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.gravitateCacheThread != null) {
                block30: {
                    try {
                        this.gravitateCacheThread.interrupt();
                        this.gravitateCacheThread.join();
                    }
                    catch (InterruptedException ie) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block30;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.cleanupRLBThreads()" + " - Got an InterruptedException:" + ie.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                this.gravitateCacheThread = null;
            }
            if (this.runtimeLoadBalancingThread != null) {
                block31: {
                    try {
                        this.runtimeLoadBalancingThread.interrupt();
                    }
                    catch (Exception e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block31;
                        try {
                            OracleImplicitConnectionCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleImplicitConnectionCache.cleanupRLBThreads()" + " - Got an Exception:" + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                this.runtimeLoadBalancingThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getStatistics() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(2);
            map.put("PhysicalConnectionClosedCount", new Integer(this.connectionClosedCount));
            map.put("PhysicalConnectionCreatedCount", new Integer(this.connectionCreatedCount));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + map);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            HashMap<String, Integer> hashMap = map;
            return hashMap;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

