/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oicc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oicc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.implicitCache = oicc;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long threadTTLTimeout = 0L;
            long threadInactivityTimeout = 0L;
            long threadAbandonedTimeout = 0L;
            while (this.timeToLive) {
                try {
                    if (this.timeToLive && (threadTTLTimeout = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                        this.runTimeToLiveTimeout(threadTTLTimeout);
                    }
                    if (this.timeToLive && (threadInactivityTimeout = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                        this.runInactivityTimeout();
                    }
                    if (this.timeToLive && (threadAbandonedTimeout = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                        this.runAbandonedTimeout(threadAbandonedTimeout);
                    }
                    if (this.timeToLive) {
                        block29: {
                            this.isSleeping = true;
                            try {
                                OracleImplicitConnectionCacheThread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                            }
                            catch (InterruptedException ie) {
                                if (!TRACE || !OracleLog.recursiveEnter()) break block29;
                                try {
                                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread.run() " + "- InterruptedException" + ie.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                        }
                        this.isSleeping = false;
                    }
                    if (this.implicitCache != null && (threadTTLTimeout > 0L || threadInactivityTimeout > 0L || threadAbandonedTimeout > 0L)) continue;
                    this.timeToLive = false;
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread.run()" + " - SQL Exceoption " + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimeToLiveTimeout(long threadTTLTimeout) throws SQLException {
        block27: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(threadTTLTimeout));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                long connCurrTime = 0L;
                long connStartTime = 0L;
                if (this.implicitCache.getNumberOfCheckedOutConnections() <= 0) break block27;
                OraclePooledConnection pc = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
                synchronized (oracleImplicitConnectionCache) {
                    Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                    int sz = this.implicitCache.checkedOutConnectionList.size();
                    for (int k2 = 0; k2 < sz; ++k2) {
                        pc = (OraclePooledConnection)ObjArr[k2];
                        Connection conn = pc.getLogicalHandle();
                        if (conn == null) continue;
                        connStartTime = ((OracleConnection)conn).getStartTime();
                        connCurrTime = System.currentTimeMillis();
                        if (connCurrTime - connStartTime <= threadTTLTimeout * 1000L) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runTimeToLiveTimeout():" + "TTL Timeout expired..." + " Executing cancel()/close()");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        try {
                            this.implicitCache.closeCheckedOutConnection(pc, true);
                            continue;
                        }
                        catch (SQLException e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) continue;
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runTimeToLiveTimeout() - while closeCheckedOutConnection " + "- SQLException:" + e2.getMessage());
                                continue;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInactivityTimeout() {
        long __ol_nanos__ = 0L;
        try {
            block23: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    this.implicitCache.doForEveryCachedConnection(4);
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block23;
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread.runInactivityTimeout()" + " - while doForEveryCachedConnection - SQLException:" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAbandonedTimeout(long abandonedTimeout) throws SQLException {
        block28: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(abandonedTimeout));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.implicitCache.getNumberOfCheckedOutConnections() <= 0) break block28;
                OraclePooledConnection pc = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
                synchronized (oracleImplicitConnectionCache) {
                    Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                    for (int k2 = 0; k2 < ObjArr.length; ++k2) {
                        pc = (OraclePooledConnection)ObjArr[k2];
                        OracleConnection conn = (OracleConnection)pc.getLogicalHandle();
                        if (conn == null) continue;
                        OracleConnectionCacheCallback occc = conn.getConnectionCacheCallbackObj();
                        if ((long)(conn.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) <= abandonedTimeout) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runAbandonedTimeout():Abandoned Timeout expired..." + "Executing cancel()/close()");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        try {
                            boolean closeCheckedOutConnection = true;
                            if (occc != null && (conn.getConnectionCacheCallbackFlag() == 4 || conn.getConnectionCacheCallbackFlag() == 1)) {
                                closeCheckedOutConnection = occc.handleAbandonedConnection(conn, conn.getConnectionCacheCallbackPrivObj());
                            }
                            if (!closeCheckedOutConnection) continue;
                            this.implicitCache.closeCheckedOutConnection(pc, true);
                            continue;
                        }
                        catch (SQLException e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) continue;
                            try {
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCacheThread." + "runAbandonedTimeout() - while closeCheckedOutConnection" + " -  SQLException:" + e2.getMessage());
                                continue;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleImplicitConnectionCacheThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCacheThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

