/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public class OracleMultiPhaseArgs {
    int action;
    int nsites;
    Vector dbLinks;
    Vector xids;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs() {
        long __ol_nanos__;
        block13: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(int _action, int _nsites, Vector _xids, Vector _dbLinks) {
        long __ol_nanos__;
        block23: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_action) + ", " + OracleLog.argument(_nsites) + ", " + OracleLog.argument(_xids) + ", " + OracleLog.argument(_dbLinks));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (_nsites <= 1) {
                    this.action = 0;
                    this.nsites = 0;
                    this.dbLinks = null;
                    this.xids = null;
                    if (!TRACE || !OracleLog.recursiveEnter()) break block23;
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleMultiPhaseArgs(_, _nsites, _, _): _nsites <= 1");
                        break block23;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (_xids.isEmpty() || _dbLinks.isEmpty() || _dbLinks.size() != _nsites || _xids.size() != 3 * _nsites) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block23;
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleMultiPhaseArgs(_, _, _, _): invalid parameters");
                        break block23;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.action = _action;
                this.nsites = _nsites;
                this.xids = _xids;
                this.dbLinks = _dbLinks;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(byte[] inBytes) {
        long __ol_nanos__;
        block26: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(inBytes));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleMultiPhaseArgs(inBytes.length = " + inBytes.length + ")");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(inBytes);
                DataInputStream dataIS = new DataInputStream(byteArrayIS);
                this.xids = new Vector();
                this.dbLinks = new Vector();
                try {
                    this.action = dataIS.readInt();
                    this.nsites = dataIS.readInt();
                    int fmtid = dataIS.readInt();
                    int gtridLen = dataIS.readInt();
                    byte[] gtrid = new byte[gtridLen];
                    int gtridRead = dataIS.read(gtrid, 0, gtridLen);
                    for (int i2 = 0; i2 < this.nsites; ++i2) {
                        int bqualLen = dataIS.readInt();
                        byte[] bqual = new byte[bqualLen];
                        int bqualRead = dataIS.read(bqual, 0, bqualLen);
                        this.xids.addElement(fmtid);
                        this.xids.addElement(gtrid);
                        this.xids.addElement(bqual);
                        String dblink = dataIS.readUTF();
                        this.dbLinks.addElement(dblink);
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block26;
                try {
                    this.printMPArgs();
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        byte[] byArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.toByteArrayOS().toByteArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream toByteArrayOS() {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] gtridCommon = null;
        int fmtidCommon = 0;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
            DataOutputStream dataOS = new DataOutputStream(byteArrayOS);
            try {
                dataOS.writeInt(this.action);
                dataOS.writeInt(this.nsites);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    String dblink = (String)this.dbLinks.elementAt(i2);
                    int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                    byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                    byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                    if (i2 == 0) {
                        fmtidCommon = fmtid;
                        gtridCommon = gtrid;
                        dataOS.writeInt(fmtid);
                        dataOS.writeInt(gtrid.length);
                        dataOS.write(gtrid, 0, gtrid.length);
                    }
                    dataOS.writeInt(bqual.length);
                    dataOS.write(bqual, 0, bqual.length);
                    dataOS.writeUTF(dblink);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    this.printMPArgs();
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byteArrayOS);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byteArrayOutputStream = byteArrayOS;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAction() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.action);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.action;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getnsite() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.nsites);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.nsites;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getdbLinks() {
        Vector vector;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dbLinks);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            vector = this.dbLinks;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getXids() {
        Vector vector;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xids);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            vector = this.xids;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMPArgs() {
        block51: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "-------printMPArgs entry-------");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  action = " + this.action);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  nsites = " + this.nsites);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    String dblink = (String)this.dbLinks.elementAt(i2);
                    int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                    byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                    byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  fmtid  [" + i2 + "] = " + fmtid);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  gtrid  [" + i2 + "] = ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.printByteArray(gtrid);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  bqual  [" + i2 + "] = ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.printByteArray(bqual);
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  dblink [" + i2 + "] = " + dblink);
                        continue;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block51;
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "-------printMPArgs return-------");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private void printByteArray(byte[] bArray) {
        StringBuffer _buf = new StringBuffer();
        for (int i2 = 0; i2 < bArray.length; ++i2) {
            _buf.append(bArray[i2] + " ");
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleMultiPhaseArgs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

