/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit;
    protected boolean savedXAConnectionAutoCommit;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection;
    protected OracleXAConnection xaconnection;
    protected int timeout;
    protected String dblink;
    private Connection logicalConnection;
    private String synchronizeBeforeRecoverNewCall;
    private String synchronizeBeforeRecoverOldCall;
    private String recoverySqlRows;
    protected boolean canBeMigratablySuspended;
    private boolean isTMRScanStarted;
    private static final Xid[] NO_XID = new Xid[0];
    Xid lastActiveXid;
    protected Xid activeXid;
    protected Hashtable<Xid, XidListEntry> xidHash;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource() {
        long __ol_nanos__;
        block13: {
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.canBeMigratablySuspended = false;
            this.isTMRScanStarted = false;
            this.lastActiveXid = null;
            this.activeXid = null;
            this.xidHash = new Hashtable(50);
            __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        long __ol_nanos__;
        block19: {
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.canBeMigratablySuspended = false;
            this.isTMRScanStarted = false;
            this.lastActiveXid = null;
            this.activeXid = null;
            this.xidHash = new Hashtable(50);
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pm_conn) + ", " + OracleLog.argument(xaconn));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.connection = pm_conn;
                this.xaconnection = xaconn;
                if (this.connection != null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -7);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-7);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnection(Connection pm_conn) throws XAException {
        long __ol_nanos__;
        block19: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pm_conn));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.connection = pm_conn;
                if (this.connection != null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -7);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-7);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized XidListEntry getMatchingXidListEntry(Xid xid) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            XidListEntry x = this.xidHash.get(xid);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + x);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XidListEntry xidListEntry = x;
            return xidListEntry;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean removeXidFromList(Xid xid) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isSameXid(this.activeXid, xid)) {
                this.activeXid = null;
            }
            boolean bl = __result__ = this.xidHash.remove(xid) != null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isSameXid(Xid xid1, Xid xid2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid1) + ", " + OracleLog.argument(xid2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (xid1 == xid2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = xid1 == xid2;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isOnStack(Xid xid) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = this.xidHash.containsKey(xid);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean isXidListEmpty() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = this.xidHash.isEmpty();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void createOrUpdateXid(Xid xid, boolean isSuspended, boolean[] isLocallySuspended) {
        long __ol_nanos__ = 0L;
        try {
            XidListEntry x;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(isSuspended) + ", " + OracleLog.argument(isLocallySuspended));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.putXidToList (xid = " + xid + ", isSusended = " + isSuspended + " ): stacking xid");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((x = this.getMatchingXidListEntry(xid)) != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.putXidToList (xid = " + xid + ", isSusended = " + isSuspended + " ): x(not supposed to be null) = " + x);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                isLocallySuspended[0] = true;
                x.isSuspended = isSuspended;
            } else {
                x = new XidListEntry(xid, isSuspended);
                this.xidHash.put(xid, x);
            }
            if (isSuspended) {
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            } else {
                this.enterGlobalTxnMode();
                if (this.lastActiveXid != null && this.isSameXid(xid, this.lastActiveXid)) {
                    this.lastActiveXid = null;
                }
                this.activeXid = x.xid;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean updateXidList(Xid xid, boolean[] flags) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.updateXidList (" + xid + "): trying to clear stacked xid");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean foundXid = false;
            XidListEntry x = this.getMatchingXidListEntry(xid);
            if (x != null) {
                foundXid = true;
                flags[0] = true;
                flags[1] = x.isSuspended;
                if (x.isSuspended) {
                    this.enterGlobalTxnMode();
                } else {
                    this.exitGlobalTxnMode();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + foundXid);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = foundXid;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isXidSuspended(Xid xid) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean returnValue = false;
            XidListEntry x = this.getMatchingXidListEntry(xid);
            if (x != null) {
                returnValue = x.isSuspended;
            }
            boolean __result__ = returnValue;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid suspendStacked(Xid xid) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Xid stackedXid = null;
            if (this.activeXid != null && !this.isSameXid(this.activeXid, xid)) {
                stackedXid = this.activeXid;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.suspendStacked(xid): Before calling end()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!this.isXidSuspended(this.activeXid)) {
                    this.end(this.activeXid, 0x2000000);
                    this.lastActiveXid = this.activeXid;
                    this.activeXid = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stackedXid);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Xid xid2 = stackedXid;
            return xid2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeStacked(Xid xid) throws XAException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xid));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (xid == null) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.resumeStacked(xid): Before calling start()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.start(xid, 0x8000000);
                this.activeXid = xid;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            Xid[] xidArray;
            long __ol_nanos__;
            block62: {
                block63: {
                    __ol_nanos__ = 0L;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(flag));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((flag & 0x1800000) != flag) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.recover(flag): XAER_INVAL, invalid flag");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (!TRACE) throw new XAException(-5);
                        if (!OracleLog.recursiveEnter()) throw new XAException(-5);
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            throw new XAException(-5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (flag == 0x1000000) {
                        this.isTMRScanStarted = true;
                        break block62;
                    }
                    if (!this.isTMRScanStarted || flag != 0x800000) break block63;
                    this.isTMRScanStarted = false;
                    Xid[] xidArray2 = NO_XID;
                    if (!TRACE) return xidArray2;
                    if (!OracleLog.recursiveEnter()) return xidArray2;
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return xidArray2;
                }
                if (!this.isTMRScanStarted || flag != 0) break block62;
                Xid[] xidArray3 = NO_XID;
                if (!TRACE) return xidArray3;
                if (!OracleLog.recursiveEnter()) return xidArray3;
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return xidArray3;
            }
            try {
                Statement stmt = null;
                ResultSet rset = null;
                ArrayList<OracleXid> xidCollection = new ArrayList<OracleXid>(50);
                try {
                    stmt = this.connection.createStatement();
                    try {
                        stmt.execute(this.synchronizeBeforeRecoverNewCall);
                    }
                    catch (Exception exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.recover(flag): DBMS_XA.dist_txn_sync failed: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        stmt.execute(this.synchronizeBeforeRecoverOldCall);
                    }
                    rset = stmt.executeQuery(this.recoverySqlRows);
                    while (rset.next()) {
                        xidCollection.add(new OracleXid(rset.getInt(1), rset.getBytes(2), rset.getBytes(3)));
                    }
                }
                catch (SQLException sqe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.recover(flag): SQLException(internal) " + sqe);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!TRACE) throw new XAException(-3);
                    if (!OracleLog.recursiveEnter()) throw new XAException(-3);
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -3);
                        throw new XAException(-3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (rset != null) {
                            rset.close();
                        }
                    }
                    catch (Exception ignore) {}
                }
                int xidSize = xidCollection.size();
                Xid[] xids = new Xid[xidSize];
                System.arraycopy(xidCollection.toArray(), 0, xids, 0, xidSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xids);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                xidArray = xids;
                if (!TRACE) return xidArray;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return xidArray;
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return xidArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        block19: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!this.savedConnectionAutoCommit || ((OracleConnection)this.connection).getTxnMode() == 1) break block19;
                try {
                    this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                    this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
                }
                catch (SQLException ignoreException) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block19;
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.restoreAutoCommitModeForGlobalTransaction got exception: " + ignoreException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        block19: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (((OracleConnection)this.connection).getTxnMode() == 1) break block19;
                try {
                    this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                    this.connection.setAutoCommit(false);
                    this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                    this.xaconnection.setAutoCommit(false);
                }
                catch (SQLException ignoreException) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block19;
                    try {
                        OracleXAResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAResource.saveAndAlterAutoCommitModeForGlobalTransaction got exception: " + ignoreException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Xid xid) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.start(xid, 0x8000000);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Xid xid) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.start(xid, 0x200000);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Xid xid) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.end(xid, 0x2000000);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Xid xid, int timeout) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(timeout));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.timeout = timeout;
            this.start(xid, 0x200000);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Xid xid, int timeout) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(timeout));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.timeout = timeout;
            this.start(xid, 0x8000000);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Connection connection;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            connection = this.connection;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionTimeout() throws XAException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.timeout);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.timeout;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        long __ol_nanos__;
        block65: {
            block58: {
                boolean _returnVal;
                Connection conn1;
                block55: {
                    block52: {
                        boolean bl;
                        __ol_nanos__ = 0L;
                        try {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xares));
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                                __ol_nanos__ = System.nanoTime();
                            }
                            conn1 = null;
                            if (xares instanceof OracleXAResource) {
                                conn1 = ((OracleXAResource)xares).getConnection();
                                break block52;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw throwable;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        return bl;
                    }
                    if (this.connection != null && !((OracleConnection)this.connection).isClosed()) break block55;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = false;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return bl;
                }
                String l_url = ((OracleConnection)this.connection).getURL();
                String l_prt = ((OracleConnection)this.connection).getProtocolType();
                if (conn1 == null) break block58;
                boolean bl = _returnVal = conn1.equals(this.connection) || ((OracleConnection)conn1).getURL().equals(l_url) || ((OracleConnection)conn1).getProtocolType().equals(l_prt) && l_prt.equals("kprb");
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + _returnVal);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = _returnVal;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return bl2;
            }
            break block65;
            catch (SQLException sqe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-3);
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = false;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(seconds));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (seconds < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            this.timeout = seconds;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBLink() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dblink);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.dblink;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDBLink(String dblink) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(dblink));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.dblink = dblink;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogicalConnection(Connection conn) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.logicalConnection = conn;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allowGlobalTxnModeOnly(int errorCode) throws XAException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(errorCode));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (((OracleConnection)this.connection).getTxnMode() == 1) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + errorCode);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(errorCode);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitGlobalTxnMode() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ((OracleConnection)this.connection).setTxnMode(0);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterGlobalTxnMode() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ((OracleConnection)this.connection).setTxnMode(1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(int error) throws XAException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(error));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((error & 0xFFFF) == 0) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + error);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                XAException __ex__ = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), error);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(int error, int defaultXAError) throws XAException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(error) + ", " + OracleLog.argument(defaultXAError));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((error & 0xFFFF) == 0) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + error + defaultXAError);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                XAException __ex__ = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), error, defaultXAError);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(SQLException sqlex, int defaultXAError) throws XAException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sqlex) + ", " + OracleLog.argument(defaultXAError));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + sqlex + defaultXAError);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XAException __ex__ = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), sqlex, defaultXAError);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleConnection __result__ = (OracleConnection)this.connection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = __result__;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;

        XidListEntry(Xid x, boolean s2) {
            this.xid = x;
            this.isSuspended = s2;
        }
    }
}

